/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller.http;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.basespringboot.security.JwtAuthentication;
import at.letto.setupservice.SetupserviceApplication;
import at.letto.setupservice.beans.MysqlCmdBean;
import at.letto.setupservice.beans.SchoolConfigBean;
import at.letto.setupservice.beans.SchoolEditBean;
import at.letto.setupservice.beans.SessionBean;
import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.config.SetupConfiguration;
import at.letto.setupservice.configFiles.SchuleEnv;
import at.letto.setupservice.controller.CommandController;
import at.letto.setupservice.controller.ExplorerController;
import at.letto.setupservice.controller.FileEditController;
import at.letto.setupservice.controller.FileViewController;
import at.letto.setupservice.controller.Msg;
import at.letto.setupservice.controller.MsgType;
import at.letto.setupservice.controller.MySQLCmdController;
import at.letto.setupservice.controller.http.HttpInitEnvController;
import at.letto.setupservice.controller.http.SchoolConfigController;
import at.letto.setupservice.model.DockerEditSchoolDto;
import at.letto.setupservice.model.DownloadFile;
import at.letto.setupservice.model.UpdateServiceDto;
import at.letto.setupservice.model.WelcomeDto;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.DatabaseService;
import at.letto.setupservice.service.DockerInstallService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.DownloadService;
import at.letto.setupservice.service.EmailService;
import at.letto.setupservice.service.InstallService;
import at.letto.setupservice.service.LizenzService;
import at.letto.setupservice.service.SetupUpdateService;
import at.letto.setupservice.service.UpdateService;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class WelcomeController {
    @Autowired
    private SetupConfiguration setupConfiguration;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private DockerConfiguration dockerConfiguration;
    @Autowired
    private HttpInitEnvController httpInitEnvController;
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    private UpdateService updateService;
    @Autowired
    private InstallService installService;
    @Autowired
    private DockerService dockerService;
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private SetupUpdateService setupUpdateService;
    @Autowired
    private FileEditController fileEditController;
    @Autowired
    private FileViewController fileViewController;
    @Autowired
    private MySQLCmdController mySQLCmdController;
    @Autowired
    private CommandController commandController;
    @Autowired
    private DatabaseService databaseService;
    @Autowired
    private LizenzService lizenzService;
    @Autowired
    private DockerInstallService dockerInstallService;
    @Autowired
    private ExplorerController explorerController;
    @Autowired
    private SchoolConfigController schoolConfigController;
    @Autowired
    private EmailService emailService;
    @Resource(name="schoolEditBean")
    SchoolEditBean schoolEditBean;
    @Resource(name="schoolConfigBean")
    SchoolConfigBean schoolConfigBean;
    @Resource(name="mysqlCmdBean")
    MysqlCmdBean mysqlCmdBean;
    @Resource(name="sessionBean")
    SessionBean sessionBean;

    @RequestMapping(value={"/config/session/welcome"})
    public String welcomeLocalDocker(@ModelAttribute WelcomeDto welcomeDto, HttpServletRequest request, Model model) {
        return this.welcomeLocal(welcomeDto, request, model);
    }

    @RequestMapping(value={"/setup/session/welcome"})
    public String welcomeLocal(@ModelAttribute WelcomeDto welcomeDto, HttpServletRequest request, Model model) {
        String remoteHost = request.getRemoteHost();
        String realip = request.getHeader("x-real-ip");
        String xforwarded = request.getHeader("x-forwarded-for");
        Object msg = "";
        if (welcomeDto == null) {
            welcomeDto = new WelcomeDto();
        }
        this.analyzeService.analyzeRequestUrl(request);
        this.dockerConfiguration.loadConfiguration();
        model.addAttribute("dockerService", (Object)this.dockerService);
        model.addAttribute("config", (Object)this.setupConfiguration.getConf());
        model.addAttribute("dockerConfiguration", (Object)this.dockerConfiguration);
        model.addAttribute("analyzeService", (Object)this.analyzeService);
        model.addAttribute("updateService", (Object)this.updateService);
        model.addAttribute("welcomeDto", (Object)welcomeDto);
        model.addAttribute("username", (Object)this.sessionBean.getUsername());
        model.addAttribute("clientip", (Object)("ip:" + remoteHost + " realip:" + realip + " fwip:" + xforwarded));
        if (this.dockerService.needDockerInit()) {
            return this.httpInitEnvController.redirectDockerInit(model);
        }
        String button = welcomeDto.getUserAction();
        String commitedAction = welcomeDto.getCommitedAction();
        if (commitedAction != null && commitedAction.trim().length() > 0) {
            button = commitedAction;
        }
        welcomeDto.setCommitedAction(null);
        try {
            JwtAuthentication auth = (JwtAuthentication)SecurityContextHolder.getContext().getAuthentication();
            model.addAttribute("username", (Object)auth.getName());
        }
        catch (Exception auth) {
            // empty catch block
        }
        if (welcomeDto.getDbrootpassword() == null) {
            welcomeDto.setDbrootpassword(this.setupConfiguration.getConf().getLettoDatabaseRootPassword());
        }
        if (welcomeDto.getLettoRevision() == null) {
            welcomeDto.setLettoRevision(this.analyzeService.getLetto_daily_revision());
        }
        if (welcomeDto.getLtiRevision() == null) {
            welcomeDto.setLtiRevision(this.analyzeService.getLti_daily_revision());
        }
        if (button != null) {
            block148 : switch (button) {
                case "installdocker": {
                    this.setupConfiguration.getConf().setSetupLettoDocker(true);
                    this.setupConfiguration.getConf().setSetupInit(false);
                    this.setupConfiguration.getConf().save();
                    this.dockerService.createPath();
                    break;
                }
                case "installhost": {
                    this.setupConfiguration.getConf().setSetupLettoLocal(true);
                    this.setupConfiguration.getConf().setSetupInit(false);
                    this.setupConfiguration.getConf().save();
                    break;
                }
                case "stophost": {
                    this.setupConfiguration.getConf().setSetupLettoLocal(false);
                    this.setupConfiguration.getConf().save();
                    break;
                }
                case "installuser": {
                    CmdThread cmdThread = this.installService.installUser(this.dockerService.welcomeAnalyzeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)"Installation konnte nicht durchgef\u00fchrt werden!", (String)"");
                }
                case "installAll": {
                    CmdThread cmdThread = this.installService.installAllUbuntu(this.dockerService.welcomeAnalyzeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)"Installation konnte nicht durchgef\u00fchrt werden!", (String)"");
                }
                case "installDb": {
                    this.installService.dbConfig();
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "installDbRoot": {
                    String pwd = this.setupConfiguration.getConf().getLettoDatabaseRootPassword();
                    if (pwd != null && pwd.length() > 0) {
                        if (this.installService.setDbRootPassword(pwd)) {
                            return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                        }
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)"Passwort konnte nicht gesetzt werden!", (String)"");
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)"Passwort darf nicht null sein!!", (String)"");
                }
                case "setdbroot": {
                    String pwd = welcomeDto.getDbrootpassword();
                    if (pwd != null && pwd.length() > 0) {
                        if (this.installService.setDbRootPassword(pwd)) {
                            return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                        }
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)"Passwort konnte nicht gesetzt werden!", (String)"");
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)"Passwort darf nicht null sein!!", (String)"");
                }
                case "configDirs": {
                    this.installService.configLocalDirs();
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "installTomEE": {
                    this.installService.installLocalTomEE();
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "configTomEE": {
                    this.installService.configLocalTomEE();
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "deleteTomEE": {
                    msg = this.installService.deleteLocalTomEE();
                    if (((String)msg).length() > 0) {
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                    }
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "stopTomEE": {
                    msg = this.installService.stopLocalTomEE();
                    if (((String)msg).length() > 0) {
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                    }
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "startTomEE": {
                    msg = this.installService.startLocalTomEE();
                    if (((String)msg).length() > 0) {
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                    }
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "restartTomEE": {
                    msg = this.installService.stopLocalTomEE();
                    if (((String)msg).length() > 0) {
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                    }
                    msg = this.installService.startLocalTomEE();
                    if (((String)msg).length() > 0) {
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                    }
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "restartrmlogTomEE": {
                    msg = this.installService.stopLocalTomEE();
                    if (((String)msg).length() > 0) {
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                    }
                    this.installService.deleteLocalTomEElogfile();
                    msg = this.installService.startLocalTomEE();
                    if (((String)msg).length() > 0) {
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                    }
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "edittomeelog": {
                    return this.fileEditController.editFileWelcome(this.installService.getLocalTomEElogfile(), model);
                }
                case "edittomeexml": {
                    return this.fileEditController.editFileWelcome(this.installService.getLocalTomEEtomeexml(), model);
                }
                case "editserverxml": {
                    return this.fileEditController.editFileWelcome(this.installService.getLocalTomEEserverxml(), model);
                }
                case "editcatalinash": {
                    return this.fileEditController.editFileWelcome(this.installService.getLocalTomEEcatalinash(), model);
                }
                case "editsetenvsh": {
                    return this.fileEditController.editFileWelcome(this.installService.getLocalTomEEsetenvsh(), model);
                }
                case "installLTI": {
                    this.installService.downloadAndInstallLTI();
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "stopLTI": {
                    this.installService.stopLocalLTI();
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "startLTI": {
                    this.installService.startLocalLTI();
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "restartLTI": {
                    this.installService.stopLocalLTI();
                    this.installService.startLocalLTI();
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "editLTIlog": {
                    return this.fileEditController.editFileWelcome(this.installService.getLocalLTIlogfile(), model);
                }
                case "editLTIconfig": {
                    return this.fileEditController.editFileWelcome(this.installService.getLocalLTIconfigfile(), model);
                }
                case "localApacheConfig": {
                    this.installService.installLocalApache();
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "localApacheRemove": {
                    this.installService.deleteLocalApache();
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "apachestart": {
                    msg = this.installService.startLocalApache();
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "apachestop": {
                    msg = this.installService.stopLocalApache();
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.analyzeService.getLocalSetupUrlWithPort();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "apacherestart": {
                    msg = this.installService.restartLocalApache();
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "editapachelog": {
                    return this.fileEditController.editFileWelcome(this.installService.getLocalApacheLogfile(), model);
                }
                case "editapacheconf": {
                    return this.fileEditController.editFileWelcome(this.installService.getLocalApacheConfigfile(), model);
                }
                case "localSetupAutostartOff": {
                    this.installService.setSetupLocalAutostart(false, false);
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "localSetupAutostartOn": {
                    this.installService.setSetupLocalAutostart(true, false);
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "localSetupAutostartRoot": {
                    this.installService.setSetupLocalAutostart(true, true);
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "localAutostartOff": {
                    this.installService.setLettoLocalAutostart(false);
                    this.installService.setLTILocalAutostart(false);
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "localAutostartOn": {
                    this.installService.setLettoLocalAutostart(true);
                    this.installService.setLTILocalAutostart(true);
                    return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                }
                case "config": {
                    return this.fileEditController.editFile(this.setupConfiguration.getConf().getPropertyFile(), model, this.dockerService.reloadEP());
                }
                case "refresh": {
                    this.dockerService.analyzeBackground(true);
                    break;
                }
                case "reload": {
                    break;
                }
                case "doc": {
                    return "redirect:" + this.dockerService.docEP();
                }
                case "cputrend": {
                    return "redirect:" + this.dockerService.systemStatusEP();
                }
                case "analyze": {
                    return "redirect:" + this.dockerService.analyzeEP();
                }
                case "searchprograms": {
                    this.setupConfiguration.searchPrograms();
                    break;
                }
                case "resetsetup": {
                    this.setupConfiguration.erstConfiguration();
                    break;
                }
                case "setuplogs": {
                    File f = new File("/opt/letto/setup/lettosetup.log");
                    if (!f.exists()) break;
                    return this.fileViewController.viewFileWelcome(f, model);
                }
                case "updatesetupdaily": {
                    msg = this.updateService.updateSetupServiceDaily();
                    if (((String)msg).equals("ok")) {
                        return "redirect:" + this.dockerService.loginEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "updatesetupstable": {
                    msg = this.updateService.updateSetupServiceStable();
                    if (((String)msg).equals("ok")) {
                        return "redirect:" + this.dockerService.loginEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "restartsetup": {
                    SetupserviceApplication.restart();
                    return "redirect:" + this.dockerService.loginEP();
                }
                case "reloadsetup": {
                    this.setupConfiguration.reload();
                    this.analyzeService.analyze();
                    return "redirect:" + this.dockerService.welcomeEP();
                }
                case "saveconfig": {
                    this.dockerService.saveAndReloadConfiguration();
                    msg = "configuration saved";
                    break;
                }
                case "lettostart": {
                    msg = this.installService.startLettoLocal();
                    this.analyzeService.analyzeinstallation();
                    return Msg.message((MsgType)MsgType.INFO, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "lettorestart": {
                    msg = this.installService.restartLettoLocal();
                    this.analyzeService.analyzeinstallation();
                    return Msg.message((MsgType)MsgType.INFO, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "lettostop": {
                    msg = this.installService.stopLettoLocal();
                    this.analyzeService.analyzeinstallation();
                    return Msg.message((MsgType)MsgType.INFO, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "lettoupdate": {
                    msg = this.installService.updateLettoLocal();
                    this.analyzeService.analyzeinstallation();
                    return Msg.message((MsgType)MsgType.INFO, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "lettoupdatelocaldaily": {
                    msg = this.installService.updateLettoLocal("daily");
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "lettoupdatelocalbeta": {
                    msg = this.installService.updateLettoLocal("beta");
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "lettoupdatelocalstable": {
                    msg = this.installService.updateLettoLocal("stable");
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "lettoupdatelocalrev": {
                    msg = this.installService.updateLettoLocal(welcomeDto.getLettoRevision());
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "ltiupdatelocal": {
                    msg = this.installService.updateLtiLocal("");
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "ltiupdatelocaldaily": {
                    msg = this.installService.updateLtiLocal("daily");
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "ltiupdatelocalbeta": {
                    msg = this.installService.updateLtiLocal("beta");
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "ltiupdatelocalstable": {
                    msg = this.installService.updateLtiLocal("stable");
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "ltiupdatelocalrev": {
                    msg = this.installService.updateLtiLocal(welcomeDto.getLtiRevision());
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "localSicherungEinrichten": {
                    msg = this.installService.localSicherungEinrichten();
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "localSicherungCronStart": {
                    msg = this.installService.localSicherungCronStart();
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "localSicherungCronStop": {
                    msg = this.installService.localSicherungCronStop();
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "localUpdateCronStart": {
                    msg = this.installService.localUpdateCronStart();
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "localUpdateCronStop": {
                    msg = this.installService.localUpdateCronStop();
                    if (msg == null || ((String)msg).length() < 1) {
                        return "redirect:" + this.dockerService.welcomeAnalyzeEP();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)msg, (String)"");
                }
                case "localSicherungNow": {
                    CmdThread cmdThread = this.installService.sicherungLocal(this.dockerService.welcomeAnalyzeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)"Sicherung konnte nicht durchgef\u00fchrt werden!", (String)"");
                }
                case "localSicherungLettoImportLast": {
                    CmdThread cmdThread = this.installService.sicherungLocalLettoImportLast(this.dockerService.welcomeAnalyzeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)"R\u00fccksicherung konnte nicht durchgef\u00fchrt werden!", (String)"");
                }
                case "localSicherungLtiImportLast": {
                    CmdThread cmdThread = this.installService.sicherungLocalLtiImportLast(this.dockerService.welcomeAnalyzeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)this.dockerService.welcomeEP(), (String)"R\u00fccksicherung konnte nicht durchgef\u00fchrt werden!", (String)"");
                }
                case "localSicherungLettoDownloadLast": {
                    DownloadFile df = this.downloadService.newDownloadGlobal(new File("/sicherung/letto.sql.gz"));
                    return "redirect:" + this.dockerService.globalDownloadEP() + "/" + df.getId();
                }
                case "localSicherungLtiDownloadLast": {
                    DownloadFile df = this.downloadService.newDownloadGlobal(new File("/sicherung/lettolti.sql.gz"));
                    return "redirect:" + this.dockerService.globalDownloadEP() + "/" + df.getId();
                }
                case "localSicherungLettoUpload": 
                case "localSicherungLtiUpload": 
                case "localSicherungDialog": {
                    return "redirect:" + this.dockerService.sicherungLocalEP();
                }
                case "localSicherungEdit": {
                    return this.fileEditController.editFileWelcome(new File("/sicherung/sicherung.sh"), model);
                }
                case "localResetDatabase": {
                    this.installService.localResetDatabase();
                    break;
                }
                case "localResetLtiDatabase": {
                    this.installService.localResetLtiDatabase();
                    break;
                }
                case "localCrontabEdit": {
                    return this.fileEditController.editFileWelcome(new File("/etc/crontab"), model);
                }
                case "lettobackup": {
                    msg = "not implementet yet!";
                    break;
                }
                case "lettorestore": {
                    msg = "not implementet yet!";
                    break;
                }
                case "cmd": {
                    return "redirect:" + this.dockerService.cmdEP();
                }
                case "mysqlcmd": {
                    this.mySQLCmdController.loadConnections();
                    return "redirect:" + this.dockerService.mysqlcmdEP();
                }
                case "emailconfig": {
                    return "redirect:" + this.dockerService.emailconfigEP();
                }
                case "backup": {
                    return "redirect:" + this.dockerService.backupEP();
                }
                case "explorer": {
                    String filename = this.dockerService.getDockerPath();
                    String template = this.explorerController.redirectExplorer(filename, model);
                    if (template == null || template.length() == 0) {
                        msg = "Cannot open directory " + filename;
                        break;
                    }
                    return template;
                }
                case "updateconfig": {
                    return "redirect:" + this.dockerService.updateEP();
                }
                case "servertoken": {
                    return "redirect:" + this.dockerService.serverTokenEP();
                }
                case "plugins": {
                    return "redirect:" + this.dockerService.pluginsEP();
                }
                case "users": {
                    return "redirect:/config/session/admin/users";
                }
                case "docker_letto_status": {
                    return "redirect:" + this.dockerService.dockerLettoStatusEP();
                }
                case "dockerCreatePath": {
                    this.dockerService.createPath();
                    break;
                }
                case "docker_mysql_logs": {
                    return this.fileViewController.viewLogfileWelcome("letto-mysql", model);
                }
                case "docker_edit_mysql_env": {
                    File f = this.microServiceConfiguration.getMysqlEnvFile();
                    return this.fileEditController.editFileWelcome(f, model);
                }
                case "docker_mysql_yml_edit": {
                    return this.fileEditController.editFileWelcome(this.microServiceConfiguration.getMysqlYmlFile(), model);
                }
                case "docker_mysql_yml_update": {
                    this.dockerService.createMysqlYml();
                    break;
                }
                case "docker_setup_logs": {
                    return this.fileViewController.viewLogfileWelcome("letto-setup", model);
                }
                case "docker_edit_setup_env": 
                case "dockerEditConfig": {
                    File f = this.microServiceConfiguration.getSetupEnvFile();
                    return this.fileEditController.editFileWelcome(f, model);
                }
                case "docker_setup_yml_edit": {
                    return this.fileEditController.editFileWelcome(this.microServiceConfiguration.getSetupYmlFile(), model);
                }
                case "docker_setup_yml_update": {
                    this.dockerService.createSetupYml();
                    break;
                }
                case "docker_login_logs": {
                    return this.fileViewController.viewLogfileWelcome("letto-login", model);
                }
                case "docker_proxy_logs": {
                    return this.fileViewController.viewLogfileWelcome("letto-proxy", model);
                }
                case "docker_letto_logs": {
                    File f = this.dockerService.dockerComposeLogsFile("docker-compose.yml");
                    return this.fileViewController.viewFileWelcome(f, model);
                }
                case "docker_edit_letto_env": {
                    File f = this.microServiceConfiguration.getLettoEnvFile();
                    return this.fileEditController.editFileWelcome(f, model);
                }
                case "docker_letto_yml_edit": {
                    return this.fileEditController.editFileWelcome(this.microServiceConfiguration.getLettoYmlFile(), model);
                }
                case "docker_letto_yml_update": {
                    this.dockerService.createLettoYml();
                    break;
                }
                case "configureDocker": {
                    return "redirect:" + this.dockerService.configureDockerLink();
                }
                case "docker_mysql_start": {
                    CmdThread cmdThread = this.setupUpdateService.dockerMysqlStart(this.dockerService.welcomeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "thread konnte nicht gestartet werden!";
                    break;
                }
                case "docker_mysql_stop": {
                    CmdThread cmdThread = this.setupUpdateService.dockerMysqlStop(this.dockerService.welcomeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "thread konnte nicht gestartet werden!";
                    break;
                }
                case "docker_mysql_restart": {
                    CmdThread cmdThread = this.setupUpdateService.dockerMysqlRestart(this.dockerService.welcomeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "thread konnte nicht gestartet werden!";
                    break;
                }
                case "docker_mysql_update": {
                    CmdThread cmdThread = this.setupUpdateService.dockerMysqlUpdate(this.dockerService.welcomeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "thread konnte nicht gestartet werden!";
                    break;
                }
                case "docker_setup_start": {
                    CmdThread cmdThread = this.setupUpdateService.setupStart(this.dockerService.welcomeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "thread konnte nicht gestartet werden!";
                    break;
                }
                case "docker_setup_stop": {
                    CmdThread cmdThread = this.setupUpdateService.setupStop(this.dockerService.welcomeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "thread konnte nicht gestartet werden!";
                    break;
                }
                case "docker_setup_restart": {
                    CmdThread cmdThread = this.setupUpdateService.setupRestart(this.dockerService.welcomeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "thread konnte nicht gestartet werden!";
                    break;
                }
                case "docker_setup_update": {
                    CmdThread cmdThread = this.setupUpdateService.setupUpdate(this.dockerService.welcomeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "thread konnte nicht gestartet werden!";
                    break;
                }
                case "docker_letto_start": {
                    CmdThread cmdThread = this.setupUpdateService.dockerLettoStart(this.dockerService.welcomeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "thread konnte nicht gestartet werden!";
                    break;
                }
                case "docker_letto_stop": {
                    CmdThread cmdThread = this.setupUpdateService.dockerLettoStop(this.dockerService.welcomeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "thread konnte nicht gestartet werden!";
                    break;
                }
                case "docker_letto_restart": {
                    CmdThread cmdThread = this.setupUpdateService.dockerLettoRestart(this.dockerService.welcomeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "thread konnte nicht gestartet werden!";
                    break;
                }
                case "docker_letto_update": {
                    CmdThread cmdThread = this.setupUpdateService.dockerLettoUpdate(this.dockerService.welcomeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "thread konnte nicht gestartet werden!";
                    break;
                }
                case "docker_proxy_config": {
                    return "redirect:" + this.dockerService.dockerLettoProxyEP();
                }
                case "base_redirect_login": {
                    CmdThread cmdThread;
                    msg = this.dockerService.setBaseRedirection("login");
                    if (!this.dockerService.isDockerContainerRunning("letto-proxy") || (cmdThread = this.setupUpdateService.dockerLettoRestart(this.dockerService.welcomeEP())) == null) break;
                    return this.commandController.getCmdOutputTemplate(model, cmdThread);
                }
                case "base_redirect_school": {
                    CmdThread cmdThread;
                    msg = this.dockerService.setBaseRedirection("letto" + ((SchuleEnv)this.dockerService.getSchulenEnv().get((int)0)).school);
                    if (!this.dockerService.isDockerContainerRunning("letto-proxy") || (cmdThread = this.setupUpdateService.dockerLettoRestart(this.dockerService.welcomeEP())) == null) break;
                    return this.commandController.getCmdOutputTemplate(model, cmdThread);
                }
                case "base_redirect_public": {
                    CmdThread cmdThread;
                    msg = this.dockerService.setBaseRedirection("public");
                    if (!this.dockerService.isDockerContainerRunning("letto-proxy") || (cmdThread = this.setupUpdateService.dockerLettoRestart(this.dockerService.welcomeEP())) == null) break;
                    return this.commandController.getCmdOutputTemplate(model, cmdThread);
                }
                case "create_new_certificate": {
                    CmdThread cmdThread = this.setupUpdateService.createCert(this.dockerService.welcomeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "cannot create new certificate!";
                    break;
                }
                case "renew_certificate": {
                    CmdThread cmdThread = this.setupUpdateService.renewCert(this.dockerService.welcomeEP());
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "cannot renew certificate!";
                    break;
                }
                case "docker_mysql_reset_root": {
                    this.databaseService.resetMysqlRootLogin();
                    this.dockerService.analyzeBackground(true);
                    break;
                }
                case "docker_mysql_lti_login_create": {
                    msg = this.databaseService.createDatabaseLtiUser();
                    this.dockerService.analyzeBackground(true);
                    break;
                }
                case "docker_mysql_lti_login_database_create": {
                    msg = this.databaseService.createDatabaseLtiUser();
                    this.databaseService.createDatabaseLti();
                    this.dockerService.analyzeBackground(true);
                    break;
                }
                case "docker_mysql_lti_database_recreate": 
                case "docker_mysql_lti_database_create": {
                    msg = this.databaseService.createDatabaseLti();
                    this.dockerService.analyzeBackground(true);
                    break;
                }
                case "docker_mysql_letto_login_create": {
                    msg = this.databaseService.createDatabaseLettoUser();
                    this.dockerService.analyzeBackground(true);
                    break;
                }
                case "docker_mysql_lti_set_password": {
                    msg = this.databaseService.createDatabaseLtiSetPassword();
                    this.dockerService.analyzeBackground(true);
                    break;
                }
                case "docker-add-school": {
                    model.addAttribute("msg", (Object)"");
                    DockerEditSchoolDto dockerEditSchoolDto = new DockerEditSchoolDto();
                    String mysqlLettoPassword = this.dockerConfiguration.getLettoEnvFile().getMysqlRootPassword();
                    if (mysqlLettoPassword == null || mysqlLettoPassword.length() < 1) {
                        mysqlLettoPassword = "changeme";
                    }
                    for (SchuleEnv schule : this.dockerConfiguration.getLettoEnvFile().getSchulen()) {
                        if (!schule.mysqlUser.equals("letto")) continue;
                        mysqlLettoPassword = schule.mysqlPassword;
                    }
                    dockerEditSchoolDto.setMysqlLettoPassword(mysqlLettoPassword);
                    dockerEditSchoolDto.setMode("add");
                    model.addAttribute("dockerEditSchoolDto", (Object)dockerEditSchoolDto);
                    model.addAttribute("action", (Object)this.dockerService.dockerEditSchoolEP());
                    this.schoolEditBean.setDockerEditSchoolDto(dockerEditSchoolDto);
                    model.addAttribute("lizenz", (Object)this.schoolEditBean.getLicenseKey());
                    model.addAttribute("schoolEditBean", (Object)this.schoolEditBean);
                    return "dockereditschool";
                }
                case "docker-restkey-create": {
                    msg = this.lizenzService.createNewRestKey();
                    break;
                }
                case "docker-restkey-set": {
                    msg = this.dockerService.setRestkeyKonsistent();
                    break;
                }
                case "debug-on": 
                case "debug-off": 
                case "use-daily": 
                case "use-stable": {
                    break;
                }
                case "check_all_licenses": {
                    msg = this.lizenzService.updateLicenseAll();
                    break;
                }
                default: {
                    CmdThread cmdThread;
                    Pattern p = Pattern.compile("^school-(.*)-(\\d+)$");
                    Matcher m = p.matcher(button);
                    if (m.find()) {
                        String cmd = m.group(1);
                        int id = Integer.parseInt(m.group(2));
                        switch (cmd) {
                            case "logs": {
                                File f = this.dockerService.dockerLogOutSchoolFile(this.dockerService.getSchuleEnv((int)id).school);
                                return this.fileViewController.viewFileWelcome(f, model);
                            }
                            case "errlogs": {
                                File f = this.dockerService.dockerLogErrSchoolFile(this.dockerService.getSchuleEnv((int)id).school);
                                return this.fileViewController.viewFileWelcome(f, model);
                            }
                            case "logs-data": {
                                String containername = "letto-data-" + this.dockerService.getSchuleEnv((int)id).school;
                                return this.fileViewController.viewLogfileWelcome(containername, model);
                            }
                            case "edit-yaml": {
                                return this.fileEditController.editFileWelcome(this.microServiceConfiguration.getSchoolYmlFile(this.dockerService.getSchuleEnv((int)id).school), model);
                            }
                            case "update-yaml": {
                                msg = this.dockerService.createSchoolYml(this.dockerService.getSchuleEnv(id));
                                break;
                            }
                            case "restart": {
                                cmdThread = this.setupUpdateService.dockerSchoolRestart(this.dockerService.welcomeEP(), this.dockerService.getSchuleEnv((int)id).school);
                                if (cmdThread != null) {
                                    return this.commandController.getCmdOutputTemplate(model, cmdThread);
                                }
                                msg = "cannot restart school!";
                                break;
                            }
                            case "stop": {
                                cmdThread = this.setupUpdateService.dockerSchoolStop(this.dockerService.welcomeEP(), this.dockerService.getSchuleEnv((int)id).school);
                                if (cmdThread != null) {
                                    return this.commandController.getCmdOutputTemplate(model, cmdThread);
                                }
                                msg = "cannot stop school!";
                                break;
                            }
                            case "update": {
                                cmdThread = this.setupUpdateService.dockerSchoolUpdate(this.dockerService.welcomeEP(), this.dockerService.getSchuleEnv((int)id).school);
                                if (cmdThread != null) {
                                    return this.commandController.getCmdOutputTemplate(model, cmdThread);
                                }
                                msg = "cannot update school!";
                                break;
                            }
                            case "save-database": {
                                cmdThread = this.databaseService.databaseDump(id);
                                if (cmdThread != null) {
                                    return this.commandController.getCmdOutputTemplate(model, cmdThread);
                                }
                                msg = "Datenbank-dump konnte nicht importiert werden!";
                                break;
                            }
                            case "login-create": {
                                msg = this.databaseService.createDatabaseSchoolLettoUser(id);
                                this.dockerService.analyzeBackground(true);
                                break;
                            }
                            case "login-database-create": {
                                msg = this.databaseService.createDatabaseSchoolLettoUser(id);
                                cmdThread = this.dockerInstallService.createDatabaseSchool(id, null);
                                if (cmdThread != null) {
                                    return this.commandController.getCmdOutputTemplate(model, cmdThread);
                                }
                                msg = (String)msg + "Datenbank konnte nicht zur\u00fcckgesetzt werden!";
                                break;
                            }
                            case "database-recreate": 
                            case "database-create": {
                                cmdThread = this.dockerInstallService.createDatabaseSchool(id, null);
                                if (cmdThread != null) {
                                    return this.commandController.getCmdOutputTemplate(model, cmdThread);
                                }
                                msg = "Datenbank-dump konnte nicht importiert werden!";
                                break;
                            }
                            case "set-password": {
                                msg = this.databaseService.DatabaseSchoolSetPassword(id);
                                this.dockerService.analyzeBackground(true);
                                break;
                            }
                            case "database-change6500": {
                                msg = this.databaseService.change6500(id);
                                this.dockerService.analyzeBackground(true);
                                break;
                            }
                            case "edit": {
                                model.addAttribute("msg", (Object)"");
                                DockerEditSchoolDto dockerEditSchoolDto = this.databaseService.loadEditSchoolDto(id);
                                if (dockerEditSchoolDto == null) {
                                    msg = "Schule kann nicht geladen werden!";
                                    break;
                                }
                                dockerEditSchoolDto.setMode("edit");
                                model.addAttribute("dockerEditSchoolDto", (Object)dockerEditSchoolDto);
                                model.addAttribute("action", (Object)this.dockerService.dockerEditSchoolEP());
                                this.schoolEditBean.setDockerEditSchoolDto(dockerEditSchoolDto);
                                model.addAttribute("lizenz", (Object)this.schoolEditBean.getLicenseKey());
                                model.addAttribute("schoolEditBean", (Object)this.schoolEditBean);
                                return "dockereditschool";
                            }
                            case "config": {
                                msg = this.schoolConfigController.load(model, id);
                                if (msg == null && ((String)msg).trim().length() != 0) break;
                                return "schoolconfig";
                            }
                            case "delete": {
                                cmdThread = this.dockerInstallService.deleteSchool(id);
                                if (cmdThread != null) {
                                    return this.commandController.getCmdOutputTemplate(model, cmdThread);
                                }
                                msg = "Schule kann nicht gel\u00f6scht werden!";
                                break;
                            }
                            case "licensecheck": {
                                msg = this.lizenzService.updateLicenseSchool(this.dockerService.getSchuleEnv(id));
                                break;
                            }
                            case "download-database": {
                                File f = new File(this.dockerService.getDatabaseDumpFilePath(id));
                                if (f.exists()) {
                                    DownloadFile df = this.downloadService.newDownloadGlobal(f);
                                    return "redirect:" + this.dockerService.globalDownloadEP() + "/" + df.getId();
                                }
                                msg = "File " + this.dockerService.getDatabaseDumpFilePath(id) + " not found!";
                                break;
                            }
                            case "restkey-from-database": {
                                msg = this.dockerService.restkeyFromDatabase(id);
                                break;
                            }
                            case "restkey-in-database": {
                                msg = this.databaseService.restkeyInDatabase(id);
                                break;
                            }
                            case "license-from-database": {
                                msg = this.dockerService.licenseFromDatabase(id);
                                break;
                            }
                            case "license-in-database": {
                                msg = this.databaseService.licenseInDatabase(this.dockerService.getSchuleEnv(id));
                            }
                        }
                        break;
                    }
                    m = Pattern.compile("^([^\\-]+)-(.+)$").matcher(button);
                    if (!m.find()) break;
                    String cmd = m.group(1);
                    String serviceName = m.group(2);
                    UpdateServiceDto service = null;
                    if (this.updateService.getUpdateDto() != null) {
                        for (UpdateServiceDto updateServiceDto : this.updateService.getUpdateDto().getServices()) {
                            if (!updateServiceDto.getContainername().trim().equals("letto-" + serviceName)) continue;
                            service = updateServiceDto;
                        }
                        if (service == null) {
                            for (UpdateServiceDto updateServiceDto : this.updateService.getUpdateDto().getServices()) {
                                if (!updateServiceDto.getServicename().trim().equals(serviceName)) continue;
                                service = updateServiceDto;
                            }
                        }
                    }
                    if (service == null) break;
                    switch (cmd) {
                        case "docker_service_logs": {
                            return this.fileViewController.viewLogfileWelcome("letto-" + serviceName, model);
                        }
                        case "docker_service_yml_edit": {
                            return this.fileEditController.editFile(service.ymlFile(), model, this.dockerService.welcomeEP());
                        }
                        case "docker_service_yml_update": {
                            msg = this.updateService.updateYml(service);
                            break block148;
                        }
                        case "docker_service_restart": 
                        case "docker_service_start": {
                            cmdThread = this.updateService.serviceRestart(service, this.dockerService.welcomeEP());
                            if (cmdThread != null) {
                                return this.commandController.getCmdOutputTemplate(model, cmdThread);
                            }
                            msg = "cannot update service " + service.getServicename() + " in Container " + service.getContainername();
                            break block148;
                        }
                        case "docker_service_stop": {
                            cmdThread = this.updateService.serviceStop(service, this.dockerService.welcomeEP());
                            if (cmdThread != null) {
                                return this.commandController.getCmdOutputTemplate(model, cmdThread);
                            }
                            msg = "cannot stop service " + service.getServicename() + " in Container " + service.getContainername();
                            break block148;
                        }
                        case "docker_service_update": {
                            cmdThread = this.updateService.serviceUpdate(service, this.dockerService.welcomeEP());
                            if (cmdThread != null) {
                                return this.commandController.getCmdOutputTemplate(model, cmdThread);
                            }
                            msg = "cannot update service " + service.getServicename() + " in Container " + service.getContainername();
                        }
                    }
                }
            }
        }
        model.addAttribute("init", (Object)this.setupConfiguration.getConf().getSetupInit());
        model.addAttribute("local", (Object)this.setupConfiguration.getConf().getSetupLettoLocal());
        model.addAttribute("docker", (Object)this.setupConfiguration.getConf().getSetupLettoDocker());
        model.addAttribute("msg", msg);
        return "welcome";
    }
}

