/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.model.docker;

import at.letto.setupservice.dto.DockerStatsDto;
import at.letto.setupservice.model.docker.DockerPortDto;
import java.util.List;
import lombok.Generated;

public class DockerContainerDto {
    private String id;
    private String image;
    private String command;
    private String created;
    private String status;
    private List<DockerPortDto> ports;
    private String name;
    private String cpu = "";
    private String memoryUsage = "";
    private String memoryLimit = "";
    private String memoryPercent = "";
    private String netInput = "";
    private String netOutput = "";
    private String blockInput = "";
    private String blockOutput = "";
    private String pids = "";
    private String revision = "";

    public DockerContainerDto(String id, String image, String command, String created, String status, List<DockerPortDto> ports, String name) {
        this.id = id;
        this.image = image;
        this.command = command;
        this.created = created;
        this.status = status;
        this.ports = ports;
        this.name = name;
    }

    public void setStats(DockerStatsDto dockerStatsDto) {
        this.cpu = "" + (int)(dockerStatsDto.getCpu() + 0.5);
        this.memoryPercent = "" + (int)(dockerStatsDto.getMemory() + 0.5);
        this.pids = dockerStatsDto.getPids();
        this.memoryUsage = dockerStatsDto.getMemoryUsage();
        this.memoryLimit = dockerStatsDto.getMemoryLimit();
        this.netInput = dockerStatsDto.getNetInput();
        this.netOutput = dockerStatsDto.getNetOutput();
        this.blockInput = dockerStatsDto.getBlockInput();
        this.blockOutput = dockerStatsDto.getBlockOutput();
    }

    public String portsHtml() {
        Object ret = "";
        for (DockerPortDto port : this.ports) {
            if (port.getContainerport() <= 0) continue;
            if (((String)ret).length() > 0) {
                ret = (String)ret + ", ";
            }
            if (port.getHostport() > 0) {
                ret = (String)ret + "<span style=\"color:green;\">" + port.getHostport() + "</span>-&gt;";
            }
            ret = (String)ret + "<span style=\"color:orange;\">" + port.getContainerport() + "</span>";
        }
        return ret;
    }

    public String statusHtml() {
        if (this.running() && this.healthy()) {
            return "<span style=\"color:green;\">" + this.status + "</span>";
        }
        if (this.running()) {
            return "<span style=\"color:orange;\">" + this.status + "</span>";
        }
        return this.status;
    }

    public boolean running() {
        return this.status.trim().startsWith("Up");
    }

    public boolean starting() {
        return this.status.contains("starting");
    }

    public boolean healthy() {
        if (this.status.trim().startsWith("Up")) {
            if (this.status.contains("(healthy)")) {
                return true;
            }
            return !this.status.contains("(");
        }
        return false;
    }

    public int getCpuProzent() {
        try {
            double d = Double.parseDouble(this.cpu);
            return (int)d;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getMemProzent() {
        try {
            double d = Double.parseDouble(this.memoryPercent);
            return (int)d;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getImage() {
        return this.image;
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public String getCreated() {
        return this.created;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public List<DockerPortDto> getPorts() {
        return this.ports;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getCpu() {
        return this.cpu;
    }

    @Generated
    public String getMemoryUsage() {
        return this.memoryUsage;
    }

    @Generated
    public String getMemoryLimit() {
        return this.memoryLimit;
    }

    @Generated
    public String getMemoryPercent() {
        return this.memoryPercent;
    }

    @Generated
    public String getNetInput() {
        return this.netInput;
    }

    @Generated
    public String getNetOutput() {
        return this.netOutput;
    }

    @Generated
    public String getBlockInput() {
        return this.blockInput;
    }

    @Generated
    public String getBlockOutput() {
        return this.blockOutput;
    }

    @Generated
    public String getPids() {
        return this.pids;
    }

    @Generated
    public String getRevision() {
        return this.revision;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setImage(String image) {
        this.image = image;
    }

    @Generated
    public void setCommand(String command) {
        this.command = command;
    }

    @Generated
    public void setCreated(String created) {
        this.created = created;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setPorts(List<DockerPortDto> ports) {
        this.ports = ports;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    @Generated
    public void setMemoryUsage(String memoryUsage) {
        this.memoryUsage = memoryUsage;
    }

    @Generated
    public void setMemoryLimit(String memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    @Generated
    public void setMemoryPercent(String memoryPercent) {
        this.memoryPercent = memoryPercent;
    }

    @Generated
    public void setNetInput(String netInput) {
        this.netInput = netInput;
    }

    @Generated
    public void setNetOutput(String netOutput) {
        this.netOutput = netOutput;
    }

    @Generated
    public void setBlockInput(String blockInput) {
        this.blockInput = blockInput;
    }

    @Generated
    public void setBlockOutput(String blockOutput) {
        this.blockOutput = blockOutput;
    }

    @Generated
    public void setPids(String pids) {
        this.pids = pids;
    }

    @Generated
    public void setRevision(String revision) {
        this.revision = revision;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerContainerDto)) {
            return false;
        }
        DockerContainerDto other = (DockerContainerDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        String this$created = this.getCreated();
        String other$created = other.getCreated();
        if (this$created == null ? other$created != null : !this$created.equals(other$created)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        List this$ports = this.getPorts();
        List other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$cpu = this.getCpu();
        String other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !this$cpu.equals(other$cpu)) {
            return false;
        }
        String this$memoryUsage = this.getMemoryUsage();
        String other$memoryUsage = other.getMemoryUsage();
        if (this$memoryUsage == null ? other$memoryUsage != null : !this$memoryUsage.equals(other$memoryUsage)) {
            return false;
        }
        String this$memoryLimit = this.getMemoryLimit();
        String other$memoryLimit = other.getMemoryLimit();
        if (this$memoryLimit == null ? other$memoryLimit != null : !this$memoryLimit.equals(other$memoryLimit)) {
            return false;
        }
        String this$memoryPercent = this.getMemoryPercent();
        String other$memoryPercent = other.getMemoryPercent();
        if (this$memoryPercent == null ? other$memoryPercent != null : !this$memoryPercent.equals(other$memoryPercent)) {
            return false;
        }
        String this$netInput = this.getNetInput();
        String other$netInput = other.getNetInput();
        if (this$netInput == null ? other$netInput != null : !this$netInput.equals(other$netInput)) {
            return false;
        }
        String this$netOutput = this.getNetOutput();
        String other$netOutput = other.getNetOutput();
        if (this$netOutput == null ? other$netOutput != null : !this$netOutput.equals(other$netOutput)) {
            return false;
        }
        String this$blockInput = this.getBlockInput();
        String other$blockInput = other.getBlockInput();
        if (this$blockInput == null ? other$blockInput != null : !this$blockInput.equals(other$blockInput)) {
            return false;
        }
        String this$blockOutput = this.getBlockOutput();
        String other$blockOutput = other.getBlockOutput();
        if (this$blockOutput == null ? other$blockOutput != null : !this$blockOutput.equals(other$blockOutput)) {
            return false;
        }
        String this$pids = this.getPids();
        String other$pids = other.getPids();
        if (this$pids == null ? other$pids != null : !this$pids.equals(other$pids)) {
            return false;
        }
        String this$revision = this.getRevision();
        String other$revision = other.getRevision();
        return !(this$revision == null ? other$revision != null : !this$revision.equals(other$revision));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DockerContainerDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        String $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : $created.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        List $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : $cpu.hashCode());
        String $memoryUsage = this.getMemoryUsage();
        result = result * 59 + ($memoryUsage == null ? 43 : $memoryUsage.hashCode());
        String $memoryLimit = this.getMemoryLimit();
        result = result * 59 + ($memoryLimit == null ? 43 : $memoryLimit.hashCode());
        String $memoryPercent = this.getMemoryPercent();
        result = result * 59 + ($memoryPercent == null ? 43 : $memoryPercent.hashCode());
        String $netInput = this.getNetInput();
        result = result * 59 + ($netInput == null ? 43 : $netInput.hashCode());
        String $netOutput = this.getNetOutput();
        result = result * 59 + ($netOutput == null ? 43 : $netOutput.hashCode());
        String $blockInput = this.getBlockInput();
        result = result * 59 + ($blockInput == null ? 43 : $blockInput.hashCode());
        String $blockOutput = this.getBlockOutput();
        result = result * 59 + ($blockOutput == null ? 43 : $blockOutput.hashCode());
        String $pids = this.getPids();
        result = result * 59 + ($pids == null ? 43 : $pids.hashCode());
        String $revision = this.getRevision();
        result = result * 59 + ($revision == null ? 43 : $revision.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DockerContainerDto(id=" + this.getId() + ", image=" + this.getImage() + ", command=" + this.getCommand() + ", created=" + this.getCreated() + ", status=" + this.getStatus() + ", ports=" + String.valueOf(this.getPorts()) + ", name=" + this.getName() + ", cpu=" + this.getCpu() + ", memoryUsage=" + this.getMemoryUsage() + ", memoryLimit=" + this.getMemoryLimit() + ", memoryPercent=" + this.getMemoryPercent() + ", netInput=" + this.getNetInput() + ", netOutput=" + this.getNetOutput() + ", blockInput=" + this.getBlockInput() + ", blockOutput=" + this.getBlockOutput() + ", pids=" + this.getPids() + ", revision=" + this.getRevision() + ")";
    }

    @Generated
    public DockerContainerDto() {
    }

    @Generated
    public DockerContainerDto(String id, String image, String command, String created, String status, List<DockerPortDto> ports, String name, String cpu, String memoryUsage, String memoryLimit, String memoryPercent, String netInput, String netOutput, String blockInput, String blockOutput, String pids, String revision) {
        this.id = id;
        this.image = image;
        this.command = command;
        this.created = created;
        this.status = status;
        this.ports = ports;
        this.name = name;
        this.cpu = cpu;
        this.memoryUsage = memoryUsage;
        this.memoryLimit = memoryLimit;
        this.memoryPercent = memoryPercent;
        this.netInput = netInput;
        this.netOutput = netOutput;
        this.blockInput = blockInput;
        this.blockOutput = blockOutput;
        this.pids = pids;
        this.revision = revision;
    }
}

