/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.data.restclient.RestLettoDataService;
import at.letto.login.restclient.RestLoginService;
import at.letto.lti.restclient.RestLtiService;
import at.letto.setup.restclient.RestSetupService;
import at.letto.setupservice.config.LoggingConfiguration;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.config.TomcatConfiguration;
import at.letto.setupservice.service.DockerService;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LettoService {
    private Logger logger = LoggerFactory.getLogger(LettoService.class);
    @Autowired
    private TomcatConfiguration tomcatConfiguration;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private LoggingConfiguration loggingConfiguration;
    private DockerService dockerService = null;
    private String uriLTI = "";
    private String uriLogin = "";
    private String uriSetup = "";
    private HashMap<String, String> uriLettoData = new HashMap();
    private RestLoginService restLoginService = null;
    private RestLtiService restLtiService = null;
    private RestSetupService restSetupService = null;
    private HashMap<String, RestLettoDataService> restLettoDataServiceHashMap = new HashMap();

    public RestLoginService getLoginService() {
        return this.restLoginService != null ? this.restLoginService : (this.restLoginService = this.initLoginService());
    }

    public RestLtiService getLtiService() {
        return this.restLtiService != null ? this.restLtiService : (this.restLtiService = this.initLtiService());
    }

    public RestSetupService getSetupService() {
        return this.restSetupService != null ? this.restSetupService : (this.restSetupService = this.initSetupService());
    }

    public RestLettoDataService getLettoDataService(String school) {
        if (this.restLettoDataServiceHashMap.containsKey(school) && this.restLettoDataServiceHashMap.get(school) != null) {
            return (RestLettoDataService)this.restLettoDataServiceHashMap.get(school);
        }
        RestLettoDataService restLettoDataService = this.initLettoDataService(school);
        if (restLettoDataService != null) {
            this.restLettoDataServiceHashMap.put(school, restLettoDataService);
        }
        return restLettoDataService;
    }

    public synchronized RestLoginService initLoginService() {
        RestLoginService service = null;
        try {
            if (this.uriLogin != null && this.uriLogin.length() > 0 && (service = new RestLoginService(this.uriLogin, "user", this.microServiceConfiguration.getUserUserPassword())).ping()) {
                this.restLoginService = service;
                return this.restLoginService;
            }
            if (this.microServiceConfiguration.isSetupDocker()) {
                this.uriLogin = "http://letto-login.nw-letto:8095";
                service = new RestLoginService(this.uriLogin, "user", this.microServiceConfiguration.getUserUserPassword());
                if (service.ping()) {
                    this.restLoginService = service;
                    return this.restLoginService;
                }
            } else {
                this.uriLogin = "https://localhost";
                service = new RestLoginService(this.uriLogin, "user", this.microServiceConfiguration.getUserUserPassword());
                if (service.ping()) {
                    this.restLoginService = service;
                    return this.restLoginService;
                }
            }
            this.uriLogin = this.microServiceConfiguration.getLoginServiceUri();
            service = new RestLoginService(this.uriLogin, "user", this.microServiceConfiguration.getUserUserPassword());
            if (service.ping()) {
                this.restLoginService = service;
                return this.restLoginService;
            }
            this.uriLogin = "https://" + this.dockerService.getServerName();
            service = new RestLoginService(this.uriLogin, "user", this.microServiceConfiguration.getUserUserPassword());
            if (service.ping()) {
                this.restLoginService = service;
                return this.restLoginService;
            }
        }
        catch (Exception ex) {
            this.logger.error("Login-service kann nicht geladen werden");
        }
        this.uriLogin = "";
        return null;
    }

    public RestLoginService getRestLoginServiceAdmin() {
        RestLoginService service = new RestLoginService(this.uriLogin, "admin", this.microServiceConfiguration.getUserAdminPassword());
        return service;
    }

    public synchronized RestSetupService initSetupService() {
        RestSetupService service = null;
        try {
            if (this.microServiceConfiguration.isSetupDocker()) {
                if (this.uriSetup != null && this.uriSetup.length() > 0 && (service = new RestSetupService(this.uriSetup, "admin", this.microServiceConfiguration.getUserAdminPassword())).pingHost()) {
                    this.restSetupService = service;
                    return this.restSetupService;
                }
                this.uriSetup = "https://host.docker.internal:9096";
                service = new RestSetupService(this.uriSetup, "admin", this.microServiceConfiguration.getUserAdminPassword());
                if (service.pingHost()) {
                    this.restSetupService = service;
                    return this.restSetupService;
                }
                this.uriSetup = "https://172.17.0.1:9096";
                service = new RestSetupService(this.uriSetup, "admin", this.microServiceConfiguration.getUserAdminPassword());
                if (service.pingHost()) {
                    this.restSetupService = service;
                    return this.restSetupService;
                }
                if (!this.dockerService.getServerName().equals("localhost") && !this.dockerService.getServerName().equals("127.0.0.1") && this.dockerService.getServerName().length() > 0) {
                    this.uriSetup = "https://" + this.dockerService.getServerName();
                    service = new RestSetupService(this.uriSetup, "admin", this.microServiceConfiguration.getUserAdminPassword());
                    if (service.pingHost()) {
                        this.restSetupService = service;
                        return this.restSetupService;
                    }
                }
            } else {
                if (this.uriSetup != null && this.uriSetup.length() > 0 && (service = new RestSetupService(this.uriSetup, "admin", this.microServiceConfiguration.getUserAdminPassword())).pingDocker()) {
                    this.restSetupService = service;
                    return this.restSetupService;
                }
                this.uriSetup = "https://localhost:3096";
                service = new RestSetupService(this.uriSetup, "admin", this.microServiceConfiguration.getUserAdminPassword());
                if (service.pingDocker()) {
                    this.restSetupService = service;
                    return this.restSetupService;
                }
                this.uriSetup = "https://localhost";
                service = new RestSetupService(this.uriSetup, "admin", this.microServiceConfiguration.getUserAdminPassword());
                if (service.pingDocker()) {
                    this.restSetupService = service;
                    return this.restSetupService;
                }
                this.uriSetup = this.microServiceConfiguration.getSetupServiceUri();
                service = new RestSetupService(this.uriSetup, "admin", this.microServiceConfiguration.getUserAdminPassword());
                if (service.pingDocker()) {
                    this.restSetupService = service;
                    return this.restSetupService;
                }
                this.uriSetup = "https://" + this.dockerService.getServerName();
                service = new RestSetupService(this.uriSetup, "admin", this.microServiceConfiguration.getUserAdminPassword());
                if (service.pingDocker()) {
                    this.restSetupService = service;
                    return this.restSetupService;
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Setup-service kann nicht geladen werden");
        }
        this.uriSetup = "";
        return null;
    }

    public synchronized RestLettoDataService initLettoDataService(String school) {
        if (school == null || school.length() < 1) {
            return null;
        }
        RestLettoDataService service = null;
        try {
            Object uri = "";
            if (this.uriLettoData.containsKey(school) && this.uriLettoData.get(school) != null) {
                uri = (String)this.uriLettoData.get(school);
            }
            if (uri != null && ((String)uri).length() > 0 && (service = new RestLettoDataService((String)uri, "user", this.microServiceConfiguration.getUserUserPassword(), school)).ping()) {
                this.restLettoDataServiceHashMap.put(school, service);
                this.uriLettoData.put(school, uri);
                return service;
            }
            if (this.microServiceConfiguration.isSetupDocker() && (service = new RestLettoDataService((String)(uri = "http://letto-data-" + school + ".nw-letto:8300"), "user", this.microServiceConfiguration.getUserUserPassword(), school)).ping()) {
                this.restLettoDataServiceHashMap.put(school, service);
                this.uriLettoData.put(school, uri);
                return service;
            }
            uri = "http://localhost:8300";
            service = new RestLettoDataService((String)uri, "user", this.microServiceConfiguration.getUserUserPassword(), school);
            if (service.ping()) {
                this.restLettoDataServiceHashMap.put(school, service);
                this.uriLettoData.put(school, uri);
                return service;
            }
        }
        catch (Exception ex) {
            this.logger.error("Data-service der Schule " + school + " kann nicht geladen werden");
        }
        if (this.uriLettoData.containsKey("school")) {
            this.uriLettoData.remove(school);
        }
        return null;
    }

    public synchronized RestLtiService initLtiService() {
        RestLtiService service = null;
        try {
            if (this.uriLTI != null && this.uriLTI.length() > 0 && (service = new RestLtiService(this.uriLTI, "user", this.microServiceConfiguration.getUserUserPassword())).ping()) {
                this.restLtiService = service;
                return this.restLtiService;
            }
            if (this.microServiceConfiguration.isSetupDocker()) {
                this.uriLTI = "http://letto-lti.nw-letto:9090";
                service = new RestLtiService(this.uriLTI, "user", this.microServiceConfiguration.getUserUserPassword());
                if (service.ping()) {
                    this.restLtiService = service;
                    return this.restLtiService;
                }
            } else {
                this.uriLTI = "https://localhost:9090";
                service = new RestLtiService(this.uriLTI, "user", this.microServiceConfiguration.getUserUserPassword());
                if (service.ping()) {
                    this.restLtiService = service;
                    return this.restLtiService;
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("Lti-service kann nicht geladen werden");
        }
        this.uriLTI = "";
        return null;
    }

    @Generated
    public void setDockerService(DockerService dockerService) {
        this.dockerService = dockerService;
    }

    @Generated
    public String getUriLTI() {
        return this.uriLTI;
    }

    @Generated
    public String getUriLogin() {
        return this.uriLogin;
    }

    @Generated
    public String getUriSetup() {
        return this.uriSetup;
    }

    @Generated
    public HashMap<String, String> getUriLettoData() {
        return this.uriLettoData;
    }
}

