/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.basespringboot.security.JwtAuthentication;
import at.letto.basespringboot.security.WebSecurityConfig;
import at.letto.databaseclient.service.LettoUserLoginService;
import at.letto.login.restclient.RestLoginService;
import at.letto.security.LettoToken;
import at.letto.setupservice.beans.SessionBean;
import at.letto.setupservice.config.LoggingConfiguration;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.dto.LeTToSetupSession;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.LettoService;
import at.letto.setupservice.service.SetupUserDetailsService;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class LoginService {
    private Logger logger = LoggerFactory.getLogger(LoginService.class);
    public static final String TOKEN_ISSUER = "LeTTo-Setup";
    public static final String TOKEN_AUDIENCE = "LeTTo";
    @Autowired
    private SetupUserDetailsService setupUserDetailsService;
    @Autowired
    private LoggingConfiguration loggingConfiguration;
    @Autowired
    private LettoService lettoService;
    @Autowired
    private DockerService dockerService;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private LettoUserLoginService lettoUserLoginService;
    @Autowired
    private WebSecurityConfig webSecurityConfig;
    @Resource(name="sessionBean")
    SessionBean sessionBean;
    private ConcurrentHashMap<String, LeTToSetupSession> sessions = new ConcurrentHashMap();

    public void checkSessionsAlive() {
        try {
            for (String sessionID : this.sessions.keySet()) {
                try {
                    LettoToken lettoToken;
                    SessionBean sb;
                    HttpSession session;
                    LeTToSetupSession leTToSetupSession = (LeTToSetupSession)this.sessions.get(sessionID);
                    try {
                        session = leTToSetupSession.session;
                        sb = (SessionBean)session.getAttribute("scopedTarget.sessionBean");
                        boolean active = sb.isActive();
                        if (session.getServletContext() == null) {
                            this.loggingConfiguration.getLoginLogger().logMessage("LOGOUT(Session Context expired) - user: " + leTToSetupSession.username + " Session-ID:" + leTToSetupSession.sessionID);
                            this.logoutToken(leTToSetupSession.lettoToken);
                            this.sessions.remove(sessionID);
                            leTToSetupSession = null;
                        }
                    }
                    catch (Exception ex) {
                        this.loggingConfiguration.getLoginLogger().logMessage("LOGOUT(Session expired) - user: " + leTToSetupSession.username + " Session-ID:" + leTToSetupSession.sessionID);
                        this.logoutToken(leTToSetupSession.lettoToken);
                        this.sessions.remove(sessionID);
                        leTToSetupSession = null;
                    }
                    if (leTToSetupSession != null && !(lettoToken = leTToSetupSession.lettoToken).isTokenNotExpired()) {
                        this.loggingConfiguration.getLoginLogger().logMessage("LOGOUT(Token expired) - user: " + leTToSetupSession.username + " Session-ID:" + leTToSetupSession.sessionID);
                        this.sessions.remove(sessionID);
                        this.logoutToken(lettoToken);
                        leTToSetupSession = null;
                    }
                    if (leTToSetupSession == null) continue;
                    session = leTToSetupSession.session;
                    sb = (SessionBean)session.getAttribute("scopedTarget.sessionBean");
                    this.updateSessionToken(sb);
                    this.logger.info("Session still active: User: " + leTToSetupSession.username + " Session-ID: " + leTToSetupSession.sessionID + " Creation-Date: " + String.valueOf(leTToSetupSession.creationDate) + " Creation-Millis: " + leTToSetupSession.creationMillis + " Client-IP: " + leTToSetupSession.clientIP + " Client-Host: " + leTToSetupSession.clientHost + " Client-Port: " + leTToSetupSession.clientPort + " Initial-Request-URI: " + leTToSetupSession.initialRequestURI + " Token-Valid-Millis: " + leTToSetupSession.lettoToken.getValidMillis());
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void logoutToken(LettoToken lettoToken) {
        if (lettoToken == null) {
            return;
        }
        if (lettoToken.getIssuer().equals(TOKEN_ISSUER)) {
            this.lettoUserLoginService.logout(lettoToken);
        } else {
            RestLoginService restLoginService = this.lettoService.getLoginService();
            restLoginService.jwtLogout(lettoToken.getToken());
        }
    }

    public HttpSession createSession(HttpServletRequest request, LettoToken lettoToken) {
        JwtAuthentication jwtAuthentication = new JwtAuthentication(lettoToken);
        SecurityContext securityContext = SecurityContextHolder.getContext();
        securityContext.setAuthentication((Authentication)jwtAuthentication);
        HttpSession session = request.getSession(true);
        this.sessionBean.setHttpSession(session);
        this.sessionBean.setLettoToken(lettoToken);
        this.sessionBean.setActive(true);
        this.sessionBean.setCreationDate(new Date());
        this.sessionBean.setCreationMillis(System.currentTimeMillis());
        if (session != null) {
            session.setAttribute("SPRING_SECURITY_CONTEXT", (Object)securityContext);
            this.loggingConfiguration.getLoginLogger().logMessage("LOGIN OK user: " + lettoToken.getUsername() + " Session-ID:" + session.getId());
            this.sessions.put(session.getId(), new LeTToSetupSession(session, lettoToken, request));
        }
        return session;
    }

    public void destroySession() {
        String username = this.sessionBean.getUsername();
        if (username != null && username.trim().length() > 0) {
            this.loggingConfiguration.getLoginLogger().logMessage("LOGOUT - user: " + username + " Session-ID:" + this.sessionBean.getHttpSession().getId());
        }
        this.deactivateSession(this.sessionBean);
    }

    public void destroySessionError() {
        String username = this.sessionBean.getUsername();
        if (username != null && username.trim().length() > 0) {
            if (this.sessionBean.getLettoToken().isTokenNotExpired()) {
                this.loggingConfiguration.getLoginLogger().logMessage("ERROR-LOGOUT - user: " + username + " Session-ID:" + this.sessionBean.getHttpSession().getId());
            } else {
                this.loggingConfiguration.getLoginLogger().logMessage("Token expired - user: " + username + " Session-ID:" + this.sessionBean.getHttpSession().getId());
            }
        }
        this.deactivateSession(this.sessionBean);
    }

    private void deactivateSession(SessionBean sessionBean) {
        try {
            String sessionID = sessionBean.getHttpSession().getId();
            this.logoutToken(sessionBean.getLettoToken());
            if (this.sessions.containsKey(sessionID)) {
                this.sessions.remove(sessionID);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        sessionBean.deactivate();
    }

    public boolean updateSessionToken() {
        return this.updateSessionToken(this.sessionBean);
    }

    public boolean updateSessionToken(SessionBean sessionBean) {
        try {
            LettoToken lettoToken;
            if (sessionBean != null && sessionBean.isActive() && (lettoToken = sessionBean.getLettoToken()) != null && lettoToken.isTokenNotExpired() && lettoToken.getValidMillis() < this.microServiceConfiguration.getJwtRefreshTime()) {
                LettoToken newLettoToken = null;
                if (lettoToken.getIssuer().equals(TOKEN_ISSUER)) {
                    if (newLettoToken != null) {
                        this.loggingConfiguration.getLoginLogger().logMessage("REFRESH(setup) OK user: " + newLettoToken.getUsername() + " Session-ID:" + sessionBean.getHttpSession().getId());
                    }
                } else {
                    RestLoginService restLoginService = this.lettoService.getLoginService();
                    newLettoToken = restLoginService.jwtRefresh(lettoToken, "").getLettoToken();
                    if (newLettoToken != null) {
                        this.loggingConfiguration.getLoginLogger().logMessage("REFRESH(login) OK user: " + newLettoToken.getUsername() + " Session-ID:" + sessionBean.getHttpSession().getId());
                    }
                }
                if (newLettoToken != null) {
                    JwtAuthentication jwtAuthentication = new JwtAuthentication(newLettoToken);
                    SecurityContext securityContext = SecurityContextHolder.getContext();
                    securityContext.setAuthentication((Authentication)jwtAuthentication);
                    sessionBean.setLettoToken(newLettoToken);
                    sessionBean.getHttpSession().setAttribute("SPRING_SECURITY_CONTEXT", (Object)securityContext);
                    String sessionID = sessionBean.getHttpSession().getId();
                    if (this.sessions.containsKey(sessionID)) {
                        LeTToSetupSession leTToSetupSession = (LeTToSetupSession)this.sessions.get(sessionID);
                        leTToSetupSession.lettoToken = newLettoToken;
                    }
                    return true;
                }
            }
        }
        catch (Exception ex) {
            try {
                this.loggingConfiguration.getLoginLogger().logMessageCritical("Error during Token-Refresh! User:" + sessionBean.getLettoToken().getUsername() + " Session-ID:" + sessionBean.getHttpSession().getId());
            }
            catch (Exception ex1) {
                System.out.println("Login-Logger fehlerhaft! Cannot refresh Token!");
            }
        }
        return false;
    }
}

