/*
 * Decompiled with CFR 0.152.
 */
package at.letto.exportservice.security;

import at.letto.exportservice.config.MicroServiceConfiguration;
import at.letto.security.LettoToken;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenService {
    private String secret;
    private long expiration;
    private MicroServiceConfiguration microServiceConfiguration;

    public JwtTokenService(MicroServiceConfiguration microServiceConfiguration) {
        this.microServiceConfiguration = microServiceConfiguration;
        this.secret = this.microServiceConfiguration.getJwtSecret();
        this.expiration = this.microServiceConfiguration.getJwtExpiration();
    }

    public LettoToken toLettoToken(String token) {
        return new LettoToken(token, this.secret);
    }

    public LettoToken generateLettoToken(String username, String vorname, String nachname, String activDirectoryname, String email, Integer id, Integer idSchule, List<String> roles) {
        LettoToken lettoToken = new LettoToken(this.secret, Long.valueOf(this.expiration), username, vorname, nachname, activDirectoryname, email, id, idSchule, roles);
        return lettoToken;
    }

    public LettoToken refreshToken(String token) {
        LettoToken lettoToken = new LettoToken(token, this.secret);
        LettoToken newToken = this.generateLettoToken(lettoToken.getUsername(), lettoToken.getVorname(), lettoToken.getNachname(), lettoToken.getActiveDirectoryName(), lettoToken.getEmail(), lettoToken.getId(), lettoToken.getIdSchule(), lettoToken.getRoles());
        return newToken;
    }
}

