/*
 * Decompiled with CFR 0.152.
 */
package at.letto.imageservice.controller;

import at.letto.imageservice.config.TomcatConfiguration;
import at.letto.service.microservice.AdminInfoDto;
import at.letto.tools.ServerStatus;
import java.util.Date;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.boot.system.ApplicationPid;
import org.springframework.context.ApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class InfoController {
    private final ApplicationContext applicationContext;
    private final TomcatConfiguration tomcatConfiguration;

    public InfoController(ApplicationContext applicationContext, TomcatConfiguration tomcatConfiguration) {
        this.applicationContext = applicationContext;
        this.tomcatConfiguration = tomcatConfiguration;
    }

    @PostMapping(value={"/image/ping"})
    public ResponseEntity<String> pingPost() {
        return ResponseEntity.ok((Object)"pong");
    }

    @GetMapping(value={"/image/ping"})
    public ResponseEntity<String> pingGet() {
        return ResponseEntity.ok((Object)"pong");
    }

    @PostMapping(value={"/image/open/pingp"})
    public ResponseEntity<String> pingP(@RequestBody String dto) {
        if (dto.equals("ping")) {
            return ResponseEntity.ok((Object)"pong");
        }
        return ResponseEntity.ok((Object)"fail");
    }

    @GetMapping(value={"/image/open/pingg"})
    public ResponseEntity<String> pingG(@RequestParam String dto) {
        if (dto.equals("ping")) {
            return ResponseEntity.ok((Object)"pong");
        }
        return ResponseEntity.ok((Object)"fail");
    }

    @PostMapping(value={"/image/auth/gast/ping"})
    public ResponseEntity<String> pingGast() {
        return ResponseEntity.ok((Object)"pong");
    }

    @PostMapping(value={"/image/auth/user/ping"})
    public ResponseEntity<String> pingUser() {
        return ResponseEntity.ok((Object)"pong");
    }

    @PostMapping(value={"/image/auth/admin/ping"})
    public ResponseEntity<String> pingAdmin() {
        return ResponseEntity.ok((Object)"pong");
    }

    @PostMapping(value={"/image/auth/letto/ping"})
    public ResponseEntity<String> pingLetto() {
        return ResponseEntity.ok((Object)"pong");
    }

    @GetMapping(value={"/image/open/version"})
    public ResponseEntity<String> version() {
        return ResponseEntity.ok((Object)ServerStatus.getRevision());
    }

    @GetMapping(value={"/image/open/info"})
    public ResponseEntity<String> info() {
        String applicationname = this.applicationContext.getId();
        String msg = "Application: " + applicationname;
        return ResponseEntity.ok((Object)msg);
    }

    @GetMapping(value={"/image/auth/letto/admininfo"})
    public ResponseEntity<AdminInfoDto> lettoinfo() {
        return this.admininfo();
    }

    @GetMapping(value={"/image/auth/admin/admininfo"})
    public ResponseEntity<AdminInfoDto> admininfo() {
        String pid = new ApplicationPid().toString();
        String applicationname = this.applicationContext.getId();
        String applicationhome = new ApplicationHome().toString();
        long uptime = System.currentTimeMillis() - this.applicationContext.getStartupDate();
        String serverversion = ServerStatus.getServerVersion();
        serverversion = "Spring Boot " + SpringVersion.getVersion() + (serverversion != null && serverversion.length() > 0 ? " , " + serverversion : "");
        AdminInfoDto ret = new AdminInfoDto(applicationname, pid, applicationhome, this.applicationContext.getStartupDate(), uptime, ServerStatus.getRevision(), new Date().toString(), ServerStatus.getBetriebssystem(), ServerStatus.getIP(), ServerStatus.getEncoding(), ServerStatus.getFileEncoding(), ServerStatus.getFileSeparator(), ServerStatus.getJavaSpecificationVersion(), ServerStatus.getJavaVendor(), ServerStatus.getJavaVersion(), ServerStatus.getJavaVersionNumber(), ServerStatus.getHostname(), ServerStatus.getLanguage(), ServerStatus.getLinuxDescription(), ServerStatus.getLinuxDistribution(), ServerStatus.getLinuxRelease(), ServerStatus.getServerUsername(), serverversion, ServerStatus.getSystemHome(), ServerStatus.isLinux(), ServerStatus.isUbuntu(), ServerStatus.isWindows(), this.tomcatConfiguration.getHttpPort(), this.tomcatConfiguration.getAjpPort(), this.tomcatConfiguration.getHttpsPort());
        return ResponseEntity.ok((Object)ret);
    }
}

