/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.controller;

import at.letto.beurteilung.dto.BeurteilungDTO;
import at.letto.beurteilung.dto.FremdLehrerDTO;
import at.letto.beurteilung.dto.KlassenBeurteilungDTO;
import at.letto.beurteilung.dto.KlassenInfoDTO;
import at.letto.beurteilung.dto.KompetenzBeurteilungsDTO;
import at.letto.beurteilung.dto.LehrerInfoDTO;
import at.letto.beurteilung.dto.NoteDTO;
import at.letto.beurteilung.dto.StudentDto;
import at.letto.beurteilung.dto.StudentGroupDto;
import at.letto.beurteilung.dto.TestDTO;
import at.letto.beurteilung.dto.TestPunkteDTO;
import at.letto.data.config.MicroServiceConfiguration;
import at.letto.data.service.BeurteilungService;
import at.letto.dto.ObjAndMsg;
import at.letto.dto.PairIntString;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;

@RestController
@RequestMapping
public class BeurteilungsController {
    @Autowired
    private BeurteilungService beurteilungService;
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;

    public ResponseEntity<String> changeKlassenbeurteilungsGewicht(int idKb, double gewicht) {
        return ResponseEntity.ok((Object)this.beurteilungService.changeKlassenbeurteilungsGewicht(idKb, gewicht));
    }

    public ResponseEntity<String> delBeurteilung(@RequestBody int id) {
        return ResponseEntity.ok((Object)this.beurteilungService.delBeurteilung(id));
    }

    public ResponseEntity<String> delBeurteilungenTestversuch(@RequestBody int id) {
        return ResponseEntity.ok((Object)this.beurteilungService.delBeurteilungenTestversuch(id));
    }

    public ResponseEntity<String> delKlassenBeurteilung(@RequestBody int id) {
        return ResponseEntity.ok((Object)this.beurteilungService.delKlassenBeurteilung(id));
    }

    public ResponseEntity<ObjAndMsg<BeurteilungDTO>> delOnlineTest(@RequestBody BeurteilungDTO b) {
        return ResponseEntity.ok((Object)this.beurteilungService.delOnlineTest(b));
    }

    public ResponseEntity<ObjAndMsg<KlassenBeurteilungDTO>> delOnlineTest(KlassenBeurteilungDTO b, int idSchema) {
        return ResponseEntity.ok((Object)this.beurteilungService.delOnlineTest(b, idSchema));
    }

    @PostMapping(value={"/data/open/beurt/beurtbyid"})
    public DeferredResult<ResponseEntity<BeurteilungDTO>> handleReqDefResult(@RequestBody String id) {
        DeferredResult output = new DeferredResult();
        ForkJoinPool.commonPool().submit(() -> {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            output.setResult((Object)ResponseEntity.ok((Object)new BeurteilungDTO()));
        });
        return output;
    }

    public ResponseEntity<BeurteilungDTO> findBeurteilungFromKlassenbeurteilungAndUser(int idKlassenbeurteilung, int idUser, int idSchema) {
        return ResponseEntity.ok(this.beurteilungService.findBeurteilungFromKlassenbeurteilungAndUser(idKlassenbeurteilung, idUser, idSchema).get());
    }

    @PostMapping(value={"/data/open/beurt/idlkfrombeurt"})
    public ResponseEntity<Integer> findIdLkBeurteilung(@RequestBody int id) {
        return ResponseEntity.ok(this.beurteilungService.findIdLkBeurteilung(id).get());
    }

    @PostMapping(value={"/data/open/beurt/klassenbeurtbyid"})
    public ResponseEntity<KlassenBeurteilungDTO> findKlassenbeurteilung(@RequestBody int id) {
        return ResponseEntity.ok(this.beurteilungService.findKlassenbeurteilung(id).get());
    }

    @PostMapping(value={"/data/open/beurt/parentklassenbeurt"})
    public ResponseEntity<KlassenBeurteilungDTO> findParentKlassenbeurteilung(@RequestBody int id) {
        return ResponseEntity.ok(this.beurteilungService.findParentKlassenbeurteilung(id).get());
    }

    @PostMapping(value={"/data/open/beurt/notebyid"})
    public ResponseEntity<NoteDTO> findNote(@RequestBody int idNote) {
        return ResponseEntity.ok(this.beurteilungService.findNote(idNote).get());
    }

    public ResponseEntity<BeurteilungDTO> saveBeurteilung(BeurteilungDTO b, int idSchema) {
        return ResponseEntity.ok((Object)this.beurteilungService.saveBeurteilung(b, idSchema));
    }

    public ResponseEntity<KlassenBeurteilungDTO> saveKlassenBeurteilung(KlassenBeurteilungDTO kbDto, int idSchema) {
        return ResponseEntity.ok((Object)this.beurteilungService.saveKlassenBeurteilung(kbDto, idSchema));
    }

    public ResponseEntity<NoteDTO> saveNote(@RequestBody NoteDTO n) {
        return ResponseEntity.ok((Object)this.beurteilungService.saveNote(n));
    }

    public ResponseEntity<Integer> findLehrerID(@RequestBody int idLk) {
        return ResponseEntity.of((Optional)this.beurteilungService.findLehrerID(idLk));
    }

    public ResponseEntity<List<BeurteilungDTO>> findByLK(@RequestBody int idLk) {
        return ResponseEntity.ok((Object)this.beurteilungService.findByLK(idLk));
    }

    public ResponseEntity<List<BeurteilungDTO>> findGlobalByLK(@RequestBody int idLk) {
        return ResponseEntity.ok((Object)this.beurteilungService.findGlobalByLK(idLk));
    }

    public ResponseEntity<List<BeurteilungDTO>> findSubBeurteilungen(@RequestBody Set<Integer> ids) {
        return ResponseEntity.ok((Object)this.beurteilungService.findSubBeurteilungen(ids));
    }

    public ResponseEntity<BeurteilungDTO> findBeurteilungDto(@RequestBody int id) {
        return ResponseEntity.ok(this.beurteilungService.findBeurteilungDto(id).get());
    }

    public ResponseEntity<List<FremdLehrerDTO>> findFremdLehrer(@RequestBody Set<Integer> ids) {
        return ResponseEntity.ok((Object)this.beurteilungService.findFremdLehrer(ids));
    }

    public ResponseEntity<List<KompetenzBeurteilungsDTO>> findKompetenzen(@RequestBody Set<Integer> ids) {
        return ResponseEntity.ok((Object)this.beurteilungService.findKompetenzen(ids));
    }

    public ResponseEntity<List<KlassenBeurteilungDTO>> findKlassenBeurteilungDto(@RequestBody int idLk) {
        return ResponseEntity.ok((Object)this.beurteilungService.findKlassenBeurteilungDto(idLk));
    }

    public ResponseEntity<List<KlassenBeurteilungDTO>> findSubKlassenBeurteilungDto(@RequestBody Set<Integer> idsParent) {
        return ResponseEntity.ok((Object)this.beurteilungService.findSubKlassenBeurteilungDto(idsParent));
    }

    public ResponseEntity<List<KlassenBeurteilungDTO>> findGlobalKlassenBeurteilungDto(@RequestBody int idLk) {
        return ResponseEntity.ok((Object)this.beurteilungService.findGlobalKlassenBeurteilungDto(idLk));
    }

    public ResponseEntity<List<BeurteilungDTO>> findByKlasse(@RequestBody int idKlasse) {
        return ResponseEntity.ok((Object)this.beurteilungService.findByKlasse(idKlasse));
    }

    public ResponseEntity<List<PairIntString>> findTestsWithFullPath(@RequestBody int idLk) {
        return ResponseEntity.ok((Object)this.beurteilungService.findTestsWithFullPath(idLk));
    }

    public ResponseEntity<List<PairIntString>> findTestsGlobalWithFullPath(@RequestBody int idLk) {
        return ResponseEntity.ok((Object)this.beurteilungService.findTestsGlobalWithFullPath(idLk));
    }

    public ResponseEntity<List<PairIntString>> findTestsFullPathWinterSemester(int idLk, Date semester) {
        return ResponseEntity.ok((Object)this.beurteilungService.findTestsFullPathWinterSemester(idLk, semester));
    }

    public ResponseEntity<List<PairIntString>> findTestsGlobalFullPathWinterSemester(int idLk, Date semester) {
        return ResponseEntity.ok((Object)this.beurteilungService.findTestsGlobalFullPathWinterSemester(idLk, semester));
    }

    public ResponseEntity<List<PairIntString>> findTestsFullPathSommerSemester(int idLk, Date semester) {
        return ResponseEntity.ok((Object)this.beurteilungService.findTestsFullPathSommerSemester(idLk, semester));
    }

    public ResponseEntity<List<PairIntString>> findTestsGlobalFullPathSommerSemester(int idLk, Date semester) {
        return ResponseEntity.ok((Object)this.beurteilungService.findTestsGlobalFullPathSommerSemester(idLk, semester));
    }

    public ResponseEntity<List<TestDTO>> findTests(@RequestBody Set<Integer> idAct) {
        return ResponseEntity.ok((Object)this.beurteilungService.findTests(idAct));
    }

    public ResponseEntity<Map<Integer, List<Integer>>> findTestGroups(@RequestBody Set<Integer> idAct) {
        return ResponseEntity.ok((Object)this.beurteilungService.findTestGroups(idAct));
    }

    public ResponseEntity<List<TestPunkteDTO>> loadTestPoints(@RequestBody Set<Integer> idAct) {
        return ResponseEntity.ok((Object)this.beurteilungService.loadTestPoints(idAct));
    }

    public ResponseEntity<List<NoteDTO>> findNoten(@RequestBody int idLk) {
        return ResponseEntity.ok((Object)this.beurteilungService.findNoten(idLk));
    }

    public ResponseEntity<List<StudentDto>> findStudents(@RequestBody int idLk) {
        return ResponseEntity.ok((Object)this.beurteilungService.findStudents(idLk));
    }

    public ResponseEntity<List<StudentGroupDto>> findStudentGroups(@RequestBody int idLk) {
        return ResponseEntity.ok((Object)this.beurteilungService.findStudentGroups(idLk));
    }

    public ResponseEntity<KlassenInfoDTO> findKlassenInfo(@RequestBody int idLk) {
        return ResponseEntity.ok(this.beurteilungService.findKlassenInfo(idLk).get());
    }

    public ResponseEntity<List<LehrerInfoDTO>> findLehrerInKlasse(@RequestBody int idLk) {
        return ResponseEntity.ok((Object)this.beurteilungService.findLehrerInKlasse(idLk));
    }

    public ResponseEntity<List<Integer>> findBeurteilungenSchuljahr(@RequestBody int idSchuljahr) {
        return ResponseEntity.ok((Object)this.beurteilungService.findBeurteilungenSchuljahr(idSchuljahr));
    }

    public ResponseEntity<List<String>> findActivitiesInKlasse(@RequestBody int idLk) {
        return ResponseEntity.ok((Object)this.beurteilungService.findActivitiesInKlasse(idLk));
    }
}

