/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.entity;

import at.letto.category.dto.CategoryDTO;
import at.letto.data.entity.CascadeOnDelete;
import at.letto.data.entity.GegenstandEntity;
import at.letto.data.entity.KompetenzEntity;
import at.letto.data.entity.MoodleRechteEntity;
import at.letto.data.entity.QuestionEntity;
import at.letto.data.entity.SchuleEntity;
import at.letto.data.entity.UserEntity;
import at.letto.dto.enums.Level;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.ConstructorResult;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedNativeQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.Table;

@Entity
@Table(name="category")
@NamedNativeQuery(name="CategoryEntity.findAllCategories", query="SELECT  c.id as id, c.name as name, c.idParent as idParent, c.GLOBALCATEGORY as globalCategory, c.PRIVATECATEGORY as privateCategory, count(q.id) as questionsInCategory, k.kompetenz as kompetenz, c.idSchool as idSchule FROM category c left join kompetenz k on k.id = c.KOMP_ID left join question q on q.idCategory = c.id group by c.id, k.id order by c.idParent, c.categories_ORDER ", resultSetMapping="CategoryDTO")
@SqlResultSetMapping(name="CategoryDTO", classes={@ConstructorResult(targetClass=CategoryDTO.class, columns={@ColumnResult(name="id"), @ColumnResult(name="name"), @ColumnResult(name="idParent"), @ColumnResult(name="globalCategory"), @ColumnResult(name="privateCategory"), @ColumnResult(name="questionsInCategory"), @ColumnResult(name="kompetenz"), @ColumnResult(name="idSchule")})})
public class CategoryEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    private Integer id;
    @OneToMany(mappedBy="parent", cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH})
    @OrderColumn
    private List<CategoryEntity> categories = new ArrayList();
    @OneToMany(mappedBy="category", cascade={CascadeType.MERGE})
    @OrderColumn
    private List<MoodleRechteEntity> rechte = new ArrayList();
    @OneToMany(mappedBy="category", cascade={CascadeType.ALL})
    @OrderColumn
    private List<QuestionEntity> questionList = new ArrayList();
    @ManyToMany
    @OrderColumn
    private List<KompetenzEntity> kompetenzen = new ArrayList();
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="ID")
    @CascadeOnDelete
    @OrderColumn
    private List<GegenstandEntity> gegenstaende = new ArrayList();
    @ManyToMany
    @JoinColumn(name="ID")
    @OrderColumn
    private List<QuestionEntity> questions = new ArrayList();
    @ManyToMany(mappedBy="categories", cascade={CascadeType.ALL})
    private List<SchuleEntity> schulen = new ArrayList();
    @ManyToMany(mappedBy="aboCategories", cascade={CascadeType.ALL})
    private List<UserEntity> userAbo = new ArrayList();
    @ManyToOne
    @JoinColumn(name="idParent")
    private CategoryEntity parent;
    @ManyToOne
    @JoinColumn(name="KOMP_ID")
    private KompetenzEntity kompetenz;
    @ManyToOne
    @JoinColumn(name="IDSCHOOL")
    private SchuleEntity schule;
    @Column(name="EINHEITENKORR")
    private Boolean einheitenKorr = false;
    @Lob
    @Column(name="EINHEITENKORRTEXT")
    private String einheitenKorrText = "";
    @Column(name="GLOBALCATEGORY")
    private Boolean globalCategory = false;
    @Column(name="LEVEL")
    @Enumerated(value=EnumType.ORDINAL)
    private Level level = Level.Grundlagen;
    @Column(name="NAME")
    private String name = "";
    @Column(name="PRIVATECATEGORY")
    private Boolean privateCategory = false;
    @Column(name="USEINTERNALCALC")
    private Boolean useInternalCalc = false;

    public Integer getId() {
        return this.id;
    }

    public List<CategoryEntity> getCategories() {
        return this.categories;
    }

    public List<MoodleRechteEntity> getRechte() {
        return this.rechte;
    }

    public List<QuestionEntity> getQuestionList() {
        return this.questionList;
    }

    public List<KompetenzEntity> getKompetenzen() {
        return this.kompetenzen;
    }

    public List<GegenstandEntity> getGegenstaende() {
        return this.gegenstaende;
    }

    public List<QuestionEntity> getQuestions() {
        return this.questions;
    }

    public List<SchuleEntity> getSchulen() {
        return this.schulen;
    }

    public List<UserEntity> getUserAbo() {
        return this.userAbo;
    }

    public CategoryEntity getParent() {
        return this.parent;
    }

    public KompetenzEntity getKompetenz() {
        return this.kompetenz;
    }

    public SchuleEntity getSchule() {
        return this.schule;
    }

    public Boolean getEinheitenKorr() {
        return this.einheitenKorr;
    }

    public String getEinheitenKorrText() {
        return this.einheitenKorrText;
    }

    public Boolean getGlobalCategory() {
        return this.globalCategory;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getPrivateCategory() {
        return this.privateCategory;
    }

    public Boolean getUseInternalCalc() {
        return this.useInternalCalc;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setCategories(List<CategoryEntity> categories) {
        this.categories = categories;
    }

    public void setRechte(List<MoodleRechteEntity> rechte) {
        this.rechte = rechte;
    }

    public void setQuestionList(List<QuestionEntity> questionList) {
        this.questionList = questionList;
    }

    public void setKompetenzen(List<KompetenzEntity> kompetenzen) {
        this.kompetenzen = kompetenzen;
    }

    public void setGegenstaende(List<GegenstandEntity> gegenstaende) {
        this.gegenstaende = gegenstaende;
    }

    public void setQuestions(List<QuestionEntity> questions) {
        this.questions = questions;
    }

    public void setSchulen(List<SchuleEntity> schulen) {
        this.schulen = schulen;
    }

    public void setUserAbo(List<UserEntity> userAbo) {
        this.userAbo = userAbo;
    }

    public void setParent(CategoryEntity parent) {
        this.parent = parent;
    }

    public void setKompetenz(KompetenzEntity kompetenz) {
        this.kompetenz = kompetenz;
    }

    public void setSchule(SchuleEntity schule) {
        this.schule = schule;
    }

    public void setEinheitenKorr(Boolean einheitenKorr) {
        this.einheitenKorr = einheitenKorr;
    }

    public void setEinheitenKorrText(String einheitenKorrText) {
        this.einheitenKorrText = einheitenKorrText;
    }

    public void setGlobalCategory(Boolean globalCategory) {
        this.globalCategory = globalCategory;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrivateCategory(Boolean privateCategory) {
        this.privateCategory = privateCategory;
    }

    public void setUseInternalCalc(Boolean useInternalCalc) {
        this.useInternalCalc = useInternalCalc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoryEntity)) {
            return false;
        }
        CategoryEntity other = (CategoryEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        List this$categories = this.getCategories();
        List other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        List this$rechte = this.getRechte();
        List other$rechte = other.getRechte();
        if (this$rechte == null ? other$rechte != null : !((Object)this$rechte).equals(other$rechte)) {
            return false;
        }
        List this$questionList = this.getQuestionList();
        List other$questionList = other.getQuestionList();
        if (this$questionList == null ? other$questionList != null : !((Object)this$questionList).equals(other$questionList)) {
            return false;
        }
        List this$kompetenzen = this.getKompetenzen();
        List other$kompetenzen = other.getKompetenzen();
        if (this$kompetenzen == null ? other$kompetenzen != null : !((Object)this$kompetenzen).equals(other$kompetenzen)) {
            return false;
        }
        List this$gegenstaende = this.getGegenstaende();
        List other$gegenstaende = other.getGegenstaende();
        if (this$gegenstaende == null ? other$gegenstaende != null : !((Object)this$gegenstaende).equals(other$gegenstaende)) {
            return false;
        }
        List this$questions = this.getQuestions();
        List other$questions = other.getQuestions();
        if (this$questions == null ? other$questions != null : !((Object)this$questions).equals(other$questions)) {
            return false;
        }
        List this$schulen = this.getSchulen();
        List other$schulen = other.getSchulen();
        if (this$schulen == null ? other$schulen != null : !((Object)this$schulen).equals(other$schulen)) {
            return false;
        }
        List this$userAbo = this.getUserAbo();
        List other$userAbo = other.getUserAbo();
        if (this$userAbo == null ? other$userAbo != null : !((Object)this$userAbo).equals(other$userAbo)) {
            return false;
        }
        CategoryEntity this$parent = this.getParent();
        CategoryEntity other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        KompetenzEntity this$kompetenz = this.getKompetenz();
        KompetenzEntity other$kompetenz = other.getKompetenz();
        if (this$kompetenz == null ? other$kompetenz != null : !this$kompetenz.equals(other$kompetenz)) {
            return false;
        }
        SchuleEntity this$schule = this.getSchule();
        SchuleEntity other$schule = other.getSchule();
        if (this$schule == null ? other$schule != null : !this$schule.equals(other$schule)) {
            return false;
        }
        Boolean this$einheitenKorr = this.getEinheitenKorr();
        Boolean other$einheitenKorr = other.getEinheitenKorr();
        if (this$einheitenKorr == null ? other$einheitenKorr != null : !((Object)this$einheitenKorr).equals(other$einheitenKorr)) {
            return false;
        }
        String this$einheitenKorrText = this.getEinheitenKorrText();
        String other$einheitenKorrText = other.getEinheitenKorrText();
        if (this$einheitenKorrText == null ? other$einheitenKorrText != null : !this$einheitenKorrText.equals(other$einheitenKorrText)) {
            return false;
        }
        Boolean this$globalCategory = this.getGlobalCategory();
        Boolean other$globalCategory = other.getGlobalCategory();
        if (this$globalCategory == null ? other$globalCategory != null : !((Object)this$globalCategory).equals(other$globalCategory)) {
            return false;
        }
        Level this$level = this.getLevel();
        Level other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Boolean this$privateCategory = this.getPrivateCategory();
        Boolean other$privateCategory = other.getPrivateCategory();
        if (this$privateCategory == null ? other$privateCategory != null : !((Object)this$privateCategory).equals(other$privateCategory)) {
            return false;
        }
        Boolean this$useInternalCalc = this.getUseInternalCalc();
        Boolean other$useInternalCalc = other.getUseInternalCalc();
        return !(this$useInternalCalc == null ? other$useInternalCalc != null : !((Object)this$useInternalCalc).equals(other$useInternalCalc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CategoryEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        List $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        List $rechte = this.getRechte();
        result = result * 59 + ($rechte == null ? 43 : ((Object)$rechte).hashCode());
        List $questionList = this.getQuestionList();
        result = result * 59 + ($questionList == null ? 43 : ((Object)$questionList).hashCode());
        List $kompetenzen = this.getKompetenzen();
        result = result * 59 + ($kompetenzen == null ? 43 : ((Object)$kompetenzen).hashCode());
        List $gegenstaende = this.getGegenstaende();
        result = result * 59 + ($gegenstaende == null ? 43 : ((Object)$gegenstaende).hashCode());
        List $questions = this.getQuestions();
        result = result * 59 + ($questions == null ? 43 : ((Object)$questions).hashCode());
        List $schulen = this.getSchulen();
        result = result * 59 + ($schulen == null ? 43 : ((Object)$schulen).hashCode());
        List $userAbo = this.getUserAbo();
        result = result * 59 + ($userAbo == null ? 43 : ((Object)$userAbo).hashCode());
        CategoryEntity $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        KompetenzEntity $kompetenz = this.getKompetenz();
        result = result * 59 + ($kompetenz == null ? 43 : $kompetenz.hashCode());
        SchuleEntity $schule = this.getSchule();
        result = result * 59 + ($schule == null ? 43 : $schule.hashCode());
        Boolean $einheitenKorr = this.getEinheitenKorr();
        result = result * 59 + ($einheitenKorr == null ? 43 : ((Object)$einheitenKorr).hashCode());
        String $einheitenKorrText = this.getEinheitenKorrText();
        result = result * 59 + ($einheitenKorrText == null ? 43 : $einheitenKorrText.hashCode());
        Boolean $globalCategory = this.getGlobalCategory();
        result = result * 59 + ($globalCategory == null ? 43 : ((Object)$globalCategory).hashCode());
        Level $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Boolean $privateCategory = this.getPrivateCategory();
        result = result * 59 + ($privateCategory == null ? 43 : ((Object)$privateCategory).hashCode());
        Boolean $useInternalCalc = this.getUseInternalCalc();
        result = result * 59 + ($useInternalCalc == null ? 43 : ((Object)$useInternalCalc).hashCode());
        return result;
    }

    public String toString() {
        return "CategoryEntity(id=" + this.getId() + ", categories=" + this.getCategories() + ", rechte=" + this.getRechte() + ", questionList=" + this.getQuestionList() + ", kompetenzen=" + this.getKompetenzen() + ", gegenstaende=" + this.getGegenstaende() + ", questions=" + this.getQuestions() + ", schulen=" + this.getSchulen() + ", userAbo=" + this.getUserAbo() + ", parent=" + this.getParent() + ", kompetenz=" + this.getKompetenz() + ", schule=" + this.getSchule() + ", einheitenKorr=" + this.getEinheitenKorr() + ", einheitenKorrText=" + this.getEinheitenKorrText() + ", globalCategory=" + this.getGlobalCategory() + ", level=" + this.getLevel() + ", name=" + this.getName() + ", privateCategory=" + this.getPrivateCategory() + ", useInternalCalc=" + this.getUseInternalCalc() + ")";
    }
}

