/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.repository;

import at.letto.beurteilung.dto.BeurteilungDTO;
import at.letto.beurteilung.dto.FremdLehrerDTO;
import at.letto.beurteilung.dto.KlassenBeurteilungDTO;
import at.letto.beurteilung.dto.KlassenInfoDTO;
import at.letto.beurteilung.dto.KompetenzBeurteilungsDTO;
import at.letto.beurteilung.dto.LehrerInfoDTO;
import at.letto.beurteilung.dto.NoteDTO;
import at.letto.beurteilung.dto.StudentDto;
import at.letto.beurteilung.dto.StudentGroupDto;
import at.letto.beurteilung.dto.TestDTO;
import at.letto.beurteilung.dto.TestPunkteDTO;
import at.letto.data.entity.BeurteilungEntity;
import at.letto.data.entity.GegenstandEntity;
import at.letto.data.entity.KlassenbeurteilungEntity;
import at.letto.data.entity.SchuelerKlasseEntity;
import at.letto.data.entity.SchuelergruppeEntity;
import at.letto.dto.PairIntString;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface BeurteilungEntityRepository
extends JpaRepository<BeurteilungEntity, Integer>,
JpaSpecificationExecutor<BeurteilungEntity> {
    @Modifying
    @Query(value="delete from BeurteilungEntity b where b.id in (select b.id from BeurteilungEntity b join b.activity a join a.test t join t.testVersuche v where v.id =:idTestVersuch)")
    public void delBeurteilungenTestversuch(int var1);

    @Query(value="select b from BeurteilungEntity b where b.klassenBeurteilung.id =:idKb and b.user.id =:idUser")
    public Optional<BeurteilungEntity> findBeurteilungFromKlassenbeurteilungAndUser(@Param(value="idKb") int var1, @Param(value="idUser") int var2);

    @Query(value="select lk.user.id from LehrerKlasseEntity lk where lk.id = :idLk")
    public Optional<Integer> findLehrerID(@Param(value="idLk") int var1);

    @Query(value="select new at.letto.beurteilung.dto.BeurteilungDTO(b.id, b.lehrerKlasse.id, b.user.id, kb.id,b.beurteilungsartGlobal.name, b.bezeichnerBeurteilungsart, b.datum, b.note, b.prozent, b.gewicht, b.fragetext, b.input, act.id, act.name, act.visible) FROM BeurteilungEntity b left join b.klassenBeurteilung kb left join b.activity act where b.lehrerKlasse.id = :idLk")
    public List<BeurteilungDTO> findByLK(@Param(value="idLk") int var1);

    @Query(value="select new at.letto.beurteilung.dto.BeurteilungDTO(b.id, b.lehrerKlasse.id, b.user.id, kb.id,b.beurteilungsartGlobal.name, b.bezeichnerBeurteilungsart, b.datum, b.note, b.prozent, b.gewicht, b.fragetext, b.input, act.id, act.name, act.visible) FROM BeurteilungEntity b left join b.klassenBeurteilung kb left join b.activity act where b.lehrerKlasse.id in (select x.id from LehrerKlasseEntity lk join lk.klasse k join k.lehrerKlasses x where lk.gegenstand = x.gegenstand and lk.id=:idLk ) ")
    public List<BeurteilungDTO> findGlobalByLK(@Param(value="idLk") int var1);

    @Query(value="select new at.letto.beurteilung.dto.BeurteilungDTO(b.id, b.parent.id, b.beurteilungsartGlobal.name, b.bezeichnerBeurteilungsart, b.datum, b.note, b.prozent, b.gewicht, b.fragetext, b.input, act.id, act.name, act.visible) FROM BeurteilungEntity b left join b.activity act where b.parent.id in :ids")
    public List<BeurteilungDTO> findSubBeurteilungen(@Param(value="ids") Set<Integer> var1);

    @Query(value="select new at.letto.beurteilung.dto.BeurteilungDTO(b.id, b.lehrerKlasse.id, b.user.id, 0,b.beurteilungsartGlobal.name, b.bezeichnerBeurteilungsart, b.datum, b.note, b.prozent, b.gewicht, b.fragetext, b.input, 0, '', false) FROM BeurteilungEntity b where b.id = :id")
    public Optional<BeurteilungDTO> findBeurteilungDto(@Param(value="id") int var1);

    @Query(value="select new at.letto.beurteilung.dto.FremdLehrerDTO(b.id, fl.id, fl.nachname, fl.vorname ) FROM BeurteilungEntity b join b.fremdLehrer fl where b.id in :ids")
    public List<FremdLehrerDTO> findFremdLehrer(@Param(value="ids") Set<Integer> var1);

    @Query(value="select distinct new at.letto.beurteilung.dto.KompetenzBeurteilungsDTO(b.id, k.id, k.kompetenz, kl.level) FROM BeurteilungEntity b join b.kompetenzenLink kl join kl.kompetenz k where b.id in :ids")
    public List<KompetenzBeurteilungsDTO> findKompetenzen(@Param(value="ids") Set<Integer> var1);

    @Query(value="select new at.letto.beurteilung.dto.KlassenBeurteilungDTO(b.id, b.lehrerKlasse.id, b.name, b.aufgabenstellung, b.beurteilungsartGlobal.name, b.bezeichnerBeurteilungsart, b.gewicht, b.datum, k.id, b.selectedLevel, b.showDateBeurteilung, b.testAllowed, fl.id, act.id, act.name, act.visible) FROM KlassenbeurteilungEntity b left join b.activity act left join b.fremdLehrer fl left join b.selKompetenz k where b.lehrerKlasse.id = :idLk")
    public List<KlassenBeurteilungDTO> findKlassenBeurteilungDto(@Param(value="idLk") int var1);

    @Query(value="select b FROM KlassenbeurteilungEntity b where b.id = :id")
    public Optional<KlassenbeurteilungEntity> findKlassenbeurteilung(@Param(value="id") int var1);

    @Query(value="select distinct par FROM KlassenbeurteilungEntity par where par.id in (select distinct b.parent.id from KlassenbeurteilungEntity b where b.id = :id)")
    public Optional<KlassenbeurteilungEntity> findParentKlassenbeurteilung(@Param(value="id") int var1);

    @Query(value="select distinct par FROM BeurteilungEntity par where par.id in (select distinct b.parent.id from BeurteilungEntity b where b.id = :id)")
    public Optional<BeurteilungEntity> findParentBeurteilung(@Param(value="id") int var1);

    @Query(value="select new at.letto.beurteilung.dto.KlassenBeurteilungDTO(b.id, b.parent.id, b.name, b.gewicht, b.testAllowed, act.id, act.name, act.visible) FROM KlassenbeurteilungEntity b left join b.activity act where b.parent.id in :idsParent")
    public List<KlassenBeurteilungDTO> findSubKlassenBeurteilungDto(@Param(value="idsParent") Set<Integer> var1);

    @Query(value="select new at.letto.beurteilung.dto.KlassenBeurteilungDTO(b.id, b.lehrerKlasse.id, b.name, b.aufgabenstellung, b.beurteilungsartGlobal.name, b.bezeichnerBeurteilungsart, b.gewicht, b.datum, k.id, b.selectedLevel, b.showDateBeurteilung, b.testAllowed, fl.id, act.id, act.name, act.visible) FROM KlassenbeurteilungEntity b left join b.activity act left join b.fremdLehrer fl left join b.selKompetenz k where b.lehrerKlasse.id in (select x.id from LehrerKlasseEntity lk join lk.klasse k join k.lehrerKlasses x where lk.gegenstand = x.gegenstand and lk.id=:idLk ) ")
    public List<KlassenBeurteilungDTO> findGlobalKlassenBeurteilungDto(@Param(value="idLk") int var1);

    @Query(value="select new at.letto.beurteilung.dto.BeurteilungDTO(b.id, lk.id, b.user.id, b.klassenBeurteilung.id,b.beurteilungsartGlobal.name, b.bezeichnerBeurteilungsart, b.datum, b.note, b.prozent, b.gewicht, b.fragetext, b.input, act.id, act.name, act.visible) FROM BeurteilungEntity b join b.lehrerKlasse lk join lk.klasse k left join b.activity act where k.id = :idKlasse")
    public List<BeurteilungDTO> findByKlasse(@Param(value="idKlasse") int var1);

    @Query(value="select new at.letto.dto.PairIntString(t.id, a.path) from ActivityEntity a join a.test t where a.idLk = :idLk")
    public List<PairIntString> findTestsWithFullPath(@Param(value="idLk") int var1);

    @Query(value="select new at.letto.dto.PairIntString(t.id, a.path) from ActivityEntity a join a.test t where a.idLk in (select x.id from LehrerKlasseEntity lk join lk.klasse k join k.lehrerKlasses x where lk.gegenstand = x.gegenstand and lk.id=:idLk ) ")
    public List<PairIntString> findTestsGlobalWithFullPath(@Param(value="idLk") int var1);

    @Query(value="select new at.letto.dto.PairIntString(t.id, a.path) from ActivityEntity a join a.test t where a.idLk = :idLk and t.testDatum <= :semester")
    public List<PairIntString> findTestsFullPathWinterSemester(@Param(value="idLk") int var1, @Param(value="semester") Date var2);

    @Query(value="select new at.letto.dto.PairIntString(t.id, a.path) from ActivityEntity a join a.test t where a.idLk in (select x.id from LehrerKlasseEntity lk join lk.klasse k join k.lehrerKlasses x where lk.gegenstand = x.gegenstand and lk.id=:idLk )  and t.testDatum <= :semester")
    public List<PairIntString> findTestsGlobalFullPathWinterSemester(@Param(value="idLk") int var1, @Param(value="semester") Date var2);

    @Query(value="select new at.letto.dto.PairIntString(t.id, a.path) from ActivityEntity a join a.test t where a.idLk = :idLk and t.testDatum >= :semester")
    public List<PairIntString> findTestsFullPathSommerSemester(@Param(value="idLk") int var1, @Param(value="semester") Date var2);

    @Query(value="select new at.letto.dto.PairIntString(t.id, a.path) from ActivityEntity a join a.test t where a.idLk in (select x.id from LehrerKlasseEntity lk join lk.klasse k join k.lehrerKlasses x where lk.gegenstand = x.gegenstand and lk.id=:idLk )  and t.testDatum >= :semester")
    public List<PairIntString> findTestsGlobalFullPathSommerSemester(@Param(value="idLk") int var1, @Param(value="semester") Date var2);

    @Query(value="select distinct new at.letto.beurteilung.dto.TestDTO(t.id, a.id, a.idLk, t.gewichtung, t.punkte, a.name, a.path, t.mode.name, glob.name, t.testDatum, g.id, g.gruppenModus) from ActivityEntity a join a.test t left join t.gruppierung g left join t.beurteilungsart ba left join ba.beurteilungsart glob where t.id in :idAct")
    public List<TestDTO> findTests(@Param(value="idAct") Set<Integer> var1);

    @Query(value="select t.gruppierung.id, t.id from TestsEntity t where t.gruppierung.id in (select g.id from TestsEntity t join t.gruppierung g join g.tests tg where t.id in :idAct group by g having count(g)>1) ")
    public Map<Integer, List<Integer>> findTestGroups(@Param(value="idAct") Set<Integer> var1);

    @Query(value="select distinct new at.letto.beurteilung.dto.TestPunkteDTO(t.id, gF.id, gF.anzahl, sum(tf.points), tf.points) from TestsEntity t join t.testGruppe g join g.testFragen tf left join tf.gruppeVonFragen gF where t.id in :idAct group by g, gF ")
    public List<TestPunkteDTO> loadTestPoints(@Param(value="idAct") Set<Integer> var1);

    @Query(value="SELECT new at.letto.beurteilung.dto.NoteDTO(n.id, lk.id, n.user.id, n.note, n.mahnung, n.semester) FROM NotenEntity n join n.lehrerKlasse lk join lk.klasse k join k.lehrerKlasses lk1 where lk1.id =:idLk and lk.gegenstand=lk1.gegenstand")
    public List<NoteDTO> findNoten(@Param(value="idLk") int var1);

    @Query(value="SELECT distinct new at.letto.beurteilung.dto.StudentDto(s.id, lk.id, s.nachname, s.vorname, s.name, s.sokratesID, 0, '') FROM LehrerKlasseEntity lk join lk.klasse k join k.schuelerKlasses sk join sk.user s join lk.gegenstand g where lk.id= :idLk")
    public List<StudentDto> findStudents(@Param(value="idLk") int var1);

    @Query(value="SELECT new at.letto.beurteilung.dto.StudentGroupDto(sg.id, sk.user.id, sg.gruppenName) FROM LehrerKlasseEntity lk join lk.klasse k join k.schuelerKlasses sk join sk.schuelerGruppen sg join lk.gegenstand g where sg.gegenstand = g and lk.id= :idLk")
    public List<StudentGroupDto> findStudentGroups(@Param(value="idLk") int var1);

    @Query(value="select new at.letto.beurteilung.dto.KlassenInfoDTO(lk.id, k.name, k.jahrgang, g.name, u.vorname, u.nachname, sj.name, sj.von, sj.bis, sj.semester, k.semester, c.text) from LehrerKlasseEntity lk join lk.klasse k join k.schuljahr sj join lk.gegenstand g join lk.user u join k.abteilung a join a.schule s join s.globalConfigs c where lk.id = :idLk and c.name like 'lizenz' ")
    public Optional<KlassenInfoDTO> findKlassenInfo(@Param(value="idLk") int var1);

    @Query(value="SELECT new at.letto.beurteilung.dto.LehrerInfoDTO(l.user.id, l.id, l.user.nachname, l.user.vorname, l.gewichtung) FROM LehrerKlasseEntity lk join lk.klasse k join k.lehrerKlasses l where l.gegenstand = lk.gegenstand and lk.id= :idLk")
    public List<LehrerInfoDTO> findLehrerInKlasse(@Param(value="idLk") int var1);

    @Query(value="select g from LehrerKlasseEntity lk join lk.gegenstand g join g.schuelerGruppen sg join sg.schuelerKlasse sk join sk.user u where u.id =:idUser and lk.id = :idLk ")
    public Optional<SchuelergruppeEntity> findUserGruppe(@Param(value="idLk") int var1, @Param(value="idUser") int var2);

    @Query(value="select g from LehrerKlasseEntity lk join lk.gegenstand g where lk.id = :idLk ")
    public Optional<GegenstandEntity> findGegenstand(@Param(value="idLk") int var1);

    @Query(value="select sk from LehrerKlasseEntity lk join lk.klasse k join k.schuelerKlasses sk join sk.user u where lk.id = :idLk and u.id = :idUser")
    public Optional<SchuelerKlasseEntity> findSchuelerKlasse(@Param(value="idLk") int var1, @Param(value="idUser") int var2);

    @Query(value="select distinct b.id from BeurteilungEntity b join b.lehrerKlasse lk join lk.klasse k join k.schuljahr sj where b.id is not null and sj.id = :idSchuljahr")
    public List<Integer> findBeurteilungenSchuljahr(@Param(value="idSchuljahr") int var1);

    @Query(value="select a.path from activity a join activitytype t on t.id = a.idActivityType where t.DESCRIPTION like 'Folder' and a.IDLK = ?1 order by activities_ORDER", nativeQuery=true)
    public List<String> findActivitiesInKlasse(@Param(value="idLk") int var1);
}

