/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.repository;

import at.letto.data.entity.BeurteilungsartEntity;
import at.letto.data.entity.BeurteilungsconfigEntity;
import at.letto.data.entity.LehrerKlasseEntity;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface BeurteilungsconfigEntityRepository
extends JpaRepository<BeurteilungsconfigEntity, Integer>,
JpaSpecificationExecutor<BeurteilungsconfigEntity> {
    @Query(value="select b from BeurteilungsconfigEntity b where b.user is null and b.defaultSchema = true")
    public Optional<BeurteilungsconfigEntity> findDefaultGlobal();

    @Query(value="select b from BeurteilungsconfigEntity b join b.user u join u.lehrerKlasses lk where b.defaultSchema = true and lk.id = :idLk")
    public Optional<BeurteilungsconfigEntity> findDefaultUser(@Param(value="idLk") int var1);

    @Query(value="select b from BeurteilungsconfigEntity b join b.user u where b.defaultSchema = true and u.id = :idUser")
    public Optional<BeurteilungsconfigEntity> findDefaultByUserId(@Param(value="idUser") int var1);

    @Query(value="select b from BeurteilungsconfigEntity b join b.user u join u.lehrerKlasses lk  where lk.id = :idLk")
    public List<BeurteilungsconfigEntity> findForUser(@Param(value="idLk") int var1);

    @Query(value="select b from BeurteilungsconfigEntity b where b.user is null and b.defaultSchema=true")
    public Optional<BeurteilungsconfigEntity> findGlobal();

    @Query(value="select b from BeurteilungsconfigEntity b join b.beurteilungsarten ba where ba.bezeichnung like :beurteilungsart")
    public Optional<BeurteilungsconfigEntity> findSchemaByBeurteilungsartName(@Param(value="beurteilungsart") String var1);

    @Query(value="select b from BeurteilungsconfigEntity b, LehrerKlasseEntity lk where b.user is null and b.gegenstaende like CONCAT('%',lk.gegenstand.kuerzel, '%') and (b.schulstufen is null or b.schulstufen like '' or b.schulstufen like CONCAT('%',lk.klasse.jahrgang, '%') )  and lk.id = :idLk")
    public Optional<BeurteilungsconfigEntity> findByLkGlobal(@Param(value="idLk") int var1);

    @Query(value="select distinct b from BeurteilungsconfigEntity b join b.user u join u.lehrerKlasses lk where lk.id = :idLk and b.gegenstaende like CONCAT('%',lk.gegenstand.kuerzel, '%') and (b.schulstufen is null or b.schulstufen like '' or b.schulstufen like CONCAT('%',lk.klasse.jahrgang, '%') )")
    public Optional<BeurteilungsconfigEntity> findByLk(@Param(value="idLk") int var1);

    @Query(value="select lk from LehrerKlasseEntity lk where lk.id = :idLk")
    public Optional<LehrerKlasseEntity> findLk(@Param(value="idLk") int var1);

    @Query(value="select b from BeurteilungsartEntity b join b.beurteilungsConfig c  where c.defaultSchema = true and b.beurteilungsart.name like :name ")
    public Optional<BeurteilungsartEntity> loadGlobalBeurteilungsart(@Param(value="name") String var1);

    @Query(value="select b from BeurteilungsartEntity b where b.bezeichnung like :name ")
    public Optional<BeurteilungsartEntity> findBeurteilungsartByBezeichnung(@Param(value="name") String var1);
}

