/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.repository;

import at.letto.data.entity.TestAntwortEntity;
import at.letto.data.entity.TestDetailsEntity;
import at.letto.tests.dto.TestDetailDto;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface TestDetailsEntityRepository
extends JpaRepository<TestDetailsEntity, Integer>,
JpaSpecificationExecutor<TestDetailsEntity> {
    @Query(value="select new at.letto.tests.dto.TestDetailDto(td.id, v.id, v.test.id, v.user.id, f.question.id, f.id, f.points, f.question.punkte, td.testAntwortJson, td.selektor, td.dataset, td.individualFeedback, CONCAT(feedback.md5,'.',feedback.typ), feedback.md5, f.question.name, td.filesForDetail, CONCAT(v.user.nachname,' ',v.user.vorname)) from TestDetailsEntity td join td.frage f join td.testVersuch v left join td.feedbackDocument feedback where td.id = :idTestDetail")
    public Optional<TestDetailDto> findTestDetail(@Param(value="idTestDetail") int var1);

    @Query(value="select new at.letto.tests.dto.TestDetailDto(td.id, v.id, v.test.id, td.testVersuch.user.id, f.question.id, f.id, f.points, f.question.punkte, td.testAntwortJson, td.selektor, td.dataset, td.individualFeedback, CONCAT(feedback.md5,'.',feedback.typ), feedback.md5, f.question.name, td.filesForDetail, CONCAT(v.user.nachname,' ',v.user.vorname)) from TestDetailsEntity td join td.frage f join td.testVersuch v left join td.feedbackDocument feedback where v.test.id = :idTest")
    public List<TestDetailDto> findTestDetailsByTestId(@Param(value="idTest") int var1);

    @Query(value="select distinct new at.letto.tests.dto.TestDetailDto(td.id, v.id, v.test.id, td.testVersuch.user.id, f.question.id, f.id, f.points, f.question.punkte, td.testAntwortJson, td.selektor, td.dataset, td.individualFeedback, CONCAT(feedback.md5,'.',feedback.typ), feedback.md5, f.question.name, td.filesForDetail, CONCAT(v.user.nachname,' ',v.user.vorname)) from TestDetailsEntity td join td.frage f join td.testVersuch v left join td.feedbackDocument feedback where f.id = :idTestFrage")
    public List<TestDetailDto> findTestDetailsByTestFrageId(@Param(value="idTestFrage") int var1);

    @Query(value="select new at.letto.tests.dto.TestDetailDto(td.id, v.id, v.test.id, td.testVersuch.user.id, f.question.id, f.id, f.points, f.question.punkte, td.testAntwortJson, td.selektor, td.dataset, td.individualFeedback, CONCAT(feedback.md5,'.',feedback.typ), feedback.md5, f.question.name, td.filesForDetail, CONCAT(v.user.nachname,' ',v.user.vorname)) from TestDetailsEntity td join td.frage f join td.testVersuch v left join td.feedbackDocument feedback where v.id = :idTestVersuch")
    public List<TestDetailDto> findTestDetailsByTestVersuchsId(@Param(value="idTestVersuch") int var1);

    @Query(value="select td from TestDetailsEntity td where td.id = :idTestDetail")
    public Optional<TestDetailsEntity> findTestDetailEntity(@Param(value="idTestDetail") int var1);

    @Query(value="select ta from TestAntwortEntity ta where ta.id = :idTestAntwort")
    public Optional<TestAntwortEntity> findTestAntwort(@Param(value="idTestAntwort") int var1);

    @Query(value="select ta from TestAntwortEntity ta where ta.testDetail.id = :idTestDetail and ta.timestamp = (select max(a1.timestamp) from TestAntwortEntity a1 where ta.testDetail = a1.testDetail) ")
    public Optional<TestAntwortEntity> findLastTestAntwort(@Param(value="idTestDetail") int var1);

    @Query(value="select ta from TestAntwortEntity ta where ta.testDetail.id = :idTestDetail")
    public List<TestAntwortEntity> findTestAntworten(@Param(value="idTestDetail") int var1);

    @Query(value="select ta from TestAntwortEntity ta where ta.testDetail.id in :ids and ta.timestamp = (select max(a1.timestamp) from TestAntwortEntity a1 where ta.testDetail = a1.testDetail) ")
    public List<TestAntwortEntity> findLastTestAntworten(@Param(value="ids") Set<Integer> var1);

    @Query(value="select count(ta) from TestAntwortEntity ta where ta.testDetail.id = :idTestDetail")
    public long countTestAntworten(@Param(value="idTestDetail") int var1);
}

