/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service;

import at.letto.beurteilung.dto.BeurteilungDTO;
import at.letto.beurteilung.dto.KlassenBeurteilungDTO;
import at.letto.beuteilungsschema.dto.BeurteilungsartDTO;
import at.letto.beuteilungsschema.dto.BeurteilungsconfigDTO;
import at.letto.data.entity.BeurteilungsconfigEntity;
import at.letto.data.mapper.BeurteilungsConfigMapper;
import at.letto.data.mapper.CycleAvoidingMappingContext;
import at.letto.data.repository.BeurteilungsconfigEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.service.interfaces.BeurteilungConfigDataService;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class BeurteilungConfigService
implements BeurteilungConfigDataService {
    @Autowired
    private AllRepositories allRepositories;

    @Transactional
    public Optional<BeurteilungsconfigDTO> loadSchema(int id) {
        return this.allRepositories.beurteilungsconfigEntityRepository.findById((Object)id).map(schema -> BeurteilungsConfigMapper.service.mapDto(schema, new CycleAvoidingMappingContext()));
    }

    @Transactional
    public Optional<BeurteilungsconfigDTO> loadDefaultSchema() {
        return this.allRepositories.beurteilungsconfigEntityRepository.findGlobal().map(schema -> BeurteilungsConfigMapper.service.mapDto(schema, new CycleAvoidingMappingContext()));
    }

    @Transactional
    public Optional<BeurteilungsconfigDTO> loadUserDefault(int idUser) {
        BeurteilungsconfigEntity schema = this.allRepositories.beurteilungsconfigEntityRepository.findDefaultByUserId(idUser).orElse(this.allRepositories.beurteilungsconfigEntityRepository.findGlobal().orElse(null));
        if (schema == null) {
            return null;
        }
        return Optional.of(BeurteilungsConfigMapper.service.mapDto(schema, new CycleAvoidingMappingContext()));
    }

    public BeurteilungsconfigDTO save(BeurteilungsconfigDTO schema) {
        return schema;
    }

    @Cacheable(sync=true, cacheNames={"schemaCache"}, key="{#idLk}")
    @Transactional
    public Optional<BeurteilungsconfigDTO> loadSchemaByLehrerKlasse(int idLk) {
        BeurteilungsconfigEntityRepository repo = this.allRepositories.beurteilungsconfigEntityRepository;
        BeurteilungsconfigEntity schema = repo.findByLk(idLk).orElse(repo.findByLkGlobal(idLk).orElse(repo.findDefaultUser(idLk).orElse(repo.findGlobal().orElse(null))));
        if (schema == null) {
            return null;
        }
        BeurteilungsconfigDTO s = this.toDto(schema);
        return Optional.of(s);
    }

    private BeurteilungsconfigDTO toDto(BeurteilungsconfigEntity schema) {
        if (schema == null) {
            return null;
        }
        BeurteilungsconfigDTO s = BeurteilungsConfigMapper.service.mapDto(schema, new CycleAvoidingMappingContext());
        s.setBeurteilungsartHash(s.getBeurteilungsarten().stream().collect(Collectors.toMap(BeurteilungsartDTO::getName, b -> b, (b1, b2) -> b1)));
        return s;
    }

    @Transactional
    public Optional<BeurteilungsartDTO> loadGlobalBeurteilungsart(String name) {
        return this.allRepositories.beurteilungsartEntityRepository.loadGlobalBeurteilungsart(name).map(b -> BeurteilungsConfigMapper.service.mapDto(b, new CycleAvoidingMappingContext()));
    }

    @Transactional
    public Optional<BeurteilungsartDTO> loadBeurteilungsartByBezeichner(String name) {
        return this.allRepositories.beurteilungsartEntityRepository.findBeurteilungsartByBezeichnung(name).map(b -> BeurteilungsConfigMapper.service.mapDto(b, new CycleAvoidingMappingContext()));
    }

    public BeurteilungsartDTO getBeurteilungsart(BeurteilungsconfigDTO conf, BeurteilungsartDTO x) {
        return conf.getBeurteilungsart(x.getBeurteilungsart().getName(), x.getName(), true);
    }

    public BeurteilungsartDTO getBeurteilungsart(BeurteilungsconfigDTO conf, BeurteilungDTO x) {
        return conf.getBeurteilungsart(x.getBeurteilungsart(), x.getBezeichnerBeurteilungsart(), true);
    }

    public BeurteilungsartDTO getBeurteilungsart(BeurteilungsconfigDTO conf, KlassenBeurteilungDTO x) {
        return conf.getBeurteilungsart(x.getBeurteilungsart(), x.getBezeichnerBeurteilungsart(), true);
    }
}

