/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.beurteilung;

import at.letto.beurteilung.dto.BeurteilungDTO;
import at.letto.beurteilung.dto.KlassenBeurteilungDTO;
import at.letto.beuteilungsschema.dto.BeurteilungsartDTO;
import at.letto.beuteilungsschema.dto.BeurteilungsconfigDTO;
import at.letto.data.entity.BeurteilungsconfigEntity;
import at.letto.data.mapper.BeurteilungsConfigMapper;
import at.letto.data.mapper.CycleAvoidingMappingContext;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BeurteilungConfigServiceDatabase {
    @Autowired
    private AllRepositories allRepositories;

    public BeurteilungsconfigDTO loadSchema(int id) {
        BeurteilungsconfigEntity schema = this.allRepositories.beurteilungsconfigEntityRepository.findById((Object)id).orElse(null);
        if (schema == null) {
            return null;
        }
        return this.toDto(schema);
    }

    public BeurteilungsconfigDTO loadDefaultSchema() {
        BeurteilungsconfigEntity schema = this.allRepositories.beurteilungsconfigEntityRepository.findGlobal().orElse(null);
        if (schema == null) {
            return null;
        }
        return this.toDto(schema);
    }

    public BeurteilungsconfigDTO findSchemaForBeurteilungsart(String beurteilungsart) {
        BeurteilungsconfigEntity schema = this.allRepositories.beurteilungsconfigEntityRepository.findGlobal().orElse(null);
        if (schema == null) {
            return null;
        }
        return this.toDto(schema);
    }

    public BeurteilungsconfigDTO loadUserDefault(int idUser) {
        BeurteilungsconfigEntity schema = this.allRepositories.beurteilungsconfigEntityRepository.findDefaultByUserId(idUser).orElse(this.allRepositories.beurteilungsconfigEntityRepository.findGlobal().orElse(null));
        if (schema == null) {
            return null;
        }
        return this.toDto(schema);
    }

    public BeurteilungsconfigDTO loadSchemaByLehrerKlasse(int idLk) {
        BeurteilungsconfigEntity schema = this.allRepositories.beurteilungsconfigEntityRepository.findByLk(idLk).orElse(this.allRepositories.beurteilungsconfigEntityRepository.findByLkGlobal(idLk).orElse(this.allRepositories.beurteilungsconfigEntityRepository.findDefaultUser(idLk).orElse(this.allRepositories.beurteilungsconfigEntityRepository.findGlobal().orElse(null))));
        if (schema == null) {
            return null;
        }
        return this.toDto(schema);
    }

    private BeurteilungsconfigDTO toDto(BeurteilungsconfigEntity schema) {
        if (schema == null) {
            return null;
        }
        BeurteilungsconfigDTO s = BeurteilungsConfigMapper.service.mapDto(schema, new CycleAvoidingMappingContext());
        s.setBeurteilungsartHash(s.getBeurteilungsarten().stream().collect(Collectors.toMap(BeurteilungsartDTO::getName, b -> b, (b1, b2) -> b1)));
        return s;
    }

    public BeurteilungsartDTO getBeurteilungsart(BeurteilungsconfigDTO conf, BeurteilungsartDTO x) {
        return conf.getBeurteilungsart(x.getBeurteilungsart().getName(), x.getName(), true);
    }

    public BeurteilungsartDTO getBeurteilungsart(BeurteilungsconfigDTO conf, BeurteilungDTO x) {
        return conf.getBeurteilungsart(x.getBeurteilungsart(), x.getBezeichnerBeurteilungsart(), true);
    }

    public BeurteilungsartDTO getBeurteilungsart(BeurteilungsconfigDTO conf, KlassenBeurteilungDTO x) {
        return conf.getBeurteilungsart(x.getBeurteilungsart(), x.getBezeichnerBeurteilungsart(), true);
    }

    public BeurteilungsartDTO loadGlobalBeurteilungsart(String name) {
        AtomicReference ret = new AtomicReference();
        this.allRepositories.beurteilungsconfigEntityRepository.loadGlobalBeurteilungsart(name).ifPresent(b -> ret.set(BeurteilungsConfigMapper.service.mapDto(b, new CycleAvoidingMappingContext())));
        return (BeurteilungsartDTO)ret.get();
    }

    public BeurteilungsartDTO loadBeurteilungsartByBezeichner(String name) {
        AtomicReference ret = new AtomicReference();
        this.allRepositories.beurteilungsconfigEntityRepository.findBeurteilungsartByBezeichnung(name).ifPresent(b -> ret.set(BeurteilungsConfigMapper.service.mapDto(b, new CycleAvoidingMappingContext())));
        return (BeurteilungsartDTO)ret.get();
    }
}

