/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.beurteilung;

import at.letto.beurteilung.dto.BeurteilungDTO;
import at.letto.beurteilung.dto.KlassenBeurteilungDTO;
import at.letto.beurteilung.dto.KompetenzBeurteilungsDTO;
import at.letto.beurteilung.dto.NoteDTO;
import at.letto.beuteilungsschema.dto.BeurteilungsartDTO;
import at.letto.beuteilungsschema.dto.BeurteilungsconfigDTO;
import at.letto.data.entity.ActivityEntity;
import at.letto.data.entity.BeurteilungEntity;
import at.letto.data.entity.BeurteilungsartEntity;
import at.letto.data.entity.KlassenbeurteilungEntity;
import at.letto.data.entity.KompetenzBeurteilungEntity;
import at.letto.data.entity.KompetenzEntity;
import at.letto.data.entity.LehrerKlasseEntity;
import at.letto.data.entity.NotenEntity;
import at.letto.data.entity.UserEntity;
import at.letto.data.repository.BeurteilungEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.BeurteilungConfigService;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BeurteilungServiceDatabase {
    @Autowired
    private AllRepositories allRepositories;
    @Autowired
    private BeurteilungConfigService beurteilungConfigService;
    @Autowired
    private BeurteilungEntityRepository beurteilungsRepository;

    private KlassenBeurteilungDTO toDto(KlassenbeurteilungEntity kb) {
        KlassenBeurteilungDTO kbDto = new KlassenBeurteilungDTO();
        kbDto.setId(kb.getId().intValue());
        kbDto.setIdLk(kb.getLehrerKlasse().getId().intValue());
        kbDto.setName(kb.getName());
        kbDto.setAufgabenstellung(kb.getAufgabenstellung());
        if (kb.getBeurteilungsartGlobal() != null) {
            kbDto.setBeurteilungsart(kb.getBeurteilungsartGlobal().getName());
        }
        kbDto.setBezeichnerBeurteilungsart(kb.getBezeichnerBeurteilungsart());
        kbDto.setGewichtung(kb.getGewicht().doubleValue());
        kbDto.setDatum(kb.getDatum());
        if (kb.getActivity() != null) {
            kbDto.setIdActivity(kb.getActivity().getId().intValue());
            kbDto.setActivityName(kb.getActivity().getName());
        }
        if (kb.getSelKompetenz() != null) {
            kbDto.setIdKompetenz(kb.getSelKompetenz().getId().intValue());
            kbDto.setKompetenzen(kb.getSelKompetenz().getKompetenz());
        }
        kbDto.setLevel(kb.getSelectedLevel());
        kb.getSubKlassenBeurteilungen().forEach(sub -> {
            KlassenBeurteilungDTO subDto = this.toDto(sub);
            subDto.setParent(kbDto);
            kbDto.getSubKlassenbeurteilungen().add(subDto);
        });
        return kbDto;
    }

    public BeurteilungDTO saveBeurteilung(BeurteilungDTO b, BeurteilungsconfigDTO schema) {
        BeurteilungEntity beurteilung = this.createBeurteilung(b, schema, true);
        BeurteilungEntity bRet = (BeurteilungEntity)this.allRepositories.beurteilungEntityRepository.save((Object)beurteilung);
        return bRet != null ? this.toDto(bRet, schema) : null;
    }

    public KlassenBeurteilungDTO saveKlassenBeurteilung(KlassenBeurteilungDTO kbDto, BeurteilungsconfigDTO schema) {
        KlassenbeurteilungEntity kb = this.createKlassenBeurteilung(kbDto, schema, true);
        KlassenbeurteilungEntity kbErg = (KlassenbeurteilungEntity)this.allRepositories.klassenbeurteilungEntityRepository.save((Object)kb);
        if (kbErg == null) {
            return null;
        }
        return this.toDto(kbErg);
    }

    public BeurteilungDTO loadBeurteilung(int id) {
        return this.beurteilungsRepository.findBeurteilungDto(id).map(b -> {
            b.setSubBeurteilungen(this.beurteilungsRepository.findSubBeurteilungen((Set)Stream.of(Integer.valueOf(id)).collect(Collectors.toCollection(HashSet::new))));
            return b;
        }).orElse(null);
    }

    private BeurteilungEntity createBeurteilung(BeurteilungDTO b, BeurteilungsconfigDTO schema, boolean runtimeException) {
        BeurteilungEntity beurteilung = b.getId() > 0 ? this.beurteilungsRepository.findById((Object)b.getId()).orElse(new BeurteilungEntity()) : new BeurteilungEntity();
        beurteilung.setDatum(b.getDatum());
        beurteilung.setFragetext(b.getFragetext());
        beurteilung.setGewicht(Double.valueOf(b.getGewicht()));
        beurteilung.setNote(b.getNote());
        beurteilung.setProzent(b.getProzent());
        beurteilung.setInput(b.getInput());
        BeurteilungsartDTO baDTO = schema.getBeurteilungsart(b);
        if (baDTO == null && runtimeException) {
            throw new RuntimeException("Angeforderte BeurteilungsartEntity konnte nicht gefunden werden!");
        }
        Optional ba = this.allRepositories.beurteilungsartEntityRepository.findById((Object)baDTO.getId());
        if (ba == null && runtimeException) {
            throw new RuntimeException("Angeforderte Beurteilungsartkonne nicht gefunden werden!");
        }
        ba.ifPresent(beurt -> {
            beurteilung.setBeurteilungsart(beurt);
            beurteilung.setBeurteilungsartGlobal(beurt.getBeurteilungsart());
        });
        this.allRepositories.userEntityRepository.findById((Object)b.getIdFremdLehrer()).ifPresent(fl -> beurteilung.setFremdLehrer(fl));
        this.allRepositories.klassenbeurteilungEntityRepository.findById((Object)b.getIdKlassenbeurteilung()).ifPresent(kb -> beurteilung.setKlassenBeurteilung(kb));
        if (b.getIdLk() != null) {
            LehrerKlasseEntity lk = this.allRepositories.lehrerKlasseEntityRepository.findById((Object)b.getIdLk()).orElse(null);
            if (lk == null && runtimeException) {
                throw new RuntimeException("Angeforderte Klasse und angeforderter Gegenstand konne nicht gefunden werden: idLK passt nicht");
            }
            beurteilung.setLehrerKlasse(lk);
        }
        if (b.getIdUser() != null) {
            UserEntity u = this.allRepositories.userEntityRepository.findById((Object)b.getIdUser()).orElse(null);
            if (u == null && runtimeException) {
                throw new RuntimeException("Angeforderter User konnte nicht in der Datenbank gefunden werden!");
            }
            beurteilung.setUser(u);
        }
        beurteilung.getKompetenzenLink().clear();
        Map<Integer, KompetenzEntity> kompHash = this.allRepositories.kompetenzEntityRepository.findAllById((Iterable)b.getKompetenzen().stream().map(k -> k.getIdKompetenz()).collect(Collectors.toList())).stream().collect(Collectors.toMap(KompetenzEntity::getId, k -> k));
        b.getKompetenzen().forEach(kl -> beurteilung.getKompetenzenLink().add(new KompetenzBeurteilungEntity(beurteilung, (KompetenzEntity)kompHash.get(kl.getIdKompetenz()), kl.getLevel())));
        beurteilung.getSubBeurteilungen().clear();
        b.getSubBeurteilungen().forEach(s -> {
            BeurteilungEntity sub = this.createBeurteilung(s, schema, false);
            sub.setParent(beurteilung);
            beurteilung.getSubBeurteilungen().add(sub);
        });
        return beurteilung;
    }

    private KlassenbeurteilungEntity createKlassenBeurteilung(KlassenBeurteilungDTO kbDto, BeurteilungsconfigDTO schema, boolean runtimeException) {
        KlassenbeurteilungEntity klassenBeurteilung = kbDto.getId() > 0 ? this.allRepositories.klassenbeurteilungEntityRepository.findById((Object)kbDto.getId()).orElse(new KlassenbeurteilungEntity()) : new KlassenbeurteilungEntity();
        klassenBeurteilung.setAufgabenstellung(kbDto.getAufgabenstellung());
        klassenBeurteilung.setName(kbDto.getName());
        klassenBeurteilung.setShowDateBeurteilung(Boolean.valueOf(kbDto.isShowDateBeurteilung()));
        klassenBeurteilung.setTestAllowed(Boolean.valueOf(kbDto.isTestAllowed()));
        klassenBeurteilung.setDatum(kbDto.getDatum());
        klassenBeurteilung.setGewicht(Double.valueOf(kbDto.getGewichtung()));
        BeurteilungsartDTO baDTO = schema.getBeurteilungsart(kbDto);
        if (baDTO == null && runtimeException) {
            throw new RuntimeException("Angeforderte BeurteilungsartEntity konnte nicht gefunden werden!");
        }
        BeurteilungsartEntity ba = this.allRepositories.beurteilungsartEntityRepository.findById((Object)baDTO.getId()).orElse(null);
        if (ba == null && runtimeException) {
            throw new RuntimeException("Angeforderte Beurteilungsartkonne nicht gefunden werden!");
        }
        klassenBeurteilung.setBeurteilungsartGlobal(ba.getBeurteilungsart());
        klassenBeurteilung.setBezeichnerBeurteilungsart(ba.getBezeichnung());
        klassenBeurteilung.setBeurteilungsartGlobal(ba.getBeurteilungsart());
        klassenBeurteilung.setBezeichnerBeurteilungsart(ba.getBezeichnung());
        klassenBeurteilung.setSubKlassenBeurteilungen(klassenBeurteilung.getSubKlassenBeurteilungen().stream().filter(s -> kbDto.getSubKlassenbeurteilungen().stream().anyMatch(x -> x.getId() == s.getId().intValue())).collect(Collectors.toList()));
        kbDto.getSubKlassenbeurteilungen().forEach(kbSub -> {
            Optional<KlassenbeurteilungEntity> optSub = klassenBeurteilung.getSubKlassenBeurteilungen().stream().filter(s -> s.getId().intValue() == kbSub.getId() && s.getId() > 0).findFirst();
            KlassenbeurteilungEntity sub = optSub.isPresent() ? optSub.get() : new KlassenbeurteilungEntity();
            sub.setParent(klassenBeurteilung);
            klassenBeurteilung.getSubKlassenBeurteilungen().add(sub);
            sub.setName(kbSub.getName());
            sub.setGewicht(Double.valueOf(kbSub.getGewichtung()));
            if (kbSub.getIdActivity() > 0) {
                this.allRepositories.activityEntityRepository.findById((Object)kbSub.getIdActivity()).ifPresent(a -> sub.setActivity(a));
            } else if (sub.getActivity() != null) {
                ActivityEntity a2 = sub.getActivity();
                a2.setKlassenBeurteilung(null);
                sub.setActivity(null);
            }
        });
        if (kbDto.getIdLk() != 0) {
            LehrerKlasseEntity lk = this.allRepositories.lehrerKlasseEntityRepository.findById((Object)kbDto.getIdLk()).orElse(null);
            if (lk == null && runtimeException) {
                throw new RuntimeException("Angeforderte Klasse und angeforderter Gegenstand konne nicht gefunden werden: idLK passt nicht");
            }
            klassenBeurteilung.setLehrerKlasse(lk);
        }
        klassenBeurteilung.setSelKompetenz((KompetenzEntity)this.allRepositories.kompetenzEntityRepository.findById((Object)kbDto.getIdKompetenz()).orElse(null));
        klassenBeurteilung.setSelectedLevel(kbDto.getLevel());
        if (kbDto.getIdFremdlehrer() > 0) {
            this.allRepositories.userEntityRepository.findById((Object)kbDto.getIdFremdlehrer()).ifPresent(fl -> klassenBeurteilung.setFremdLehrer(fl));
        }
        return klassenBeurteilung;
    }

    public NotenEntity findNote(int idNote) {
        return this.allRepositories.notenEntityRepository.findById((Object)idNote).orElse(new NotenEntity());
    }

    public KlassenBeurteilungDTO findKlassenbeurteilung(int id) {
        AtomicReference kbDto = new AtomicReference();
        this.allRepositories.klassenbeurteilungEntityRepository.findById((Object)id).ifPresent(kb -> kbDto.set(this.toDto(kb)));
        return (KlassenBeurteilungDTO)kbDto.get();
    }

    public KlassenBeurteilungDTO findParentKlassenbeurteilung(int id) {
        AtomicReference kbDto = new AtomicReference();
        this.beurteilungsRepository.findParentKlassenbeurteilung(id).ifPresent(kb -> kbDto.set(this.toDto(kb)));
        if (kbDto.get() == null) {
            return this.findKlassenbeurteilung(id);
        }
        return (KlassenBeurteilungDTO)kbDto.get();
    }

    public Integer findIdLkBeurteilung(int id) {
        AtomicReference idLkAtomic = new AtomicReference();
        this.beurteilungsRepository.findParentBeurteilung(id).ifPresent(b -> idLkAtomic.set(b.getLehrerKlasse().getId()));
        if (idLkAtomic.get() == null) {
            this.allRepositories.beurteilungEntityRepository.findById((Object)id).ifPresent(b -> idLkAtomic.set(b.getLehrerKlasse().getId()));
        }
        return (Integer)idLkAtomic.get();
    }

    public NoteDTO saveNote(NoteDTO n) {
        LehrerKlasseEntity lk = this.allRepositories.lehrerKlasseEntityRepository.findById((Object)n.getIdLk()).orElse(null);
        if (lk == null) {
            throw new RuntimeException("LehrerKlasse-Objekt konnte nicht zugeordnet werden!");
        }
        NotenEntity note = this.allRepositories.notenEntityRepository.findById((Object)n.getId()).orElse(new NotenEntity());
        if (n.getId() == 0) {
            note.setLehrerKlasse(lk);
            note.setSemester(n.getSemestrierung());
            this.allRepositories.userEntityRepository.findById((Object)n.getIdUser()).ifPresent(u -> note.setUser(u));
        }
        note.setMahnung(Boolean.valueOf(n.isMahnung()));
        note.setNote(n.getNote());
        note.getNegativeDeskriptoren().clear();
        note.getNegativerLehrinhalt().clear();
        if (note.getNote().equals("5")) {
            List ids = n.getNegativeDeskriptoren().keySet().stream().filter(id -> (Boolean)n.getNegativeDeskriptoren().get(id)).collect(Collectors.toList());
            note.getNegativeDeskriptoren().addAll(this.allRepositories.deskriptorEntityRepository.findAllById(ids));
            ids = n.getNegativeLehrinhalte().keySet().stream().filter(id -> (Boolean)n.getNegativeLehrinhalte().get(id)).collect(Collectors.toList());
            note.getNegativerLehrinhalt().addAll(this.allRepositories.lehrinhaltEntityRepository.findAllById(ids));
        }
        NotenEntity noteSaved = (NotenEntity)this.allRepositories.notenEntityRepository.save((Object)note);
        return this.toDTO(noteSaved);
    }

    public BeurteilungDTO delOnlineTest(BeurteilungDTO b) {
        if (b.getIdActivity() == 0) {
            return b;
        }
        this.allRepositories.activityEntityRepository.findById((Object)b.getIdActivity()).ifPresent(act -> {
            this.allRepositories.activityEntityRepository.delete(act);
            this.allRepositories.beurteilungEntityRepository.findById((Object)b.getId()).ifPresent(beurt -> {
                beurt.setActivity(null);
                this.allRepositories.beurteilungEntityRepository.save(beurt);
                b.setIdActivity(0);
                b.setActivityName("");
            });
        });
        return b;
    }

    public KlassenBeurteilungDTO delOnlineTest(KlassenBeurteilungDTO b, BeurteilungsconfigDTO schema) {
        if (b.getIdActivity() == 0) {
            return b;
        }
        b.setIdActivity(0);
        b.setActivityName("");
        KlassenBeurteilungDTO kb = b.getParent() != null ? b.getParent() : b;
        this.saveKlassenBeurteilung(kb, schema);
        return b;
    }

    public void delKlassenBeurteilung(KlassenBeurteilungDTO kb) {
        if (kb.getId() > 0) {
            this.allRepositories.klassenbeurteilungEntityRepository.deleteById((Object)kb.getId());
        }
    }

    public void delBeurteilung(BeurteilungDTO b) {
        if (b.getId() > 0) {
            this.allRepositories.beurteilungEntityRepository.deleteById((Object)b.getId());
        }
    }

    public void changeKlassenbeurteilungsGewicht(int idKb, double gewicht) {
        this.allRepositories.klassenbeurteilungEntityRepository.updateGewicht(idKb, gewicht);
    }

    public void delBeurteilungenTestversuch(int idTest) {
        if (idTest > 0) {
            this.allRepositories.beurteilungEntityRepository.delBeurteilungenTestversuch(idTest);
        }
    }

    public BeurteilungDTO findBeurteilungFromKlassenbeurteilungAndUser(int idKlassenbeurteilung, int idUser, BeurteilungsconfigDTO schema) {
        Optional b = this.allRepositories.beurteilungEntityRepository.findBeurteilungFromKlassenbeurteilungAndUser(idKlassenbeurteilung, idUser);
        if (b.isPresent()) {
            return this.toDto((BeurteilungEntity)b.get(), schema);
        }
        return null;
    }

    public void updateConfig(String config, int idLk) {
        this.allRepositories.lehrerKlasseEntityRepository.updateConfig(idLk, config);
    }

    public NoteDTO toDTO(NotenEntity note) {
        NoteDTO n = new NoteDTO();
        n.setId(note.getId().intValue());
        n.setIdLk(note.getLehrerKlasse().getId());
        n.setIdUser(note.getUser().getId());
        n.setNote(note.getNote());
        n.setMahnung(note.getMahnung().booleanValue());
        n.setSemestrierung(note.getSemester());
        return n;
    }

    public BeurteilungDTO toDto(BeurteilungEntity beurteilung, BeurteilungsconfigDTO schema) {
        BeurteilungDTO b = this.toDtoIntern(beurteilung);
        if (beurteilung.getKompetenzenLink().size() > 0) {
            List kompetenzen = beurteilung.getKompetenzenLink().stream().map(kl -> new KompetenzBeurteilungsDTO(b.getId(), kl.getKompetenz().getId().intValue(), kl.getKompetenz().getKompetenz(), kl.getLevel())).collect(Collectors.toList());
            b.setKompetenzen(kompetenzen);
        }
        if (beurteilung.getFremdLehrer() != null) {
            UserEntity fl = beurteilung.getFremdLehrer();
            b.setFremdLehrer(fl.getNachname() + " " + fl.getVorname());
            b.setIdFremdLehrer(fl.getId().intValue());
        }
        beurteilung.getSubBeurteilungen().forEach(sub -> {
            BeurteilungDTO subDto = this.toDtoIntern(sub);
            subDto.setParent(b);
            b.getSubBeurteilungen().add(subDto);
        });
        if (beurteilung.getActivity() != null) {
            b.setIdActivity(beurteilung.getActivity().getId().intValue());
            b.setActivityName(beurteilung.getActivity().getName());
        }
        b.mark(schema);
        b.setDateOK(true);
        return b;
    }

    public BeurteilungDTO toDtoIntern(BeurteilungEntity be) {
        BeurteilungDTO b = new BeurteilungDTO();
        b.setId(be.getId().intValue());
        b.setIdLk(be.getLehrerKlasse() != null ? be.getLehrerKlasse().getId() : null);
        b.setIdUser(be.getUser() != null ? be.getUser().getId() : null);
        b.setIdKlassenbeurteilung(be.getKlassenBeurteilung() != null ? be.getKlassenBeurteilung().getId() : 0);
        b.setBeurteilungsart(be.getBeurteilungsartGlobal().getName());
        b.setBezeichnerBeurteilungsart(be.getBezeichnerBeurteilungsart());
        b.setDatum(be.getDatum());
        b.setNote(be.getNote());
        b.setProzent(be.getProzent());
        b.setGewicht(be.getGewicht().doubleValue());
        b.setFragetext(be.getFragetext());
        b.setInput(be.getInput());
        return b;
    }
}

