/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.tree;

import at.letto.category.dto.RechteCategoryDto;
import at.letto.data.service.tree.TreeServiceDatabase;
import at.letto.tools.ChangeLists;
import at.letto.tools.Listen;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RechteService {
    @Autowired
    private TreeServiceDatabase treeServiceDatabase;
    private Map<Integer, List<RechteCategoryDto>> rechteMap;

    RechteService(TreeServiceDatabase treeServiceDatabase) {
        this.treeServiceDatabase = treeServiceDatabase;
        this.rechteMap = treeServiceDatabase.findAllRechte().stream().collect(Collectors.groupingBy(r -> r.getIdCategory(), Collectors.toList()));
    }

    public void rechteChange(RechteCategoryDto r) {
        this.treeServiceDatabase.rechteChange(r);
        if (!this.rechteMap.containsKey(r.getId())) {
            this.rechteMap.put(r.getId(), new Vector());
        }
        ((List)this.rechteMap.get(r.getId())).add(r);
    }

    public int rechteAdd(RechteCategoryDto r) {
        int id = this.treeServiceDatabase.rechteAdd(r);
        if (!this.rechteMap.containsKey(r.getId())) {
            this.rechteMap.put(r.getId(), new Vector());
        }
        List list = (List)this.rechteMap.get(r.getIdCategory());
        r.setId(id);
        int ind = list.indexOf(r);
        if (ind > 0) {
            list.set(ind, r);
        } else {
            list.add(r);
        }
        return id;
    }

    public void rechteRemove(RechteCategoryDto r) {
        this.treeServiceDatabase.rechteRemove(r);
        this.rechteMap.remove(r.getId());
    }

    public List<RechteCategoryDto> findRechteForCategory(int idCategory) {
        return ((List)this.rechteMap.get(idCategory)).stream().map(r -> new RechteCategoryDto(r.getId(), r.getIdUser(), r.getIdCategory(), r.getQChange(), r.getQDelete(), r.getQInsert(), r.getUser())).collect(Collectors.toList());
    }

    public List<RechteCategoryDto> findRechteForCategoryFromDatabase(int idCategory) {
        return this.treeServiceDatabase.findRechteForCategory(idCategory);
    }

    public void changeRechteForCategory(int idCateg, List<RechteCategoryDto> rechte) {
        Listen.removeNotContaing(rechte, (int)idCateg, RechteCategoryDto::getIdCategory);
        rechte = Listen.removeElementsNonUnique(rechte, (boolean)false);
        List dbRechte = this.findRechteForCategory(idCateg);
        ChangeLists ret = Listen.detectChanges((List)rechte, (List)dbRechte, RechteCategoryDto::changed);
        List liste = (List)this.rechteMap.get(idCateg);
        Listen.change((List)liste, (List)ret.getChange());
        Listen.remove((List)liste, (List)ret.getDel());
        liste.addAll(ret.getAdd());
        ret.getChange().forEach(r -> this.treeServiceDatabase.rechteChange(r));
        ret.getAdd().forEach(r -> r.setId(this.treeServiceDatabase.rechteAdd(r)));
        ret.getDel().forEach(r -> this.treeServiceDatabase.rechteRemove(r));
    }
}

