/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.config;

import org.apache.catalina.connector.Connector;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TomcatConfiguration {
    private static final String PROTOCOL = "AJP/1.3";
    @Value(value="${tomcat.ajp.port:9099}")
    private int ajpPort;

    @Bean
    public WebServerFactoryCustomizer<TomcatServletWebServerFactory> servletContainer() {
        return server -> {
            if (server instanceof TomcatServletWebServerFactory) {
                server.addAdditionalTomcatConnectors(new Connector[]{this.redirectConnector()});
            }
        };
    }

    private Connector redirectConnector() {
        Connector connector = new Connector(PROTOCOL);
        connector.setScheme("http");
        connector.setPort(this.ajpPort);
        connector.setSecure(false);
        connector.setAllowTrace(false);
        return connector;
    }
}

