/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.controller;

import at.letto.lti.model.dto.LoginInitiationDTO;
import at.letto.lti.model.lti.Nonce;
import at.letto.lti.model.lti.PlatformDeployment;
import at.letto.lti.repository.NonceRepository;
import at.letto.lti.repository.PlatformDeploymentRepository;
import at.letto.lti.service.LTIDataService;
import at.letto.lti.utils.lti.LtiOidcUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/oidc"})
public class OIDCController {
    static final Logger log = LoggerFactory.getLogger(OIDCController.class);
    private static final String none = "none";
    private static final String formPost = "form_post";
    private static final String idToken = "id_token";
    private static final String openId = "openid";
    @Autowired
    PlatformDeploymentRepository platformDeploymentRepository;
    @Autowired
    NonceRepository nonceRepository;
    @Autowired
    LTIDataService ltiDataService;

    @RequestMapping(value={"/login_initiations"})
    public RedirectView loginInitiations(HttpServletRequest req, Model model) {
        LoginInitiationDTO loginInitiationDTO = new LoginInitiationDTO(req);
        List platformDeploymentListEntityList = this.platformDeploymentRepository.findByIss(loginInitiationDTO.getIss());
        if (platformDeploymentListEntityList.isEmpty()) {
            model.addAttribute("error_type", (Object)"iss_nonexisting");
            return new RedirectView("error");
        }
        PlatformDeployment lti3KeyEntity = (PlatformDeployment)platformDeploymentListEntityList.get(0);
        try {
            Map parameters = this.generateAuthRequestPayload(lti3KeyEntity, loginInitiationDTO);
            model.addAllAttributes(parameters);
            model.addAttribute("initiation_dto", (Object)loginInitiationDTO);
            return new RedirectView((String)parameters.get("oicdEndpointComplete"));
        }
        catch (Exception ex) {
            model.addAttribute("Error", (Object)ex.getMessage());
            return new RedirectView("lti3Error");
        }
    }

    private Map<String, String> generateAuthRequestPayload(PlatformDeployment platformDeployment, LoginInitiationDTO loginInitiationDTO) throws GeneralSecurityException, IOException {
        HashMap<String, String> authRequestMap = new HashMap<String, String>();
        authRequestMap.put("client_id", platformDeployment.getClientId());
        authRequestMap.put("login_hint", loginInitiationDTO.getLoginHint());
        authRequestMap.put("lti_message_hint", loginInitiationDTO.getLtiMessageHint());
        authRequestMap.put("nonce", ((Nonce)this.nonceRepository.save((Object)new Nonce())).getNonce());
        authRequestMap.put("prompt", none);
        authRequestMap.put("redirect_uri", loginInitiationDTO.getTargetLinkUri());
        authRequestMap.put("response_mode", formPost);
        authRequestMap.put("response_type", idToken);
        authRequestMap.put("scope", openId);
        String state = LtiOidcUtils.generateState((LTIDataService)this.ltiDataService, (PlatformDeployment)platformDeployment, authRequestMap, (LoginInitiationDTO)loginInitiationDTO);
        authRequestMap.put("state", state);
        authRequestMap.put("oicdEndpoint", platformDeployment.getOidcEndpoint());
        authRequestMap.put("oicdEndpointComplete", this.generateCompleteUrl(authRequestMap));
        return authRequestMap;
    }

    private String generateCompleteUrl(Map<String, String> model) {
        return model.get("oicdEndpoint") + "?client_id=" + model.get("client_id") + "&login_hint=" + model.get("login_hint") + "&lti_message_hint=" + model.get("lti_message_hint") + "&nonce=" + model.get("nonce") + "&prompt=" + model.get("prompt") + "&redirect_uri=" + model.get("redirect_uri") + "&response_mode=" + model.get("response_mode") + "&response_type=" + model.get("response_type") + "&scope=" + model.get("scope") + "&state=" + model.get("state");
    }
}

