/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.config;

import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.model.LettoSetupConfigFile;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.LettoService;
import at.letto.setupservice.service.UpdateService;
import at.letto.tools.Cmd;
import org.springframework.context.annotation.Configuration;

@Configuration
public class StartupConfiguration {
    private AnalyzeService analyzeService;
    private DockerConfiguration dockerConfiguration;
    private UpdateService updateService;
    private LettoService lettoService;
    private LettoSetupConfigFile conf;
    private boolean autostartLettoLocal = false;
    private boolean autostartLettoDocker = false;
    private boolean autostartLtiLocal = false;

    private void setPropDef(String prop, String def) {
        if (def != null && def.trim().length() > 0) {
            this.conf.setProperty(prop, def);
        }
    }

    public StartupConfiguration(AnalyzeService analyzeService, DockerConfiguration dockerConfiguration, UpdateService updateService, LettoService lettoService) {
        this.analyzeService = analyzeService;
        this.dockerConfiguration = dockerConfiguration;
        this.updateService = updateService;
        this.lettoService = lettoService;
        this.analyzeService.analyzebase();
        if (analyzeService.isLinux()) {
            LettoSetupConfigFile.setLinux();
        } else if (analyzeService.isWindows()) {
            LettoSetupConfigFile.setWindows();
        } else if (analyzeService.isMac()) {
            LettoSetupConfigFile.setMac();
        }
        this.conf = new LettoSetupConfigFile(analyzeService.getRootPath() + "/letto.conf");
        this.analyzeService.setStartupConfiguration(this);
        this.analyzeService.analyzeinstallation();
        if (!this.conf.existsPropertiesFile()) {
            this.erstConfiguration();
        }
        this.startLeTTo();
    }

    public void erstConfiguration() {
        this.conf.setSetupInit(true);
        this.conf.setSetupLettoDocker(false);
        this.conf.setSetupLettoLocal(false);
        System.out.println("Erstkonfiguration");
        this.setPropDef("letto.tomee.mysql.server", this.analyzeService.getLocal_tomee_mysql_server());
        this.setPropDef("letto.tomee.mysql.database", this.analyzeService.getLocal_tomee_mysql_database());
        this.setPropDef("letto.tomee.mysql.user", this.analyzeService.getLocal_tomee_mysql_user());
        this.setPropDef("letto.tomee.mysql.password", this.analyzeService.getLocal_tomee_mysql_password());
        this.setPropDef("letto.lti.mysql.server", this.analyzeService.getLocal_lti_mysql_server());
        this.setPropDef("letto.lti.mysql.database", this.analyzeService.getLocal_lti_mysql_database());
        this.setPropDef("letto.lti.mysql.user", this.analyzeService.getLocal_lti_mysql_user());
        this.setPropDef("letto.lti.mysql.password", this.analyzeService.getLocal_lti_mysql_password());
        this.setPropDef("letto.mysql.sicherungsuser", this.analyzeService.getLocal_sicherung_user());
        this.setPropDef("letto.mysql.sicherungspasswort", this.analyzeService.getLocal_sicherung_password());
        this.setPropDef("letto.dns.name", this.analyzeService.getLocal_dns_name());
        this.setPropDef("letto.admin.email", this.analyzeService.getLocal_admin_email());
        this.setPropDef("letto.memory", this.analyzeService.getLocal_letto_memory());
        this.setPropDef("letto.local.maxima", this.analyzeService.searchMaximaPath());
        this.setPropDef("letto.local.tex", this.analyzeService.searchTexPath());
        this.setPropDef("letto.local.inkscape", this.analyzeService.searchInkscapePath());
        if (this.analyzeService.isLocalInstallationFound()) {
            this.conf.setSetupLettoLocal(true);
        }
        if (this.analyzeService.isSetupConfigurationPresent()) {
            this.conf.setSetupLettoDocker(true);
        }
        this.conf.save();
    }

    public void searchPrograms() {
        String p = this.analyzeService.searchMaximaPath();
        if (p != null && p.length() > 0) {
            this.setPropDef("letto.local.maxima", p);
        }
        if ((p = this.analyzeService.searchTexPath()) != null && p.length() > 0) {
            this.setPropDef("letto.local.tex", p);
        }
        if ((p = this.analyzeService.searchInkscapePath()) != null && p.length() > 0) {
            this.setPropDef("letto.local.inkscape", p);
        }
        this.conf.save();
        this.analyzeService.analyze();
    }

    public void startLeTTo() {
        if (this.autostartLettoLocal && !this.isRunningLettoLocal()) {
            this.startLettoLocal();
        }
        System.out.println("Starte LeTTo");
    }

    public boolean isRunningLettoLocal() {
        return false;
    }

    public void startLettoLocal() {
        if (this.analyzeService.isLinux()) {
            Cmd.systemcall((String)"/opt/letto/start.sh");
        }
    }

    public void reload() {
        this.conf = new LettoSetupConfigFile(this.analyzeService.getRootPath() + "/letto.conf");
        this.analyzeService.analyze();
    }

    public AnalyzeService getAnalyzeService() {
        return this.analyzeService;
    }

    public DockerConfiguration getDockerConfiguration() {
        return this.dockerConfiguration;
    }

    public UpdateService getUpdateService() {
        return this.updateService;
    }

    public LettoService getLettoService() {
        return this.lettoService;
    }

    public LettoSetupConfigFile getConf() {
        return this.conf;
    }

    public boolean isAutostartLettoLocal() {
        return this.autostartLettoLocal;
    }

    public boolean isAutostartLettoDocker() {
        return this.autostartLettoDocker;
    }

    public boolean isAutostartLtiLocal() {
        return this.autostartLtiLocal;
    }
}

