/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.config;

import at.letto.basespringboot.config.BaseMicroServiceConfiguration;
import at.letto.basespringboot.config.BaseRestWebSecurityConfigurerAdapter;
import at.letto.basespringboot.service.BaseLettoUserDetailsService;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.service.CustomUserDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig
extends BaseRestWebSecurityConfigurerAdapter {
    private final MicroServiceConfiguration microServiceConfiguration;
    private final CustomUserDetailsService customUserDetailsService;

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    public WebSecurityConfig(CustomUserDetailsService customUserDetailsService, MicroServiceConfiguration microServiceConfiguration) {
        this.microServiceConfiguration = microServiceConfiguration;
        this.customUserDetailsService = customUserDetailsService;
        this.configure((BaseLettoUserDetailsService)this.customUserDetailsService, (BaseMicroServiceConfiguration)this.microServiceConfiguration);
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService((UserDetailsService)this.customUserDetailsService).passwordEncoder(this.passwordEncoder());
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.httpBasic().and()).csrf().disable()).headers().frameOptions().disable().cacheControl().disable().and()).authorizeRequests().antMatchers(new String[]{"/"})).permitAll().antMatchers(new String[]{"/setup"})).permitAll().antMatchers(new String[]{"/setup/auth/login"})).permitAll().antMatchers(new String[]{"/setup/open/**"})).permitAll().antMatchers(new String[]{"/setup/auth/teacher/**"})).hasAnyAuthority(new String[]{"teacher", "admin"}).antMatchers(new String[]{"/setup/auth/student/**"})).hasAnyAuthority(new String[]{"student", "teacher", "admin"}).antMatchers(new String[]{"/setup/auth/admin/**"})).hasAnyAuthority(new String[]{"admin"}).antMatchers(new String[]{"/setup/auth/global/**"})).hasAnyAuthority(new String[]{"global"}).anyRequest()).authenticated().and()).formLogin().loginPage("/setup/auth/login").and()).logout().invalidateHttpSession(true).logoutUrl("/setup/open/logout").and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED).sessionFixation().newSession();
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService((UserDetailsService)this.customUserDetailsService).passwordEncoder(this.passwordEncoder());
    }
}

