/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.security.JwtAuthentication;
import at.letto.security.LettoToken;
import at.letto.setupservice.SetupserviceApplication;
import at.letto.setupservice.component.LettoSetupComponent;
import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.config.StartupConfiguration;
import at.letto.setupservice.config.TomcatConfiguration;
import at.letto.setupservice.controller.Msg;
import at.letto.setupservice.controller.MsgType;
import at.letto.setupservice.model.CmdDto;
import at.letto.setupservice.model.CmdThread;
import at.letto.setupservice.model.DownloadFile;
import at.letto.setupservice.model.FileEditDto;
import at.letto.setupservice.model.LoginModel;
import at.letto.setupservice.model.RequestButtonDto;
import at.letto.setupservice.model.WelcomeDto;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.CustomUserDetailsService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.DownloadService;
import at.letto.setupservice.service.InstallService;
import at.letto.setupservice.service.LettoService;
import at.letto.setupservice.service.UpdateService;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class MainHttpController {
    @Autowired
    TomcatConfiguration tomcatConfiguration;
    @Autowired
    StartupConfiguration startupConfiguration;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    private LettoSetupComponent lettoSetupComponent;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private CustomUserDetailsService customUserDetailsService;
    @Autowired
    private LettoService lettoService;
    @Autowired
    private DockerConfiguration dockerConfiguration;
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    private UpdateService updateService;
    @Autowired
    private InstallService installService;
    @Autowired
    private CmdService cmdService;
    @Autowired
    private DockerService dockerService;
    @Autowired
    private DownloadService downloadService;

    @RequestMapping(value={"/"})
    public String root() {
        return "redirect:/setup/auth/login";
    }

    @RequestMapping(value={"/setup"})
    public String service() {
        return "redirect:/setup/auth/login";
    }

    @GetMapping(value={"/setup/open/tokenlogin"})
    public String tokenLogin(@RequestParam String token) {
        try {
            String jwts = this.lettoService.getLoginService().jwtTokenFromTempToken(this.microServiceConfiguration.getServerSecret(), token);
            LettoToken lettoToken = new LettoToken(jwts, this.microServiceConfiguration.getJwtSecret());
            this.lettoSetupComponent.setLettoToken(lettoToken);
            SecurityContextHolder.getContext().setAuthentication((Authentication)new JwtAuthentication(lettoToken));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "redirect:/setup/auth/welcome";
    }

    @RequestMapping(value={"/setup/auth/teacher/lehrer"})
    public String lehrer(Model model) {
        try {
            JwtAuthentication auth = (JwtAuthentication)SecurityContextHolder.getContext().getAuthentication();
            model.addAttribute("username", (Object)auth.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "lehrer";
    }

    @RequestMapping(value={"/setup/auth/student/schueler"})
    public String schueler(Model model) {
        try {
            JwtAuthentication auth = (JwtAuthentication)SecurityContextHolder.getContext().getAuthentication();
            model.addAttribute("username", (Object)auth.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "schueler";
    }

    @RequestMapping(value={"/setup/auth/login"})
    public String login(@ModelAttribute LoginModel loginModel, Model model, HttpServletRequest request) {
        this.analyzeService.analyzeRequestUrl(request);
        return "redirect:/setup/open/loginletto";
    }

    @RequestMapping(value={"/setup/open/loginletto"})
    public String loginForm(@ModelAttribute LoginModel loginModel, Model model, HttpServletRequest request, HttpServletResponse response) {
        this.analyzeService.analyzeRequestUrl(request);
        if (loginModel != null && loginModel.getName().length() > 0 && loginModel.getPasswort().length() > 0) {
            try {
                String username = loginModel.getName();
                String password = loginModel.getPasswort();
                Integer idSchule = loginModel.getIdSchule();
                String schule = loginModel.getSchule();
                LettoToken lettoToken = this.lettoService.getLoginService().jwtLogin(username, password, idSchule.intValue(), this.microServiceConfiguration.getJwtSecret());
                String redirection = "/setup/auth/welcome";
                if (lettoToken == null) {
                    lettoToken = this.customUserDetailsService.checkUsernamePassword(username, password);
                }
                if (lettoToken != null) {
                    JwtAuthentication jwtAuthentication = new JwtAuthentication(lettoToken);
                    SecurityContextHolder.getContext().setAuthentication((Authentication)jwtAuthentication);
                    this.lettoSetupComponent.setLettoToken(lettoToken);
                    return "redirect:" + redirection;
                }
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                model.addAttribute("paramerror", (Object)true);
            }
        }
        model.addAttribute("loginModel", (Object)loginModel);
        model.addAttribute("test", (Object)"ABC");
        return "loginletto";
    }

    @GetMapping(value={"/setup/open/logout"})
    public String logoutPage(HttpServletRequest request, HttpServletResponse response) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        this.lettoSetupComponent.setLettoToken(null);
        if (auth != null) {
            new SecurityContextLogoutHandler().logout(request, response, auth);
        }
        return "redirect:/setup/auth/login";
    }

    @RequestMapping(value={"/setup/auth/global/install"})
    public String installPage(@ModelAttribute LoginModel loginModel, Model model) {
        return "redirect:/setup/auth/login";
    }

    @RequestMapping(value={"/setup/auth/global/fileedit"})
    public String fileEdit(@ModelAttribute FileEditDto fileEditDto, Model model) {
        String button = fileEditDto.getUserAction();
        if (button != null) {
            switch (button) {
                case "reload": {
                    fileEditDto.load();
                    break;
                }
                case "save": {
                    fileEditDto.saveAndReload();
                    break;
                }
                case "reset": {
                    fileEditDto.reset();
                    break;
                }
                case "cancel": {
                    return "redirect:" + fileEditDto.getBacklink();
                }
                case "ok": {
                    fileEditDto.saveAndReload();
                    return "redirect:" + fileEditDto.getOklink();
                }
                case "downloadFile": {
                    DownloadFile df = this.downloadService.newDownloadGlobal(fileEditDto.getFile());
                    return "redirect:/setup/auth/global/download/" + df.getId();
                }
            }
        }
        model.addAttribute("fileEditDto", (Object)fileEditDto);
        return "fileedit";
    }

    @RequestMapping(value={"/setup/auth/global/analyze"})
    public String analyzePage(@ModelAttribute RequestButtonDto requestButtonDto, Model model) {
        String button = requestButtonDto.getUserAction();
        if (button != null) {
            if (button.equals("reload")) {
                this.analyzeService.analyze();
            }
            if (button.equals("update")) {
                String msg = this.updateService.updateSetupService();
                if (msg.equals("ok")) {
                    return "redirect:/setup/auth/login";
                }
                return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/global/analyze", (String)msg, (String)"");
            }
            if (button.equals("back")) {
                return "redirect:/setup/auth/welcome";
            }
        } else {
            this.analyzeService.analyze();
        }
        model.addAttribute("analyzeService", (Object)this.analyzeService);
        model.addAttribute("updateService", (Object)this.updateService);
        model.addAttribute("requestButtonDto", (Object)new RequestButtonDto());
        return "analyze";
    }

    @RequestMapping(value={"/setup/auth/reload"})
    public String reload(@ModelAttribute RequestButtonDto requestButtonDto, HttpServletRequest request, Model model) {
        this.analyzeService.analyzeRequestUrl(request);
        this.startupConfiguration.reload();
        this.dockerConfiguration.loadConfiguration();
        return "redirect:/setup/auth/welcome";
    }

    @RequestMapping(value={"/setup/auth/admin/cmd"})
    public String cmd(@ModelAttribute CmdDto cmdDto, Model model) {
        String button = cmdDto.getUserAction();
        if (button != null) {
            CmdThread cmdThread;
            CmdThread cmdThread2;
            if (button.equals("ok") && cmdDto.getCmd() != null && cmdDto.getCmd().length() > 0) {
                cmdThread2 = this.cmdService.cmdScriptBackground("/setup/auth/admin/cmd", cmdDto.getHomedir(), new String[]{cmdDto.getCmd()});
                if (cmdThread2 != null) {
                    model.addAttribute("cmdThread", (Object)cmdThread2);
                    model.addAttribute("threads", (Object)this.cmdService.getThreads());
                    return "cmdoutput";
                }
                Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)("Command konnte nicht durchgef\u00fchrt werden! " + cmdDto.getCmd()), (String)"");
            }
            if (button.equals("back")) {
                return "redirect:/setup/auth/welcome";
            }
            Matcher m = Pattern.compile("^open(\\d+)$").matcher(button);
            if (m.find() && (cmdThread2 = this.cmdService.getThread(m.group(1))) != null) {
                return this.cmdService.opencmd(model, "/setup/auth/admin/cmd", cmdThread2);
            }
            m = Pattern.compile("^stop(\\d+)$").matcher(button);
            if (m.find() && (cmdThread2 = this.cmdService.getThread(m.group(1))) != null) {
                cmdThread2.stop();
            }
            if ((m = Pattern.compile("^remove(\\d+)$").matcher(button)).find() && (cmdThread2 = this.cmdService.getThread(m.group(1))) != null) {
                this.cmdService.removeThread(cmdThread2);
            }
            if (button.equals("stop.all")) {
                for (int i = 0; i < this.cmdService.getThreads().size(); ++i) {
                    cmdThread = (CmdThread)this.cmdService.getThreads().get(i);
                    cmdThread.stop();
                }
            }
            if (button.equals("remove.finished")) {
                for (int i = 0; i < this.cmdService.getThreads().size(); ++i) {
                    cmdThread = (CmdThread)this.cmdService.getThreads().get(i);
                    if (cmdThread.isFinished()) {
                        this.cmdService.removeThread(cmdThread);
                    }
                    --i;
                }
            }
            if (button.equals("remove.all")) {
                while (this.cmdService.getThreads().size() > 0) {
                    this.cmdService.removeThread((CmdThread)this.cmdService.getThreads().get(0));
                }
            }
        } else {
            cmdDto.setCmd("");
            cmdDto.setHomedir(this.analyzeService.getUserDir());
        }
        model.addAttribute("cmdDto", (Object)cmdDto);
        model.addAttribute("threads", (Object)this.cmdService.getThreads());
        return "cmd";
    }

    @RequestMapping(value={"/setup/auth/admin/cmdoutput"})
    public String cmdoutput(@ModelAttribute CmdDto cmdDto, Model model) {
        CmdThread cmdThread = this.cmdService.getThread(cmdDto.getId());
        String button = cmdDto.getUserAction();
        if (button != null) {
            if (button.equals("ok")) {
                if (cmdThread == null || cmdThread.getBacklink() == null || cmdThread.getBacklink().length() < 1) {
                    return "redirect:/setup/auth/welcome";
                }
                return "redirect:" + cmdThread.getBacklink();
            }
        } else {
            cmdDto.setCmd("");
            cmdDto.setHomedir(this.analyzeService.getUserDir());
        }
        model.addAttribute("cmdThread", (Object)cmdThread);
        return "cmdoutput";
    }

    @RequestMapping(value={"/setup/auth/welcomeanalyze"})
    public String welcomeanalyze(@ModelAttribute RequestButtonDto requestButtonDto, HttpServletRequest request, Model model) {
        this.analyzeService.analyzeRequestUrl(request);
        this.analyzeService.analyze();
        return "redirect:/setup/auth/welcome";
    }

    private String editFileWelcome(File f, Model model) {
        if (f != null) {
            FileEditDto fileEditDto = new FileEditDto(f);
            fileEditDto.setBacklink("/setup/auth/welcome");
            fileEditDto.setOklink("/setup/auth/welcome");
            fileEditDto.setHelplink("https://letto.at");
            fileEditDto.setInfo("Information<span style=\"color:red;\"> Info </span>");
            return this.fileEdit(fileEditDto, model);
        }
        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)"Datei konnte nicht gefunden werden!", (String)"");
    }

    @RequestMapping(value={"/setup/auth/welcome"})
    public String welcome(@ModelAttribute WelcomeDto welcomeDto, HttpServletRequest request, Model model) {
        this.analyzeService.analyzeRequestUrl(request);
        if (welcomeDto == null) {
            welcomeDto = new WelcomeDto();
        }
        String button = welcomeDto.getUserAction();
        try {
            JwtAuthentication auth = (JwtAuthentication)SecurityContextHolder.getContext().getAuthentication();
            model.addAttribute("username", (Object)auth.getName());
        }
        catch (Exception auth) {
            // empty catch block
        }
        model.addAttribute("config", (Object)this.startupConfiguration.getConf());
        model.addAttribute("analyzeService", (Object)this.analyzeService);
        model.addAttribute("updateService", (Object)this.updateService);
        if (welcomeDto.getDbrootpassword() == null) {
            welcomeDto.setDbrootpassword(this.startupConfiguration.getConf().getLettoDatabaseRootPassword());
        }
        if (welcomeDto.getLettoRevision() == null) {
            welcomeDto.setLettoRevision(this.analyzeService.getLetto_daily_revision());
        }
        if (welcomeDto.getLtiRevision() == null) {
            welcomeDto.setLtiRevision(this.analyzeService.getLti_daily_revision());
        }
        model.addAttribute("welcomeDto", (Object)welcomeDto);
        if (button != null) {
            switch (button) {
                case "installdocker": {
                    this.startupConfiguration.getConf().setSetupLettoDocker(true);
                    this.startupConfiguration.getConf().setSetupInit(false);
                    this.startupConfiguration.getConf().save();
                    this.dockerService.createPath();
                    break;
                }
                case "installhost": {
                    this.startupConfiguration.getConf().setSetupLettoLocal(true);
                    this.startupConfiguration.getConf().setSetupInit(false);
                    this.startupConfiguration.getConf().save();
                    break;
                }
                case "stophost": {
                    this.startupConfiguration.getConf().setSetupLettoLocal(false);
                    this.startupConfiguration.getConf().save();
                    break;
                }
                case "installuser": {
                    CmdThread cmdThread = this.installService.installUser("/setup/auth/welcomeanalyze");
                    if (cmdThread != null) {
                        model.addAttribute("cmdThread", (Object)cmdThread);
                        model.addAttribute("threads", (Object)this.cmdService.getThreads());
                        this.analyzeService.analyze();
                        return "cmdoutput";
                    }
                    Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)"Installation konnte nicht durchgef\u00fchrt werden!", (String)"");
                }
                case "installAll": {
                    CmdThread cmdThread = this.installService.installAllUbuntu("/setup/auth/welcomeanalyze");
                    if (cmdThread != null) {
                        model.addAttribute("cmdThread", (Object)cmdThread);
                        model.addAttribute("threads", (Object)this.cmdService.getThreads());
                        return "cmdoutput";
                    }
                    Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)"Installation konnte nicht durchgef\u00fchrt werden!", (String)"");
                }
                case "installDb": {
                    this.installService.dbConfig();
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "installDbRoot": {
                    String pwd = this.startupConfiguration.getConf().getLettoDatabaseRootPassword();
                    if (pwd != null && pwd.length() > 0) {
                        if (this.installService.setDbRootPassword(pwd)) {
                            return "redirect:/setup/auth/welcomeanalyze";
                        }
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)"Passwort konnte nicht gesetzt werden!", (String)"");
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)"Passwort darf nicht null sein!!", (String)"");
                }
                case "setdbroot": {
                    String pwd = welcomeDto.getDbrootpassword();
                    if (pwd != null && pwd.length() > 0) {
                        if (this.installService.setDbRootPassword(pwd)) {
                            return "redirect:/setup/auth/welcomeanalyze";
                        }
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)"Passwort konnte nicht gesetzt werden!", (String)"");
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)"Passwort darf nicht null sein!!", (String)"");
                }
                case "configDirs": {
                    this.installService.configLocalDirs();
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "installTomEE": {
                    this.installService.installLocalTomEE();
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "configTomEE": {
                    this.installService.configLocalTomEE();
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "deleteTomEE": {
                    String msg = this.installService.deleteLocalTomEE();
                    if (msg.length() > 0) {
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                    }
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "stopTomEE": {
                    String msg = this.installService.stopLocalTomEE();
                    if (msg.length() > 0) {
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                    }
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "startTomEE": {
                    String msg = this.installService.startLocalTomEE();
                    if (msg.length() > 0) {
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                    }
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "restartTomEE": {
                    String msg = this.installService.stopLocalTomEE();
                    if (msg.length() > 0) {
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                    }
                    msg = this.installService.startLocalTomEE();
                    if (msg.length() > 0) {
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                    }
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "restartrmlogTomEE": {
                    String msg = this.installService.stopLocalTomEE();
                    if (msg.length() > 0) {
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                    }
                    this.installService.deleteLocalTomEElogfile();
                    msg = this.installService.startLocalTomEE();
                    if (msg.length() > 0) {
                        return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                    }
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "edittomeelog": {
                    return this.editFileWelcome(this.installService.getLocalTomEElogfile(), model);
                }
                case "edittomeexml": {
                    return this.editFileWelcome(this.installService.getLocalTomEEtomeexml(), model);
                }
                case "editserverxml": {
                    return this.editFileWelcome(this.installService.getLocalTomEEserverxml(), model);
                }
                case "editcatalinash": {
                    return this.editFileWelcome(this.installService.getLocalTomEEcatalinash(), model);
                }
                case "editsetenvsh": {
                    return this.editFileWelcome(this.installService.getLocalTomEEsetenvsh(), model);
                }
                case "installLTI": {
                    this.installService.downloadAndInstallLTI();
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "stopLTI": {
                    this.installService.stopLocalLTI();
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "startLTI": {
                    this.installService.startLocalLTI();
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "restartLTI": {
                    this.installService.stopLocalLTI();
                    this.installService.startLocalLTI();
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "editLTIlog": {
                    return this.editFileWelcome(this.installService.getLocalLTIlogfile(), model);
                }
                case "editLTIconfig": {
                    return this.editFileWelcome(this.installService.getLocalLTIconfigfile(), model);
                }
                case "localApacheConfig": {
                    this.installService.installLocalApache();
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "localApacheRemove": {
                    this.installService.deleteLocalApache();
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "apachestart": {
                    String msg = this.installService.startLocalApache();
                    if (msg == null || msg.length() < 1) {
                        return "redirect:/setup/auth/welcomeanalyze";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "apachestop": {
                    String msg = this.installService.stopLocalApache();
                    if (msg == null || msg.length() < 1) {
                        return "redirect:" + this.analyzeService.getLocalSetupUrlWithPort();
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "apacherestart": {
                    String msg = this.installService.restartLocalApache();
                    if (msg == null || msg.length() < 1) {
                        return "redirect:/setup/auth/welcomeanalyze";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "editapachelog": {
                    return this.editFileWelcome(this.installService.getLocalApacheLogfile(), model);
                }
                case "editapacheconf": {
                    return this.editFileWelcome(this.installService.getLocalApacheConfigfile(), model);
                }
                case "localSetupAutostartOff": {
                    this.installService.setSetupLocalAutostart(false, false);
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "localSetupAutostartOn": {
                    this.installService.setSetupLocalAutostart(true, false);
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "localSetupAutostartRoot": {
                    this.installService.setSetupLocalAutostart(true, true);
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "localAutostartOff": {
                    this.installService.setLettoLocalAutostart(false);
                    this.installService.setLTILocalAutostart(false);
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "localAutostartOn": {
                    this.installService.setLettoLocalAutostart(true);
                    this.installService.setLTILocalAutostart(true);
                    return "redirect:/setup/auth/welcomeanalyze";
                }
                case "config": {
                    FileEditDto fileEditDto = new FileEditDto(this.startupConfiguration.getConf().getPropertyFile());
                    fileEditDto.setBacklink("/setup/auth/reload");
                    fileEditDto.setOklink("/setup/auth/reload");
                    fileEditDto.setHelplink("https://letto.at");
                    fileEditDto.setInfo("Information<span style=\"color:red;\"> Info </span>");
                    return this.fileEdit(fileEditDto, model);
                }
                case "refresh": {
                    this.analyzeService.analyze();
                    break;
                }
                case "analyze": {
                    return "redirect:/setup/auth/global/analyze";
                }
                case "searchprograms": {
                    this.startupConfiguration.searchPrograms();
                    break;
                }
                case "resetsetup": {
                    this.startupConfiguration.erstConfiguration();
                    break;
                }
                case "updatesetup": {
                    String msg = this.updateService.updateSetupService();
                    if (msg.equals("ok")) {
                        return "redirect:/setup/auth/login";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "restartsetup": {
                    SetupserviceApplication.restart();
                    return "redirect:/setup/auth/login";
                }
                case "reloadsetup": {
                    this.startupConfiguration.reload();
                    this.analyzeService.analyze();
                    return "redirect:/setup/auth/welcome";
                }
                case "lettostart": {
                    String msg = this.installService.startLettoLocal();
                    this.analyzeService.analyzeinstallation();
                    return Msg.message((MsgType)MsgType.INFO, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "lettorestart": {
                    String msg = this.installService.restartLettoLocal();
                    this.analyzeService.analyzeinstallation();
                    return Msg.message((MsgType)MsgType.INFO, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "lettostop": {
                    String msg = this.installService.stopLettoLocal();
                    this.analyzeService.analyzeinstallation();
                    return Msg.message((MsgType)MsgType.INFO, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "lettoupdate": {
                    String msg = this.installService.updateLettoLocal();
                    this.analyzeService.analyzeinstallation();
                    return Msg.message((MsgType)MsgType.INFO, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "lettoupdatelocaldaily": {
                    String msg = this.installService.updateLettoLocal("daily");
                    if (msg == null || msg.length() < 1) {
                        return "redirect:/setup/auth/welcomeanalyze";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "lettoupdatelocalbeta": {
                    String msg = this.installService.updateLettoLocal("beta");
                    if (msg == null || msg.length() < 1) {
                        return "redirect:/setup/auth/welcomeanalyze";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "lettoupdatelocalstable": {
                    String msg = this.installService.updateLettoLocal("stable");
                    if (msg == null || msg.length() < 1) {
                        return "redirect:/setup/auth/welcomeanalyze";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "lettoupdatelocalrev": {
                    String msg = this.installService.updateLettoLocal(welcomeDto.getLettoRevision());
                    if (msg == null || msg.length() < 1) {
                        return "redirect:/setup/auth/welcomeanalyze";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "ltiupdatelocal": {
                    String msg = this.installService.updateLtiLocal("");
                    if (msg == null || msg.length() < 1) {
                        return "redirect:/setup/auth/welcomeanalyze";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "ltiupdatelocaldaily": {
                    String msg = this.installService.updateLtiLocal("daily");
                    if (msg == null || msg.length() < 1) {
                        return "redirect:/setup/auth/welcomeanalyze";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "ltiupdatelocalbeta": {
                    String msg = this.installService.updateLtiLocal("beta");
                    if (msg == null || msg.length() < 1) {
                        return "redirect:/setup/auth/welcomeanalyze";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "ltiupdatelocalstable": {
                    String msg = this.installService.updateLtiLocal("stable");
                    if (msg == null || msg.length() < 1) {
                        return "redirect:/setup/auth/welcomeanalyze";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "ltiupdatelocalrev": {
                    String msg = this.installService.updateLtiLocal(welcomeDto.getLtiRevision());
                    if (msg == null || msg.length() < 1) {
                        return "redirect:/setup/auth/welcomeanalyze";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "localSicherungEinrichten": {
                    String msg = this.installService.localSicherungEinrichten();
                    if (msg == null || msg.length() < 1) {
                        return "redirect:/setup/auth/welcomeanalyze";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "localSicherungCronStart": {
                    String msg = this.installService.localSicherungCronStart();
                    if (msg == null || msg.length() < 1) {
                        return "redirect:/setup/auth/welcomeanalyze";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "localSicherungCronStop": {
                    String msg = this.installService.localSicherungCronStop();
                    if (msg == null || msg.length() < 1) {
                        return "redirect:/setup/auth/welcomeanalyze";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "localUpdateCronStart": {
                    String msg = this.installService.localUpdateCronStart();
                    if (msg == null || msg.length() < 1) {
                        return "redirect:/setup/auth/welcomeanalyze";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "localUpdateCronStop": {
                    String msg = this.installService.localUpdateCronStop();
                    if (msg == null || msg.length() < 1) {
                        return "redirect:/setup/auth/welcomeanalyze";
                    }
                    return Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)msg, (String)"");
                }
                case "localSicherungNow": {
                    CmdThread cmdThread = this.installService.sicherungLocal("/setup/auth/welcomeanalyze");
                    if (cmdThread != null) {
                        model.addAttribute("cmdThread", (Object)cmdThread);
                        model.addAttribute("threads", (Object)this.cmdService.getThreads());
                        return "cmdoutput";
                    }
                    Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)"Sicherung konnte nicht durchgef\u00fchrt werden!", (String)"");
                }
                case "localSicherungLettoImportLast": {
                    CmdThread cmdThread = this.installService.sicherungLocalLettoImportLast("/setup/auth/welcomeanalyze");
                    if (cmdThread != null) {
                        model.addAttribute("cmdThread", (Object)cmdThread);
                        model.addAttribute("threads", (Object)this.cmdService.getThreads());
                        return "cmdoutput";
                    }
                    Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)"R\u00fccksicherung konnte nicht durchgef\u00fchrt werden!", (String)"");
                }
                case "localSicherungLtiImportLast": {
                    CmdThread cmdThread = this.installService.sicherungLocalLtiImportLast("/setup/auth/welcomeanalyze");
                    if (cmdThread != null) {
                        model.addAttribute("cmdThread", (Object)cmdThread);
                        model.addAttribute("threads", (Object)this.cmdService.getThreads());
                        return "cmdoutput";
                    }
                    Msg.message((MsgType)MsgType.ERROR, (Model)model, (String)"/setup/auth/welcome", (String)"R\u00fccksicherung konnte nicht durchgef\u00fchrt werden!", (String)"");
                }
                case "localSicherungLettoDownloadLast": {
                    DownloadFile df = this.downloadService.newDownloadGlobal(new File("/sicherung/letto.sql.gz"));
                    return "redirect:/setup/auth/global/download/" + df.getId();
                }
                case "localSicherungLtiDownloadLast": {
                    DownloadFile df = this.downloadService.newDownloadGlobal(new File("/sicherung/lettolti.sql.gz"));
                    return "redirect:/setup/auth/global/download/" + df.getId();
                }
                case "localSicherungLettoUpload": 
                case "localSicherungLtiUpload": 
                case "localSicherungDialog": {
                    return "redirect:/setup/auth/global/sicherunglocal";
                }
                case "localSicherungEdit": {
                    return this.editFileWelcome(new File("/sicherung/sicherung.sh"), model);
                }
                case "localResetDatabase": {
                    this.installService.localResetDatabase();
                    break;
                }
                case "localResetLtiDatabase": {
                    this.installService.localResetLtiDatabase();
                    break;
                }
                case "localCrontabEdit": {
                    return this.editFileWelcome(new File("/etc/crontab"), model);
                }
                case "lettobackup": {
                    break;
                }
                case "lettorestore": {
                    break;
                }
                case "cmd": {
                    return "redirect:/setup/auth/admin/cmd";
                }
                case "dockerCreatePath": {
                    this.dockerService.createPath();
                    break;
                }
                case "dockerEditConfig": {
                    FileEditDto fileEditDto = new FileEditDto(this.dockerService.getSetupFile());
                    fileEditDto.setBacklink("/setup/auth/reload");
                    fileEditDto.setOklink("/setup/auth/reload");
                    fileEditDto.setHelplink("https://letto.at");
                    fileEditDto.setInfo("Information<span style=\"color:red;\"> Info </span>");
                    return this.fileEdit(fileEditDto, model);
                }
            }
        }
        model.addAttribute("init", (Object)this.startupConfiguration.getConf().getSetupInit());
        model.addAttribute("local", (Object)this.startupConfiguration.getConf().getSetupLettoLocal());
        model.addAttribute("docker", (Object)this.startupConfiguration.getConf().getSetupLettoDocker());
        return "welcome";
    }

    public TomcatConfiguration getTomcatConfiguration() {
        return this.tomcatConfiguration;
    }

    public StartupConfiguration getStartupConfiguration() {
        return this.startupConfiguration;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public LettoSetupComponent getLettoSetupComponent() {
        return this.lettoSetupComponent;
    }

    public MicroServiceConfiguration getMicroServiceConfiguration() {
        return this.microServiceConfiguration;
    }

    public CustomUserDetailsService getCustomUserDetailsService() {
        return this.customUserDetailsService;
    }

    public LettoService getLettoService() {
        return this.lettoService;
    }

    public DockerConfiguration getDockerConfiguration() {
        return this.dockerConfiguration;
    }

    public AnalyzeService getAnalyzeService() {
        return this.analyzeService;
    }

    public UpdateService getUpdateService() {
        return this.updateService;
    }

    public InstallService getInstallService() {
        return this.installService;
    }

    public CmdService getCmdService() {
        return this.cmdService;
    }

    public DockerService getDockerService() {
        return this.dockerService;
    }

    public DownloadService getDownloadService() {
        return this.downloadService;
    }

    public void setTomcatConfiguration(TomcatConfiguration tomcatConfiguration) {
        this.tomcatConfiguration = tomcatConfiguration;
    }

    public void setStartupConfiguration(StartupConfiguration startupConfiguration) {
        this.startupConfiguration = startupConfiguration;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setLettoSetupComponent(LettoSetupComponent lettoSetupComponent) {
        this.lettoSetupComponent = lettoSetupComponent;
    }

    public void setMicroServiceConfiguration(MicroServiceConfiguration microServiceConfiguration) {
        this.microServiceConfiguration = microServiceConfiguration;
    }

    public void setCustomUserDetailsService(CustomUserDetailsService customUserDetailsService) {
        this.customUserDetailsService = customUserDetailsService;
    }

    public void setLettoService(LettoService lettoService) {
        this.lettoService = lettoService;
    }

    public void setDockerConfiguration(DockerConfiguration dockerConfiguration) {
        this.dockerConfiguration = dockerConfiguration;
    }

    public void setAnalyzeService(AnalyzeService analyzeService) {
        this.analyzeService = analyzeService;
    }

    public void setUpdateService(UpdateService updateService) {
        this.updateService = updateService;
    }

    public void setInstallService(InstallService installService) {
        this.installService = installService;
    }

    public void setCmdService(CmdService cmdService) {
        this.cmdService = cmdService;
    }

    public void setDockerService(DockerService dockerService) {
        this.dockerService = dockerService;
    }

    public void setDownloadService(DownloadService downloadService) {
        this.downloadService = downloadService;
    }
}

