/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.model;

import at.letto.setupservice.model.FileEditDto;
import at.letto.tools.Cmd;
import java.io.File;
import java.io.FileWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileEditDto {
    private EditMode editmode = EditMode.TEXT;
    private String filename = "";
    private String path = "";
    private String info = "";
    private String helplink = "";
    private String inhalt = "";
    private String origin = "";
    private String userAction = null;
    private String backlink = "";
    private String oklink = "";

    public FileEditDto(String filename, String path, String inhalt) {
        this.filename = filename;
        this.path = path;
        this.inhalt = inhalt;
        this.origin = inhalt;
    }

    public FileEditDto(String filename, String path) {
        this.filename = filename;
        this.path = path;
        this.load();
    }

    public FileEditDto(File file) {
        String inhalt = "";
        String filename = file.getAbsolutePath().replaceAll("\\\\", "/").trim();
        String pfad = "";
        String name = filename;
        Matcher m = Pattern.compile("(.*)/([^/]+)$").matcher(filename);
        if (m.find()) {
            pfad = m.group(1);
            name = m.group(2);
        }
        this.filename = name;
        this.path = pfad;
        this.load();
    }

    public File getFile() {
        File f = this.path.length() > 0 ? new File(this.path + "/" + this.filename) : new File(this.filename);
        return f;
    }

    public void load() {
        File file = this.getFile();
        this.inhalt = "";
        try {
            for (String s : Cmd.readfile((File)file)) {
                this.inhalt = this.inhalt + s + "\n";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.origin = this.inhalt;
    }

    public boolean save() {
        File f = this.getFile();
        try {
            FileWriter fileWriter = new FileWriter(f);
            fileWriter.write(this.inhalt);
            this.origin = this.inhalt;
            fileWriter.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void reset() {
        this.inhalt = this.origin;
    }

    public boolean saveAndReload() {
        if (this.save()) {
            this.load();
            return true;
        }
        return false;
    }

    public String getOklink() {
        if (this.oklink != null && this.oklink.length() > 0) {
            return this.oklink;
        }
        return this.getBacklink();
    }

    public EditMode getEditmode() {
        return this.editmode;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getPath() {
        return this.path;
    }

    public String getInfo() {
        return this.info;
    }

    public String getHelplink() {
        return this.helplink;
    }

    public String getInhalt() {
        return this.inhalt;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getUserAction() {
        return this.userAction;
    }

    public String getBacklink() {
        return this.backlink;
    }

    public void setEditmode(EditMode editmode) {
        this.editmode = editmode;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setHelplink(String helplink) {
        this.helplink = helplink;
    }

    public void setInhalt(String inhalt) {
        this.inhalt = inhalt;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public void setUserAction(String userAction) {
        this.userAction = userAction;
    }

    public void setBacklink(String backlink) {
        this.backlink = backlink;
    }

    public void setOklink(String oklink) {
        this.oklink = oklink;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileEditDto)) {
            return false;
        }
        FileEditDto other = (FileEditDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        EditMode this$editmode = this.getEditmode();
        EditMode other$editmode = other.getEditmode();
        if (this$editmode == null ? other$editmode != null : !this$editmode.equals(other$editmode)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$info = this.getInfo();
        String other$info = other.getInfo();
        if (this$info == null ? other$info != null : !this$info.equals(other$info)) {
            return false;
        }
        String this$helplink = this.getHelplink();
        String other$helplink = other.getHelplink();
        if (this$helplink == null ? other$helplink != null : !this$helplink.equals(other$helplink)) {
            return false;
        }
        String this$inhalt = this.getInhalt();
        String other$inhalt = other.getInhalt();
        if (this$inhalt == null ? other$inhalt != null : !this$inhalt.equals(other$inhalt)) {
            return false;
        }
        String this$origin = this.getOrigin();
        String other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        String this$userAction = this.getUserAction();
        String other$userAction = other.getUserAction();
        if (this$userAction == null ? other$userAction != null : !this$userAction.equals(other$userAction)) {
            return false;
        }
        String this$backlink = this.getBacklink();
        String other$backlink = other.getBacklink();
        if (this$backlink == null ? other$backlink != null : !this$backlink.equals(other$backlink)) {
            return false;
        }
        String this$oklink = this.getOklink();
        String other$oklink = other.getOklink();
        return !(this$oklink == null ? other$oklink != null : !this$oklink.equals(other$oklink));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileEditDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EditMode $editmode = this.getEditmode();
        result = result * 59 + ($editmode == null ? 43 : $editmode.hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        String $helplink = this.getHelplink();
        result = result * 59 + ($helplink == null ? 43 : $helplink.hashCode());
        String $inhalt = this.getInhalt();
        result = result * 59 + ($inhalt == null ? 43 : $inhalt.hashCode());
        String $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        String $userAction = this.getUserAction();
        result = result * 59 + ($userAction == null ? 43 : $userAction.hashCode());
        String $backlink = this.getBacklink();
        result = result * 59 + ($backlink == null ? 43 : $backlink.hashCode());
        String $oklink = this.getOklink();
        result = result * 59 + ($oklink == null ? 43 : $oklink.hashCode());
        return result;
    }

    public String toString() {
        return "FileEditDto(editmode=" + this.getEditmode() + ", filename=" + this.getFilename() + ", path=" + this.getPath() + ", info=" + this.getInfo() + ", helplink=" + this.getHelplink() + ", inhalt=" + this.getInhalt() + ", origin=" + this.getOrigin() + ", userAction=" + this.getUserAction() + ", backlink=" + this.getBacklink() + ", oklink=" + this.getOklink() + ")";
    }

    public FileEditDto() {
    }
}

