/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.service.rest.RestLettoDataService;
import at.letto.service.rest.RestLoginService;
import at.letto.setupservice.config.LoggingConfiguration;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.config.TomcatConfiguration;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LettoService {
    private Logger logger = LoggerFactory.getLogger(LettoService.class);
    private TomcatConfiguration tomcatConfiguration;
    private MicroServiceConfiguration microServiceConfiguration;
    private LoggingConfiguration loggingConfiguration;
    private RestLoginService loginService = null;
    private Hashtable<Integer, RestLettoDataService> dataServiceHashtable = null;

    public LettoService(TomcatConfiguration tomcatConfiguration, MicroServiceConfiguration microServiceConfiguration, LoggingConfiguration loggingConfiguration) {
        this.microServiceConfiguration = microServiceConfiguration;
        this.tomcatConfiguration = tomcatConfiguration;
        this.loggingConfiguration = loggingConfiguration;
        this.getLoginService();
    }

    public synchronized RestLoginService getLoginService() {
        if (this.loginService == null) {
            try {
                this.loginService = new RestLoginService(this.microServiceConfiguration.getLoginServiceUri());
            }
            catch (Exception ex) {
                this.logger.error("Loginservice kann nicht geladen werden von " + this.microServiceConfiguration.getImageServiceUri());
            }
        }
        return this.loginService;
    }

    private void loadLettoDataService() {
        this.loadLettoDataService(this.microServiceConfiguration.getSchuleStandardIdSchuleLizenz(), this.microServiceConfiguration.getSchuleStandardSchulename(), this.microServiceConfiguration.getSchuleStandardLettoDataUser(), this.microServiceConfiguration.getSchuleStandardLettoDataPassword(), this.microServiceConfiguration.getSchuleStandardLettoDataUri());
    }

    public void loadLettoDataService(String idSchule, String schulname, String username, String password, String uri) {
        try {
            int id = Integer.parseInt(idSchule);
            RestLettoDataService dataService = new RestLettoDataService(uri, username, password, id, schulname);
            this.dataServiceHashtable.put(id, dataService);
        }
        catch (Exception ex) {
            this.logger.error("LettoData Service f\u00fcr die Schule " + schulname + " kann nicht geladen werden von " + uri);
        }
    }

    public List<RestLettoDataService> getLettoDataServices() {
        ArrayList<RestLettoDataService> ret = new ArrayList<RestLettoDataService>();
        for (RestLettoDataService s : this.dataServiceHashtable.values()) {
            ret.add(s);
        }
        return ret;
    }

    public RestLettoDataService getLettoDataService(Integer idSchule) {
        if (this.dataServiceHashtable == null || this.dataServiceHashtable.size() == 0) {
            this.loadLettoDataService();
        }
        if (idSchule != null && this.dataServiceHashtable.containsKey(idSchule)) {
            return (RestLettoDataService)this.dataServiceHashtable.get(idSchule);
        }
        return null;
    }
}

