/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.setupservice.SetupserviceApplication;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.tools.Cmd;
import at.letto.tools.ENCRYPT;
import at.letto.tools.WebGet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateService {
    @Autowired
    AnalyzeService analyzeService;
    private static final String lettosetupUrl = "https://www.letto.at/download/public/letto/setup/lettosetup";
    public static final String lettoDownload = "https://www.letto.at/download/letto";
    public static final String lettoDailyUrl = "https://www.letto.at/download/letto/daily";
    public static final String lettoStableUrl = "https://www.letto.at/download/letto/stable";
    public static final String lettoBetaUrl = "https://www.letto.at/download/letto/beta";
    public static final String lettoArchivUrl = "https://www.letto.at/download/letto/archiv";
    public static final String lettoLTIUrl = "https://www.letto.at/download/letto/lti";

    private void saveByteArrayInFile(byte[] data, File f) throws IOException {
        FileOutputStream fos = new FileOutputStream(f);
        if (data != null) {
            fos.write(data);
        }
        fos.close();
        this.analyzeService.setOwnerLetto(new File[]{f});
    }

    public String downloadCheckMd5(String url, String md5url, String zieldatei) {
        return this.downloadCheckMd5(url, md5url, new File(zieldatei));
    }

    public String downloadCheckMd5(String url, String md5url, File file) {
        byte[] data = null;
        try {
            String md5 = WebGet.getUrlString((String)md5url).trim().split(" ")[0];
            data = WebGet.getUrlByteArray((String)url);
            String downloadMd5 = ENCRYPT.md5((byte[])data);
            if (!downloadMd5.equals(md5)) {
                return "Pr\u00fcfsummenfehler beim Download von " + url;
            }
        }
        catch (Exception ex) {
            return "Pr\u00fcfsummenfehler beim Download von " + url;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            if (data != null) {
                fos.write(data);
            }
            fos.close();
            this.analyzeService.setOwnerLetto(new File[]{file});
            return "";
        }
        catch (Exception ex) {
            return file.getAbsolutePath() + " kann nicht geschrieben werden!";
        }
    }

    public String downloadBinary(String url, String zieldatei) {
        return this.downloadBinary(url, new File(zieldatei));
    }

    public String downloadBinary(String url, File file) {
        byte[] data = null;
        try {
            data = WebGet.getUrlByteArray((String)url);
        }
        catch (Exception ex) {
            return "Fehler beim Download von " + url;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            if (data != null) {
                fos.write(data);
            }
            fos.close();
            this.analyzeService.setOwnerLetto(new File[]{file});
            return "";
        }
        catch (Exception ex) {
            return file.getAbsolutePath() + " kann nicht geschrieben werden!";
        }
    }

    public String download(String url, String zieldatei) {
        return this.download(url, new File(zieldatei));
    }

    public String download(String url, File file) {
        try {
            Vector data = WebGet.getUrlStringVector((String)url);
            if (Cmd.writelnfile((Vector)data, (File)file)) {
                return "";
            }
            this.analyzeService.setOwnerLetto(new File[]{file});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file.getAbsolutePath() + " kann nicht geschrieben werden!";
    }

    public String updateSetupService() {
        File p = new File(this.analyzeService.getRootPath());
        if (p.isDirectory()) {
            String msg = this.downloadCheckMd5("https://www.letto.at/download/public/letto/setup/lettosetup.jar", "https://www.letto.at/download/public/letto/setup/lettosetup.md5", p.getAbsolutePath() + "/lettosetup.jar");
            if (msg.length() > 0) {
                return msg;
            }
            SetupserviceApplication.restart();
            return "ok";
        }
        return "Cannot create directory " + p.getAbsolutePath();
    }
}

