/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.controller;

import at.letto.lti.model.dto.LoginInitiationDTO;
import at.letto.lti.model.lti.PlatformDeployment;
import at.letto.lti.repository.PlatformDeploymentRepository;
import at.letto.lti.service.LTIDataService;
import at.letto.lti.utils.lti.LtiOidcUtils;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@Scope(value="session")
@RequestMapping(value={"/oidc"})
public class OIDCController {
    static final Logger log = LoggerFactory.getLogger(OIDCController.class);
    @Autowired
    PlatformDeploymentRepository platformDeploymentRepository;
    @Autowired
    LTIDataService ltiDataService;

    @RequestMapping(value={"/login_initiations"})
    public RedirectView loginInitiations(HttpServletRequest req, Model model) {
        LoginInitiationDTO loginInitiationDTO = new LoginInitiationDTO(req);
        String clientIdValue = loginInitiationDTO.getClientId();
        String deploymentIdValue = loginInitiationDTO.getLtiDeploymentId();
        List platformDeploymentList = this.platformDeploymentRepository.findByIss(loginInitiationDTO.getIss());
        if (platformDeploymentList.isEmpty()) {
            model.addAttribute("Error", (Object)("Not found any existing tool deployment with iss: " + loginInitiationDTO.getIss() + " clientId: " + clientIdValue + " deploymentId: " + deploymentIdValue));
            return new RedirectView("lti3Error");
        }
        PlatformDeployment platformDeployment = (PlatformDeployment)platformDeploymentList.get(0);
        if (platformDeploymentList.size() == 1 && (clientIdValue == null || deploymentIdValue == null)) {
            if (clientIdValue == null) {
                clientIdValue = platformDeployment.getClientId();
            }
            if (deploymentIdValue == null) {
                deploymentIdValue = platformDeployment.getDeploymentId();
            }
        }
        try {
            Map parameters = this.generateAuthRequestPayload(loginInitiationDTO, clientIdValue, deploymentIdValue, platformDeployment.getOidcEndpoint());
            HttpSession session = req.getSession();
            List<String> stateList = session.getAttribute("lti_state") != null ? (List)session.getAttribute("lti_state") : new ArrayList();
            String state = (String)parameters.get("state");
            if (!stateList.contains(state)) {
                stateList.add(state);
            }
            session.setAttribute("lti_state", stateList);
            List<String> nonceList = session.getAttribute("lti_nonce") != null ? (List)session.getAttribute("lti_nonce") : new ArrayList();
            String nonce = (String)parameters.get("nonce");
            if (!nonceList.contains(nonce)) {
                nonceList.add(nonce);
            }
            session.setAttribute("lti_nonce", nonceList);
            String ret = (String)parameters.get("oidcEndpointComplete");
            RedirectView rv = new RedirectView(ret);
            rv.setExpandUriTemplateVariables(false);
            return rv;
        }
        catch (Exception ex) {
            model.addAttribute("Error", (Object)ExceptionUtils.getStackTrace((Throwable)ex));
            return new RedirectView("lti3Error");
        }
    }

    private Map<String, String> generateAuthRequestPayload(LoginInitiationDTO loginInitiationDTO, String clientIdValue, String deploymentIdValue, String oidcEndpoint) throws GeneralSecurityException, IOException {
        HashMap<String, String> authRequestMap = new HashMap<String, String>();
        if (clientIdValue != null) {
            authRequestMap.put("client_id", clientIdValue);
        }
        authRequestMap.put("login_hint", loginInitiationDTO.getLoginHint());
        authRequestMap.put("lti_message_hint", loginInitiationDTO.getLtiMessageHint());
        String nonce = UUID.randomUUID().toString();
        String nonceHash = Hashing.sha256().hashString((CharSequence)nonce, StandardCharsets.UTF_8).toString();
        authRequestMap.put("nonce", nonce);
        authRequestMap.put("nonce_hash", nonceHash);
        authRequestMap.put("prompt", "none");
        authRequestMap.put("redirect_uri", loginInitiationDTO.getTargetLinkUri());
        authRequestMap.put("response_mode", "form_post");
        authRequestMap.put("response_type", "id_token");
        authRequestMap.put("scope", "openid");
        String state = LtiOidcUtils.generateState((LTIDataService)this.ltiDataService, authRequestMap, (LoginInitiationDTO)loginInitiationDTO, (String)clientIdValue, (String)deploymentIdValue);
        authRequestMap.put("state", state);
        authRequestMap.put("oidcEndpoint", oidcEndpoint);
        authRequestMap.put("oidcEndpointComplete", this.generateCompleteUrl(authRequestMap));
        return authRequestMap;
    }

    private String generateCompleteUrl(Map<String, String> model) throws UnsupportedEncodingException {
        StringBuilder getUrl = new StringBuilder();
        getUrl.append(model.get("oidcEndpoint"));
        if (model.get("client_id") != null) {
            getUrl = this.addParameter(getUrl, "client_id", model.get("client_id"), true);
            getUrl = this.addParameter(getUrl, "login_hint", model.get("login_hint"), false);
        } else {
            getUrl = this.addParameter(getUrl, "login_hint", model.get("login_hint"), true);
        }
        getUrl = this.addParameter(getUrl, "lti_message_hint", model.get("lti_message_hint"), false);
        getUrl = this.addParameter(getUrl, "nonce", model.get("nonce_hash"), false);
        getUrl = this.addParameter(getUrl, "prompt", model.get("prompt"), false);
        getUrl = this.addParameter(getUrl, "redirect_uri", model.get("redirect_uri"), false);
        getUrl = this.addParameter(getUrl, "response_mode", model.get("response_mode"), false);
        getUrl = this.addParameter(getUrl, "response_type", model.get("response_type"), false);
        getUrl = this.addParameter(getUrl, "scope", model.get("scope"), false);
        getUrl = this.addParameter(getUrl, "state", model.get("state"), false);
        return getUrl.toString();
    }

    private StringBuilder addParameter(StringBuilder url, String parameter, String value, boolean first) throws UnsupportedEncodingException {
        if (value != null) {
            if (first) {
                url.append("?").append(parameter).append("=");
            } else {
                url.append("&").append(parameter).append("=");
            }
            url.append(value);
        }
        return url;
    }
}

