/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.model.lti;

import at.letto.lti.dto.LtiRsaKeyDTO;
import at.letto.lti.model.lti.BaseEntity;
import at.letto.lti.model.lti.RSAKeyId;
import at.letto.tools.Datum;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="rsa_key")
public class RSAKeyEntity
extends BaseEntity {
    @EmbeddedId
    private RSAKeyId kid;
    @Basic
    @Column(name="public_key", length=4096)
    private String publicKey;
    @Basic
    @Column(name="private_key", length=4096)
    private String privateKey;

    protected RSAKeyEntity() {
    }

    public RSAKeyEntity(String kid, Boolean tool, String publicKey, String privateKey) {
        RSAKeyId rsaKeyId;
        this.kid = rsaKeyId = new RSAKeyId(kid, tool);
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public RSAKeyId getKid() {
        return this.kid;
    }

    public void setKid(RSAKeyId kid) {
        this.kid = kid;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RSAKeyEntity that = (RSAKeyEntity)o;
        if (this.kid != that.kid) {
            return false;
        }
        if (this.publicKey != null ? !this.publicKey.equals(that.publicKey) : that.publicKey != null) {
            return false;
        }
        return this.privateKey != null ? this.privateKey.equals(that.privateKey) : that.privateKey == null;
    }

    public int hashCode() {
        int result = this.kid != null ? this.kid.hashCode() : 0;
        result = 31 * result + (this.publicKey != null ? this.publicKey.hashCode() : 0);
        result = 31 * result + (this.privateKey != null ? this.privateKey.hashCode() : 0);
        return result;
    }

    public LtiRsaKeyDTO toDto() {
        String privateKey = this.getPrivateKey().trim().replaceAll("^-----BEGIN PRIVATE KEY-----", "").replaceAll("-----END PRIVATE KEY-----$", "");
        String publicKey = this.getPublicKey().trim().replaceAll("^-----BEGIN PUBLIC KEY-----", "").replaceAll("-----END PUBLIC KEY-----$", "");
        return new LtiRsaKeyDTO(this.getKid().getKid(), this.getKid().getTool(), this.getVersion(), Datum.toString((Date)this.getCreatedAt()), Datum.toString((Date)this.getUpdatedAt()), privateKey, publicKey);
    }
}

