/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.utils.lti;

import at.letto.lti.config.ApplicationConfig;
import at.letto.lti.model.lti.LtiContextEntity;
import at.letto.lti.model.lti.LtiLinkEntity;
import at.letto.lti.model.lti.LtiMembershipEntity;
import at.letto.lti.model.lti.LtiResultEntity;
import at.letto.lti.model.lti.LtiUserEntity;
import at.letto.lti.model.lti.PlatformDeployment;
import at.letto.lti.service.LTIDataService;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.thymeleaf.util.ListUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class LTI3Request {
    static final Logger log = LoggerFactory.getLogger(LTI3Request.class);
    HttpServletRequest httpServletRequest;
    LTIDataService ltiDataService;
    PlatformDeployment key;
    LtiContextEntity context;
    LtiLinkEntity link;
    LtiMembershipEntity membership;
    LtiUserEntity user;
    LtiResultEntity result;
    boolean loaded = false;
    boolean complete = false;
    boolean correct = false;
    boolean updated = false;
    int loadingUpdates = 0;
    String ltiMessageType;
    String ltiVersion;
    String ltiDeploymentId;
    String ltiGivenName;
    String ltiFamilyName;
    String ltiMiddleName;
    String ltiPicture;
    String ltiEmail;
    String ltiName;
    List<String> ltiRoles;
    List<String> ltiRoleScopeMentor;
    int userRoleNumber;
    Map<String, Object> ltiResourceLink;
    String ltiLinkId;
    String ltiLinkTitle;
    String ltiLinkDescription;
    Map<String, Object> ltiContext;
    String ltiContextId;
    String ltiContextTitle;
    String ltiContextLabel;
    List<String> ltiContextType;
    Map<String, Object> ltiToolPlatform;
    String ltiToolPlatformName;
    String ltiToolPlatformContactEmail;
    String ltiToolPlatformDesc;
    String ltiToolPlatformUrl;
    String ltiToolPlatformProduct;
    String ltiToolPlatformFamilyCode;
    String ltiToolPlatformVersion;
    Map<String, Object> ltiEndpoint;
    List<String> ltiEndpointScope;
    String ltiEndpointLineItems;
    Map<String, Object> ltiNamesRoleService;
    String ltiNamesRoleServiceContextMembershipsUrl;
    List<String> ltiNamesRoleServiceVersions;
    Map<String, Object> ltiCaliperEndpointService;
    List<String> ltiCaliperEndpointServiceScopes;
    String ltiCaliperEndpointServiceUrl;
    String ltiCaliperEndpointServiceSessionId;
    String iss;
    String aud;
    Date iat;
    Date exp;
    String sub;
    String kid;
    String lti11LegacyUserId;
    String nonce;
    String locale;
    Map<String, Object> ltiLaunchPresentation;
    String ltiPresTarget;
    Integer ltiPresWidth;
    Integer ltiPresHeight;
    String ltiPresReturnUrl;
    Locale ltiPresLocale;
    Map<String, Object> ltiExtension;
    Map<String, Object> ltiCustom;
    String ltiTargetLinkUrl;

    public static synchronized LTI3Request getInstance() {
        LTI3Request ltiRequest = null;
        try {
            ltiRequest = LTI3Request.getInstanceOrDie();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ltiRequest;
    }

    public static LTI3Request getInstanceOrDie() {
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest req = sra.getRequest();
        if (req == null) {
            throw new IllegalStateException("No HttpServletRequest can be found, cannot get the LTIRequest unless we are currently in a request");
        }
        LTI3Request ltiRequest = (LTI3Request)req.getAttribute(LTI3Request.class.getName());
        if (ltiRequest == null) {
            log.debug("No LTIRequest found, attempting to create one for the current request");
            LTIDataService ltiDataService = null;
            try {
                ltiDataService = (LTIDataService)ApplicationConfig.getContext().getBean(LTIDataService.class);
            }
            catch (Exception e) {
                log.warn("Unable to get the LTIDataService, initializing the LTIRequest without it");
            }
            try {
                if (ltiDataService == null) {
                    throw new IllegalStateException("Error internal, no Dataservice available: " + req);
                }
                ltiRequest = new LTI3Request(req, ltiDataService, true);
            }
            catch (Exception e) {
                log.warn("Failure trying to create the LTIRequest: {}", (Throwable)e);
            }
        }
        if (ltiRequest == null) {
            throw new IllegalStateException("Invalid LTI request, cannot create LTIRequest from request: " + req);
        }
        return ltiRequest;
    }

    public LTI3Request(HttpServletRequest request, LTIDataService ltiDataService, boolean update) {
        if (request == null) {
            throw new AssertionError((Object)"cannot make an LtiRequest without a request");
        }
        if (ltiDataService == null) {
            throw new AssertionError((Object)"LTIDataService cannot be null");
        }
        this.ltiDataService = ltiDataService;
        this.httpServletRequest = request;
        String jwt = this.httpServletRequest.getParameter("id_token");
        JwtParser parser = Jwts.parser();
        parser.setSigningKeyResolver((SigningKeyResolver)new /* Unavailable Anonymous Inner Class!! */);
        Jws jws = parser.parseClaimsJws(jwt);
        String checkNonce = this.checkNonce(jws);
        if (!checkNonce.equals("true")) {
            throw new IllegalStateException("Nonce error: " + checkNonce);
        }
        String isLTI3Request = LTI3Request.isLTI3Request((Jws)jws);
        if (!isLTI3Request.equals("true")) {
            throw new IllegalStateException("Request is not a valid LTI3 request: " + isLTI3Request);
        }
        String processRequestParameters = this.processRequestParameters(request, jws);
        if (!processRequestParameters.equals("true")) {
            throw new IllegalStateException("Request is not a valid LTI3 request: " + processRequestParameters);
        }
        ltiDataService.loadLTIDataFromDB(this);
        if (update) {
            ltiDataService.updateLTIDataInDB(this);
        }
    }

    public String processRequestParameters(HttpServletRequest request, Jws<Claims> jws) {
        if (request != null && this.httpServletRequest != request) {
            this.httpServletRequest = request;
        }
        assert (this.httpServletRequest != null);
        this.ltiMessageType = this.getStringFromLTIRequest(jws, "https://purl.imsglobal.org/spec/lti/claim/message_type");
        this.ltiVersion = this.getStringFromLTIRequest(jws, "https://purl.imsglobal.org/spec/lti/claim/version");
        this.ltiDeploymentId = this.getStringFromLTIRequest(jws, "https://purl.imsglobal.org/spec/lti/claim/deployment_id");
        this.ltiGivenName = this.getStringFromLTIRequest(jws, "given_name");
        this.ltiFamilyName = this.getStringFromLTIRequest(jws, "family_name");
        this.ltiMiddleName = this.getStringFromLTIRequest(jws, "middle_name");
        this.ltiPicture = this.getStringFromLTIRequest(jws, "picture");
        this.ltiEmail = this.getStringFromLTIRequest(jws, "email");
        this.ltiName = this.getStringFromLTIRequest(jws, "name");
        this.ltiRoles = this.getListFromLTIRequest(jws, "https://purl.imsglobal.org/spec/lti/claim/roles");
        this.userRoleNumber = this.makeUserRoleNum(this.ltiRoles);
        this.ltiRoleScopeMentor = this.getListFromLTIRequest(jws, "https://purl.imsglobal.org/spec/lti/claim/role_scope_mentor");
        this.ltiResourceLink = this.getMapFromLTIRequest(jws, "https://purl.imsglobal.org/spec/lti/claim/resource_link");
        this.ltiLinkId = this.getStringFromLTIRequestMap(this.ltiResourceLink, "id");
        this.ltiLinkDescription = this.getStringFromLTIRequestMap(this.ltiResourceLink, "description");
        this.ltiLinkTitle = this.getStringFromLTIRequestMap(this.ltiResourceLink, "title");
        this.ltiContext = this.getMapFromLTIRequest(jws, "https://purl.imsglobal.org/spec/lti/claim/context");
        this.ltiContextId = this.getStringFromLTIRequestMap(this.ltiContext, "id");
        this.ltiContextLabel = this.getStringFromLTIRequestMap(this.ltiContext, "label");
        this.ltiContextTitle = this.getStringFromLTIRequestMap(this.ltiContext, "title");
        this.ltiContextType = this.getListFromLTIRequestMap(this.ltiContext, "type");
        this.ltiToolPlatform = this.getMapFromLTIRequest(jws, "https://purl.imsglobal.org/spec/lti/claim/tool_platform");
        this.ltiToolPlatformName = this.getStringFromLTIRequestMap(this.ltiToolPlatform, "name");
        this.ltiToolPlatformContactEmail = this.getStringFromLTIRequestMap(this.ltiToolPlatform, "contact_email");
        this.ltiToolPlatformDesc = this.getStringFromLTIRequestMap(this.ltiToolPlatform, "description");
        this.ltiToolPlatformUrl = this.getStringFromLTIRequestMap(this.ltiToolPlatform, "url");
        this.ltiToolPlatformProduct = this.getStringFromLTIRequestMap(this.ltiToolPlatform, "product_family_code");
        this.ltiToolPlatformFamilyCode = this.getStringFromLTIRequestMap(this.ltiToolPlatform, "product_family_code");
        this.ltiToolPlatformVersion = this.getStringFromLTIRequestMap(this.ltiToolPlatform, "version");
        this.ltiEndpoint = this.getMapFromLTIRequest(jws, "https://purl.imsglobal.org/spec/lti-ags/claim/endpoint");
        this.ltiEndpointScope = this.getListFromLTIRequestMap(this.ltiEndpoint, "scope");
        this.ltiEndpointLineItems = this.getStringFromLTIRequestMap(this.ltiEndpoint, "lineitems");
        this.ltiNamesRoleService = this.getMapFromLTIRequest(jws, "https://purl.imsglobal.org/spec/lti-nrps/claim/namesroleservice");
        this.ltiNamesRoleServiceContextMembershipsUrl = this.getStringFromLTIRequestMap(this.ltiNamesRoleService, "context_memberships_url");
        this.ltiNamesRoleServiceVersions = this.getListFromLTIRequestMap(this.ltiNamesRoleService, "service_versions");
        this.ltiCaliperEndpointService = this.getMapFromLTIRequest(jws, "https://purl.imsglobal.org/spec/lti-ces/claim/caliper-endpoint-service");
        this.ltiCaliperEndpointServiceScopes = this.getListFromLTIRequestMap(this.ltiCaliperEndpointService, "scopes");
        this.ltiCaliperEndpointServiceUrl = this.getStringFromLTIRequestMap(this.ltiCaliperEndpointService, "caliper_endpoint_url");
        this.ltiCaliperEndpointServiceSessionId = this.getStringFromLTIRequestMap(this.ltiCaliperEndpointService, "caliper_federated_session_id");
        this.iss = ((Claims)jws.getBody()).getIssuer();
        this.aud = ((Claims)jws.getBody()).getAudience();
        this.iat = ((Claims)jws.getBody()).getIssuedAt();
        this.exp = ((Claims)jws.getBody()).getExpiration();
        this.sub = ((Claims)jws.getBody()).getSubject();
        this.nonce = this.getStringFromLTIRequest(jws, "nonce");
        this.lti11LegacyUserId = this.getStringFromLTIRequest(jws, "https://purl.imsglobal.org/spec/lti/claim/lti11_legacy_user_id");
        this.locale = this.getStringFromLTIRequest(jws, "locale");
        this.ltiPresLocale = this.locale == null ? Locale.getDefault() : Locale.forLanguageTag(this.locale);
        this.ltiLaunchPresentation = this.getMapFromLTIRequest(jws, "https://purl.imsglobal.org/spec/lti/claim/launch_presentation");
        this.ltiPresHeight = this.getIntegerFromLTIRequestMap(this.ltiLaunchPresentation, "height");
        this.ltiPresWidth = this.getIntegerFromLTIRequestMap(this.ltiLaunchPresentation, "width");
        this.ltiPresReturnUrl = this.getStringFromLTIRequestMap(this.ltiLaunchPresentation, "return_url");
        this.ltiPresTarget = this.getStringFromLTIRequestMap(this.ltiLaunchPresentation, "document_target");
        this.ltiCustom = this.getMapFromLTIRequest(jws, "https://purl.imsglobal.org/spec/lti/claim/custom");
        this.ltiExtension = this.getMapFromLTIRequest(jws, "https://www.example.com/extension");
        this.ltiTargetLinkUrl = this.getStringFromLTIRequest(jws, "https://purl.imsglobal.org/spec/lti/claim/target_link_uri");
        HttpSession session = this.httpServletRequest.getSession();
        session.setAttribute("user_id", (Object)this.aud);
        session.setAttribute("context_id", (Object)this.ltiContextId);
        String normalizedRoleName = "http://purl.imsglobal.org/vocab/lis/v2/system/person#User";
        if (this.isRoleAdministrator()) {
            normalizedRoleName = "http://purl.imsglobal.org/vocab/lis/v2/institution/person#Administrator";
        } else if (this.isRoleInstructor()) {
            normalizedRoleName = "http://purl.imsglobal.org/vocab/lis/v2/institution/person#Instructor ";
        } else if (this.isRoleLearner()) {
            normalizedRoleName = "http://purl.imsglobal.org/vocab/lis/v2/institution/person#Learner";
        }
        session.setAttribute("user_role", (Object)normalizedRoleName);
        String isComplete = this.checkCompleteLTIRequest();
        this.complete = isComplete.equals("true");
        String isCorrect = this.checkCorrectLTIRequest();
        this.correct = isCorrect.equals("true");
        if (this.complete && this.correct) {
            return "true";
        }
        if (this.complete) {
            isComplete = "";
        } else if (this.correct) {
            isCorrect = "";
        }
        return isComplete + isCorrect;
    }

    private String getStringFromLTIRequest(Jws<Claims> jws, String stringToGet) {
        if (((Claims)jws.getBody()).containsKey((Object)stringToGet)) {
            return (String)((Claims)jws.getBody()).get(stringToGet, String.class);
        }
        return null;
    }

    private String getStringFromLTIRequestMap(Map map, String stringToGet) {
        if (map.containsKey(stringToGet)) {
            return map.get(stringToGet).toString();
        }
        return null;
    }

    private Integer getIntegerFromLTIRequestMap(Map map, String integerToGet) {
        if (map.containsKey(integerToGet)) {
            try {
                return Integer.valueOf(map.get(integerToGet).toString());
            }
            catch (Exception ex) {
                log.error("No integer when expected in: {0}. Returning null", (Object)integerToGet);
                return null;
            }
        }
        return null;
    }

    private List<String> getListFromLTIRequestMap(Map map, String listToGet) {
        if (map.containsKey(listToGet)) {
            try {
                return (List)map.get(listToGet);
            }
            catch (Exception ex) {
                log.error("No list when expected in: {0} Returning null", (Object)listToGet);
                return new ArrayList<String>();
            }
        }
        return new ArrayList<String>();
    }

    private Map<String, Object> getMapFromLTIRequest(Jws<Claims> jws, String mapToGet) {
        if (((Claims)jws.getBody()).containsKey((Object)mapToGet)) {
            try {
                return (Map)((Claims)jws.getBody()).get(mapToGet, Map.class);
            }
            catch (Exception ex) {
                log.error("No map integer when expected in: {0}. Returning null", (Object)mapToGet);
                return new HashMap<String, Object>();
            }
        }
        return new HashMap<String, Object>();
    }

    private List<String> getListFromLTIRequest(Jws<Claims> jws, String listToGet) {
        if (((Claims)jws.getBody()).containsKey((Object)listToGet)) {
            try {
                return (List)((Claims)jws.getBody()).get(listToGet, List.class);
            }
            catch (Exception ex) {
                log.error("No map integer when expected in: " + listToGet + ". Returning null");
                return new ArrayList<String>();
            }
        }
        return new ArrayList<String>();
    }

    public boolean checkCompleteLTIRequest(boolean objects) {
        return objects && this.key != null && this.context != null && this.link != null && this.user != null;
    }

    public String checkCompleteLTIRequest() {
        String completStr = "";
        if (StringUtils.isEmpty((CharSequence)this.ltiDeploymentId)) {
            completStr = completStr + " Lti Deployment Id is empty.\n ";
        }
        if (this.ltiResourceLink == null || this.ltiResourceLink.size() == 0) {
            completStr = completStr + " Lti Resource Link is empty.\n ";
        } else if (StringUtils.isEmpty((CharSequence)this.ltiLinkId)) {
            completStr = completStr + " Lti Resource Link ID is empty.\n ";
        }
        if (StringUtils.isEmpty((CharSequence)this.sub)) {
            completStr = completStr + " User (sub) is empty.\n ";
        }
        if (this.ltiRoles == null || ListUtils.isEmpty((List)this.ltiRoles)) {
            completStr = completStr + " Lti Roles is empty.\n ";
        }
        if (this.exp == null) {
            completStr = completStr + " Exp is empty or invalid.\n ";
        }
        if (this.iat == null) {
            completStr = completStr + " Iat is empty or invalid.\n ";
        }
        if (completStr.equals("")) {
            return "true";
        }
        return completStr;
    }

    private String checkCorrectLTIRequest() {
        String correctStr = "true";
        return correctStr;
    }

    public String checkNonce(Jws<Claims> jws) {
        String nonce = (String)((Claims)jws.getBody()).get("nonce", String.class);
        if (nonce == null) {
            return "Nonce = null.";
        }
        if (this.ltiDataService.getRepos().nonces.existsById((Object)nonce)) {
            this.ltiDataService.getRepos().nonces.deleteById((Object)nonce);
            return "true";
        }
        return "Unknown or already used nounce.";
    }

    public static String isLTI3Request(Jws<Claims> jws) {
        String ltiMessageType;
        String errorDetail = "";
        boolean valid = false;
        String ltiVersion = (String)((Claims)jws.getBody()).get("https://purl.imsglobal.org/spec/lti/claim/version", String.class);
        if (ltiVersion == null) {
            errorDetail = "LTI Version = null. ";
        }
        if ((ltiMessageType = (String)((Claims)jws.getBody()).get("https://purl.imsglobal.org/spec/lti/claim/message_type", String.class)) == null) {
            errorDetail = errorDetail + "LTI Message Type = null. ";
        }
        if (ltiMessageType != null && ltiVersion != null) {
            boolean goodLTIVersion;
            boolean goodMessageType = "LtiResourceLinkRequest".equals(ltiMessageType);
            if (!goodMessageType) {
                errorDetail = "LTI Message Type is not right: " + ltiMessageType + ". ";
            }
            if (!(goodLTIVersion = "1.3.0".equals(ltiVersion))) {
                errorDetail = errorDetail + "LTI Version is not right: " + ltiVersion;
            }
            boolean bl = valid = goodMessageType && goodLTIVersion;
        }
        if (valid) {
            return "true";
        }
        return errorDetail;
    }

    public boolean isRoleAdministrator() {
        return this.ltiRoles != null && this.userRoleNumber >= 2;
    }

    public boolean isRoleInstructor() {
        return this.ltiRoles != null && this.userRoleNumber >= 1;
    }

    public boolean isRoleLearner() {
        return this.ltiRoles != null && this.ltiRoles.contains("http://purl.imsglobal.org/vocab/lis/v2/membership#Learner");
    }

    public int makeUserRoleNum(List<String> rawUserRoles) {
        int roleNum = 0;
        if (rawUserRoles != null) {
            if (rawUserRoles.contains("http://purl.imsglobal.org/vocab/lis/v2/membership#Administrator")) {
                roleNum = 2;
            } else if (rawUserRoles.contains("http://purl.imsglobal.org/vocab/lis/v2/membership#Instructor")) {
                roleNum = 1;
            }
        }
        return roleNum;
    }

    public LtiContextEntity getContext() {
        return this.context;
    }

    public LtiLinkEntity getLink() {
        return this.link;
    }

    public LtiMembershipEntity getMembership() {
        return this.membership;
    }

    public LtiUserEntity getUser() {
        return this.user;
    }

    public LtiResultEntity getResult() {
        return this.result;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public int getLoadingUpdates() {
        return this.loadingUpdates;
    }

    public void setLoadingUpdates(int loadingUpdates) {
        this.loadingUpdates = loadingUpdates;
    }

    public String getLtiMessageType() {
        return this.ltiMessageType;
    }

    public String getLtiVersion() {
        return this.ltiVersion;
    }

    public String getLtiGivenName() {
        return this.ltiGivenName;
    }

    public String getLtiFamilyName() {
        return this.ltiFamilyName;
    }

    public String getLtiMiddleName() {
        return this.ltiMiddleName;
    }

    public String getLtiPicture() {
        return this.ltiPicture;
    }

    public String getLtiEmail() {
        return this.ltiEmail;
    }

    public void setLtiEmail(String ltiEmail) {
        this.ltiEmail = ltiEmail;
    }

    public String getLtiName() {
        return this.ltiName;
    }

    public void setLtiName(String ltiName) {
        this.ltiName = ltiName;
    }

    public List<String> getLtiRoles() {
        return this.ltiRoles;
    }

    public List<String> getLtiRoleScopeMentor() {
        return this.ltiRoleScopeMentor;
    }

    public Map<String, Object> getLtiResourceLink() {
        return this.ltiResourceLink;
    }

    public String getLtiLinkId() {
        return this.ltiLinkId;
    }

    public void setLtiLinkId(String ltiLinkId) {
        this.ltiLinkId = ltiLinkId;
    }

    public String getLtiLinkTitle() {
        return this.ltiLinkTitle;
    }

    public String getLtiLinkDescription() {
        return this.ltiLinkDescription;
    }

    public Map<String, Object> getLtiContext() {
        return this.ltiContext;
    }

    public String getLtiContextId() {
        return this.ltiContextId;
    }

    public void setLtiContextId(String ltiContextId) {
        this.ltiContextId = ltiContextId;
    }

    public String getLtiContextTitle() {
        return this.ltiContextTitle;
    }

    public String getLtiContextLabel() {
        return this.ltiContextLabel;
    }

    public List<String> getLtiContextType() {
        return this.ltiContextType;
    }

    public Map<String, Object> getLtiToolPlatform() {
        return this.ltiToolPlatform;
    }

    public String getLtiToolPlatformName() {
        return this.ltiToolPlatformName;
    }

    public String getLtiToolPlatformContactEmail() {
        return this.ltiToolPlatformContactEmail;
    }

    public String getLtiToolPlatformDesc() {
        return this.ltiToolPlatformDesc;
    }

    public String getLtiToolPlatformUrl() {
        return this.ltiToolPlatformUrl;
    }

    public String getLtiToolPlatformProduct() {
        return this.ltiToolPlatformProduct;
    }

    public String getLtiToolPlatformFamilyCode() {
        return this.ltiToolPlatformFamilyCode;
    }

    public String getLtiToolPlatformVersion() {
        return this.ltiToolPlatformVersion;
    }

    public Map<String, Object> getLtiEndpoint() {
        return this.ltiEndpoint;
    }

    public List<String> getLtiEndpointScope() {
        return this.ltiEndpointScope;
    }

    public String getLtiEndpointLineItems() {
        return this.ltiEndpointLineItems;
    }

    public Map<String, Object> getLtiNamesRoleService() {
        return this.ltiNamesRoleService;
    }

    public String getLtiNamesRoleServiceContextMembershipsUrl() {
        return this.ltiNamesRoleServiceContextMembershipsUrl;
    }

    public List<String> getLtiNamesRoleServiceVersions() {
        return this.ltiNamesRoleServiceVersions;
    }

    public Map<String, Object> getLtiCaliperEndpointService() {
        return this.ltiCaliperEndpointService;
    }

    public List<String> getLtiCaliperEndpointServiceScopes() {
        return this.ltiCaliperEndpointServiceScopes;
    }

    public String getLtiCaliperEndpointServiceUrl() {
        return this.ltiCaliperEndpointServiceUrl;
    }

    public String getLtiCaliperEndpointServiceSessionId() {
        return this.ltiCaliperEndpointServiceSessionId;
    }

    public String getIss() {
        return this.iss;
    }

    public String getAud() {
        return this.aud;
    }

    public Date getIat() {
        return this.iat;
    }

    public Date getExp() {
        return this.exp;
    }

    public String getSub() {
        return this.sub;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    public String getLti11LegacyUserId() {
        return this.lti11LegacyUserId;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getLocale() {
        return this.locale;
    }

    public Map<String, Object> getLtiLaunchPresentation() {
        return this.ltiLaunchPresentation;
    }

    public String getLtiPresTarget() {
        return this.ltiPresTarget;
    }

    public int getLtiPresWidth() {
        return this.ltiPresWidth;
    }

    public int getLtiPresHeight() {
        return this.ltiPresHeight;
    }

    public String getLtiPresReturnUrl() {
        return this.ltiPresReturnUrl;
    }

    public Locale getLtiPresLocale() {
        return this.ltiPresLocale;
    }

    public Map<String, Object> getLtiExtension() {
        return this.ltiExtension;
    }

    public Map<String, Object> getLtiCustom() {
        return this.ltiCustom;
    }

    public String getLtiTargetLinkUrl() {
        return this.ltiTargetLinkUrl;
    }

    public String getLtiDeploymentId() {
        return this.ltiDeploymentId;
    }

    public void setLtiDeploymentId(String ltiDeploymentId) {
        this.ltiDeploymentId = ltiDeploymentId;
    }

    public PlatformDeployment getKey() {
        return this.key;
    }

    public void setKey(PlatformDeployment key) {
        this.key = key;
    }

    public void setContext(LtiContextEntity context) {
        this.context = context;
    }

    public void setLink(LtiLinkEntity link) {
        this.link = link;
    }

    public void setMembership(LtiMembershipEntity membership) {
        this.membership = membership;
    }

    public void setUser(LtiUserEntity user) {
        this.user = user;
    }

    public void setResult(LtiResultEntity result) {
        this.result = result;
    }

    public int getUserRoleNumber() {
        return this.userRoleNumber;
    }

    public void setUserRoleNumber(int userRoleNumber) {
        this.userRoleNumber = userRoleNumber;
    }
}

