/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.model.lti;

import at.letto.lti.model.lti.BaseEntity;
import at.letto.lti.model.lti.LtiLinkEntity;
import at.letto.lti.model.lti.LtiMembershipEntity;
import at.letto.lti.model.lti.PlatformDeployment;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="lti_context")
public class LtiContextEntity
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="context_id", nullable=false, insertable=true, updatable=true)
    private long contextId;
    @Basic
    @Column(name="context_key", nullable=false, insertable=true, updatable=true, length=4096)
    private String contextKey;
    @Basic
    @Column(name="title", nullable=true, insertable=true, updatable=true, length=4096)
    private String title;
    @Lob
    @Column(name="json", nullable=true, insertable=true, updatable=true, length=65535)
    private String json;
    @Lob
    @Column(nullable=true, length=65535)
    private String settings;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="key_id", referencedColumnName="key_id", nullable=false)
    private PlatformDeployment platformDeployment;
    @OneToMany(mappedBy="context")
    private Set<LtiLinkEntity> links;
    @OneToMany(mappedBy="context")
    private Set<LtiMembershipEntity> memberships;

    public LtiContextEntity() {
    }

    public LtiContextEntity(String contextKey, PlatformDeployment platformDeployment, String title, String json) {
        if (!StringUtils.isNotBlank((CharSequence)contextKey)) {
            throw new AssertionError();
        }
        if (platformDeployment == null) {
            throw new AssertionError();
        }
        this.contextKey = contextKey;
        this.platformDeployment = platformDeployment;
        this.title = title;
        this.json = json;
    }

    public long getContextId() {
        return this.contextId;
    }

    public void setContextId(long contextId) {
        this.contextId = contextId;
    }

    public String getContextKey() {
        return this.contextKey;
    }

    public void setContextKey(String contextKey) {
        this.contextKey = contextKey;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public String getSettings() {
        return this.settings;
    }

    public void setSettings(String settings) {
        this.settings = settings;
    }

    public PlatformDeployment getPlatformDeployment() {
        return this.platformDeployment;
    }

    public void setPlatformDeployment(PlatformDeployment platformDeployment) {
        this.platformDeployment = platformDeployment;
    }

    public Set<LtiLinkEntity> getLinks() {
        return this.links;
    }

    public void setLinks(Set<LtiLinkEntity> links) {
        this.links = links;
    }

    public Set<LtiMembershipEntity> getMemberships() {
        return this.memberships;
    }

    public void setMemberships(Set<LtiMembershipEntity> memberships) {
        this.memberships = memberships;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LtiContextEntity that = (LtiContextEntity)o;
        if (this.contextId != that.contextId) {
            return false;
        }
        return this.contextKey != null ? this.contextKey.equals(that.contextKey) : that.contextKey == null;
    }

    public int hashCode() {
        int result = (int)this.contextId;
        result = 31 * result + (this.contextKey != null ? this.contextKey.hashCode() : 0);
        return result;
    }
}

