/*
 * Decompiled with CFR 0.152.
 */
package at.letto.lti.model.lti;

import at.letto.lti.model.lti.BaseEntity;
import at.letto.lti.model.lti.LtiContextEntity;
import at.letto.lti.model.lti.LtiResultEntity;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="lti_link")
public class LtiLinkEntity
extends BaseEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="link_id", nullable=false, insertable=true, updatable=true)
    private long linkId;
    @Basic
    @Column(name="link_key", nullable=false, insertable=true, updatable=true, length=4096)
    private String linkKey;
    @Basic
    @Column(name="title", nullable=true, insertable=true, updatable=true, length=4096)
    private String title;
    @Basic
    @Column(name="score_maximum")
    private Float scoreMaximum;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="context_id")
    private LtiContextEntity context;
    @OneToMany(mappedBy="link", fetch=FetchType.LAZY)
    private Set<LtiResultEntity> results;

    protected LtiLinkEntity() {
    }

    public LtiLinkEntity(String linkKey, LtiContextEntity context, String title, Float scoreMaximum) {
        if (!StringUtils.isNotBlank((CharSequence)linkKey)) {
            throw new AssertionError();
        }
        if (context == null) {
            throw new AssertionError();
        }
        this.linkKey = linkKey;
        this.context = context;
        this.title = title;
        this.scoreMaximum = scoreMaximum;
    }

    public long getLinkId() {
        return this.linkId;
    }

    public void setLinkId(long linkId) {
        this.linkId = linkId;
    }

    public String getLinkKey() {
        return this.linkKey;
    }

    public void setLinkKey(String linkKey) {
        this.linkKey = linkKey;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Float getScoreMaximum() {
        return this.scoreMaximum;
    }

    public void setScoreMaximum(Float scoreMaximum) {
        this.scoreMaximum = scoreMaximum;
    }

    public LtiContextEntity getContext() {
        return this.context;
    }

    public void setContext(LtiContextEntity context) {
        this.context = context;
    }

    public Set<LtiResultEntity> getResults() {
        return this.results;
    }

    public void setResults(Set<LtiResultEntity> results) {
        this.results = results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LtiLinkEntity that = (LtiLinkEntity)o;
        if (this.linkId != that.linkId) {
            return false;
        }
        return this.linkKey != null ? this.linkKey.equals(that.linkKey) : that.linkKey == null;
    }

    public int hashCode() {
        int result = (int)this.linkId;
        result = 31 * result + (this.linkKey != null ? this.linkKey.hashCode() : 0);
        return result;
    }
}

