/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.config;

import at.letto.setupservice.config.CrontabConfiguration;
import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.config.LoggingConfiguration;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.config.SetupConfiguration;
import at.letto.setupservice.config.StartupConfiguration;
import at.letto.setupservice.config.TomcatConfiguration;
import at.letto.setupservice.configFiles.LettoEnvFile;
import at.letto.setupservice.configFiles.SetupEnvFile;
import at.letto.setupservice.model.LettoSetupConfigFile;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.DownloadService;
import at.letto.setupservice.service.LettoService;
import at.letto.setupservice.service.SetupUpdateService;
import at.letto.setupservice.service.SetupUserDetailsService;
import at.letto.setupservice.service.UpdateService;
import at.letto.setupservice.service.WatchdogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

@Configuration
public class StartupConfiguration {
    private AnalyzeService analyzeService;
    private CmdService cmdService;
    private DockerConfiguration dockerConfiguration;
    private UpdateService updateService;
    private LettoService lettoService;
    private MicroServiceConfiguration microServiceConfiguration;
    private SetupUserDetailsService userDetailsService;
    private SetupConfiguration setupConfiguration;
    private DockerService dockerService;
    private DownloadService downloadService;
    private LoggingConfiguration loggingConfiguration;
    private TomcatConfiguration tomcatConfiguration;
    private SetupUpdateService setupUpdateService;
    private SetupUserDetailsService setupUserDetailsService;
    private CrontabConfiguration crontabConfiguration;

    public StartupConfiguration(AnalyzeService analyzeService, CmdService cmdService, DockerConfiguration dockerConfiguration, UpdateService updateService, LettoService lettoService, MicroServiceConfiguration microServiceConfiguration, SetupUserDetailsService userDetailsService, SetupConfiguration setupConfiguration, DockerService dockerService, DownloadService downloadService, LoggingConfiguration loggingConfiguration, TomcatConfiguration tomcatConfiguration, SetupUpdateService setupUpdateService, SetupUserDetailsService setupUserDetailsService, CrontabConfiguration crontabConfiguration) {
        this.analyzeService = analyzeService;
        this.cmdService = cmdService;
        this.dockerConfiguration = dockerConfiguration;
        this.updateService = updateService;
        this.lettoService = lettoService;
        this.microServiceConfiguration = microServiceConfiguration;
        this.userDetailsService = userDetailsService;
        this.setupConfiguration = setupConfiguration;
        this.dockerService = dockerService;
        this.downloadService = downloadService;
        this.loggingConfiguration = loggingConfiguration;
        this.tomcatConfiguration = tomcatConfiguration;
        this.setupUpdateService = setupUpdateService;
        this.setupUserDetailsService = setupUserDetailsService;
        this.crontabConfiguration = crontabConfiguration;
        Logger watchdogLogger = LoggerFactory.getLogger(WatchdogService.class);
        lettoService.setDockerService(dockerService);
        analyzeService.setSetupConfiguration(setupConfiguration);
        analyzeService.analyzebase();
        this.initializeKeys();
        if (analyzeService.isLinux()) {
            LettoSetupConfigFile.setLinux();
        } else if (analyzeService.isWindows()) {
            LettoSetupConfigFile.setWindows();
        } else if (analyzeService.isMac()) {
            LettoSetupConfigFile.setMac();
        }
        cmdService.init(analyzeService.isWindows(), analyzeService.getRootPath(), analyzeService.getCmdCharset());
        dockerService.updateUserPasswords();
        Thread t = new Thread((Runnable)new FinishStartup(this, null), "Startup finish");
        t.start();
    }

    public void initializeKeys() {
        try {
            SetupEnvFile setupEnv = this.dockerConfiguration.getSetupEnvFile();
            LettoEnvFile lettoEnv = this.dockerConfiguration.getLettoEnvFile();
            if (!(this.microServiceConfiguration.isSetupDocker() || this.setupUserDetailsService.getSetupAdminPassword() != null && this.setupUserDetailsService.getSetupAdminPassword().trim().length() != 0 && this.setupUserDetailsService.getSetupAdminPasswordEncrypted() != null && this.setupUserDetailsService.getSetupAdminPasswordEncrypted().trim().length() != 0 || this.setupUserDetailsService.getSetupLocalAdminPassword() == null || this.setupUserDetailsService.getSetupLocalAdminPassword().trim().length() <= 0)) {
                this.setupUserDetailsService.setSetupAdminPassword(this.setupUserDetailsService.getSetupLocalAdminPassword());
            }
            if (!this.microServiceConfiguration.getSetupEnvFile().exists()) {
                String ap = this.setupUserDetailsService.getSetupAdminPassword();
                if (ap == null || ap.trim().length() == 0) {
                    ap = "letto";
                }
                setupEnv.setAdminPassword(this.microServiceConfiguration.getUserAdminPassword());
                setupEnv.setAdminPasswordEncrypted(new BCryptPasswordEncoder().encode((CharSequence)ap));
                String lettoUID = this.microServiceConfiguration.getLettoUID();
                if (lettoUID == null || lettoUID.trim().length() == 0) {
                    lettoUID = System.getenv("LETTO_UID");
                }
                if (lettoUID == null || lettoUID.trim().length() == 0) {
                    lettoUID = "1000";
                }
                setupEnv.setLettoUID(lettoUID);
                setupEnv.setRunAsRoot(true);
                setupEnv.setLettoRestkey("");
                setupEnv.setLettoPath(this.microServiceConfiguration.getLettoPath());
                setupEnv.setHttpsPort("3096");
                setupEnv.setPathSeperator(this.microServiceConfiguration.getPathSeperator());
                setupEnv.setSetupCompose(this.microServiceConfiguration.getSetupComposePath());
                setupEnv.setLettoCompose(this.microServiceConfiguration.getLettoComposePath());
                setupEnv.setHostBS(this.microServiceConfiguration.getHostBetriebssystem());
                setupEnv.setDebug(false);
                setupEnv.setStable(false);
                setupEnv.writeFile();
            }
            this.dockerService.checkDockerStatus();
        }
        catch (Exception ex) {
            System.out.println("error in key initialize");
        }
    }

    static /* synthetic */ MicroServiceConfiguration access$100(StartupConfiguration x0) {
        return x0.microServiceConfiguration;
    }

    static /* synthetic */ SetupConfiguration access$200(StartupConfiguration x0) {
        return x0.setupConfiguration;
    }

    static /* synthetic */ AnalyzeService access$300(StartupConfiguration x0) {
        return x0.analyzeService;
    }

    static /* synthetic */ DockerService access$400(StartupConfiguration x0) {
        return x0.dockerService;
    }

    static /* synthetic */ SetupUpdateService access$500(StartupConfiguration x0) {
        return x0.setupUpdateService;
    }
}

