/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.configFiles;

import at.letto.setupservice.config.DockerConfiguration;
import at.letto.setupservice.configFiles.EnvFile;
import at.letto.setupservice.configFiles.SchuleEnv;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LettoEnvFile
extends EnvFile {
    public static final String FILENAME = "/letto_compose/.env";

    public LettoEnvFile(File file) {
        super(file);
    }

    public LettoEnvFile(String filename) {
        this(new File(filename));
    }

    public LettoEnvFile() {
        this(FILENAME);
    }

    public String[][] template() {
        String ps = "/";
        String hbs = "LINUX";
        String lp = "/opt/letto";
        String uid = "1000";
        if (DockerConfiguration.staticSetupEnvFile != null) {
            if (DockerConfiguration.staticSetupEnvFile.getPathSeperator() != null && DockerConfiguration.staticSetupEnvFile.getPathSeperator().length() > 0) {
                ps = DockerConfiguration.staticSetupEnvFile.getPathSeperator();
            }
            if (DockerConfiguration.staticSetupEnvFile.getHostBS() != null && DockerConfiguration.staticSetupEnvFile.getHostBS().length() > 0) {
                hbs = DockerConfiguration.staticSetupEnvFile.getHostBS();
            }
            if (DockerConfiguration.staticSetupEnvFile.getLettoPath() != null && DockerConfiguration.staticSetupEnvFile.getLettoPath().length() > 0) {
                lp = DockerConfiguration.staticSetupEnvFile.getLettoPath();
            }
            if (DockerConfiguration.staticSetupEnvFile.getLettoUID() != null && DockerConfiguration.staticSetupEnvFile.getLettoUID().length() > 0) {
                uid = DockerConfiguration.staticSetupEnvFile.getLettoUID();
            }
        }
        String[][] ret = new String[][]{{"LETTO_UID", uid, "uid from user 'letto' on the docker-host system"}, {"RUN_AS_ROOT", "true", "start setup-service as user root inside the docker container"}, {"LETTO_RESTKEY", "", "Restkey from the server to connect to the license-server"}, {"SERVICE_USER_PASSWORD", "wqEycXhK65pPL3", "password from user 'user' for service-to-service connection"}, {"SERVICE_GAST_PASSWORD", "Kor5Tzu4tZ34P6", "password from user 'gast' for service-to-service connection"}, {"SERVICE_ADMIN_PASSWORD", "Uzp34kGhTeBdK", "password from user 'admin' for service-to-service connection"}, {"SERVER_NAME", "localhost", ""}, {"SERVER_INFO", "Serverbetreiber Information", ""}, {"DOMAIN_ALTERNATIV", "", ""}, {"EMAIL", "", ""}, {"REDIRECT", "public", ""}, {"LETTO_PATH", lp, ""}, {"SETUP_COMPOSE", lp + ps + "docker" + ps + "compose" + ps + "setup", ""}, {"LETTO_COMPOSE", lp + ps + "docker" + ps + "compose" + ps + "letto", ""}, {"DOCKER_BASE", lp + ps + "docker", ""}, {"CERT_CREATED", "false", ""}, {"MYSQL_ROOT_PASSWORD", "", ""}, {"MYSQL_PORT", "13306", ""}, {"MYSQL_HOST", "letto-mysql", ""}, {"VOLUME_DATABASE", lp + ps + "docker" + ps + "storage" + ps + "database", ""}, {"MYSQL_DUMP_PATH", lp + ps + "docker" + ps + "storage" + ps + "database-dump", ""}, {"MYSQL_BACKUP_PATH", lp + ps + "docker" + ps + "storage" + ps + "database-backup", ""}, {"PHP_MYADMIN_HOST", "phpmyadmin", ""}, {"MYSQL_LTI_HOST", "letto-mysql.nw-letto:3306", ""}, {"MYSQL_LTI_DATABASE", "lettolti", ""}, {"MYSQL_LTI_USER", "lettolti", ""}, {"MYSQL_LTI_PASSWORD", "", ""}, {"PROXY_PATH", lp + ps + "docker" + ps + "proxy", ""}, {"VOLUME_PUBLIC", lp + ps + "docker" + ps + "public", ""}, {"VOLUME_IMAGES", lp + ps + "docker" + ps + "storage" + ps + "images", ""}, {"VOLUME_PLUGINS", lp + ps + "docker" + ps + "storage" + ps + "plugins", ""}, {"VOLUME_PHOTOS", lp + ps + "docker" + ps + "storage" + ps + "photos", ""}, {"VOLUME_PROJEKTE", lp + ps + "docker" + ps + "storage" + ps + "projekte", ""}, {"VOLUME_PRINT", lp + ps + "docker" + ps + "storage" + ps + "print", ""}, {"VOLUME_EXPORT", lp + ps + "docker" + ps + "storage" + ps + "export", ""}, {"VOLUME_LOG", lp + ps + "docker" + ps + "storage" + ps + "log", ""}, {"LETTO_LTI_URI", "http://letto-lti.nw-letto:8090", ""}, {"LETTO_IMAGE_URI", "http://letto-image.nw-letto:8091", ""}, {"LETTO_MATH_URI", "http://letto-math.nw-letto:8092", ""}, {"LETTO_DEMO_URI", "http://letto-demo.nw-letto:8093", ""}, {"LETTO_MAIL_URI", "http://letto-mail.nw-letto:8094", ""}, {"LETTO_LOGIN_URI", "http://letto-login.nw-letto:8095", ""}, {"LETTO_SETUP_URI", "http://letto-setup.nw-letto:8096", ""}, {"LETTO_PRINT_URI", "http://letto-print.nw-letto:8098", ""}, {"LETTO_EXPORT_URI", "http://letto-export.nw-letto:8099", ""}, {"LETTO_BEURTEILUNG_URI", "http://letto-beurteilung.nw-letto:8100", ""}, {"LETTO_TEST_URI", "http://letto-test.nw-letto:8101", ""}, {"LETTO_QUESTION_URI", "http://letto-question.nw-letto:8102", ""}, {"LETTO_PLUGIN_URI", "http://letto-plugin.nw-letto:8200", ""}, {"LETTO_PLUGINSOURCECODE_URI", "http://letto-pluginsourcecode.nw-letto:8204", ""}, {"LETTO_LETTOEDIT_URI", "http://letto-lettoedit.nw-letto:8310", ""}, {"LETTO_LEHRPLAN_URI", "http://letto-lehrplan.nw-letto:8700", ""}, {"JWT_SECRET", "", "Secret f\u00fcr den JWT-Token am Server"}, {"SERVER_SECRET", "", "Secret f\u00fcr den JWT-Token am Server"}, {"LETTO_LOCAL_PRIVATE_KEY", "", "Private Key des Servers"}, {"LETTO_LOCAL_PUBLIC_KEY", "", "Public Key des Servers"}, {"LETTO_SCHULEN", "", ""}};
        return ret;
    }

    public String getLettoUID() {
        return this.getVar("LETTO_UID");
    }

    public void setLettoUID(String lettoUID) {
        this.setVar("LETTO_UID", lettoUID);
    }

    public Boolean getRunAsRoot() {
        return this.getVarBoolean("RUN_AS_ROOT");
    }

    public void setRunAsRoot(boolean runAsRoot) {
        this.setVar("RUN_AS_ROOT", Boolean.valueOf(runAsRoot));
    }

    public String getLettoRestkey() {
        return this.getVar("LETTO_RESTKEY");
    }

    public void setLettoRestkey(String lettoRestkey) {
        this.setVar("LETTO_RESTKEY", lettoRestkey);
    }

    public String getServiceUserPassword() {
        return this.getVar("SERVICE_USER_PASSWORD");
    }

    public void setServiceUserPassword(String serviceUserPassword) {
        this.setVar("SERVICE_USER_PASSWORD", serviceUserPassword);
    }

    public String getServiceGastPassword() {
        return this.getVar("SERVICE_GAST_PASSWORD");
    }

    public void setServiceGastPassword(String serviceGastPassword) {
        this.setVar("SERVICE_GAST_PASSWORD", serviceGastPassword);
    }

    public String getServiceAdminPassword() {
        return this.getVar("SERVICE_ADMIN_PASSWORD");
    }

    public void setServiceAdminPassword(String serviceAdminPassword) {
        this.setVar("SERVICE_ADMIN_PASSWORD", serviceAdminPassword);
    }

    public String getServerName() {
        return this.getVar("SERVER_NAME");
    }

    public void setServerName(String serverName) {
        this.setVar("SERVER_NAME", serverName);
    }

    public String getServerInfo() {
        return this.getVar("SERVER_INFO");
    }

    public void setServerInfo(String serverInfo) {
        this.setVar("SERVER_INFO", serverInfo);
    }

    public String getDomainAlternativ() {
        return this.getVar("DOMAIN_ALTERNATIV");
    }

    public void setDomainAlternativ(String domainAlternativ) {
        this.setVar("DOMAIN_ALTERNATIV", domainAlternativ);
    }

    public String getEmail() {
        return this.getVar("EMAIL");
    }

    public void setEmail(String email) {
        this.setVar("EMAIL", email);
    }

    public String getRedirect() {
        return this.getVar("REDIRECT");
    }

    public void setRedirect(String redirect) {
        this.setVar("REDIRECT", redirect);
    }

    public String getDockerBase() {
        return this.getVar("DOCKER_BASE");
    }

    public void setDockerBase(String dockerBase) {
        this.setVar("DOCKER_BASE", dockerBase);
    }

    public String getMysqlRootPassword() {
        return this.getVar("MYSQL_ROOT_PASSWORD");
    }

    public void setMysqlRootPassword(String mysqlRootPassword) {
        this.setVar("MYSQL_ROOT_PASSWORD", mysqlRootPassword);
    }

    public String getMysqlPort() {
        return this.getVar("MYSQL_PORT");
    }

    public void setMysqlPort(String mysqlPort) {
        this.setVar("MYSQL_PORT", mysqlPort);
    }

    public String getMysqlHost() {
        return this.getVar("MYSQL_HOST");
    }

    public void setMysqlHost(String mysqlHost) {
        this.setVar("MYSQL_HOST", mysqlHost);
    }

    public String getVolumeDatabase() {
        return this.getVar("VOLUME_DATABASE");
    }

    public void setVolumeDatabase(String volumeDatabase) {
        this.setVar("VOLUME_DATABASE", volumeDatabase);
    }

    public String getMysqlDumpPath() {
        return this.getVar("MYSQL_DUMP_PATH");
    }

    public void setMysqlDumpPath(String mysqlDumpPath) {
        this.setVar("MYSQL_DUMP_PATH", mysqlDumpPath);
    }

    public String getMysqlBackupPath() {
        return this.getVar("MYSQL_BACKUP_PATH");
    }

    public void setMysqlBackupPath(String mysqlBackupPath) {
        this.setVar("MYSQL_BACKUP_PATH", mysqlBackupPath);
    }

    public String getPhpMyadminHost() {
        return this.getVar("PHP_MYADMIN_HOST");
    }

    public void setPhpMyadminHost(String phpMyadminHost) {
        this.setVar("PHP_MYADMIN_HOST", phpMyadminHost);
    }

    public String getMysqlLtiHost() {
        return this.getVar("MYSQL_LTI_HOST");
    }

    public void setMysqlLtiHost(String mysqlLtiHost) {
        this.setVar("MYSQL_LTI_HOST", mysqlLtiHost);
    }

    public String getMysqlLtiDatabase() {
        return this.getVar("MYSQL_LTI_DATABASE");
    }

    public void setMysqlLtiDatabase(String mysqlLtiDatabase) {
        this.setVar("MYSQL_LTI_DATABASE", mysqlLtiDatabase);
    }

    public String getMysqlLtiUser() {
        return this.getVar("MYSQL_LTI_USER");
    }

    public void setMysqlLtiUser(String mysqlLtiUser) {
        this.setVar("MYSQL_LTI_USER", mysqlLtiUser);
    }

    public String getMysqlLtiPassword() {
        return this.getVar("MYSQL_LTI_PASSWORD");
    }

    public void setMysqlLtiPassword(String mysqlLtiPassword) {
        this.setVar("MYSQL_LTI_PASSWORD", mysqlLtiPassword);
    }

    public boolean isCertCreated() {
        return this.getVarBoolean("CERT_CREATED") == true;
    }

    public void setCertCreated(boolean certCreated) {
        this.setVar("CERT_CREATED", certCreated ? "true" : "false");
    }

    public String getProxyPath() {
        return this.getVar("PROXY_PATH");
    }

    public void setProxyPath(String proxyPath) {
        this.setVar("PROXY_PATH", proxyPath);
    }

    public String getVolumePublic() {
        return this.getVar("VOLUME_PUBLIC");
    }

    public void setVolumePublic(String VolumePublic) {
        this.setVar("VOLUME_PUBLIC", VolumePublic);
    }

    public String getVolumeImages() {
        return this.getVar("VOLUME_IMAGES");
    }

    public void setVolumeImages(String volumeImages) {
        this.setVar("VOLUME_IMAGES", volumeImages);
    }

    public String getVolumePlugins() {
        return this.getVar("VOLUME_PLUGINS");
    }

    public void setVolumePlugins(String volumePlugins) {
        this.setVar("VOLUME_PLUGINS", volumePlugins);
    }

    public String getVolumePhotos() {
        return this.getVar("VOLUME_PHOTOS");
    }

    public void setVolumePhotos(String volumePhotos) {
        this.setVar("VOLUME_PHOTOS", volumePhotos);
    }

    public String getVolumeProjekte() {
        return this.getVar("VOLUME_PROJEKTE");
    }

    public void setVolumeProjekte(String volumeProjekte) {
        this.setVar("VOLUME_PROJEKTE", volumeProjekte);
    }

    public String getVolumePrint() {
        return this.getVar("VOLUME_PRINT");
    }

    public void setVolumePrint(String volumePrint) {
        this.setVar("VOLUME_PRINT", volumePrint);
    }

    public String getVolumeExport() {
        return this.getVar("VOLUME_EXPORT");
    }

    public void setVolumeExport(String volumeExport) {
        this.setVar("VOLUME_EXPORT", volumeExport);
    }

    public String getVolumeLog() {
        return this.getVar("VOLUME_LOG");
    }

    public void setVolumeLog(String volumeLog) {
        this.setVar("VOLUME_LOG", volumeLog);
    }

    public String getLettoSchulen() {
        return this.getVar("LETTO_SCHULEN");
    }

    public void setLettoSchulen(String lettoSchulen) {
        this.setVar("LETTO_SCHULEN", lettoSchulen);
    }

    public String getLettoLtiUri() {
        return this.getVar("LETTO_LTI_URI");
    }

    public void setLettoLtiUri(String lettoLtiUri) {
        this.setVar("LETTO_LTI_URI", lettoLtiUri);
    }

    public String getLettoImageUri() {
        return this.getVar("LETTO_IMAGE_URI");
    }

    public void setLettoImageUri(String lettoImageUri) {
        this.setVar("LETTO_IMAGE_URI", lettoImageUri);
    }

    public String getLettoMathUri() {
        return this.getVar("LETTO_MATH_URI");
    }

    public void setLettoMathUri(String lettoMathUri) {
        this.setVar("LETTO_MATH_URI", lettoMathUri);
    }

    public String getLettoDemoUri() {
        return this.getVar("LETTO_DEMO_URI");
    }

    public void setLettoDemoUri(String lettoDemoUri) {
        this.setVar("LETTO_MATH_URI", lettoDemoUri);
    }

    public String getLettoMailUri() {
        return this.getVar("LETTO_MAIL_URI");
    }

    public void setLettoMailUri(String lettoMailUri) {
        this.setVar("LETTO_MAIL_URI", lettoMailUri);
    }

    public String getLettoLoginUri() {
        return this.getVar("LETTO_LOGIN_URI");
    }

    public void setLettoLoginUri(String uri) {
        this.setVar("LETTO_LOGIN_URI", uri);
    }

    public String getLettoSETUPUri() {
        return this.getVar("LETTO_SETUP_URI");
    }

    public void setLettoSETUPUri(String lettoSETUPuri) {
        this.setVar("LETTO_SETUP_URI", lettoSETUPuri);
    }

    public String getLettoPRINTUri() {
        return this.getVar("LETTO_PRINT_URI");
    }

    public void setLettoPRINTUri(String lettoPRINTuri) {
        this.setVar("LETTO_PRINT_URI", lettoPRINTuri);
    }

    public String getLettoEXPORTUri() {
        return this.getVar("LETTO_EXPORT_URI");
    }

    public void setLettoEXPORTUri(String lettoEXPORTuri) {
        this.setVar("LETTO_EXPORT_URI", lettoEXPORTuri);
    }

    public String getLettoBEURTEILUNGUri() {
        return this.getVar("LETTO_BEURTEILUNG_URI");
    }

    public void setLettoBEURTEILUNGUri(String lettoBEURTEILUNGuri) {
        this.setVar("LETTO_BEURTEILUNG_URI", lettoBEURTEILUNGuri);
    }

    public String getLettoTESTUri() {
        return this.getVar("LETTO_TEST_URI");
    }

    public void setLettoTESTUri(String lettoTESTuri) {
        this.setVar("LETTO_TEST_URI", lettoTESTuri);
    }

    public String getLettoQUESTIONUri() {
        return this.getVar("LETTO_QUESTION_URI");
    }

    public void setLettoQUESTIONUri(String lettoQUESTIONuri) {
        this.setVar("LETTO_QUESTION_URI", lettoQUESTIONuri);
    }

    public String getLettoPLUGINUri() {
        return this.getVar("LETTO_PLUGIN_URI");
    }

    public void setLettoPLUGINUri(String lettoPLUGINuri) {
        this.setVar("LETTO_PLUGIN_URI", lettoPLUGINuri);
    }

    public String getLettoPLUGINSOURCECODEUri() {
        return this.getVar("LETTO_PLUGINSOURCECODE_URI");
    }

    public void setLettoPLUGINSOURCECODEUri(String lettoPLUGINSOURCECODEuri) {
        this.setVar("LETTO_PLUGINSOURCECODE_URI", lettoPLUGINSOURCECODEuri);
    }

    public String getLettoLETTOEDITUri() {
        return this.getVar("LETTO_LETTOEDIT_URI");
    }

    public void setLettoLETTOEDITUri(String lettoLETTOEDITuri) {
        this.setVar("LETTO_LETTOEDIT_URI", lettoLETTOEDITuri);
    }

    public String getLettoLEHRPLANUri() {
        return this.getVar("LETTO_LEHRPLAN_URI");
    }

    public void setLettoLEHRPLANUri(String lettoLEHRPLANuri) {
        this.setVar("LETTO_LEHRPLAN_URI", lettoLEHRPLANuri);
    }

    public String getJwtSecret() {
        return this.getVar("JWT_SECRET") != null ? this.getVar("JWT_SECRET").trim() : "";
    }

    public void setJwtSecret(String JwtSecret) {
        this.setVar("JWT_SECRET", JwtSecret);
    }

    public String getServerSecret() {
        return this.getVar("SERVER_SECRET") != null ? this.getVar("SERVER_SECRET").trim() : "";
    }

    public void setServerSecret(String ServerSecret) {
        this.setVar("SERVER_SECRET", ServerSecret);
    }

    public String getLettoPrivateKey() {
        return this.getVar("LETTO_LOCAL_PRIVATE_KEY") != null ? this.getVar("LETTO_LOCAL_PRIVATE_KEY").trim() : "";
    }

    public void setLettoPrivateKey(String LettoPrivateKey) {
        this.setVar("LETTO_LOCAL_PRIVATE_KEY", LettoPrivateKey);
    }

    public String getLettoPublicKey() {
        return this.getVar("LETTO_LOCAL_PUBLIC_KEY") != null ? this.getVar("LETTO_LOCAL_PUBLIC_KEY").trim() : "";
    }

    public void setLettoPublicKey(String LettoPublicKey) {
        this.setVar("LETTO_LOCAL_PUBLIC_KEY", LettoPublicKey);
    }

    public String getLettoLicenseServer() {
        return this.getVar("LETTO_LICENSE_SERVER") != null ? this.getVar("LETTO_LICENSE_SERVER").trim() : "";
    }

    public void setLettoLicenseServer(String LettoLicenseServer) {
        this.setVar("LETTO_LICENSE_SERVER", LettoLicenseServer);
    }

    public Vector<SchuleEnv> getSchulen() {
        HashMap<Integer, SchuleEnv> schulen = new HashMap<Integer, SchuleEnv>();
        Vector<SchuleEnv> schulelist = new Vector<SchuleEnv>();
        Pattern p = Pattern.compile("^\\s*LETTO_(\\d+)_(.+)$");
        block42: for (EnvFile.EnvVar var : this.varlist) {
            Matcher m = p.matcher(var.name);
            if (!m.find()) continue;
            int envID = Integer.parseInt(m.group(1));
            String bez = m.group(2);
            SchuleEnv schule = null;
            if (schulen.containsKey(envID)) {
                schule = (SchuleEnv)schulen.get(envID);
            } else {
                schule = new SchuleEnv(envID);
                schulen.put(envID, schule);
                schulelist.add(schule);
            }
            switch (bez) {
                case "SCHOOL": {
                    schule.school = var.wert;
                    continue block42;
                }
                case "MYSQL_HOST": {
                    schule.mysqlHost = var.wert;
                    continue block42;
                }
                case "MYSQL_DATABASE": {
                    schule.mysqlDatabase = var.wert.trim();
                    continue block42;
                }
                case "MYSQL_USER": {
                    schule.mysqlUser = var.wert.trim();
                    continue block42;
                }
                case "MYSQL_PASSWORD": {
                    schule.mysqlPassword = var.wert.trim();
                    continue block42;
                }
                case "MEMORY": {
                    schule.memory = var.wert;
                    continue block42;
                }
                case "JAVA_OPTS_LETTO": {
                    schule.javaOptsLetto = var.wert.trim();
                    continue block42;
                }
                case "JAVA_OPTS_DATA": {
                    schule.javaOptsData = var.wert.trim();
                    continue block42;
                }
                case "LICENCE": {
                    schule.licence = var.wert;
                    continue block42;
                }
                case "LICENCE_NO_UPDATE": {
                    schule.licenceNoUpdate = var.getWertBoolean();
                    continue block42;
                }
                case "ID_SCHULE_LIZENZ": {
                    schule.idSchuleLizenz = var.getWertInt();
                    continue block42;
                }
                case "ID_SCHULE_DATA": {
                    schule.idSchuleData = var.getWertInt();
                    continue block42;
                }
                case "SCHULNAME": {
                    schule.schulname = var.wert;
                    continue block42;
                }
                case "DATA_URI": {
                    schule.dataURI = var.wert;
                    continue block42;
                }
                case "DATA_USER": {
                    schule.dataUser = var.wert;
                    continue block42;
                }
                case "DATA_PASSWORD": {
                    schule.dataPassword = var.wert;
                    continue block42;
                }
                case "LETTO_URI": {
                    schule.lettoURI = var.wert;
                    continue block42;
                }
                case "LOGIN_URI_EXTERN": {
                    schule.loginURIextern = var.wert;
                    continue block42;
                }
                case "LETTO_URI_EXTERN": {
                    schule.lettoURIextern = var.wert;
                    continue block42;
                }
            }
            System.out.println(var.name + " in env-Datei " + this.file.getAbsolutePath() + " nicht bekannt!");
        }
        return schulelist;
    }

    public void setSchulen(Vector<SchuleEnv> schulelist) {
        Collections.sort(schulelist);
        this.removeSchulen();
        String ss = "";
        for (SchuleEnv schule : schulelist) {
            this.setSchule(schule);
            if (schule.school.trim().length() <= 0) continue;
            ss = ss + schule.school.trim() + " ";
        }
        ss = ss.trim();
        this.setVar("LETTO_SCHULEN", ss);
    }

    private void removeSchulen() {
        HashMap schulen = new HashMap();
        Vector schulelist = new Vector();
        Pattern p = Pattern.compile("^\\s*LETTO_(\\d+)_(.+)$");
        for (int i = 0; i < this.varlist.size(); ++i) {
            Matcher m = p.matcher(((EnvFile.EnvVar)this.varlist.get((int)i)).name);
            if (!m.find()) continue;
            EnvFile.EnvVar envVar = (EnvFile.EnvVar)this.varlist.get(i);
            this.varlist.remove(envVar);
            this.vars.remove(envVar);
            --i;
        }
    }

    private void setSchule(SchuleEnv schule) {
        this.setVar("LETTO_" + schule.envID + "_SCHOOL", schule.school, "school", "");
        this.setVar("LETTO_" + schule.envID + "_MYSQL_HOST", schule.mysqlHost, "letto-mysql.nw-letto:3306", "");
        this.setVar("LETTO_" + schule.envID + "_MYSQL_DATABASE", schule.mysqlDatabase, "letto", "");
        this.setVar("LETTO_" + schule.envID + "_MYSQL_USER", schule.mysqlUser, "letto", "");
        this.setVar("LETTO_" + schule.envID + "_MYSQL_PASSWORD", schule.mysqlPassword, "changeme", "");
        this.setVar("LETTO_" + schule.envID + "_MEMORY", schule.memory, "500M", "");
        this.setVar("LETTO_" + schule.envID + "_JAVA_OPTS_LETTO", schule.javaOptsLetto, "-Xms500m -Xmx2G", "");
        this.setVar("LETTO_" + schule.envID + "_JAVA_OPTS_DATA", schule.javaOptsData, "-Xms200m -Xmx500m", "");
        this.setVar("LETTO_" + schule.envID + "_LICENCE", schule.licence, "", "");
        if (schule.licenceNoUpdate) {
            this.setVar("LETTO_" + schule.envID + "_LICENCE_NO_UPDATE", "true", "false", "");
        }
        this.setVar("LETTO_" + schule.envID + "_ID_SCHULE_LIZENZ", "" + schule.idSchuleLizenz, "0", "");
        this.setVar("LETTO_" + schule.envID + "_ID_SCHULE_DATA", "" + schule.idSchuleData, "0", "");
        this.setVar("LETTO_" + schule.envID + "_SCHULNAME", schule.schulname, "", "");
        this.setVar("LETTO_" + schule.envID + "_DATA_URI", schule.dataURI, "http://letto-data-school.nw-letto:8300", "");
        this.setVar("LETTO_" + schule.envID + "_DATA_USER", schule.dataUser, "user", "");
        this.setVar("LETTO_" + schule.envID + "_DATA_PASSWORD", schule.dataPassword, "wqEycXhK65pPL3", "");
        this.setVar("LETTO_" + schule.envID + "_LETTO_URI", schule.lettoURI, "http://letto-server-school.nw-letto:8080", "");
        this.setVar("LETTO_" + schule.envID + "_LOGIN_URI_EXTERN", schule.loginURIextern, "https://localhost/login", "");
        this.setVar("LETTO_" + schule.envID + "_LETTO_URI_EXTERN", schule.lettoURIextern, "https://localhost/lettoschool", "");
    }

    public SchuleEnv getSchule(String school) {
        Vector schulen = this.getSchulen();
        for (SchuleEnv schule : schulen) {
            if (!schule.school.equals(school)) continue;
            return schule;
        }
        return null;
    }

    public SchuleEnv getSchule(int envId) {
        Vector schulen = this.getSchulen();
        for (SchuleEnv schule : schulen) {
            if (schule.envID != envId) continue;
            return schule;
        }
        return null;
    }
}

