/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setupservice.controller.CommandController;
import at.letto.setupservice.controller.ExplorerController;
import at.letto.setupservice.model.BackupModel;
import at.letto.setupservice.model.DownloadFile;
import at.letto.setupservice.service.BackupService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.DownloadService;
import at.letto.setupservice.service.UploadService;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class BackupController {
    @Autowired
    private DockerService dockerService;
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private BackupService backupService;
    @Autowired
    private CommandController commandController;
    @Autowired
    private ExplorerController explorerController;
    @Autowired
    private UploadService uploadService;
    private BackupModel backupModel = null;

    @RequestMapping(value={"/config/session/admin/backup"})
    public String backupDocker(@ModelAttribute BackupModel backupModel, HttpServletRequest request, Model model) {
        return this.backupLocal(backupModel, request, model);
    }

    @RequestMapping(value={"/setup/session/admin/backup"})
    public String backupLocal(@ModelAttribute BackupModel backupModel, HttpServletRequest request, Model model) {
        model.addAttribute("dockerService", (Object)this.dockerService);
        model.addAttribute("backupService", (Object)this.backupService);
        model.addAttribute("action", (Object)this.dockerService.backupEP());
        model.addAttribute("actionupload", (Object)this.dockerService.backupUploadEP());
        String msg = "";
        if (backupModel.getUserAction() == null) {
            backupModel = this.backupService.loadBackupModel();
        } else {
            String button = backupModel.getUserAction();
            if (button.contains(",")) {
                button = button.split(",")[0];
            }
            switch (button) {
                case "refresh": {
                    backupModel = this.backupService.loadBackupModel();
                    break;
                }
                case "ok": {
                    this.backupService.saveBackupModel(backupModel);
                    return "redirect:" + this.dockerService.welcomeEP();
                }
                case "cancel": {
                    return "redirect:" + this.dockerService.welcomeEP();
                }
                case "startbackup": {
                    this.backupService.saveBackupModel(backupModel);
                    CmdThread cmdThread = this.backupService.backup(backupModel);
                    if (cmdThread != null) {
                        return this.commandController.getCmdOutputTemplate(model, cmdThread);
                    }
                    msg = "thread konnte nicht gestartet werden!";
                    break;
                }
                default: {
                    Matcher m = Pattern.compile("^dump-([a-zA-Z0-9]+)-(.*)$").matcher(button);
                    if (m.find()) {
                        String command = m.group(1);
                        String filename = m.group(2);
                        switch (command) {
                            case "download": {
                                File f = new File(this.dockerService.getDatabaseDumpDirectoryPath() + "/" + filename);
                                if (f.exists()) {
                                    DownloadFile df = this.downloadService.newDownloadGlobal(f);
                                    return "redirect:" + this.dockerService.globalDownloadEP() + "/" + df.getId();
                                }
                                msg = "File " + filename + " not found!";
                                break;
                            }
                            case "delete": {
                                File f = new File(this.dockerService.getDatabaseDumpDirectoryPath() + "/" + filename);
                                if (!f.exists()) break;
                                f.delete();
                            }
                        }
                    } else {
                        m = Pattern.compile("^backup-([a-zA-Z0-9]+)-(.*)$").matcher(button);
                        if (m.find()) {
                            String command = m.group(1);
                            String filename = m.group(2);
                            switch (command) {
                                case "open": {
                                    File f = new File(this.dockerService.getBackupDirectoryPath() + "/" + filename);
                                    if (f.exists()) {
                                        String template = this.explorerController.redirectExplorer(f, model);
                                        if (template == null || template.length() == 0) {
                                            msg = "Cannot open directory " + filename;
                                            break;
                                        }
                                        return template;
                                    }
                                    msg = "Directory " + filename + " not found!";
                                }
                            }
                        }
                    }
                    backupModel = this.backupService.loadBackupModel();
                }
            }
        }
        model.addAttribute("msg", (Object)msg);
        model.addAttribute("backupModel", (Object)backupModel);
        this.backupModel = backupModel;
        return "backup";
    }

    @PostMapping(value={"/config/session/admin/backupupload"})
    public String uploadFileDocker(HttpServletRequest request, Model model) {
        return this.uploadFile(request, model);
    }

    @PostMapping(value={"/setup/session/admin/backupupload"})
    public String uploadFileLocal(HttpServletRequest request, Model model) {
        return this.uploadFile(request, model);
    }

    public String uploadFile(HttpServletRequest request, Model model) {
        String msg = "";
        model.addAttribute("dockerService", (Object)this.dockerService);
        model.addAttribute("backupService", (Object)this.backupService);
        model.addAttribute("action", (Object)this.dockerService.backupEP());
        model.addAttribute("actionupload", (Object)this.dockerService.backupUploadEP());
        String uploadDirectory = this.dockerService.getDatabaseDumpDirectoryPath();
        try {
            File file = this.uploadService.handleUpload(request, uploadDirectory);
        }
        catch (Exception e) {
            msg = "cannot upload file!";
        }
        this.backupModel = this.backupService.loadBackupModel();
        model.addAttribute("msg", (Object)msg);
        model.addAttribute("backupModel", (Object)this.backupModel);
        return "backup";
    }
}

