/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller;

import at.letto.login.restclient.RestLoginService;
import at.letto.security.JwtAuthentication;
import at.letto.security.LettoToken;
import at.letto.setupservice.component.LettoSetupComponent;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.model.LoginModel;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.LettoService;
import at.letto.setupservice.service.SetupUserDetailsService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class LoginController {
    @Autowired
    private LettoSetupComponent lettoSetupComponent;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private SetupUserDetailsService setupUserDetailsService;
    @Autowired
    private LettoService lettoService;
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    private DockerService dockerService;

    @GetMapping(value={"/setup/open/tokenlogin"})
    public String tokenLoginLocal(@RequestParam String token) {
        try {
            String jwts = this.lettoService.getLoginService().jwtTokenFromTempToken(this.microServiceConfiguration.getServerSecret(), token);
            LettoToken lettoToken = new LettoToken(jwts, this.microServiceConfiguration.getJwtSecret());
            this.lettoSetupComponent.setLettoToken(lettoToken);
            SecurityContextHolder.getContext().setAuthentication((Authentication)new JwtAuthentication(lettoToken));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "redirect:/setup/session/welcome";
    }

    @GetMapping(value={"/config/open/tokenlogin"})
    public String tokenLogin(@RequestParam String token) {
        try {
            String jwts = this.lettoService.getLoginService().jwtTokenFromTempToken(this.microServiceConfiguration.getServerSecret(), token);
            LettoToken lettoToken = new LettoToken(jwts, this.microServiceConfiguration.getJwtSecret());
            this.lettoSetupComponent.setLettoToken(lettoToken);
            SecurityContextHolder.getContext().setAuthentication((Authentication)new JwtAuthentication(lettoToken));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "redirect:" + (this.microServiceConfiguration.isSetupDocker() ? "/config/session/welcome" : "/setup/session/welcome");
    }

    @RequestMapping(value={"/config/open/login"})
    public String login(@ModelAttribute LoginModel loginModel, Model model, HttpServletRequest request) {
        this.analyzeService.analyzeRequestUrl(request);
        return "redirect:/config/open/loginletto";
    }

    @RequestMapping(value={"/setup/open/login"})
    public String loginLocal(@ModelAttribute LoginModel loginModel, Model model, HttpServletRequest request) {
        this.analyzeService.analyzeRequestUrl(request);
        return "redirect:/setup/open/loginletto";
    }

    @RequestMapping(value={"/config/open/loginletto"})
    public String loginForm(@ModelAttribute LoginModel loginModel, Model model, HttpServletRequest request, HttpServletResponse response) {
        return this.loginForm(loginModel, model, request, true);
    }

    @RequestMapping(value={"/setup/open/loginletto"})
    public String loginFormLocal(@ModelAttribute LoginModel loginModel, Model model, HttpServletRequest request, HttpServletResponse response) {
        return this.loginForm(loginModel, model, request, false);
    }

    private String loginForm(@ModelAttribute LoginModel loginModel, Model model, HttpServletRequest request, boolean docker) {
        this.analyzeService.analyzeRequestUrl(request);
        String msg = "";
        if (loginModel != null && loginModel.getName().length() > 0 && loginModel.getPasswort().length() > 0) {
            try {
                String redirection;
                String username = loginModel.getName();
                String password = loginModel.getPasswort();
                Integer idSchule = loginModel.getIdSchule();
                String schule = loginModel.getSchule();
                RestLoginService loginService = this.lettoService.getLoginService();
                LettoToken lettoToken = null;
                if (loginService != null) {
                    lettoToken = loginService.jwtLogin(username, password, "", this.microServiceConfiguration.getJwtSecret());
                }
                String string = redirection = docker ? "/config/session/welcome" : "/setup/session/welcome";
                if (lettoToken == null && username.equals("admin")) {
                    lettoToken = this.setupUserDetailsService.checkSetupUsernamePassword(username, password);
                }
                if (lettoToken != null) {
                    if (lettoToken.isGlobal()) {
                        JwtAuthentication jwtAuthentication = new JwtAuthentication(lettoToken);
                        SecurityContextHolder.getContext().setAuthentication((Authentication)jwtAuthentication);
                        this.lettoSetupComponent.setLettoToken(lettoToken);
                        this.dockerService.analyzeBackground(true);
                        return "redirect:" + redirection;
                    }
                    String uri = this.lettoService.getLoginService().jwtGetTempTokenUri(lettoToken.getToken());
                    if (uri != null && uri.length() > 0) {
                        return "redirect:" + uri;
                    }
                    msg = "Login fehlerhaft!";
                }
                loginModel.setPasswort("");
            }
            catch (Exception ex) {
                msg = ex.getMessage();
                model.addAttribute("paramerror", (Object)true);
            }
        }
        model.addAttribute("loginModel", (Object)loginModel);
        model.addAttribute("test", (Object)"ABC");
        model.addAttribute("msg", (Object)msg);
        model.addAttribute("action", (Object)(docker ? "/config/open/loginletto" : "/setup/open/loginletto"));
        model.addAttribute("dockerService", (Object)this.dockerService);
        return "loginletto";
    }

    @GetMapping(value={"/config/open/logout"})
    public String logoutPage(HttpServletRequest request, HttpServletResponse response) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        this.lettoSetupComponent.setLettoToken(null);
        if (auth != null) {
            new SecurityContextLogoutHandler().logout(request, response, auth);
        }
        return "redirect:/config/open/login";
    }

    @GetMapping(value={"/setup/open/logout"})
    public String logoutPageLocal(HttpServletRequest request, HttpServletResponse response) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        this.lettoSetupComponent.setLettoToken(null);
        if (auth != null) {
            new SecurityContextLogoutHandler().logout(request, response, auth);
        }
        return "redirect:/setup/open/login";
    }
}

