/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.controller.http;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.controller.FileEditController;
import at.letto.setupservice.model.DockerLettoProxyResultModel;
import at.letto.setupservice.model.FileInfoDto;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DockerService;
import at.letto.tools.Cmd;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class HttpLettoProxyController {
    @Autowired
    private DockerService dockerService;
    @Autowired
    private CmdService cmdService;
    @Autowired
    private FileEditController fileEditController;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;

    public String dockerLettoProxyEP() {
        return this.microServiceConfiguration.isSetupDocker() ? "/config/session/admin/dockerlettoproxy" : "/setup/session/admin/dockerlettoproxy";
    }

    @RequestMapping(value={"/config/session/admin/dockerlettoproxy"})
    public String dockerLettoProxyDocker(@ModelAttribute DockerLettoProxyResultModel resultModel, HttpServletRequest request, Model model) {
        model.addAttribute("action", (Object)"/config/session/admin/dockerlettoproxy");
        return this.dockerLettoProxy(resultModel, request, model);
    }

    @RequestMapping(value={"/setup/session/admin/dockerlettoproxy"})
    public String dockerLettoProxyLocal(@ModelAttribute DockerLettoProxyResultModel resultModel, HttpServletRequest request, Model model) {
        model.addAttribute("action", (Object)"/setup/session/admin/dockerlettoproxy");
        return this.dockerLettoProxy(resultModel, request, model);
    }

    private String dockerLettoProxy(@ModelAttribute DockerLettoProxyResultModel resultModel, HttpServletRequest request, Model model) {
        String msg = "";
        String button = resultModel.getUserAction();
        if (button != null) {
            switch (button) {
                case "refresh": {
                    break;
                }
                case "back": {
                    return "redirect:" + this.dockerService.welcomeEP();
                }
                case "restart": {
                    CmdThread t = this.cmdService.cmdScriptForeground(2000L, new String[]{"docker restart letto-proxy"});
                    this.dockerService.analyze(true);
                    msg = "proxy restarted!";
                    break;
                }
                case "createfile": {
                    File f1;
                    String filename = resultModel.getNewFile();
                    if (filename == null || filename.trim().length() <= 0) break;
                    if (!(filename = filename.trim()).endsWith(".conf")) {
                        filename = filename + ".conf";
                    }
                    if (!(f1 = new File(this.dockerService.getProxyPath() + "/servers/" + filename)).exists()) {
                        try {
                            f1.createNewFile();
                            msg = filename + " created!";
                            break;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    msg = filename + " NOT created!";
                    break;
                }
                default: {
                    String filename;
                    if (button.startsWith("Edit")) {
                        String filename2 = button.substring(4);
                        if (filename2.length() <= 0) break;
                        try {
                            for (FileInfoDto fileInfoDto : this.dockerService.getProxyConfFiles()) {
                                if (!fileInfoDto.getFilename().equals(filename2)) continue;
                                File f = fileInfoDto.getFile();
                                return this.fileEditController.editFile(f, model, this.dockerLettoProxyEP());
                            }
                        }
                        catch (Exception ex) {
                            msg = "Error editing file " + filename2;
                        }
                        break;
                    }
                    if (button.startsWith("Del")) {
                        String filename3 = button.substring(3);
                        if (filename3.length() <= 0) break;
                        try {
                            for (FileInfoDto fileInfoDto : this.dockerService.getProxyConfFiles()) {
                                if (!fileInfoDto.getFilename().equals(filename3)) continue;
                                msg = filename3 + " deleted!";
                                fileInfoDto.getFile().delete();
                            }
                            break;
                        }
                        catch (Exception ex) {
                            msg = "Error deleting file " + filename3;
                            break;
                        }
                    }
                    if (button.startsWith("TEdit")) {
                        String filename4 = button.substring(5);
                        if (filename4.length() <= 0) break;
                        try {
                            for (FileInfoDto fileInfoDto : this.dockerService.getProxyConfTemplateFiles()) {
                                if (!fileInfoDto.getFilename().equals(filename4)) continue;
                                File f = fileInfoDto.getFile();
                                return this.fileEditController.editFile(f, model, this.dockerLettoProxyEP());
                            }
                        }
                        catch (Exception ex) {
                            msg = "Error editing file " + filename4;
                        }
                        break;
                    }
                    if (button.startsWith("TCopy")) {
                        String filename5 = button.substring(5);
                        if (filename5.length() <= 0) break;
                        try {
                            for (FileInfoDto fileInfoDto : this.dockerService.getProxyConfTemplateFiles()) {
                                if (!fileInfoDto.getFilename().equals(filename5)) continue;
                                try {
                                    File f = fileInfoDto.getFile();
                                    Vector data = Cmd.readfile((File)f);
                                    File f1 = new File(this.dockerService.getProxyPath() + "/" + fileInfoDto.getFilename());
                                    Cmd.writelnfile((Vector)data, (File)f1);
                                    msg = filename5 + " copied to " + f1.getAbsolutePath();
                                }
                                catch (Exception ex) {
                                    msg = msg + "cannot copy " + fileInfoDto.getFilename() + " ! ";
                                }
                            }
                            break;
                        }
                        catch (Exception ex) {
                            msg = "Error copying file " + filename5;
                            break;
                        }
                    }
                    if (button.startsWith("SEdit")) {
                        String filename6 = button.substring(5);
                        if (filename6.length() <= 0) break;
                        try {
                            File f = new File(this.dockerService.getProxyPath() + "/servers/" + filename6);
                            return this.fileEditController.editFile(f, model, this.dockerLettoProxyEP());
                        }
                        catch (Exception ex) {
                            msg = "Error editing file " + filename6;
                            break;
                        }
                    }
                    if (!button.startsWith("SDel") || (filename = button.substring(4)).length() <= 0) break;
                    try {
                        File f = new File(this.dockerService.getProxyPath() + "/servers/" + filename);
                        f.delete();
                        msg = "additional Server " + filename + " deleted!";
                        break;
                    }
                    catch (Exception ex) {
                        msg = "Error deleting additional Server " + filename;
                    }
                }
            }
        }
        model.addAttribute("msg", (Object)msg);
        model.addAttribute("dockerService", (Object)this.dockerService);
        this.dockerService.analyzeFiles();
        return "dockerlettoproxy";
    }
}

