/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.dto;

import java.util.Vector;

public class CpuTrendDto {
    public static final int MAX_CPU_WERTE = 10000;
    private int index = -1;
    private Vector<Long> times = new Vector();
    private Vector<Double> cpuLoads = new Vector();

    public void addCPUload(double cpuLoad) {
        long time = System.currentTimeMillis();
        this.index = (this.index + 1) % 10000;
        while (this.times.size() < this.index + 1) {
            this.times.add(0L);
        }
        while (this.cpuLoads.size() < this.index + 1) {
            this.cpuLoads.add(0.0);
        }
        this.times.set(this.index, time);
        this.cpuLoads.set(this.index, cpuLoad);
    }

    public double[] trendCpuLoad(int seconds) {
        if (seconds >= 10000) {
            seconds = 9999;
        }
        double[] trend = new double[seconds + 1];
        if (this.times.size() == 0) {
            return trend;
        }
        int index = this.index;
        long lasttime = (Long)this.times.get(index);
        int s = this.times.size();
        trend[seconds] = (Double)this.cpuLoads.get(index);
        int i = (index + 1) % s;
        while (i != index) {
            int trendIndex = seconds - (int)((lasttime - (Long)this.times.get(i) + 500L) / 1000L);
            if (trendIndex >= 0 && trendIndex < trend.length) {
                trend[trendIndex] = (Double)this.cpuLoads.get(i);
            }
            i = (i + 1) % s;
        }
        for (i = 1; i < trend.length; ++i) {
            if (trend[i] != 0.0) continue;
            trend[i] = trend[i - 1];
        }
        return trend;
    }

    public String[] cpuLoadJSstring(int seconds) {
        int time = 3600;
        int x = -time;
        boolean first = true;
        StringBuilder sb0 = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        sb0.append("[");
        sb1.append("[");
        for (double d : this.trendCpuLoad(seconds)) {
            if (!first || d != 0.0) {
                sb1.append((first ? "" : ",") + (double)((int)(d * 10000.0)) / 100.0);
                sb0.append((first ? "" : ",") + x++);
                first = false;
                continue;
            }
            ++x;
        }
        sb0.append("]");
        sb1.append("]");
        String[] ret = new String[]{sb0.toString(), sb1.toString()};
        return ret;
    }

    public double getLastCpuLoad() {
        if (this.index == -1 || this.times.size() == 0) {
            return 0.0;
        }
        return (Double)this.cpuLoads.get(this.index);
    }

    public double getAvCpuLoadLastMinute() {
        int startindex;
        if (this.index == -1 || this.times.size() == 0) {
            return 0.0;
        }
        double sum = (Double)this.cpuLoads.get(this.index);
        int anz = 1;
        long lasttime = (Long)this.times.get(this.index);
        int i = startindex = this.index == 0 ? this.times.size() - 1 : this.index - 1;
        while (i != this.index) {
            if ((Long)this.times.get(i) + 60000L < lasttime) {
                return sum / (double)anz;
            }
            sum += ((Double)this.cpuLoads.get(i)).doubleValue();
            ++anz;
            i = i == 0 ? this.times.size() - 1 : i - 1;
        }
        return sum / (double)anz;
    }
}

