/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.model;

import at.letto.setupservice.model.DownloadFile;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DownloadFile {
    private File file;
    private String id;
    private long time;
    private String filename;
    private String name;
    private String extension;
    private String absolutPath;
    private RIGHT right;
    private String user = "";

    public DownloadFile(File file, String id, String user) {
        this(file, id, RIGHT.USER);
        this.user = user;
    }

    public DownloadFile(File file, String id, RIGHT right) {
        this.right = right;
        this.user = "";
        this.file = file;
        this.id = id;
        this.time = System.currentTimeMillis();
        this.absolutPath = file.getAbsolutePath().replaceAll("\\\\", "/");
        String[] pp = this.absolutPath.split("/");
        this.filename = pp.length == 0 ? "" : pp[pp.length - 1];
        Matcher m = Pattern.compile("^(.*)(\\.[^\\.]*)$").matcher(this.filename);
        if (m.find()) {
            this.name = m.group(1);
            this.extension = m.group(2);
        } else {
            this.name = this.filename;
            this.extension = "";
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getId() {
        return this.id;
    }

    public long getTime() {
        return this.time;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getName() {
        return this.name;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getAbsolutPath() {
        return this.absolutPath;
    }

    public RIGHT getRight() {
        return this.right;
    }

    public String getUser() {
        return this.user;
    }
}

