/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setup.restclient.RestLocalSetupService;
import at.letto.setup.restclient.RestSetupService;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.configFiles.LettoEnvFile;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.SetupUpdateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SetupUpdateService {
    @Autowired
    private CmdService cmdService;
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private DockerService dockerService;
    private Boolean isHostLinux = null;

    private boolean isHostLinux() {
        if (this.isHostLinux == null) {
            this.isHostLinux = this.dockerService.isHostLinux();
        }
        return this.isHostLinux;
    }

    public RestSetupService setupAgent() {
        RestSetupService setupAgent = new RestSetupService("http://letto-setup-agent.nw-letto:8096", "admin", this.microServiceConfiguration.getUserAdminPassword());
        return setupAgent;
    }

    public void waitSeconds(int i) {
        try {
            Thread.sleep(i * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isSetupAgentRunning() {
        String result = this.setupAgent().manipulateSetupService("ping", true, "");
        return result != null && result.equals("pong");
    }

    public void setupAgentStop() {
        if (this.isSetupAgentRunning()) {
            String cmd = "docker stop letto-setup-agent";
            this.cmdService.cmdScriptForeground(100000L, false, new String[]{cmd});
        }
    }

    public String getSetupComposeDir() {
        return this.dockerService.getSetupComposeDir();
    }

    public String getLettoComposeDir() {
        return this.dockerService.getLettoComposeDir();
    }

    public String getMysqlComposeDir() {
        return this.dockerService.getMysqlComposeDir();
    }

    private void dockerCompose(CmdThread cmdThread, String dir, String yml, String service, String info, int timeout, boolean restart, boolean update) {
        String dockercmd = "docker compose ";
        if (yml != null && yml.length() > 0) {
            dockercmd = "docker compose -f " + yml + " ";
        }
        if (update && restart) {
            cmdThread.htmlOut("update and restart " + info + "-services from " + dir);
            cmdThread.runCmd(new String[]{"cd " + dir, dockercmd + " down", dockercmd + " pull", dockercmd + " up -d"});
        } else if (update) {
            cmdThread.htmlOut("update " + info + "-services from " + dir);
            cmdThread.runCmd(new String[]{"cd " + dir, dockercmd + " pull", dockercmd + " up -d"});
        } else if (restart) {
            cmdThread.htmlOut("restart " + info + "-services from " + dir);
            cmdThread.runCmd(new String[]{"cd " + dir, dockercmd + " down", dockercmd + " up -d"});
        } else {
            cmdThread.htmlOut("start " + info + "-services from " + dir);
            cmdThread.runCmd(new String[]{"cd " + dir, dockercmd + " up -d"});
        }
        if (service != null && service.length() > 0) {
            cmdThread.htmlOut("Wait for service " + service);
            int t = 4;
            this.waitSeconds(t);
            while (!this.dockerService.isDockerContainerRunningHealthyLive(service)) {
                this.waitSeconds(1);
                if (++t <= timeout) continue;
                cmdThread.htmlErr(info + "-services cannot start within " + timeout + " seconds!");
                return;
            }
            cmdThread.htmlOut(info + "-services started in " + t + " seconds");
        } else {
            cmdThread.htmlOut(info + "-services started");
        }
    }

    public void lettoDockerStartAndWait(CmdThread cmdThread, boolean restart, boolean update) {
        this.dockerCompose(cmdThread, this.getLettoComposeDir(), null, "letto-login", "LeTTo", 300, restart, update);
    }

    public void setupDockerStartAndWait(CmdThread cmdThread, boolean restart, boolean update) {
        this.dockerCompose(cmdThread, this.getSetupComposeDir(), null, "letto-setup", "Setup", 60, restart, update);
    }

    public void mysqlDockerStartAndWait(CmdThread cmdThread, boolean restart, boolean update) {
        this.dockerCompose(cmdThread, this.getMysqlComposeDir(), null, "letto-mysql", "Mysql", 600, restart, update);
    }

    public void schuleDockerStartAndWait(CmdThread cmdThread, String school, boolean restart, boolean update) {
        this.dockerCompose(cmdThread, this.getLettoComposeDir(), "docker-compose-" + school + ".yml ", "letto-server-" + school, "LeTTo-" + school, 120, restart, update);
    }

    public void renewCert(CmdThread cmdThread) {
        cmdThread.htmlOut("create new letsencrypt certificate");
        cmdThread.runCmd(new String[]{"docker run -i --rm -v certs:/etc/letsencrypt -v certs-data:/data/letsencrypt certbot/certbot renew --webroot --webroot-path=/data/letsencrypt"});
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        cmdThread.runCmd(new String[]{"docker restart letto-proxy"});
    }

    public void createNewCert(CmdThread cmdThread) {
        cmdThread.htmlOut("create new letsencrypt certificate");
        String domains = " -d " + this.dockerService.getServerName();
        try {
            String[] alternatives;
            for (String a : alternatives = this.dockerService.dockerConfiguration.getLettoEnvFile().getDomainAlternativ().split("\\s+")) {
                if (a.length() <= 0) continue;
                domains = domains + " -d " + a;
            }
        }
        catch (Exception alternatives) {
            // empty catch block
        }
        cmdThread.runCmd(new String[]{"docker exec -i letto-proxy /removecert.sh", "docker run -i --rm -v certs:/etc/letsencrypt -v certs-data:/data/letsencrypt certbot/certbot certonly --webroot --webroot-path=/data/letsencrypt  --non-interactive --agree-tos -m " + this.dockerService.getAdminEmail() + domains});
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException alternatives) {
            // empty catch block
        }
        LettoEnvFile envFile = this.dockerService.dockerConfiguration.getLettoEnvFile();
        envFile.setCertCreated(true);
        envFile.writeFile();
        this.dockerService.analyze(false);
        cmdThread.runCmd(new String[]{"docker restart letto-proxy"});
    }

    public CmdThread startProcess(String backlink, SETUP_CMD cmd, String school) {
        SetupRestart cmdThread = new SetupRestart(this, backlink, cmd, school);
        cmdThread.start();
        this.cmdService.addThread((CmdThread)cmdThread);
        return cmdThread;
    }

    public CmdThread dockerUpdateAll(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.UPDATE_ALL, null);
    }

    public CmdThread dockerRestartAll(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.RESTART_ALL, null);
    }

    public CmdThread setupStart(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.START, null);
    }

    public CmdThread setupStop(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.STOP, null);
    }

    public CmdThread setupRestart(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.RESTART, null);
    }

    public CmdThread setupUpdate(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.UPDATE, null);
    }

    public CmdThread dockerLettoRestart(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.LETTO_RESTART, null);
    }

    public CmdThread dockerLettoStart(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.LETTO_START, null);
    }

    public CmdThread dockerLettoStop(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.LETTO_STOP, null);
    }

    public CmdThread dockerLettoUpdate(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.LETTO_UPDATE, null);
    }

    public CmdThread dockerServiceRestart(String backlink, String ymlFileName) {
        return this.startProcess(backlink, SETUP_CMD.SERVICE_RESTART, ymlFileName);
    }

    public CmdThread dockerServiceStart(String backlink, String ymlFileName) {
        return this.startProcess(backlink, SETUP_CMD.SERVICE_START, ymlFileName);
    }

    public CmdThread dockerServiceStop(String backlink, String ymlFileName) {
        return this.startProcess(backlink, SETUP_CMD.SERVICE_STOP, ymlFileName);
    }

    public CmdThread dockerServiceDelete(String backlink, String ymlFileName) {
        return this.startProcess(backlink, SETUP_CMD.SERVICE_DELETE, ymlFileName);
    }

    public CmdThread dockerServiceUpdate(String backlink, String ymlFileName) {
        return this.startProcess(backlink, SETUP_CMD.SERVICE_UPDATE, ymlFileName);
    }

    public CmdThread dockerSchoolRestart(String backlink, String school) {
        return this.startProcess(backlink, SETUP_CMD.SCHOOL_RESTART, school);
    }

    public CmdThread dockerSchoolStart(String backlink, String school) {
        return this.startProcess(backlink, SETUP_CMD.SCHOOL_START, school);
    }

    public CmdThread dockerSchoolStop(String backlink, String school) {
        return this.startProcess(backlink, SETUP_CMD.SCHOOL_STOP, school);
    }

    public CmdThread dockerSchoolUpdate(String backlink, String school) {
        return this.startProcess(backlink, SETUP_CMD.SCHOOL_UPDATE, school);
    }

    public CmdThread dockerMysqlRestart(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.SQL_RESTART, null);
    }

    public CmdThread dockerMysqlStart(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.SQL_START, null);
    }

    public CmdThread dockerMysqlStop(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.SQL_STOP, null);
    }

    public CmdThread dockerMysqlUpdate(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.SQL_UPDATE, null);
    }

    public CmdThread createCert(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.CREATE_CERT, null);
    }

    public CmdThread renewCert(String backlink) {
        return this.startProcess(backlink, SETUP_CMD.RENEW_CERT, null);
    }

    public RestLocalSetupService getRestLocalSetupService() {
        RestLocalSetupService restLocalSetupService;
        if (this.isHostLinux() && (restLocalSetupService = new RestLocalSetupService("http://172.17.0.1:8096", "user", this.microServiceConfiguration.getUserUserPassword())).ping()) {
            return restLocalSetupService;
        }
        restLocalSetupService = new RestLocalSetupService("http://host.docker.internal:8096", "user", this.microServiceConfiguration.getUserUserPassword());
        if (restLocalSetupService.ping()) {
            return restLocalSetupService;
        }
        if (!this.isHostLinux.booleanValue() && (restLocalSetupService = new RestLocalSetupService("http://172.17.0.1:8096", "user", this.microServiceConfiguration.getUserUserPassword())).ping()) {
            return restLocalSetupService;
        }
        return null;
    }

    public String setupRestart() {
        RestLocalSetupService restLocalSetupService = this.getRestLocalSetupService();
        if (restLocalSetupService != null) {
            String result = restLocalSetupService.setupDockerRestart();
            return "restart Setup with docker compose";
        }
        return "cannot connect to local Setup-Service please restart Service in the hosts commandline";
    }

    public String setupStart() {
        RestLocalSetupService restLocalSetupService = this.getRestLocalSetupService();
        if (restLocalSetupService != null) {
            String result = restLocalSetupService.setupDockerStart();
            return "start Setup with docker compose";
        }
        return "cannot connect to local Setup-Service please start Service in the hosts commandline";
    }

    public String setupStop() {
        RestLocalSetupService restLocalSetupService = this.getRestLocalSetupService();
        if (restLocalSetupService != null) {
            String result = restLocalSetupService.setupDockerStop();
            return "stop Setup with docker compose";
        }
        return "cannot connect to local Setup-Service please stop Service in the hosts commandline";
    }

    public String setupUpdate() {
        RestLocalSetupService restLocalSetupService = this.getRestLocalSetupService();
        if (restLocalSetupService != null) {
            String result = restLocalSetupService.setupDockerUpdate();
            return "update Setup with docker compose";
        }
        return "cannot connect to local Setup-Service please update Service in the hosts commandline";
    }

    public String lettoRestart() {
        RestLocalSetupService restLocalSetupService = this.getRestLocalSetupService();
        if (restLocalSetupService != null) {
            String result = restLocalSetupService.lettoDockerRestart();
            return "restart LeTTo with docker compose";
        }
        return "cannot connect to local Setup-Service please restart Service in the hosts commandline";
    }

    public String lettoStart() {
        RestLocalSetupService restLocalSetupService = this.getRestLocalSetupService();
        if (restLocalSetupService != null) {
            String result = restLocalSetupService.lettoDockerStart();
            return "start LeTTo with docker compose";
        }
        return "cannot connect to local Setup-Service please start Service in the hosts commandline";
    }

    public String lettoStop() {
        RestLocalSetupService restLocalSetupService = this.getRestLocalSetupService();
        if (restLocalSetupService != null) {
            String result = restLocalSetupService.lettoDockerStop();
            return "stop LeTTo with docker compose";
        }
        return "cannot connect to local Setup-Service please stop Service in the hosts commandline";
    }

    public String lettoUpdate() {
        RestLocalSetupService restLocalSetupService = this.getRestLocalSetupService();
        if (restLocalSetupService != null) {
            String result = restLocalSetupService.lettoDockerUpdate();
            return "update LeTTo with docker compose";
        }
        return "cannot connect to local Setup-Service please update Service in the hosts commandline";
    }

    static /* synthetic */ AnalyzeService access$000(SetupUpdateService x0) {
        return x0.analyzeService;
    }

    static /* synthetic */ DockerService access$100(SetupUpdateService x0) {
        return x0.dockerService;
    }

    static /* synthetic */ MicroServiceConfiguration access$200(SetupUpdateService x0) {
        return x0.microServiceConfiguration;
    }
}

