/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.basespringboot.service.BaseLettoUserDetailsService;
import at.letto.security.LettoToken;
import at.letto.service.RestUser;
import at.letto.setupservice.config.MicroServiceConfiguration;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class SetupUserDetailsService
extends BaseLettoUserDetailsService {
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;
    @Value(value="${ADMIN_PASSWORD:}")
    private String setupAdminPassword;
    @Value(value="${ADMIN_PASSWORD_ENCRYPTED:}")
    protected String setupAdminPasswordEncrypted;
    @Value(value="${letto.user.admin.password:}")
    private String setupLocalAdminPassword;

    public void loadUserList() {
        super.loadUserList();
        if (this.setupAdminPassword != null && this.setupAdminPassword.length() > 0) {
            this.setupAdminPasswordEncrypted = new BCryptPasswordEncoder().encode((CharSequence)this.setupAdminPassword);
        }
    }

    public LettoToken checkUsernamePassword(String username, String password) {
        RestUser restUser;
        if (username != null && username.length() > 0 && this.users.containsKey(username) && new BCryptPasswordEncoder().matches((CharSequence)password, (restUser = (RestUser)this.users.get(username)).getEncodedpassword())) {
            ArrayList<String> roles = new ArrayList<String>();
            for (String r : restUser.getRoles()) {
                roles.add(r);
            }
            LettoToken lettoToken = new LettoToken(this.microServiceConfiguration.getJwtSecret(), Long.valueOf(this.microServiceConfiguration.getJwtExpiration()), username, "", username, "", "", "de", Integer.valueOf(0), Integer.valueOf(0), "", "", "", roles);
            return lettoToken;
        }
        return null;
    }

    public LettoToken checkSetupUsernamePassword(String username, String password) {
        if (username != null && username.length() > 0 && this.users.containsKey(username) && username.equals("admin") && new BCryptPasswordEncoder().matches((CharSequence)password, this.setupAdminPasswordEncrypted)) {
            ArrayList<String> roles = new ArrayList<String>();
            String[] rolesArray = "gast,user,admin,global".trim().split(",");
            roles.add("global");
            roles.add("admin");
            roles.add("teacher");
            roles.add("student");
            LettoToken lettoToken = new LettoToken(this.microServiceConfiguration.getJwtSecret(), Long.valueOf(this.microServiceConfiguration.getJwtExpiration()), username, "", username, "", "", "de", Integer.valueOf(0), Integer.valueOf(0), "", "", "", roles);
            return lettoToken;
        }
        return null;
    }

    public String getSetupAdminPassword() {
        return this.setupAdminPassword;
    }

    public void setSetupAdminPassword(String setupAdminPassword) {
        this.setupAdminPassword = setupAdminPassword;
    }

    public String getSetupAdminPasswordEncrypted() {
        return this.setupAdminPasswordEncrypted;
    }

    public void setSetupAdminPasswordEncrypted(String setupAdminPasswordEncrypted) {
        this.setupAdminPasswordEncrypted = setupAdminPasswordEncrypted;
    }

    public String getSetupLocalAdminPassword() {
        return this.setupLocalAdminPassword;
    }

    public void setSetupLocalAdminPassword(String setupLocalAdminPassword) {
        this.setupLocalAdminPassword = setupLocalAdminPassword;
    }
}

