/*
 * Decompiled with CFR 0.152.
 */
package at.letto.setupservice.service;

import at.letto.basespringboot.cmd.CmdThread;
import at.letto.setupservice.SetupserviceApplication;
import at.letto.setupservice.config.MicroServiceConfiguration;
import at.letto.setupservice.configFiles.SchuleEnv;
import at.letto.setupservice.model.UpdateDto;
import at.letto.setupservice.model.UpdateServiceDto;
import at.letto.setupservice.model.docker.DockerComposeDto;
import at.letto.setupservice.model.docker.DockerComposeServiceDto;
import at.letto.setupservice.model.docker.DockerContainerDto;
import at.letto.setupservice.model.docker.DockerStatusDto;
import at.letto.setupservice.service.AnalyzeService;
import at.letto.setupservice.service.CmdService;
import at.letto.setupservice.service.DockerService;
import at.letto.setupservice.service.ResourcenService;
import at.letto.setupservice.service.SetupUpdateService;
import at.letto.tools.Cmd;
import at.letto.tools.ENCRYPT;
import at.letto.tools.WebGet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateService {
    @Autowired
    private AnalyzeService analyzeService;
    @Autowired
    private DockerService dockerService;
    @Autowired
    private SetupUpdateService setupUpdateService;
    @Autowired
    private CmdService cmdService;
    @Autowired
    private MicroServiceConfiguration microServiceConfiguration;
    @Autowired
    private ResourcenService resourcenService;
    private static final String lettosetupUrlStable = "https://www.letto.at/download/letto/stable/lettosetup";
    private static final String lettosetupUrlDaily = "https://www.letto.at/download/letto/daily/lettosetup";
    private static final String lettosetupUrlBeta = "https://www.letto.at/download/letto/beta/lettosetup";
    private static final String lettosetupUrlRev = "https://www.letto.at/download/letto/archiv/rev";
    public static final String lettoDownload = "https://www.letto.at/download/letto";
    public static final String lettoDailyUrl = "https://www.letto.at/download/letto/daily";
    public static final String lettoStableUrl = "https://www.letto.at/download/letto/stable";
    public static final String lettoBetaUrl = "https://www.letto.at/download/letto/beta";
    public static final String lettoArchivUrl = "https://www.letto.at/download/letto/archiv";
    public static final String lettoLTIUrl = "https://www.letto.at/download/letto/lti";
    private UpdateDto updateDto = null;
    private volatile boolean loadUpdateDtoRunning = false;

    private void saveByteArrayInFile(byte[] data, File f) throws IOException {
        FileOutputStream fos = new FileOutputStream(f);
        if (data != null) {
            fos.write(data);
        }
        fos.close();
        this.analyzeService.setOwnerLetto(new File[]{f});
    }

    public String downloadCheckMd5(String url, String md5url, String zieldatei) {
        return this.downloadCheckMd5(url, md5url, new File(zieldatei));
    }

    public String downloadCheckMd5(String url, String md5url, File file) {
        File tempFile;
        block7: {
            tempFile = new File(file.getAbsolutePath() + ".spare");
            try {
                String md5 = WebGet.getUrlString((String)md5url).trim().split(" ")[0];
                if (WebGet.readFileFromURL((String)url, (File)tempFile)) {
                    String downloadMd5 = ENCRYPT.md5((File)tempFile);
                    if (!downloadMd5.equals(md5)) {
                        return "Pr\u00fcfsummenfehler beim Download von " + url;
                    }
                    break block7;
                }
                return "Cannot download File from " + url;
            }
            catch (Exception ex) {
                return "Fehler beim Download von " + url;
            }
        }
        try {
            if (file.exists()) {
                file.delete();
            }
            tempFile.renameTo(file);
            this.analyzeService.setOwnerLetto(new File[]{file});
            return "";
        }
        catch (Exception ex) {
            return file.getAbsolutePath() + " kann nicht geschrieben werden!";
        }
    }

    public String downloadBinary(String url, String zieldatei) {
        return this.downloadBinary(url, new File(zieldatei));
    }

    public String downloadBinary(String url, File file) {
        byte[] data = null;
        try {
            data = WebGet.getUrlByteArray((String)url);
        }
        catch (Exception ex) {
            return "Fehler beim Download von " + url;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            if (data != null) {
                fos.write(data);
            }
            fos.close();
            this.analyzeService.setOwnerLetto(new File[]{file});
            return "";
        }
        catch (Exception ex) {
            return file.getAbsolutePath() + " kann nicht geschrieben werden!";
        }
    }

    public String download(String url, String zieldatei) {
        return this.download(url, new File(zieldatei));
    }

    public String download(String url, File file) {
        try {
            Vector data = WebGet.getUrlStringVector((String)url);
            if (Cmd.writelnfile((Vector)data, (File)file)) {
                return "";
            }
            this.analyzeService.setOwnerLetto(new File[]{file});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file.getAbsolutePath() + " kann nicht geschrieben werden!";
    }

    public String updateSetupServiceStable() {
        return this.updateSetupService(lettosetupUrlStable);
    }

    public String updateSetupServiceDaily() {
        return this.updateSetupService(lettosetupUrlDaily);
    }

    public String updateSetupService(String url) {
        try {
            File p = new File(this.analyzeService.getRootPath());
            if (p.isDirectory()) {
                String msg = this.downloadCheckMd5(url + ".jar", url + ".md5", p.getAbsolutePath() + "/lettosetup.jar");
                if (msg.length() > 0) {
                    return msg;
                }
                SetupserviceApplication.restart();
                return "ok";
            }
            return "Cannot create directory " + p.getAbsolutePath();
        }
        catch (Exception ex) {
            return "Cannot download from " + url + " : " + ex.getMessage();
        }
        catch (Error ex) {
            return "Cannot download from " + url + " : " + ex.getMessage();
        }
    }

    public UpdateDto getUpdateDto() {
        if (this.updateDto == null) {
            this.loadUpdateDto();
        }
        return this.updateDto;
    }

    public void loadUpdateDto() {
        if (this.loadUpdateDtoRunning) {
            return;
        }
        this.loadUpdateDtoRunning = true;
        try {
            UpdateDto loadedUpdateDto = new UpdateDto();
            loadedUpdateDto.setSetupRev(this.analyzeService.getRevision());
            try {
                loadedUpdateDto.setSetupRevBeta(WebGet.getUrlString((String)"https://www.letto.at/download/letto/beta/lettosetup.rev").trim().replaceAll("\n", "").replaceAll("\r", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                loadedUpdateDto.setSetupRevDaily(WebGet.getUrlString((String)"https://www.letto.at/download/letto/daily/lettosetup.rev").trim().replaceAll("\n", "").replaceAll("\r", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                loadedUpdateDto.setSetupRevStable(WebGet.getUrlString((String)"https://www.letto.at/download/letto/stable/lettosetup.rev").trim().replaceAll("\n", "").replaceAll("\r", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            loadedUpdateDto.setSetupLastUpdate(this.dockerService.dockerConfiguration.getSetupEnvFile().getSetupUpdate());
            this.dockerService.loadSetupYml();
            this.dockerService.loadMysqlYml();
            this.dockerService.loadLettoYml();
            DockerComposeDto mysqlYml = this.dockerService.getMysqlYml();
            DockerComposeDto setupYml = this.dockerService.getSetupYml();
            DockerComposeDto lettoYml = this.dockerService.getLettoYml();
            DockerStatusDto status = this.dockerService.getDockerStatus();
            Object composeServiceDto = null;
            Object container = null;
            HashMap<String, String> dockerRevInfo = new HashMap<String, String>();
            try {
                Pattern p = Pattern.compile("^([^=]+)=(.*)");
                for (String line : WebGet.getUrlStringVector((String)"https://www.letto.at/download/letto/docker-rev-info.txt")) {
                    Matcher m = p.matcher(line);
                    if (!m.find()) continue;
                    String cn = m.group(1).trim();
                    String rev = m.group(2).trim();
                    if (cn.length() <= 0 || rev.length() <= 0) continue;
                    dockerRevInfo.put(cn, rev);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.loadUpdateDto(loadedUpdateDto, status, dockerRevInfo, this.dockerService.isDockerRunning() ? "/opt/letto/docker/compose/mysql" : this.setupUpdateService.getMysqlComposeDir(), this.microServiceConfiguration.getMysqlYmlFile().getName(), mysqlYml.serviceFromName("lettomysql"));
            this.loadUpdateDto(loadedUpdateDto, status, dockerRevInfo, this.dockerService.isDockerRunning() ? "/opt/letto/docker/compose/mysql" : this.setupUpdateService.getMysqlComposeDir(), this.microServiceConfiguration.getMysqlYmlFile().getName(), mysqlYml.serviceFromName("lettophpmyadmin"));
            this.loadUpdateDto(loadedUpdateDto, status, dockerRevInfo, this.dockerService.isDockerRunning() ? "/opt/letto/docker/compose/setup" : this.setupUpdateService.getSetupComposeDir(), this.microServiceConfiguration.getSetupYmlFile().getName(), setupYml.serviceFromName("setup"));
            this.loadUpdateDto(loadedUpdateDto, status, dockerRevInfo, this.dockerService.isDockerRunning() ? "/opt/letto/docker/compose/letto" : this.setupUpdateService.getLettoComposeDir(), this.microServiceConfiguration.getLettoYmlFile().getName(), lettoYml.serviceFromName("login"));
            this.loadUpdateDto(loadedUpdateDto, status, dockerRevInfo, this.dockerService.isDockerRunning() ? "/opt/letto/docker/compose/letto" : this.setupUpdateService.getLettoComposeDir(), this.microServiceConfiguration.getLettoYmlFile().getName(), lettoYml.serviceFromName("proxy"));
            for (SchuleEnv schule : this.dockerService.dockerConfiguration.getLettoEnvFile().getSchulen()) {
                String school = schule.school;
                DockerComposeDto schoolYml = this.dockerService.getSchoolYml(school);
                this.loadUpdateDto(loadedUpdateDto, status, dockerRevInfo, this.dockerService.isDockerRunning() ? "/opt/letto/docker/compose/letto" : this.setupUpdateService.getLettoComposeDir(), this.microServiceConfiguration.getSchoolYmlFile(school).getName(), schoolYml.serviceFromImage("lettoserver"));
                this.loadUpdateDto(loadedUpdateDto, status, dockerRevInfo, this.dockerService.isDockerRunning() ? "/opt/letto/docker/compose/letto" : this.setupUpdateService.getLettoComposeDir(), this.microServiceConfiguration.getSchoolYmlFile(school).getName(), schoolYml.serviceFromImage("letto-service-data"));
            }
            Pattern pattern = Pattern.compile("^docker-service-(.*)\\.yml$");
            String composeDirName = this.dockerService.isDockerRunning() ? "/opt/letto/docker/compose/letto" : this.setupUpdateService.getLettoComposeDir();
            for (File f : new File(composeDirName).listFiles()) {
                String name;
                String filename = f.getName();
                Matcher m = pattern.matcher(filename);
                if (!m.find() || (name = m.group(1)).trim().length() <= 0) continue;
                DockerComposeDto yml = this.dockerService.loadServiceYml(f);
                for (DockerComposeServiceDto dto : yml.getServices()) {
                    String im = dto.getImage().trim();
                    if (!im.startsWith("lettohub/")) continue;
                    UpdateServiceDto updateServiceDto = this.loadUpdateDto(loadedUpdateDto, status, dockerRevInfo, composeDirName, filename, dto);
                    updateServiceDto.setDeleteable(true);
                }
            }
            for (String name : this.dockerService.getAvailableServices()) {
                String ymlFile = "docker-service-" + name + ".yml";
                if (ymlFile == null || ymlFile.length() <= 0 || name == null || name.length() <= 0 || name.trim().length() <= 0) continue;
                boolean found = false;
                for (UpdateServiceDto dto : loadedUpdateDto.getServices()) {
                    if (!dto.getYmlFilename().trim().equalsIgnoreCase(ymlFile)) continue;
                    found = true;
                }
                if (found) continue;
                loadedUpdateDto.getAvailableServices().add(name);
            }
            this.updateDto = loadedUpdateDto;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Error er) {
            er.printStackTrace();
        }
        this.loadUpdateDtoRunning = false;
    }

    private UpdateServiceDto loadUpdateDto(UpdateDto us, DockerStatusDto status, HashMap<String, String> dockerRevInfo, String composePath, String ymlFilename, DockerComposeServiceDto composeServiceDto) {
        UpdateServiceDto ser = new UpdateServiceDto();
        ser.setComposePath(composePath);
        ser.setYmlFilename(ymlFilename);
        us.getServices().add(ser);
        if (composeServiceDto != null) {
            try {
                ser.setServicename(composeServiceDto.getName());
                ser.setImage(composeServiceDto.getImage().split(":")[0]);
                if (ser.getImage().startsWith("lettohub/")) {
                    ser.setLettohubImage(ser.getImage().substring(9));
                }
                ser.setPlan(composeServiceDto.getImage().split(":")[1]);
                ser.setContainername(composeServiceDto.getContainername());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                CmdThread cmd = this.cmdService.cmdScriptForeground(4000L, false, new String[]{"docker exec -i " + ser.getContainername() + " cat revision.txt"});
                String rev = (String)((Vector)cmd.getOut().get(0)).get(0);
                if (!rev.trim().startsWith("cat") && !rev.trim().toLowerCase().startsWith("error")) {
                    ser.setRevision(rev);
                }
            }
            catch (Exception cmd) {
                // empty catch block
            }
            DockerContainerDto container = status.container(ser.getContainername());
            if (!this.microServiceConfiguration.getMysqlYmlFile().exists()) {
                ser.setRunning("not installed");
            } else if (container == null) {
                ser.setRunning("not started");
            } else if (container.running() && container.healthy()) {
                ser.setRunning("running");
            } else if (container.running()) {
                ser.setRunning("unhealthy");
            } else {
                ser.setRunning("stopped");
            }
            if (ser.getLettohubImage().length() > 0) {
                String im = ser.getLettohubImage();
                if (dockerRevInfo.containsKey(im + "-daily")) {
                    ser.setDailyVersion(dockerRevInfo.get(im + "-daily"));
                }
                if (dockerRevInfo.containsKey(im + "-stable")) {
                    ser.setStableVersion(dockerRevInfo.get(im + "-stable"));
                }
                if (dockerRevInfo.containsKey(im + "-beta")) {
                    ser.setBetaVersion(dockerRevInfo.get(im + "-beta"));
                }
                if (dockerRevInfo.containsKey(im + "-latest")) {
                    ser.setLatestVersion(dockerRevInfo.get(im + "-latest"));
                }
            }
        } else {
            ser.setRunning("not installed");
        }
        return ser;
    }

    public String setTag(UpdateServiceDto service, String tag) {
        String rev = tag;
        if (rev.matches("^[0-9]+$") && service.getLettohubImage().length() > 0) {
            rev = "rev" + rev;
        }
        int servicePrefix = 0;
        int dataPrefix = 0;
        boolean firstservice = false;
        boolean firstdata = false;
        String actualservice = "";
        try {
            Vector data = Cmd.readfile((File)service.ymlFile());
            Vector<String> dataout = new Vector<String>();
            for (String line : data) {
                int prefix;
                int n = prefix = (line = line.replaceAll("\\r", "").replaceAll("\\n", "")).trim().length() > 0 ? line.indexOf(line.trim().substring(0, 1)) : 0;
                if (!line.trim().startsWith("#") && line.trim().length() != 0) {
                    if (!firstservice && servicePrefix == 0 && line.trim().startsWith("services:")) {
                        servicePrefix = line.indexOf("services");
                        firstservice = true;
                    } else if (firstservice) {
                        servicePrefix = prefix;
                        dataPrefix = 0;
                        firstservice = false;
                        actualservice = line.trim();
                        actualservice = actualservice.substring(0, actualservice.indexOf(":"));
                        firstdata = true;
                    } else if (servicePrefix > 0 && prefix == servicePrefix) {
                        dataPrefix = 0;
                        actualservice = line.trim();
                        actualservice = actualservice.substring(0, actualservice.indexOf(":"));
                        firstdata = true;
                    } else if (firstdata) {
                        dataPrefix = prefix;
                        firstdata = false;
                    } else if (prefix < dataPrefix) {
                        dataPrefix = 0;
                    } else if (prefix < servicePrefix) {
                        servicePrefix = 0;
                    }
                    if (servicePrefix > 0 && dataPrefix > 0 && actualservice.equals(service.getServicename()) && prefix == dataPrefix && line.trim().startsWith("image:")) {
                        line = line.substring(0, prefix) + "image: " + service.getImage() + ":" + rev;
                    }
                }
                dataout.add(line);
            }
            Cmd.writelnfile(dataout, (File)service.ymlFile());
            this.loadUpdateDto();
            return service.getYmlFilename() + " with service " + service.getServicename() + " updated tag to " + rev;
        }
        catch (Exception exception) {
            return "cannot set Tag to " + tag;
        }
    }

    public String updateYml(UpdateServiceDto service) {
        Matcher m;
        String msg = null;
        if (service.getComposePath().endsWith("setup") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            msg = this.dockerService.createSetupYml();
        } else if (service.getComposePath().endsWith("mysql") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            msg = this.dockerService.createMysqlYml();
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            msg = this.dockerService.createLettoYml();
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-service-")) {
            msg = this.dockerService.createYml(service.getYmlFilename());
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-compose-") && (m = Pattern.compile("docker-compose-(.*)\\.yml").matcher(service.getYmlFilename())).find()) {
            String school = m.group(1);
            SchuleEnv schule = this.dockerService.getSchuleEnv(school);
            msg = this.dockerService.createSchoolYml(schule);
        }
        if (msg != null) {
            this.loadUpdateDto();
        } else {
            msg = "service nicht bekannt. kann nicht upgedated werden!";
        }
        return msg;
    }

    public String installService(String serviceName) {
        String ymlFileName = "docker-service-" + serviceName + ".yml";
        String msg = this.dockerService.createYml(ymlFileName);
        if (msg == null || msg.trim().length() == 0) {
            msg = "Service " + serviceName + " installed. Now you are able to start the service. ";
        }
        File proxyFile = this.dockerService.isDockerRunning() ? new File("/opt/letto/docker/proxy/" + serviceName + ".conf") : new File(this.dockerService.getProxyPath() + "/" + serviceName + ".conf");
        Vector proxyData = this.resourcenService.loadTextFileFromResource("proxy/" + serviceName + ".conf");
        if (proxyData != null && proxyData.size() > 0) {
            Cmd.writelnfile((Vector)proxyData, (File)proxyFile);
            msg = msg + "Proxy file " + proxyFile.getAbsolutePath() + " created - please restart proxy to take effekt.";
        }
        this.loadUpdateDto();
        return msg;
    }

    public CmdThread serviceUpdate(UpdateServiceDto service, String endpoint) {
        Matcher m;
        CmdThread cmdThread = null;
        System.out.println("Update: path:" + service.getComposePath() + " yml:" + service.getYmlFilename());
        if (service.getComposePath().endsWith("setup") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.setupUpdate(endpoint);
        } else if (service.getComposePath().endsWith("mysql") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.dockerMysqlUpdate(endpoint);
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.dockerLettoUpdate(endpoint);
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-service-")) {
            cmdThread = this.setupUpdateService.dockerServiceUpdate(endpoint, service.getYmlFilename());
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-compose-") && (m = Pattern.compile("docker-compose-(.*)\\.yml").matcher(service.getYmlFilename())).find()) {
            String school = m.group(1);
            cmdThread = this.setupUpdateService.dockerSchoolUpdate(endpoint, school);
        }
        return cmdThread;
    }

    public CmdThread serviceRestart(UpdateServiceDto service, String endpoint) {
        Matcher m;
        CmdThread cmdThread = null;
        if (service.getComposePath().endsWith("setup") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.setupRestart(endpoint);
        } else if (service.getComposePath().endsWith("mysql") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.dockerMysqlRestart(endpoint);
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.dockerLettoRestart(endpoint);
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-service-")) {
            cmdThread = this.setupUpdateService.dockerServiceRestart(endpoint, service.getYmlFilename());
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-compose-") && (m = Pattern.compile("docker-compose-(.*)\\.yml").matcher(service.getYmlFilename())).find()) {
            String school = m.group(1);
            cmdThread = this.setupUpdateService.dockerSchoolRestart(endpoint, school);
        }
        return cmdThread;
    }

    public CmdThread serviceStop(UpdateServiceDto service, String endpoint) {
        Matcher m;
        CmdThread cmdThread = null;
        if (service.getComposePath().endsWith("setup") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.setupStop(endpoint);
        } else if (service.getComposePath().endsWith("mysql") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.dockerMysqlStop(endpoint);
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().equalsIgnoreCase("docker-compose.yml")) {
            cmdThread = this.setupUpdateService.dockerLettoStop(endpoint);
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-service-")) {
            cmdThread = this.setupUpdateService.dockerServiceStop(endpoint, service.getYmlFilename());
        } else if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-compose-") && (m = Pattern.compile("docker-compose-(.*)\\.yml").matcher(service.getYmlFilename())).find()) {
            String school = m.group(1);
            cmdThread = this.setupUpdateService.dockerSchoolStop(endpoint, school);
        }
        return cmdThread;
    }

    public CmdThread serviceDelete(UpdateServiceDto service) {
        CmdThread cmdThread = null;
        if (service.getComposePath().endsWith("letto") && service.getYmlFilename().startsWith("docker-service-")) {
            cmdThread = this.setupUpdateService.dockerServiceDelete(this.dockerService.updateEP(), service.getYmlFilename());
        }
        return cmdThread;
    }

    public String updateSetup(String rev) {
        if (rev == null) {
            rev = "";
        }
        if (rev.trim().length() == 0) {
            return "Cannot Update setup to nothing!";
        }
        this.dockerService.dockerConfiguration.getSetupEnvFile().setSetupUpdate(rev);
        this.dockerService.dockerConfiguration.saveConfiguration();
        String msg = "";
        msg = rev.equals("stable") ? this.updateSetupService(lettosetupUrlStable) : (rev.equals("daily") ? this.updateSetupService(lettosetupUrlDaily) : (rev.equals("beta") ? this.updateSetupService(lettosetupUrlBeta) : this.updateSetupService(lettosetupUrlRev + rev + "/lettosetup")));
        this.loadUpdateDto();
        return msg;
    }

    public String styleSetupStable() {
        try {
            if (this.updateDto.getSetupRevStable().length() > 0 && !this.updateDto.getSetupRev().equals(this.updateDto.getSetupRevStable())) {
                return "background-color:green;";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String styleSetupDaily() {
        try {
            if (this.updateDto.getSetupRevDaily().length() > 0 && !this.updateDto.getSetupRev().equals(this.updateDto.getSetupRevDaily())) {
                return "background-color:green;";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String styleSetupBeta() {
        try {
            if (this.updateDto.getSetupRevBeta().length() > 0 && !this.updateDto.getSetupRev().equals(this.updateDto.getSetupRevBeta())) {
                return "background-color:green;";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String styleUpdate(String containername) {
        if (this.availableUpdate(containername)) {
            return "background-color:green;";
        }
        return "";
    }

    public boolean availableUpdate(String containername) {
        try {
            UpdateServiceDto dto = this.updateDto.getServiceFromContainerName(containername);
            if (dto != null) {
                String rev = dto.getRevision();
                String plan = dto.getPlan();
                if (plan.equals("beta") ? dto.getBetaVersion().length() > 0 && !rev.equals(dto.getBetaVersion()) : (plan.equals("daily") ? dto.getDailyVersion().length() > 0 && !rev.equals(dto.getDailyVersion()) : (plan.equals("stable") ? dto.getStableVersion().length() > 0 && !rev.equals(dto.getStableVersion()) : plan.equals("latest") && dto.getLatestVersion().length() > 0 && !rev.equals(dto.getLatestVersion())))) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String availableUpdateRevision(String containername) {
        try {
            UpdateServiceDto dto = this.updateDto.getServiceFromContainerName(containername);
            if (dto != null) {
                String rev = dto.getRevision();
                String plan = dto.getPlan();
                if (plan.equals("beta")) {
                    return dto.getBetaVersion();
                }
                if (plan.equals("daily")) {
                    return dto.getDailyVersion();
                }
                if (plan.equals("stable")) {
                    return dto.getStableVersion();
                }
                if (plan.equals("latest")) {
                    return dto.getLatestVersion();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String styleBetaRev(String servicename) {
        try {
            UpdateServiceDto dto = this.updateDto.getServiceFromContainerName(servicename);
            if (dto != null) {
                String rev = dto.getRevision();
                String plan = dto.getPlan();
                if (plan.equals("beta") && dto.getBetaVersion().length() > 0 && !rev.equals(dto.getBetaVersion())) {
                    return "color:red;";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String styleStableRev(String containername) {
        try {
            UpdateServiceDto dto = this.updateDto.getServiceFromContainerName(containername);
            if (dto != null) {
                String rev = dto.getRevision();
                String plan = dto.getPlan();
                if (plan.equals("stable") && dto.getStableVersion().length() > 0 && !rev.equals(dto.getStableVersion())) {
                    return "color:red;";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String styleDailyRev(String containername) {
        try {
            UpdateServiceDto dto = this.updateDto.getServiceFromContainerName(containername);
            if (dto != null) {
                String rev = dto.getRevision();
                String plan = dto.getPlan();
                if (plan.equals("daily") && dto.getDailyVersion().length() > 0 && !rev.equals(dto.getDailyVersion())) {
                    return "color:red;";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public String styleLatestRev(String containername) {
        try {
            UpdateServiceDto dto = this.updateDto.getServiceFromContainerName(containername);
            if (dto != null) {
                String rev = dto.getRevision();
                String plan = dto.getPlan();
                if (plan.equals("latest") && dto.getLatestVersion().length() > 0 && !rev.equals(dto.getLatestVersion())) {
                    return "color:red;";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }
}

