/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data;

import at.letto.data.dto.PairIntInt;
import at.letto.tools.Listen;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;

public final class DatabaseUtil {
    public static boolean backup(String dbUsername, String dbPassword, String dbName, String outputFile) throws IOException, InterruptedException {
        String command = String.format("mysqldump -u%s -p%s --add-drop-table --databases %s -r %s", dbUsername, dbPassword, dbName, outputFile);
        Process process = Runtime.getRuntime().exec(command);
        int processComplete = process.waitFor();
        return processComplete == 0;
    }

    public static boolean restore(String dbUsername, String dbPassword, String dbName, String sourceFile) throws IOException, InterruptedException {
        String[] command = new String[]{"mysql", "-u" + dbUsername, "-p" + dbPassword, "-e", " source " + sourceFile, dbName};
        Process runtimeProcess = Runtime.getRuntime().exec(command);
        int processComplete = runtimeProcess.waitFor();
        return processComplete == 0;
    }

    public static void sortEntities(List<Integer> ids, int idNeu, int pos, String table, String sortCol, EntityManager em) {
        if (pos < 0 || pos >= ids.size()) {
            ids.add(idNeu);
        } else {
            ids.add(pos, idNeu);
        }
        Vector<PairIntInt> idsSorted = new Vector<PairIntInt>();
        for (int i = 0; i < ids.size(); ++i) {
            idsSorted.add(new PairIntInt(ids.get(i).intValue(), i));
        }
        String upd = Listen.sqlUpdateSort(idsSorted, PairIntInt::getVal2);
        String sql = String.format("INSERT into %s (id, %s) VALUES %s ON DUPLICATE KEY UPDATE %s = VALUES(%s);", table, sortCol, upd, sortCol, sortCol);
        try {
            em.createNativeQuery(sql).executeUpdate();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

