/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.controller;

import at.letto.data.dto.config.GlobalConfigDto;
import at.letto.data.dto.config.UserConfigDto;
import at.letto.data.repository.ConfiguserEntityRepository;
import at.letto.data.repository.GlobalconfigEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.config.ConfigService;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseTools;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class ConfigDataController {
    @Autowired
    ConfigService configService;
    @Autowired
    AllRepositories repos;

    @PostMapping(value={"/data/auth/user/conf/load_global_all"})
    public ResponseEntity<DtoAndMsg<List<GlobalConfigDto>>> loadAllGlobalConf() {
        return ResponseTools.getResponse(GlobalconfigEntityRepository::findGlobalAll, (Object)this.repos.globalconfigEntityRepository);
    }

    @PostMapping(value={"/data/auth/user/conf/load_user_all"})
    public ResponseEntity<DtoAndMsg<List<UserConfigDto>>> loadAllUserConf() {
        return ResponseTools.getResponse(ConfiguserEntityRepository::findUserConfigAll, (Object)this.repos.configuserEntityRepository);
    }

    @PostMapping(value={"/data/auth/user/conf/set_global"})
    public ResponseEntity<DtoAndMsg<String>> setGlobal(@RequestBody GlobalConfigDto c) {
        return ResponseTools.getErrResponse(ConfigService::setGlobal, (Object)this.configService, (Object)c);
    }

    @PostMapping(value={"/data/auth/user/conf/del_global"})
    public ResponseEntity<DtoAndMsg<String>> deleteGlobalConf(@RequestBody String key) {
        return ResponseTools.getErrResponse(ConfigService::deleteGlobalConf, (Object)this.configService, (Object)key);
    }

    @PostMapping(value={"/data/auth/user/conf/del_user"})
    public ResponseEntity<DtoAndMsg<String>> deleteUserConf(@RequestBody Map<String, String> vals) {
        int idUser = Integer.parseInt(vals.get("idUser"));
        String key = vals.get("key");
        return ResponseTools.getErrResponse(ConfigService::deleteUserConf, (Object)this.configService, (Object)key, (Object)idUser);
    }

    @PostMapping(value={"/data/auth/user/conf/get_global"})
    public ResponseEntity<DtoAndMsg<GlobalConfigDto>> getGlobalConf(@RequestBody String key) {
        return ResponseTools.getResponse(ConfigService::getGlobalConf, (Object)this.configService, (Object)key);
    }

    @PostMapping(value={"/data/auth/user/conf/get_user"})
    public ResponseEntity<DtoAndMsg<UserConfigDto>> getUserConf(@RequestBody Map<String, String> vals) {
        int idUser = Integer.parseInt(vals.get("idUser"));
        String key = vals.get("key");
        return ResponseTools.getResponse(ConfigService::get, (Object)this.configService, (Object)key, (Object)idUser);
    }

    @PostMapping(value={"/data/auth/user/conf/set_user"})
    public ResponseEntity<DtoAndMsg<Integer>> setUserConf(@RequestBody UserConfigDto c) {
        return ResponseTools.getResponse(ConfigService::set, (Object)this.configService, (Object)c);
    }
}

