/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.controller;

import at.letto.data.config.MicroServiceConfiguration;
import at.letto.data.dto.user.UserKeyDto;
import at.letto.data.service.UserService;
import at.letto.lehrplan.requestdto.CheckPasswordRequestDto;
import at.letto.service.interfaces.CheckPasswortResponseDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class LoginController {
    @Autowired
    private UserService userService;
    @Autowired
    MicroServiceConfiguration microServiceConfiguration;

    @PostMapping(value={"/data/auth/user/userbyname"})
    public ResponseEntity<UserKeyDto> userByName(@RequestBody String username) {
        UserKeyDto user = this.userService.getUserByName(username);
        return ResponseEntity.ok((Object)user);
    }

    @PostMapping(value={"/data/auth/user/checkpassword"})
    public ResponseEntity<CheckPasswortResponseDto> checkPassword(@RequestBody CheckPasswordRequestDto checkPasswordRequestDto) {
        CheckPasswortResponseDto response = this.userService.checkCredentials(checkPasswordRequestDto.getUsername(), checkPasswordRequestDto.getPassword());
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/data/open/tempTokenRedirectUri"})
    public ResponseEntity<String> tempTokenRedirectUri() {
        String uri = this.microServiceConfiguration.getLettodataRedirectTokenUri();
        return ResponseEntity.ok((Object)uri);
    }
}

