/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.controller;

import at.letto.data.dto.activity.ActivityChangeDto;
import at.letto.data.dto.activity.ActivityDto;
import at.letto.data.dto.dashboard.DashboardAllDto;
import at.letto.data.dto.gruppierung.InitTestInfoDto;
import at.letto.data.dto.testFrage.GroupingTestFragenDto;
import at.letto.data.dto.testFrage.InsertTestFrageDto;
import at.letto.data.dto.tests.AdaptVersuchDto;
import at.letto.data.dto.tests.CreateEmptyTestVersuchDTO;
import at.letto.data.dto.tests.SaveTestVersuchDto;
import at.letto.data.dto.tests.StopTestDto;
import at.letto.data.dto.tests.TestEigenschaftsDto;
import at.letto.data.dto.tests.TestFrageDto;
import at.letto.data.dto.tests.TestInhaltDto;
import at.letto.data.dto.tests.TestVersuchDto;
import at.letto.data.dto.tests.VersuchFullDto;
import at.letto.data.dto.tests.score.TestDetailAndAnswer;
import at.letto.data.dto.tests.score.TestScoreDto;
import at.letto.data.repository.TestsEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.dashboard.DashboardService;
import at.letto.data.service.tests.TestsServiceDatabase;
import at.letto.tools.rest.DtoAndMsg;
import at.letto.tools.rest.ResponseTools;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class TestsController {
    @Autowired
    TestsServiceDatabase testsService;
    @Autowired
    DashboardService dashboardService;
    @Autowired
    AllRepositories repos;

    @PostMapping(value={"/data/auth/user/test/change_gewicht"})
    public ResponseEntity<DtoAndMsg<String>> changeGewichtungTest(@RequestBody HashMap<String, String> vals) {
        int idTest = Integer.parseInt(vals.get("idTest"));
        double gewicht = Double.parseDouble(vals.get("gewicht"));
        return ResponseTools.getErrResponse(TestsServiceDatabase::changeGewichtungTest, (Object)this.testsService, (Object)idTest, (Object)gewicht);
    }

    @PostMapping(value={"/data/auth/user/test/load_q_anz_vers"})
    public ResponseEntity<DtoAndMsg<Integer>> getAnzahlFragenInTestversuch(@RequestBody int id) {
        return ResponseTools.getResponse(TestsServiceDatabase::getAnzahlFragenInTestversuch, (Object)this.testsService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/test/load_eigenschaften"})
    public ResponseEntity<DtoAndMsg<TestEigenschaftsDto>> loadTestEigenschaften(@RequestBody Integer id) {
        return ResponseTools.getErrResponse(TestsServiceDatabase::loadTestEigenschaften, (Object)this.testsService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/test/save_eigenschaften"})
    public ResponseEntity<DtoAndMsg<ActivityDto>> saveTestEigenschaften(@RequestBody ActivityChangeDto test) {
        return ResponseTools.getResponse(TestsServiceDatabase::saveTest, (Object)this.testsService, (Object)test);
    }

    @PostMapping(value={"/data/auth/user/test/save_activity"})
    public ResponseEntity<DtoAndMsg<ActivityChangeDto>> saveActivity(@RequestBody ActivityChangeDto act) {
        return ResponseTools.getResponse(TestsServiceDatabase::saveActivity, (Object)this.testsService, (Object)act);
    }

    @PostMapping(value={"/data/auth/user/test/load_eigenschaften_by_act"})
    public ResponseEntity<DtoAndMsg<TestEigenschaftsDto>> loadTestEigenschaftenByActivityId(@RequestBody int idTest) {
        return ResponseTools.getResponse(TestsEntityRepository::findTestEigenschaftenByActivityId, (Object)this.repos.testsEntityRepository, (Object)idTest);
    }

    @PostMapping(value={"/data/auth/user/test/load_test_full"})
    public ResponseEntity<DtoAndMsg<TestInhaltDto>> loadTestFull(@RequestBody int idTest) {
        return ResponseTools.getResponse(TestsServiceDatabase::loadTestInhaltFromDatabase, (Object)this.testsService, (Object)idTest);
    }

    @PostMapping(value={"/data/auth/user/test/stop"})
    public ResponseEntity<DtoAndMsg<String>> stopTest(@RequestBody StopTestDto dto) {
        return ResponseTools.getErrResponse(TestsServiceDatabase::stopTest, (Object)this.testsService, (Object)dto.getIdTest(), (Object)dto.getDate(), (Object)dto.isStop());
    }

    @PostMapping(value={"/data/auth/user/test/adapt_versuch"})
    public ResponseEntity<DtoAndMsg<TestVersuchDto>> adaptTestVersuch(@RequestBody AdaptVersuchDto a) {
        return ResponseTools.getResponse(TestsServiceDatabase::adaptTestVersuch, (Object)this.testsService, (Object)a.getV(), (Object)a.getT());
    }

    @PostMapping(value={"/data/auth/user/test/load_versuch"})
    public ResponseEntity<DtoAndMsg<TestVersuchDto>> loadTestVersuchSimple(@RequestBody int id) {
        return ResponseTools.getResponse(TestsServiceDatabase::loadTestVersuchSimple, (Object)this.testsService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/test/load_versuche"})
    public ResponseEntity<DtoAndMsg<List<TestVersuchDto>>> loadTestVersucheSimple(@RequestBody int id) {
        return ResponseTools.getResponse(TestsServiceDatabase::loadTestVersucheSimple, (Object)this.testsService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/test/load_versuch_full"})
    public ResponseEntity<DtoAndMsg<TestVersuchDto>> loadTestVersuchComplete(@RequestBody VersuchFullDto dto) {
        return ResponseTools.getResponse(TestsServiceDatabase::loadTestVersuchComplete, (Object)this.testsService, (Object)dto.getIdVersuch(), (Object)dto.getT());
    }

    @PostMapping(value={"/data/auth/user/test/del_versuch"})
    public ResponseEntity<DtoAndMsg<String>> delTestVersuch(@RequestBody int id) {
        return ResponseTools.getErrResponse(TestsServiceDatabase::delTestVersuch, (Object)this.testsService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/test/del_testfrage"})
    public ResponseEntity<DtoAndMsg<String>> delTestFrage(@RequestBody int id) {
        return ResponseTools.getErrResponse(TestsServiceDatabase::delTestFrage, (Object)this.testsService, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/test/change_points_tf"})
    public ResponseEntity<DtoAndMsg<String>> updateTestFragePoints(@RequestBody HashMap<String, String> vals) {
        int idTestfrage = Integer.parseInt(vals.get("idTestfrage"));
        double points = Double.parseDouble(vals.get("points"));
        return ResponseTools.getErrResponse(TestsServiceDatabase::updateTestFragePoints, (Object)this.testsService, (Object)idTestfrage, (Object)points);
    }

    @PostMapping(value={"/data/auth/user/test/change_points_tf_in_group"})
    public ResponseEntity<DtoAndMsg<String>> updateTestFragePointsInGroup(@RequestBody HashMap<String, String> vals) {
        int idGruppierung = Integer.parseInt(vals.get("idGruppierung"));
        double points = Double.parseDouble(vals.get("points"));
        return ResponseTools.getErrResponse(TestsServiceDatabase::updateTestFragePointsInGruppe, (Object)this.testsService, (Object)idGruppierung, (Object)points);
    }

    @PostMapping(value={"/data/auth/user/test/load_open_versuche"})
    public ResponseEntity<DtoAndMsg<List<TestVersuchDto>>> loadOpenTestVersucheByTestId(@RequestBody int id) {
        return ResponseTools.getResponse(TestsEntityRepository::findOpenTestVersucheByTestId, (Object)this.repos.testsEntityRepository, (Object)id);
    }

    @PostMapping(value={"/data/auth/user/test/students_for_versuch"})
    public ResponseEntity<DtoAndMsg<List<CreateEmptyTestVersuchDTO>>> loadStudentsForCreateVersuch(@RequestBody Set<Integer> idTests) {
        return ResponseTools.getResponse(TestsEntityRepository::findStudentsForCreateVersuch, (Object)this.repos.testsEntityRepository, idTests);
    }

    @PostMapping(value={"/data/auth/user/test/set_start_pos"})
    public ResponseEntity<DtoAndMsg<String>> saveTestVersuchStartPos(@RequestBody HashMap<String, String> vals) {
        int idVersuch = Integer.parseInt(vals.get("idVersuch"));
        String pos = vals.get("pos");
        return ResponseTools.getErrResponse(TestsServiceDatabase::saveTestVersuchStartPos, (Object)this.testsService, (Object)idVersuch, (Object)pos);
    }

    @PostMapping(value={"/data/auth/user/test/change_protokoll"})
    public ResponseEntity<DtoAndMsg<String>> updateTestVersuchProtokoll(@RequestBody HashMap<String, String> vals) {
        int idVersuch = Integer.parseInt(vals.get("idVersuch"));
        String protokoll = vals.get("protokoll");
        return ResponseTools.getErrResponse(TestsServiceDatabase::updateTestVersuchProtokoll, (Object)this.testsService, (Object)idVersuch, (Object)protokoll);
    }

    @PostMapping(value={"/data/auth/user/test/load_versuche_user"})
    public ResponseEntity<DtoAndMsg<List<TestVersuchDto>>> loadTestVersucheByUserId(@RequestBody HashMap<String, String> vals) {
        int idUser = Integer.parseInt(vals.get("idUser"));
        int idTest = Integer.parseInt(vals.get("idTest"));
        return ResponseTools.getResponse(TestsEntityRepository::findTestVersucheByUserId, (Object)this.repos.testsEntityRepository, (Object)idUser, (Object)idTest);
    }

    @PostMapping(value={"/data/auth/user/test/save_versuch"})
    public ResponseEntity<DtoAndMsg<TestVersuchDto>> saveTestVersuch(@RequestBody SaveTestVersuchDto dto) {
        return ResponseTools.getResponse(TestsServiceDatabase::saveTestVersuch, (Object)this.testsService, (Object)dto.getV(), (Object)dto.isAnonym());
    }

    @PostMapping(value={"/data/auth/user/test/save_versuch_properties"})
    public ResponseEntity<DtoAndMsg<String>> saveTestVersuchProperties(@RequestBody TestVersuchDto dto) {
        return ResponseTools.getResponse(TestsServiceDatabase::saveTestVersuchProperties, (Object)this.testsService, (Object)dto);
    }

    @PostMapping(value={"/data/auth/user/test/save_fragen_order"})
    public ResponseEntity<DtoAndMsg<String>> saveFragenOrder(@RequestBody List<TestFrageDto> fragen) {
        return ResponseTools.getResponse(TestsServiceDatabase::sortTestfragenInDatabase, (Object)this.testsService, fragen);
    }

    @PostMapping(value={"/data/auth/user/test/isoloate_fragen"})
    public ResponseEntity<DtoAndMsg<String>> isolateTestFragen(@RequestBody List<TestFrageDto> fragen) {
        return ResponseTools.getResponse(TestsServiceDatabase::isolateTestFrage, (Object)this.testsService, fragen);
    }

    @PostMapping(value={"/data/auth/user/test/grouping_fragen"})
    public ResponseEntity<DtoAndMsg<Integer>> groupingTestFragen(@RequestBody GroupingTestFragenDto grouping) {
        return ResponseTools.getResponse(TestsServiceDatabase::groupingTestFragen, (Object)this.testsService, (Object)grouping.getIdsTestfragen(), (Object)grouping.getAnzahl(), (Object)grouping.getNr());
    }

    @PostMapping(value={"/data/auth/user/test/change_grouping"})
    public ResponseEntity<DtoAndMsg<String>> updateGruppierungPoints(@RequestBody HashMap<String, String> vals) {
        int idGruppierung = Integer.parseInt(vals.get("idGruppierung"));
        int anzahl = Integer.parseInt(vals.get("anzahl"));
        return ResponseTools.getResponse(TestsServiceDatabase::updateGruppierungPoints, (Object)this.testsService, (Object)idGruppierung, (Object)anzahl);
    }

    @PostMapping(value={"/data/auth/user/test/del_testfrage_from_group"})
    public ResponseEntity<DtoAndMsg<String>> removeTestfageFromGruppierung(@RequestBody HashMap<String, String> vals) {
        int idTestfrage = Integer.parseInt(vals.get("idTestfrage"));
        return ResponseTools.getResponse(TestsServiceDatabase::removeTestfageFromGruppierung, (Object)this.testsService, (Object)idTestfrage);
    }

    @PostMapping(value={"/data/auth/user/test/del_grouping"})
    public ResponseEntity<DtoAndMsg<String>> removeGruppierung(@RequestBody int idGruppierung) {
        return ResponseTools.getResponse(TestsServiceDatabase::removeGruppierung, (Object)this.testsService, (Object)idGruppierung);
    }

    @PostMapping(value={"/data/auth/user/test/load_init_test_info"})
    public ResponseEntity<DtoAndMsg<InitTestInfoDto>> loadInitTestInfo(@RequestBody HashMap<String, String> vals) {
        int idTest = Integer.parseInt(vals.get("idTest"));
        int idParentFolder = Integer.parseInt(vals.get("idParentFolder"));
        int idLk = Integer.parseInt(vals.get("idLk"));
        return ResponseTools.getResponse(TestsServiceDatabase::loadInitTestInfo, (Object)this.testsService, (Object)idTest, (Object)idParentFolder, (Object)idLk);
    }

    @PostMapping(value={"/data/auth/user/test/save_testfrage"})
    public ResponseEntity<DtoAndMsg<String>> insertTestQuestion(@RequestBody InsertTestFrageDto dto) {
        return ResponseTools.getResponse(TestsServiceDatabase::insertTestQuestion, (Object)this.testsService, (Object)dto.getIdGruppe(), (Object)dto.getIdQuestions());
    }

    @PostMapping(value={"/data/auth/user/test/load_answers_versuch"})
    public ResponseEntity<DtoAndMsg<List<TestDetailAndAnswer>>> loadTestAnswersJsonFromVersuch(@RequestBody Integer idVersuch) {
        return ResponseTools.getResponse(TestsServiceDatabase::loadTestAnswersJsonFromVersuch, (Object)this.testsService, (Object)idVersuch);
    }

    @PostMapping(value={"/data/auth/user/test/score_versuch"})
    public ResponseEntity<DtoAndMsg<String>> scoreVersuch(@RequestBody TestScoreDto dto) {
        return ResponseTools.getResponse(TestsServiceDatabase::scoreTestVersuch, (Object)this.testsService, (Object)dto);
    }

    @PostMapping(value={"/data/auth/user/test/store_proz_test_versuch"})
    public ResponseEntity<DtoAndMsg<String>> storeProzentTestVersuch(@RequestBody Map<String, String> dto) {
        return ResponseTools.getResponse(TestsServiceDatabase::storeProzentTestVersuch, (Object)this.testsService, dto);
    }

    @PostMapping(value={"/data/auth/user/test/dashboard"})
    public ResponseEntity<DtoAndMsg<DashboardAllDto>> dashBoard(@RequestBody Map<String, String> vals) {
        int idUser = Integer.parseInt(vals.get("idUser"));
        int idSj = Integer.parseInt(vals.get("idSj"));
        return ResponseTools.getResponse(DashboardService::loadDashboard, (Object)this.dashboardService, (Object)idUser, (Object)idSj);
    }
}

