/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.entity;

import at.letto.data.dto.category.CategoryDTO;
import at.letto.data.dto.category.CategorySortDTO;
import at.letto.data.entity.CascadeOnDelete;
import at.letto.data.entity.CategoryKompetenzEntity;
import at.letto.data.entity.GegenstandEntity;
import at.letto.data.entity.MoodleRechteEntity;
import at.letto.data.entity.QuestionEntity;
import at.letto.data.entity.SchuleEntity;
import at.letto.tools.enums.Level;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.ConstructorResult;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;

@Entity
@Table(name="category")
@NamedNativeQueries(value={@NamedNativeQuery(name="CategoryEntity.findAllCategories", query="SELECT  c.id as id, c.name as name, c.idParent as idParent, c.EINHEITENKORR as einheitenKorr, c.EINHEITENKORRTEXT as einheitenKorrText, c.CATEGORYLINK as categoryLink, c.GLOBALCATEGORY as globalCategory, c.PRIVATECATEGORY as privateCategory, count(q.id) as questionsInCategory, c.KOMP_ID as idKompetenz, c.LEVEL as level,c.idSchool as idSchule, c.categories_ORDER as orderCol FROM category c  left join question q on q.idCategory = c.id group by c.id, c.KOMP_ID, c.idParent, c.categories_ORDER order by c.idParent, c.categories_ORDER ", resultSetMapping="CategoryDTO"), @NamedNativeQuery(name="CategoryEntity.findCatById", query="SELECT  c.id as id, c.name as name, c.idParent as idParent, c.EINHEITENKORR as einheitenKorr, c.EINHEITENKORRTEXT as einheitenKorrText, c.CATEGORYLINK as categoryLink, c.GLOBALCATEGORY as globalCategory, c.PRIVATECATEGORY as privateCategory, count(q.id) as questionsInCategory, c.KOMP_ID as idKompetenz, c.LEVEL as level, c.idSchool as idSchule, c.categories_ORDER as orderCol FROM category c  left join question q on q.idCategory = c.id where c.id = :id group by c.id, c.KOMP_ID, c.idParent, c.categories_ORDER order by c.idParent, c.categories_ORDER ", resultSetMapping="CategoryDTO"), @NamedNativeQuery(name="CategoryEntity.findChildCategories", query="SELECT  c.id as id, c.name as name, c.categories_ORDER as orderCol FROM category c where c.idParent=:idParent order by c.categories_ORDER ", resultSetMapping="CategorySortDTO"), @NamedNativeQuery(name="CategoryEntity.findRoot", query="SELECT  c.id as id, c.name as name, c.categories_ORDER as orderCol FROM category c where c.idParent is null ", resultSetMapping="CategorySortDTO")})
@SqlResultSetMappings(value={@SqlResultSetMapping(name="CategorySortDTO", classes={@ConstructorResult(targetClass=CategorySortDTO.class, columns={@ColumnResult(name="id"), @ColumnResult(name="name"), @ColumnResult(name="orderCol")})}), @SqlResultSetMapping(name="CategoryDTO", classes={@ConstructorResult(targetClass=CategoryDTO.class, columns={@ColumnResult(name="id"), @ColumnResult(name="name"), @ColumnResult(name="idParent"), @ColumnResult(name="einheitenKorr"), @ColumnResult(name="einheitenKorrText"), @ColumnResult(name="categoryLink"), @ColumnResult(name="globalCategory"), @ColumnResult(name="privateCategory"), @ColumnResult(name="questionsInCategory"), @ColumnResult(name="idKompetenz"), @ColumnResult(name="level"), @ColumnResult(name="idSchule"), @ColumnResult(name="orderCol")})})})
public class CategoryEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="ID", nullable=false)
    private Integer id;
    @OneToMany(mappedBy="parent", cascade={CascadeType.ALL}, orphanRemoval=true)
    @CascadeOnDelete
    @OrderColumn
    private List<CategoryEntity> categories = new ArrayList();
    @OneToMany(mappedBy="category", cascade={CascadeType.ALL}, orphanRemoval=true)
    @CascadeOnDelete
    @OrderColumn
    private List<MoodleRechteEntity> rechte = new ArrayList();
    @OneToMany(mappedBy="category", cascade={CascadeType.ALL}, orphanRemoval=true)
    @CascadeOnDelete
    private List<QuestionEntity> questionList = new ArrayList();
    @OneToMany(mappedBy="category", cascade={CascadeType.ALL}, orphanRemoval=true)
    @CascadeOnDelete
    @OrderColumn(name="kompetenzen_ORDER")
    private List<CategoryKompetenzEntity> kompetenz = new ArrayList();
    @ManyToMany
    @JoinTable(name="category_gegenstand", joinColumns={@JoinColumn(name="categories_ID")}, inverseJoinColumns={@JoinColumn(name="gegenstaende_ID")})
    @OrderColumn
    private List<GegenstandEntity> gegenstaende = new ArrayList();
    @ManyToMany(mappedBy="categories", cascade={CascadeType.ALL})
    private List<SchuleEntity> schulen = new ArrayList();
    @ManyToOne
    @JoinColumn(name="idParent")
    private CategoryEntity parent;
    @Column(name="KOMP_ID")
    private Integer idKompetenz;
    @Column(name="EINHEITENKORR")
    private Boolean einheitenKorr = false;
    @Lob
    @Column(name="EINHEITENKORRTEXT")
    private String einheitenKorrText = "";
    @Column(name="GLOBALCATEGORY")
    private Boolean globalCategory = false;
    @Column(name="LEVEL")
    @Enumerated(value=EnumType.ORDINAL)
    private Level level = Level.Grundlagen;
    @Column(name="NAME")
    private String name = "";
    @Column(name="CATEGORYLINK")
    private String categoryLink = "";
    @Column(name="PRIVATECATEGORY")
    private Boolean privateCategory = false;
    @Column(name="USEINTERNALCALC")
    private Boolean useInternalCalc = false;

    public Integer getId() {
        return this.id;
    }

    public List<CategoryEntity> getCategories() {
        return this.categories;
    }

    public List<MoodleRechteEntity> getRechte() {
        return this.rechte;
    }

    public List<QuestionEntity> getQuestionList() {
        return this.questionList;
    }

    public List<CategoryKompetenzEntity> getKompetenz() {
        return this.kompetenz;
    }

    public List<GegenstandEntity> getGegenstaende() {
        return this.gegenstaende;
    }

    public List<SchuleEntity> getSchulen() {
        return this.schulen;
    }

    public CategoryEntity getParent() {
        return this.parent;
    }

    public Integer getIdKompetenz() {
        return this.idKompetenz;
    }

    public Boolean getEinheitenKorr() {
        return this.einheitenKorr;
    }

    public String getEinheitenKorrText() {
        return this.einheitenKorrText;
    }

    public Boolean getGlobalCategory() {
        return this.globalCategory;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public String getCategoryLink() {
        return this.categoryLink;
    }

    public Boolean getPrivateCategory() {
        return this.privateCategory;
    }

    public Boolean getUseInternalCalc() {
        return this.useInternalCalc;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setCategories(List<CategoryEntity> categories) {
        this.categories = categories;
    }

    public void setRechte(List<MoodleRechteEntity> rechte) {
        this.rechte = rechte;
    }

    public void setQuestionList(List<QuestionEntity> questionList) {
        this.questionList = questionList;
    }

    public void setKompetenz(List<CategoryKompetenzEntity> kompetenz) {
        this.kompetenz = kompetenz;
    }

    public void setGegenstaende(List<GegenstandEntity> gegenstaende) {
        this.gegenstaende = gegenstaende;
    }

    public void setSchulen(List<SchuleEntity> schulen) {
        this.schulen = schulen;
    }

    public void setParent(CategoryEntity parent) {
        this.parent = parent;
    }

    public void setIdKompetenz(Integer idKompetenz) {
        this.idKompetenz = idKompetenz;
    }

    public void setEinheitenKorr(Boolean einheitenKorr) {
        this.einheitenKorr = einheitenKorr;
    }

    public void setEinheitenKorrText(String einheitenKorrText) {
        this.einheitenKorrText = einheitenKorrText;
    }

    public void setGlobalCategory(Boolean globalCategory) {
        this.globalCategory = globalCategory;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCategoryLink(String categoryLink) {
        this.categoryLink = categoryLink;
    }

    public void setPrivateCategory(Boolean privateCategory) {
        this.privateCategory = privateCategory;
    }

    public void setUseInternalCalc(Boolean useInternalCalc) {
        this.useInternalCalc = useInternalCalc;
    }
}

