/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.repository;

import at.letto.data.dto.activity.ActivityBaseDto;
import at.letto.data.entity.ActivityEntity;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface ActivityEntityRepository
extends JpaRepository<ActivityEntity, Integer>,
JpaSpecificationExecutor<ActivityEntity> {
    public static final String actBase = "new at.letto.data.dto.activity.ActivityBaseDto(a.id, a.idLk, t.id, l.id, q.id, d.id, p.id, kb.id, b.id, a.activityType.id, a.lehrerKlasse.id,a.parentFolder.id, a.name, a.path, a.visible, a.erstellerId, a.activityType.description, a.activityType.imageName, a.folderOrder, a.lkOrder) ";

    @Query(value="SELECT a FROM ActivityEntity a where a.parentFolder.id  = :idFolder")
    public List<ActivityEntity> activitiesInFolder(@Param(value="idFolder") int var1);

    @Query(value="SELECT a.id FROM activity a where a.idParentActivity = :idFolder", nativeQuery=true)
    public List<Integer> activityIdsInFolder(@Param(value="idFolder") int var1);

    @Query(value="SELECT a.id FROM activity a where a.idLehrerKlasse = :idLehrerKlasse", nativeQuery=true)
    public List<Integer> activityIdsInGegenstand(@Param(value="idLehrerKlasse") int var1);

    @Query(value="SELECT a FROM ActivityEntity a where a.lehrerKlasse.id  = :idLk")
    public List<ActivityEntity> activitiesInLehrerKlasse(@Param(value="idLk") int var1);

    @Query(value="SELECT a FROM ActivityEntity a join a.lehrerKlasse lk join lk.klasse k where k.id  = :idKlasse order by lk.gegenstand.kuerzel")
    public List<ActivityEntity> activitiesInKlasse(@Param(value="idKlasse") int var1);

    @Query(value="SELECT a FROM ActivityEntity a join a.lehrerKlasse lk join lk.klasse k where k.id  = :idKlasse and lk.user.id = :idUser order by lk.gegenstand.kuerzel")
    public List<ActivityEntity> activitiesInKlasse(@Param(value="idKlasse") int var1, @Param(value="idUser") int var2);

    @Query(value="select new at.letto.data.dto.activity.ActivityBaseDto(a.id, a.idLk, t.id, l.id, q.id, d.id, p.id, kb.id, b.id, a.activityType.id, a.lehrerKlasse.id,a.parentFolder.id, a.name, a.path, a.visible, a.erstellerId, a.activityType.description, a.activityType.imageName, a.folderOrder, a.lkOrder) from ActivityEntity a left join a.klassenBeurteilung kb left join a.beurteilung b left join a.test t left join a.question q left join a.dokument d left join a.inetLink l left join a.project p ")
    public List<ActivityBaseDto> loadAll();

    @Query(value="select new at.letto.data.dto.activity.ActivityBaseDto(a.id, a.idLk, t.id, l.id, q.id, d.id, p.id, kb.id, b.id, a.activityType.id, a.lehrerKlasse.id,a.parentFolder.id, a.name, a.path, a.visible, a.erstellerId, a.activityType.description, a.activityType.imageName, a.folderOrder, a.lkOrder)  from ActivityEntity a left join a.question q left join a.dokument d left join a.inetLink l left join a.project p left join a.klassenBeurteilung kb left join  a.beurteilung b left join a.test t where a.id=:id")
    public ActivityBaseDto loadById(@Param(value="id") int var1);

    @Query(value="select new at.letto.data.dto.activity.ActivityBaseDto(a.id, a.idLk, t.id, l.id, q.id, d.id, p.id, kb.id, b.id, a.activityType.id, a.lehrerKlasse.id,a.parentFolder.id, a.name, a.path, a.visible, a.erstellerId, a.activityType.description, a.activityType.imageName, a.folderOrder, a.lkOrder)  from ActivityEntity a join a.test t left join a.question q left join a.dokument d left join a.inetLink l left join a.project p left join a.klassenBeurteilung kb left join  a.beurteilung b where t.id=:idTest")
    public ActivityBaseDto loadByTestId(@Param(value="idTest") int var1);

    @Query(value="select new at.letto.data.dto.activity.ActivityBaseDto(a.id, a.idLk, t.id, l.id, q.id, d.id, p.id, kb.id, b.id, a.activityType.id, a.lehrerKlasse.id,a.parentFolder.id, a.name, a.path, a.visible, a.erstellerId, a.activityType.description, a.activityType.imageName, a.folderOrder, a.lkOrder)  from ActivityEntity a left join a.question q left join a.dokument d left join a.inetLink l left join a.project p left join a.klassenBeurteilung kb left join  a.beurteilung b  left join a.test t where a.parentFolder.id=:idParent")
    public List<ActivityBaseDto> loadFolder(@Param(value="idParent") int var1);

    @Query(value="select new at.letto.data.dto.activity.ActivityBaseDto(a.id, a.idLk, t.id, l.id, q.id, d.id, p.id, kb.id, b.id, a.activityType.id, a.lehrerKlasse.id,a.parentFolder.id, a.name, a.path, a.visible, a.erstellerId, a.activityType.description, a.activityType.imageName, a.folderOrder, a.lkOrder)  from ActivityEntity a left join a.question q left join a.dokument d left join a.inetLink l left join a.project p left join a.klassenBeurteilung kb left join  a.beurteilung b  left join a.test t where a.lehrerKlasse.id=:idParent")
    public List<ActivityBaseDto> loadInLk(@Param(value="idParent") int var1);

    @Modifying
    @Transactional
    @Query(value="update ActivityEntity set name = :name WHERE id=:id")
    public void updateName(@Param(value="id") int var1, @Param(value="name") String var2);

    @Modifying
    @Transactional
    @Query(value="update ActivityEntity set visible = :visible WHERE id=:id")
    public void updateVisibility(@Param(value="id") int var1, @Param(value="visible") boolean var2);

    @Modifying
    @Transactional
    @Query(value="update ActivityEntity set name = :name, visible=:visible WHERE id=:id")
    public void update(@Param(value="id") int var1, @Param(value="name") String var2, @Param(value="visible") boolean var3);

    @Modifying
    @Transactional
    @Query(value="update activity set folder_ORDER=:order WHERE id=:id", nativeQuery=true)
    public void setFolderPos(@Param(value="id") int var1, @Param(value="order") int var2);

    @Modifying
    @Transactional
    @Query(value="update activity set activities_ORDER=:order WHERE id=:id", nativeQuery=true)
    public void setLkPos(@Param(value="id") int var1, @Param(value="order") int var2);

    @Modifying
    @Transactional
    @Query(value="insert into activity (id, folder_ORDER) values (:vals) ON DUPLICATE KEY UPDATE folder_ORDER = VALUES(folder_ORDER)", nativeQuery=true)
    public void orderActivitiesFolder(@Param(value="vals") String var1);

    @Query(value="select max(a.folderOrder) from ActivityEntity a join a.parentFolder par where par.id = :id")
    public Long loadMaxActivitiesOrder(@Param(value="id") int var1);
}

