/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.repository;

import at.letto.data.dto.question.list.QuestionCommentDTO;
import at.letto.data.dto.question.list.QuestionKompetenzDTO;
import at.letto.data.dto.question.list.QuestionListDTO;
import at.letto.data.dto.question.list.QuestionUsedInGegenstandDTO;
import at.letto.data.dto.question.list.QuestionUsedInTestsDTO;
import at.letto.data.entity.QuestionEntity;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface QuestionEntityRepository
extends JpaRepository<QuestionEntity, Integer>,
JpaSpecificationExecutor<QuestionEntity> {
    public static final String questListDto = "new at.letto.data.dto.question.list.QuestionListDTO(q.id, q.name, q.licenceKey, q.hidden, q.questionType, q.idUser, c.id)";

    @Query(value="select new at.letto.data.dto.question.list.QuestionListDTO(q.id, q.name, q.licenceKey, q.hidden, q.questionType, q.idUser, c.id) from QuestionEntity q join q.category c where c.id = :idCateg order by q.orderColumn")
    public List<QuestionListDTO> loadQuestionList(@Param(value="idCateg") int var1);

    @Query(value="select new at.letto.data.dto.question.list.QuestionListDTO(q.id, q.name, q.licenceKey, q.hidden, q.questionType, q.idUser, c.id) from QuestionEntity q join q.category c order by q.orderColumn")
    public List<QuestionListDTO> loadQuestionListAll();

    @Query(value="select count(q) from QuestionEntity q where q.id=:id")
    public Long checkIfPresent(@Param(value="id") int var1);

    @Query(value="select new at.letto.data.dto.question.list.QuestionCommentDTO(c.id, c.question.id, c.message, c.icon) from QuestioncommentEntity c where c.question.id in :ids")
    public List<QuestionCommentDTO> loadQuestionComments(@Param(value="ids") Set<Integer> var1);

    @Query(value="select new at.letto.data.dto.question.list.QuestionCommentDTO(c.id, c.question.id, c.message, c.icon) from QuestioncommentEntity c where c.question.category.id > 0")
    public List<QuestionCommentDTO> loadAllQuestionComments();

    @Query(value="select distinct new at.letto.data.dto.question.list.QuestionKompetenzDTO(k.id, k.parent.parent.id, k.idKompetenz, '', k.level) from SubQuestionKompetenzEntity k where k.parent.parent.id in :ids")
    public List<QuestionKompetenzDTO> loadQuestionKompetenzen(@Param(value="ids") Set<Integer> var1);

    @Query(value="select distinct new at.letto.data.dto.question.list.QuestionKompetenzDTO(k.id, k.parent.parent.id, k.idKompetenz, '', k.level) from SubQuestionKompetenzEntity k where k.parent.parent.id > 0")
    public List<QuestionKompetenzDTO> loadQuestionKompetenzenAll();

    @Query(value="select sq.id from QuestionEntity q join q.subQuestions sq join q.category c where c.id = :idCat")
    public List<Integer> loadSubQuestionIDs(@Param(value="idCat") int var1);

    @Query(value="select distinct new at.letto.data.dto.question.list.QuestionUsedInGegenstandDTO(q.id, a.name, t.testDatum) from ActivityEntity a join a.test t join t.testGruppe g join g.testFragen f join f.question q, TestsEntity t2 join t2.activity a2 where q.id in :ids and t2.id=:idTests and a.idLk = a2.idLk")
    public List<QuestionUsedInGegenstandDTO> loadUsedTestsInGegenstand(@Param(value="ids") Set<Integer> var1, @Param(value="idTests") int var2);

    @Query(value="select distinct new at.letto.data.dto.question.list.QuestionUsedInTestsDTO(q.id, t.id, g.id, a.name, lk.gegenstand.kuerzel, lk.user.name, a.name, t.testDatum) from ActivityEntity a join a.test t join t.testGruppe g join g.testFragen f join f.question q, LehrerKlasseEntity lk where lk.id = a.idLk and q.id in :idQuestion")
    public List<QuestionUsedInTestsDTO> loadUsedTestsForQuestion(@Param(value="idQuestion") int var1);

    @Query(value="select q.id from question q where q.idCategory = :idCateg order by q.questionList_ORDER", nativeQuery=true)
    public List<Integer> loadQuestionIDs(@Param(value="idCateg") int var1);

    @Query(value="select x.text from GlobalconfigEntity x where x.name like 'lizenz'")
    public List<String> findLizenzen();

    @Modifying
    @Transactional
    @Query(value="delete from SubQuestionKompetenzEntity sk WHERE sk.parent.id in :ids")
    public void deleteKompetenzen(@Param(value="ids") List<Long> var1);

    @Modifying
    @Transactional
    @Query(value="update question set idCategory=:idCategory WHERE id=:id", nativeQuery=true)
    public void changeCategory(@Param(value="id") int var1, @Param(value="idCategory") Integer var2);

    @Modifying
    @Transactional
    @Query(value="update QuestionEntity set abzug=:penalty WHERE id in:ids")
    public void changePenalty(@Param(value="ids") List<Integer> var1, @Param(value="penalty") String var2);

    @Modifying
    @Transactional
    @Query(value="update QuestionEntity set abzug=:penalty WHERE id= :id")
    public void changePenalty(@Param(value="id") int var1, @Param(value="penalty") String var2);

    @Modifying
    @Transactional
    @Query(value="update question set questionList_ORDER=:order WHERE id=:id", nativeQuery=true)
    public void setListPos(@Param(value="id") int var1, @Param(value="order") int var2);
}

