/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.repository;

import at.letto.data.entity.TestFrageEntity;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface TestFrageEntityRepository
extends JpaRepository<TestFrageEntity, Integer>,
JpaSpecificationExecutor<TestFrageEntity> {
    @Query(value="select distinct(tf.id) from TestFrageEntity tf join tf.question q join tf.testDetails td join td.testVersuch tv where tv.finished = true and tv.test.id != :idTest and q.id = :idQuestion group by tf.id")
    public List<Integer> searchClosedTestQuestions(@Param(value="idQuestion") int var1, @Param(value="idTest") int var2);

    @Query(value="select distinct(tf.id) from TestFrageEntity tf join tf.question q join tf.testDetails td join td.testVersuch tv where tv.finished = true and q.id = :idQuestion group by tf.id")
    public List<Integer> searchClosedTestQuestions(@Param(value="idQuestion") int var1);

    @Query(value="select q.category.id from TestFrageEntity tf join tf.question q where tf.id = :idTestfrage")
    public Integer loadIdCategory(@Param(value="idTestfrage") int var1);

    @Modifying
    @Transactional
    @Query(value="update testFrage set idQuestion=:idQuestion WHERE id in :ids", nativeQuery=true)
    public void changeQuestionInTestfrage(@Param(value="ids") List<Integer> var1, @Param(value="idQuestion") int var2);

    @Modifying
    @Transactional
    @Query(value="update TestFrageEntity set points = :points where id = :id")
    public void updateTestFragePoints(@Param(value="id") int var1, @Param(value="points") double var2);

    @Modifying
    @Transactional
    @Query(value="update TestFrageEntity tf set tf.points = :points where tf.gruppeVonFragen.id = :idGruppe")
    public void updateGruppierungPoints(@Param(value="idGruppe") int var1, @Param(value="points") double var2);

    @Modifying
    @Transactional
    @Query(value="delete from TestFrageEntity tf where tf.id = :id")
    public void deleteTestFrage(@Param(value="id") int var1);

    @Modifying
    @Transactional
    @Query(value="delete from TestDetailsEntity td where td.frage.id = :idTestFrage")
    public void deleteTestDetails(@Param(value="idTestFrage") int var1);

    @Modifying
    @Transactional
    @Query(value="delete from TestAntwortEntity a where a.testDetail.frage.id = :idTestFrage")
    public void deleteTestAnswers(@Param(value="idTestFrage") int var1);

    @Modifying
    @Transactional
    @Query(value="update TestFrageEntity tf set tf.gruppeVonFragen=null where tf.id = :idTestfrage")
    public void removeTestfageFromGruppierung(@Param(value="idTestfrage") int var1);

    @Modifying
    @Transactional
    @Query(value="update TestFrageEntity tf set tf.gruppeVonFragen=null where tf.gruppeVonFragen.id = :idGruppierung")
    public void removeAllTestfagenFromGruppierung(@Param(value="idGruppierung") int var1);
}

