/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.repository;

import at.letto.data.dto.user.UserDto;
import at.letto.data.dto.user.UserSimpleDto;
import at.letto.data.entity.UserEntity;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface UserEntityRepository
extends JpaRepository<UserEntity, Integer>,
JpaSpecificationExecutor<UserEntity> {
    public static final String userDto = "new at.letto.data.dto.user.UserDto(u.id, u.name, u.activeDirectoryName, u.vorname, u.nachname, u.changeAbosPossible, u.disabled, u.email, u.admin, u.extern, u.global, u.mann, u.student, u.teacher,u.licence, u.useSchoolLicence, u.multipleLogin, u.payingStudent, u.sokratesID) ";
    public static final String userSimpleDto = "new at.letto.data.dto.user.UserSimpleDto(u.id, u.name, u.vorname, u.nachname) ";

    public List<UserEntity> findAllByName(String var1);

    public List<UserEntity> findAllById(int var1);

    @Query(value="select new at.letto.data.dto.user.UserDto(u.id, u.name, u.activeDirectoryName, u.vorname, u.nachname, u.changeAbosPossible, u.disabled, u.email, u.admin, u.extern, u.global, u.mann, u.student, u.teacher,u.licence, u.useSchoolLicence, u.multipleLogin, u.payingStudent, u.sokratesID)  from UserEntity u where u.teacher=true")
    public List<UserDto> loadLehrer();

    @Query(value="select new at.letto.data.dto.user.UserSimpleDto(u.id, u.name, u.vorname, u.nachname)  from UserEntity u where u.teacher=true")
    public List<UserSimpleDto> loadLehrerSimple();

    @Query(value="select new at.letto.data.dto.user.UserSimpleDto(u.id, u.name, u.vorname, u.nachname)  from UserEntity u where u.teacher=true and u.schule.id = :id")
    public List<UserSimpleDto> loadLehrerFromSchoolSimple(@Param(value="id") int var1);

    @Query(value="select new at.letto.data.dto.user.UserDto(u.id, u.name, u.activeDirectoryName, u.vorname, u.nachname, u.changeAbosPossible, u.disabled, u.email, u.admin, u.extern, u.global, u.mann, u.student, u.teacher,u.licence, u.useSchoolLicence, u.multipleLogin, u.payingStudent, u.sokratesID)  from UserEntity u where u.id=:id")
    public UserDto loadUserById(@Param(value="id") int var1);

    @Query(value="select new at.letto.data.dto.user.UserDto(u.id, u.name, u.activeDirectoryName, u.vorname, u.nachname, u.changeAbosPossible, u.disabled, u.email, u.admin, u.extern, u.global, u.mann, u.student, u.teacher,u.licence, u.useSchoolLicence, u.multipleLogin, u.payingStudent, u.sokratesID)  from UserEntity u where u.name=:name")
    public UserDto loadUserByName(@Param(value="name") String var1);

    @Query(value="select new at.letto.data.dto.user.UserSimpleDto(u.id, u.name, u.vorname, u.nachname)  from KlasseEntity k join k.schuelerKlasses sk join sk.user u where k.id=:idKlasse")
    public List<UserSimpleDto> loadSchuelerSimpleByKlasse(@Param(value="idKlasse") int var1);

    @Query(value="select new at.letto.data.dto.user.UserSimpleDto(u.id, u.name, u.vorname, u.nachname)  from UserEntity u where u.student=true and u.schule.id = :id")
    public List<UserSimpleDto> loadSchuelerFromSchoolSimple(@Param(value="id") int var1);

    @Query(value="select new at.letto.data.dto.user.UserDto(u.id, u.name, u.activeDirectoryName, u.vorname, u.nachname, u.changeAbosPossible, u.disabled, u.email, u.admin, u.extern, u.global, u.mann, u.student, u.teacher,u.licence, u.useSchoolLicence, u.multipleLogin, u.payingStudent, u.sokratesID)  from KlasseEntity k join k.schuelerKlasses sk join sk.user u where k.id=:idKlasse")
    public List<UserDto> loadSchuelerByKlasse(@Param(value="idKlasse") int var1);

    @Query(value="SELECT count(u) FROM UserEntity u where u.global = true")
    public Long loadAdminAnzahl();

    @Query(value="SELECT count(u) FROM UserEntity u")
    public Long loadUserAnzahl();

    @Query(value="select u from UserEntity u where u.schule.id not in :id")
    public List<UserEntity> loadUserNotInSchool(@Param(value="id") int var1);

    @Modifying
    @Transactional
    @Query(value="update UserEntity u set u.useSchoolLicence = false")
    public void resetSchuelerLizenzen();

    @Modifying
    @Transactional
    @Query(value="update UserEntity u set u.password = :pwd where u.id = :idUser")
    public void changePwd(@Param(value="idUser") int var1, @Param(value="pwd") String var2);

    @Modifying
    @Transactional
    @Query(value="update UserEntity u set u.password = :pwd where u.id in :idUsers")
    public void changePwd(@Param(value="idUsers") List<Integer> var1, @Param(value="pwd") String var2);

    @Modifying
    @Transactional
    @Query(value="update UserEntity u set u.tempPasswort = :pwd where u.id = :idUser")
    public void changeTempPwd(@Param(value="idUser") int var1, @Param(value="pwd") String var2);

    @Modifying
    @Transactional
    @Query(value="update UserEntity u set u.tempPasswort = :pwd where u.id in :idUsers")
    public void changeTempPwd(@Param(value="idUsers") List<Integer> var1, @Param(value="pwd") String var2);

    @Modifying
    @Transactional
    @Query(value="update UserEntity u set u.name=:#{#u.name}, u.activeDirectoryName=:#{#u.activeDirectoryName},u.vorname=:#{#u.vorname},u.nachname=:#{#u.nachname},u.changeAbosPossible=:#{#u.changeAbosPossible},u.disabled=:#{#u.disabled},u.email=:#{#u.email},u.admin=:#{#u.admin},u.extern=:#{#u.extern},u.global=:#{#u.global},u.mann=:#{#u.mann},u.student=:#{#u.student},u.teacher=:#{#u.teacher},u.licence=:#{#u.licence},u.useSchoolLicence=:#{#u.useSchoolLicence},u.multipleLogin=:#{#u.multipleLogin},u.payingStudent=:#{#u.payingStudent},u.sokratesID=:#{#u.sokratesID} where u.id in :#{#u.id}")
    public void changeUser(@Param(value="u") UserDto var1);
}

