/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service;

import at.letto.data.entity.ActivityEntity;
import at.letto.data.entity.CategoryEntity;
import at.letto.data.enums.REMOVE_MODE;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.data.service.DeleteService;
import at.letto.data.service.NativeSql;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DeleteService {
    @Inject
    EntityManager em;
    @Autowired
    private AllRepositories repos;
    @Autowired
    NativeSql nativeSql;
    @Value(value="${spring.datasource.url}")
    private String datasource;
    private boolean delThreadRunning = false;

    @PostConstruct
    public void init() {
    }

    public void delUser(List<Integer> idsUser) {
        this.nativeSql.execNativeWithIds("delete c from configuser c where c.USER_ID in :ids", idsUser);
        this.nativeSql.execNativeWithIds("delete l from LogMsg l where l.idUser in :ids", idsUser);
        this.nativeSql.execNativeWithIds("delete u from user_user u where u.bookedAboUsers_ID in :ids", idsUser);
        this.nativeSql.execNativeWithIds("delete u from user_user u where u.aboUsers_ID in :ids", idsUser);
        this.nativeSql.execNativeWithIds("delete u from category_user u where u.userAbo_ID in :ids", idsUser);
        this.nativeSql.execNativeWithIds("delete u from user_category u where u.User_ID in :ids", idsUser);
        this.nativeSql.execNativeWithIds("delete r from moodleRechte r where r.idUser in :ids", idsUser);
        this.nativeSql.execNativeWithIds("update beurteilungsconfig set idUser=null where idUser in :ids", idsUser);
        List idsTest = this.em.createQuery("select distinct t.id from UserEntity u join u.testVersuche v join v.test t where u.id in :ids", Integer.class).setParameter("ids", idsUser).getResultList();
        this.delTests(idsTest, REMOVE_MODE.All);
        this.nativeSql.execNativeWithIds("delete u from user u where u.id in :ids", idsUser);
    }

    public void delLehrerKlasseById(int idLk) {
        Vector lks = new Vector();
        this.repos.lehrerKlasseEntityRepository.findById((Object)idLk).ifPresent(lk -> lks.add(lk));
    }

    public void delLehrerKlasseById(List<Integer> idsLk) {
        this.delLehrerKlasseObjekte(idsLk, REMOVE_MODE.All);
    }

    private void delLehrerKlasseObjekte(List<Integer> ids, REMOVE_MODE mode) {
        if (ids.size() > 0) {
            this.nativeSql.execNativeWithIds("delete n from noten_lehrinhalt n join noten no on n.negativeNote_ID = no.id where no.idLehrerKlasse in :ids", ids);
            this.nativeSql.execNativeWithIds("delete n from noten_deskriptor n join noten no on n.negativeNote_ID = no.id where no.idLehrerKlasse in :ids", ids);
            this.nativeSql.execNativeWithIds("delete n from noten n where n.idLehrerKlasse in :ids", ids);
            System.out.println("L\u00f6schen Beurteilungen");
            List idsBeurt = this.em.createQuery("select b.id from BeurteilungEntity b join b.lehrerKlasse lk where lk.id in :ids", Integer.class).setParameter("ids", ids).getResultList();
            this.nativeSql.execNativeWithIds("delete from kompetenz_beurteilung where beurteilungID in :ids", idsBeurt);
            this.nativeSql.execNativeWithIds("delete from beurteilung where idSubBeurteilung in :ids", idsBeurt);
            this.nativeSql.execNativeWithIds("delete from beurteilung where id in :ids", idsBeurt);
            System.out.println("L\u00f6schen Klassen-Beurteilungen");
            this.nativeSql.execNativeWithIds("delete kb from klassenbeurteilung kb join klassenbeurteilung par on kb.idParent=par.id where par.idLehrerKlasse in :ids", ids);
            this.nativeSql.execNativeWithIds("delete from klassenbeurteilung where idLehrerKlasse in :ids", ids);
            System.out.println("L\u00f6schen Aktivit\u00e4ten");
            List actids = this.em.createNativeQuery("select id from activity a where a.idLehrerKlasse in (" + this.nativeSql.idsAsString(ids) + ")").getResultList();
            this.delChildAct(actids, mode);
            this.nativeSql.execNativeWithIds("delete from katalog_fremdlehrer where lkID in :ids", ids);
            this.nativeSql.execNativeWithIds("delete bg from beurtGruppeLK bg join lehrerKlasse lk on bg.LEHRERKLASSE_ID = lk.id where lk.id in :ids", ids);
            this.nativeSql.execNativeWithIds("delete lk from lehrerKlasse lk where lk.id in :ids", ids);
        }
    }

    public void delSchuelerKlasseByIds(List<Integer> idsSk) {
        this.delSchuelerKlasseEntities(idsSk);
    }

    public void delSchuelerKlasseById(int idSk) {
        Vector idsSk = new Vector();
        this.delSchuelerKlasseByIds(idsSk);
    }

    private void delSchuelerKlasseEntities(List<Integer> ids) {
        if (ids.size() > 0) {
            this.nativeSql.execNativeWithIds("delete sg from schuelergruppe sg where SCHUELERKLASSE_ID in :ids", ids);
            this.nativeSql.execNativeWithIds("delete sk from schuelerKlasse sk where id in :ids", ids);
        }
    }

    private void sql_try(String sql_command) {
        try {
            this.nativeSql.execNative(sql_command);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void delChildAct(ActivityEntity par) {
        List act = this.em.createQuery("select a from ActivityEntity a where a.parentFolder.id = :id", ActivityEntity.class).setParameter("id", (Object)par.getId()).getResultList();
        int i = 0;
        for (ActivityEntity a : act) {
            this.delChildAct(a);
            this.repos.activityEntityRepository.delete((Object)a);
            if (i++ % 100 != 0) continue;
            System.out.print(".");
        }
    }

    private void delChildAct(List<Integer> ids, REMOVE_MODE mode) {
        List idLinks;
        List childIDs = this.em.createQuery("select a.id from ActivityEntity a where a.parentFolder.id in :id", Integer.class).setParameter("id", ids).getResultList();
        boolean i = false;
        if (childIDs.size() > 0) {
            this.delChildAct(childIDs, mode);
        }
        if ((idLinks = this.em.createQuery("select l.id from InetlinksEntity l join l.activity a where a.id in :ids", Integer.class).setParameter("ids", ids).getResultList()).size() > 0) {
            this.nativeSql.execNativeWithIds("delete a from activity a join inetlinks l  on a.idLink = l.id where l.id in :ids", idLinks);
            this.nativeSql.execNativeWithIds("delete l from inetlinks l where l.id in :ids", idLinks);
        }
        this.nativeSql.execNativeWithIds("delete p from projekte p join activity a on a.idProject = p.id where a.id in :ids", ids);
        this.nativeSql.execNativeWithIds("delete p from dokumente p join activity a on a.idDokument = p.id where a.id in :ids", ids);
        List idTests = this.em.createQuery("select t.id from ActivityEntity a join a.test t where a.id in :ids", Integer.class).setParameter("ids", ids).getResultList();
        this.delTests(idTests, mode);
        this.nativeSql.execNativeWithIds("delete a from activity a where a.id in :ids", ids);
    }

    private void delChildCat(CategoryEntity par) {
        List childs = this.em.createQuery("select c from CategoryEntity c where c.parent.id = :id", CategoryEntity.class).setParameter("id", (Object)par.getId()).getResultList();
        int i = 0;
        for (CategoryEntity c : childs) {
            this.delChildCat(c);
            this.nativeSql.execNative("update question q set q.idCategory=null where q.idCategory = " + c.getId());
            this.repos.categoryEntityRepository.delete((Object)c);
            if (i++ % 100 != 0) continue;
            System.out.print(".");
        }
    }

    public void delTests(List<Integer> idsTests, REMOVE_MODE mode) {
        this.nativeSql.execNativeWithIds("delete tas from testAnswerSubQuestion tas join testAntwort ta on ta.id=tas.idTestAntwort join testDetails td on ta.idTestDetail=td.ID join testVersuch v on td.idTestVersuch = v.id where v.idTest in :ids", idsTests);
        this.nativeSql.execNativeWithIds("delete ta from testAntwort ta join testDetails td on ta.idTestDetail=td.ID join testVersuch v on td.idTestVersuch = v.id where v.idTest in :ids", idsTests);
        if (!mode.equals((Object)REMOVE_MODE.Testantworten)) {
            this.nativeSql.execNativeWithIds("delete f from FilesForTestDetails f join testDetails td on f.TestDetail_ID=td.ID join testVersuch v on td.idTestVersuch = v.id where v.idTest in :ids", idsTests);
            this.nativeSql.execNativeWithIds("delete td from testDetails td join testVersuch v on td.idTestVersuch = v.id where v.idTest in :ids", idsTests);
            this.nativeSql.execNativeWithIds("delete v from testVersuch v where v.idTest in :ids", idsTests);
        }
        if (!mode.equals((Object)REMOVE_MODE.Testantworten) && !mode.equals((Object)REMOVE_MODE.Testversuche)) {
            this.nativeSql.execNativeWithIds("delete f from FilesForTestDetails f join testDetails td on f.TestDetail_ID=td.ID join testVersuch v on td.idTestVersuch = v.id where v.idTest in :ids", idsTests);
            this.nativeSql.execNativeWithIds("delete td from testDetails td join testVersuch v on td.idTestVersuch = v.id where v.idTest in :ids", idsTests);
            this.nativeSql.execNativeWithIds("delete v from testVersuch v where v.idTest in :ids", idsTests);
        }
        if (mode.equals((Object)REMOVE_MODE.Alle_Beurteilungen) || mode.equals((Object)REMOVE_MODE.All)) {
            this.nativeSql.execNativeWithIds("delete tf from testFrage tf join testGruppe g on tf.idTestGruppe=g.id join testGruppe p1 on g.PARENT_ID=p1.ID join testGruppe p2 on p1.PARENT_ID = p2.ID where p2.idTest in :ids", idsTests);
            this.nativeSql.execNativeWithIds("delete tf from testFrage tf join testGruppe g on tf.idTestGruppe=g.id join testGruppe p1 on g.PARENT_ID=p1.ID where p1.idTest in :ids", idsTests);
            this.nativeSql.execNativeWithIds("delete td from testDetails td join testFrage tf on tf.id = td.question join testGruppe g on tf.idTestGruppe=g.id  where g.idTest in :ids", idsTests);
            this.nativeSql.execNativeWithIds("delete tf from testFrage tf join testGruppe g on tf.idTestGruppe=g.id where g.idTest in :ids", idsTests);
            this.nativeSql.execNativeWithIds("delete v from testVersuch v join testGruppe g on g.id =v.idGruppe where g.idTest in :ids", idsTests);
            this.nativeSql.execNativeWithIds("delete g from testGruppe g join testGruppe p1 on g.PARENT_ID=p1.ID join testGruppe p2 on p1.PARENT_ID = p2.ID where p2.idTest in :ids", idsTests);
            this.nativeSql.execNativeWithIds("delete g from testGruppe g join testGruppe p1 on g.PARENT_ID=p1.ID where p1.idTest in :ids", idsTests);
            this.nativeSql.execNativeWithIds("delete g from testGruppe g where g.idTest in :ids", idsTests);
            this.nativeSql.execNativeWithIds("update activity a set a.idTest=null where a.idTest  in :ids", idsTests);
            this.nativeSql.execNativeWithIds("delete t from tests t where t.id in :ids", idsTests);
            this.nativeSql.execNativeWithIds("delete a from activity a where a.idTest  in :ids", idsTests);
        }
    }

    public void delTests(int idTest) {
        Vector<Integer> idTests = new Vector<Integer>();
        idTests.add(idTest);
        this.delTests(idTests, REMOVE_MODE.All);
    }

    public void dropTables() {
        System.out.println("Nicht mehr notwendige Tabellen l\u00f6schen");
        this.sql_try("DROP TABLE artikelart");
        this.sql_try("DROP TABLE ausbildung");
        this.sql_try("DROP TABLE betrieb");
        this.sql_try("DROP TABLE budget");
        this.sql_try("DROP TABLE budgetuser");
        this.sql_try("DROP TABLE einrichtung");
        this.sql_try("DROP TABLE fahrtkosten");
        this.sql_try("DROP TABLE hardware");
        this.sql_try("DROP TABLE inventar");
        this.sql_try("DROP TABLE inventarart");
        this.sql_try("DROP TABLE kustodiat");
        this.sql_try("DROP TABLE nachtest");
        this.sql_try("DROP TABLE netz");
        this.sql_try("DROP TABLE nic");
        this.sql_try("DROP TABLE nicnetz");
        this.sql_try("DROP TABLE nictyp");
        this.sql_try("DROP TABLE praktikum");
        this.sql_try("DROP TABLE raum");
        this.sql_try("DROP TABLE teilnehmer");
        this.sql_try("DROP TABLE u1");
        this.sql_try("DROP TABLE url");
        this.sql_try("DROP TABLE urlhardware");
        this.sql_try("DROP TABLE userphoto");
        this.sql_try("DROP TABLE vertreter");
        this.sql_try("DROP TABLE zustand");
        this.sql_try("DROP TABLE zuweiser");
    }

    public void updateSql() {
        System.out.print("Anpassung an Spring ");
        File f = new File("C:\\git\\letto-setup\\sql\\changes6500.sql");
        try {
            Scanner fr = new Scanner(f);
            while (fr.hasNextLine()) {
                String sql = fr.nextLine();
                System.out.print(".");
                if (sql.isEmpty()) continue;
                this.sql_try(sql);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        System.out.println(".");
    }

    public String removeOldSchuljahre(REMOVE_MODE mode, Date d) {
        if (d == null) {
            d = new Date();
        }
        1 deleteThread = new /* Unavailable Anonymous Inner Class!! */;
        if (!this.delThreadRunning) {
            deleteThread.start();
            return "L\u00f6schprozess wurde gestartet";
        }
        return "L\u00f6schprozess gerade aktiv, weitere L\u00f6schanfrage kann nicht gestartet werden";
    }

    public String removeSchuljahr(REMOVE_MODE mode, int id) {
        2 deleteThread = new /* Unavailable Anonymous Inner Class!! */;
        if (!this.delThreadRunning) {
            deleteThread.start();
            return "L\u00f6schprozess wurde gestartet";
        }
        return "L\u00f6schprozess gerade aktiv, weitere L\u00f6schanfrage kann nicht gestartet werden";
    }

    public void removeDataFromSchuljahr(List<Integer> idsSchuljahre, REMOVE_MODE mode) {
        List idTests = this.em.createQuery("select t.id from ActivityEntity a join a.test t join a.lehrerKlasse lk join lk.klasse k join k.schuljahr sj where sj.id in :ids", Integer.class).setParameter("ids", idsSchuljahre).getResultList();
        this.delTests(idTests, mode);
        if (mode.equals((Object)REMOVE_MODE.Alle_Beurteilungen) || mode.equals((Object)REMOVE_MODE.All)) {
            List lks = this.em.createQuery("select lk.id from LehrerKlasseEntity lk join lk.klasse k join k.schuljahr sj where sj.id in :ids", Integer.class).setParameter("ids", idsSchuljahre).getResultList();
            this.delLehrerKlasseObjekte(lks, mode);
        }
        if (mode.equals((Object)REMOVE_MODE.All)) {
            List sks = this.em.createQuery("select sk.id from SchuelerKlasseEntity sk join sk.klasse k join k.schuljahr sj where sj.id in :ids", Integer.class).setParameter("ids", idsSchuljahre).getResultList();
            this.delSchuelerKlasseByIds(sks);
            this.nativeSql.execNativeWithIds("delete k from klasse k where k.idSchuljahr in :ids", idsSchuljahre);
            this.nativeSql.execNativeWithIds("delete sj from schuljahr sj where sj.id in :ids", idsSchuljahre);
        }
    }

    public void removeSchuljahr(String name) {
        List idsSj = this.repos.schuljahrEntityRepository.loadSchuljahre().stream().filter(sj -> sj.getName().equals(name)).map(sj -> sj.getId()).collect(Collectors.toList());
        List idsKlassen = this.repos.klasseEntityRepository.loadKlassen().stream().filter(k -> idsSj.contains(k.getIdSchuljahr())).map(k -> k.getId()).collect(Collectors.toList());
        this.repos.schuelerKlasseEntityRepository.loadSchuelerInSchuljahr(idsSj);
    }

    public void removeData(int idSchule) {
        this.updateSql();
        this.dropTables();
        System.out.print("L\u00f6schen von \u00fcberfl\u00fcssigen Tabelleninhalten");
        this.nativeSql.execNative("DELETE from testAnswerSubQuestion");
        this.nativeSql.execNative("DELETE from testAntwort");
        this.nativeSql.execNative("DELETE from Cpu");
        this.nativeSql.execNative("DELETE from category_user");
        this.nativeSql.execNative("DELETE from schule_category");
        System.out.print(", Sch\u00fcler-Klasse-Objekte l\u00f6schen");
        List schueler = this.repos.schuelerKlasseEntityRepository.loadSchuelerNotInSchool(idSchule);
        List idsSchueler = schueler.stream().map(s -> s.getId()).collect(Collectors.toList());
        this.delSchuelerKlasseByIds(idsSchueler);
        System.out.println(", Lehrer-Klasse-Objekte l\u00f6schen");
        List lks = this.repos.lehrerKlasseEntityRepository.loadLehrerNotInSchool(idSchule);
        this.delLehrerKlasseObjekte(lks.stream().map(lk -> lk.getId()).collect(Collectors.toList()), REMOVE_MODE.All);
        System.out.print("Benutzer laden");
        List users = this.repos.userEntityRepository.loadUserNotInSchool(idSchule);
        List idsUser = users.stream().map(u -> u.getId()).collect(Collectors.toList());
        List cats = this.em.createQuery("select c from CategoryEntity c join c.parent p1 join p1.parent p2 where p2.parent is null and p1.name not like 'letto'", CategoryEntity.class).getResultList();
        List usersInSchool = this.em.createQuery("select u from UserEntity u join u.schule s where s.id in :id").setParameter("id", (Object)idSchule).getResultList();
        cats = cats.stream().filter(c -> usersInSchool.stream().noneMatch(u -> u.getName().equals(c.getName()))).filter(c -> c.getGlobalCategory() == null || c.getGlobalCategory() == false).collect(Collectors.toList());
        System.out.println("Benutzerkategorien l\u00f6schen");
        for (CategoryEntity cat : cats) {
            if (cat.getName().toLowerCase().equals("letto")) continue;
            this.delChildCat(cat);
            this.nativeSql.execNative("update question q set q.idCategory=null where q.idCategory = " + cat.getId());
            this.repos.categoryEntityRepository.delete((Object)cat);
        }
        System.out.print("Benutzer l\u00f6schen");
        this.delUser(idsUser);
        System.out.print(", leere Hauptkategorien l\u00f6schen");
        cats = this.em.createQuery("select distinct c from CategoryEntity c join c.parent p1 left join c.categories ch where p1.parent is null and ch.name is null ", CategoryEntity.class).getResultList();
        List idCats = cats.stream().map(c -> c.getId()).collect(Collectors.toList());
        this.nativeSql.execNativeWithIds("delete cu FROM category_user cu where cu.aboCategories_ID in :ids", idCats);
        this.nativeSql.execNativeWithIds("delete cu FROM user_category cu where cu.aboCategories_ID in :ids", idCats);
        this.repos.categoryEntityRepository.deleteAll((Iterable)cats);
        System.out.print(", Schulen l\u00f6schen");
        List schulen = this.repos.schuleEntityRepository.loadSchuleNotInSchool(idSchule);
        List idsSchulen = schulen.stream().map(s -> s.getId()).collect(Collectors.toList());
        this.nativeSql.execNativeWithIds("delete k FROM klasse k join abteilung a on a.id=k.idAbteilung where a.idSchule in :ids", idsSchulen);
        this.nativeSql.execNativeWithIds("delete a FROM abteilung a where a.idSchule in :ids", idsSchulen);
        this.nativeSql.execNativeWithIds("update globalconfig c set c.idSchule=null where c.idSchule in :ids", idsSchulen);
        this.nativeSql.execNativeWithIds("delete s FROM schule_schultyp s where s.schulen_ID in :ids", idsSchulen);
        this.nativeSql.execNativeWithIds("delete s FROM schule_category s where s.schulen_ID in :ids", idsSchulen);
        this.nativeSql.execNativeWithIds("delete s FROM schule s where s.id in :ids", idsSchulen);
        System.out.println(", Fragen l\u00f6schen");
        List idsQuestions = this.em.createNativeQuery("SELECT distinct q.id FROM question q left join testFrage tf on tf.idQuestion=q.id \nwhere tf.id is null and q.idCategory is null").getResultList();
        List x = idsQuestions.stream().map(id -> id.intValue()).collect(Collectors.toList());
        this.delQuestions(x);
        this.nativeSql.execNative("SET FOREIGN_KEY_CHECKS=0;");
        this.nativeSql.execNative("delete b from bewertungen b ");
        this.nativeSql.execNative("delete from beurteilungsart");
        this.nativeSql.execNative("delete from beurtGruppe");
        this.nativeSql.execNative("delete from beurtGruppenDef");
        this.nativeSql.execNative("delete from beurteilungsconfig");
        this.nativeSql.execNative("INSERT INTO `beurtGruppenDef` VALUES (7768329,'Mitarbeit'),(7768330,'Pr\u00fcfungen'),(7768331,'Haus\u00fcbungen');");
        this.nativeSql.execNative("INSERT INTO `beurtGruppe` VALUES (7768342,2,7768329,6167759), (7768343,5,7768330,6167759), (7768344,1,7768331,6167759);");
        this.nativeSql.execNative("INSERT INTO `beurteilungsart` VALUES (6167760,'',5,0,1,0,'',1,7768343,6167759,6167751,1,NULL), (6167766,'',1,0,1,0,'',0,7768342,6167759,6167752,2,NULL), (6167780,'',1,0,1,0,'',0,7768344,6167759,46,3,NULL), (6167785,'',2,0,1,0,'*Pr\u00fcfung,Mitarbeit,!Protokoll',1,7768343,6167759,12376432,4,NULL), (6167792,'',0,0,0,0,'',1,NULL,6167759,6167757,5,NULL), (6167799,'',3,0,1,0,'Mitarbeit, !Protokoll',1,7768342,6167759,6167758,6,NULL), (6671147,'',1,0,1,0,'',1,7768343,6167759,21134563,0,NULL), (8237106,'',2,0,1,0,'',0,7768342,6167759,45,7,NULL), (8237114,'',5,0,1,0,'',1,7768343,6167759,43,8,NULL), (9203489,'',1,0,1,0,'',1,7768342,6167759,47,9,NULL), (22534112,'',5,0,1,0,'',1,7768343,6167759,44,10,NULL);");
        this.nativeSql.execNative("INSERT INTO `beurteilungsconfig` (`id`,`ANZEIGEKATALOG`,`BESCHREIBUNG`,`CALCNOTE`,`DEFAULTSCHEMA`,`GEGENSTAENDE`,`GRUPPIERUNG`,`MINPROZENT`,`NAME`,`SCHOWNOTENSCHUELER`,`SCHULSTUFEN`,`SUMMELEHRER`,`USEDMODES`,`idUser`) VALUES (6167759,1,'',1,0,NULL,0,37.5,'default',1,NULL,0,NULL,NULL);");
        this.nativeSql.execNative("INSERT INTO bewertungen VALUES (6167761,89,93.75,'1','Sehr Gut',6167760,0), (6167762,76,81.25,'2','Gut',6167760,1), (6167763,61,68.75,'3','Befriedigend',6167760,2), (6167764,50.1,56.25,'4','Gen\u00fcgend',6167760,3), (6167765,0,43.75,'5','Nicht Gen\u00fcgend',6167760,4), (6167767,87.5,93.75,'+','+',6167766,0), (6167768,75,80,'+~','+~',6167766,1), (6167769,62.5,67,'~','~',6167766,2), (6195713,50,55,'~-','~-',6167766,3), (6195714,0,38,'-','-',6167766,4), (6167781,80,93.75,'+','+',6167780,0), (6167782,50,75,'~','~',6167780,1), (6167783,0,38,'-','-',6167780,2), (6167784,0,0,'\u00a5','H\u00dc fehlt',6167780,3), (6167786,87.5,93.75,'1','1',6167785,0), (6167787,75,81.25,'2','2',6167785,1), (6167788,62.5,68.75,'3','3',6167785,2), (6167789,50,56.25,'4','4',6167785,3), (6167790,0,43.75,'5','5',6167785,4), (6167791,0,-1,'\u00a5','\u00a5',6167785,5), (6167793,0,-1,'E','Elterngespr\u00e4ch',6167792,0), (6167794,0,-1,'T','Telefonat',6167792,1), (6167795,0,-1,'K','L\u00e4ngere Krankheit',6167792,2), (6167796,0,-1,'D','Disziplin',6167792,3), (6167797,0,-1,'F','Fr\u00fchwarnungsgespr\u00e4ch',6167792,4), (6167798,0,-1,'X','Sonstiges',6167792,5), (6167800,90,93.75,'1','Sehr Gut',6167799,0), (6167801,80,85,'2','Gut',6167799,1), (6167802,66,75,'3','Befriedigend',6167799,2), (6167803,50,55,'4','Gen\u00fcgend',6167799,3), (6167804,0,38,'5','Nicht gen\u00fcgend',6167799,4), (6196504,0,0,'\u00a5',NULL,6167799,5), (6671290,87.5,93.75,'1','Sehr Gut',6671147,0), (6671291,75,81.25,'2','Gut',6671147,1), (6671292,62.5,68.75,'3','Befriedigend',6671147,2), (6671293,50.1,56.25,'4','Gen\u00fcgend',6671147,3), (6671294,0,43.75,'5','Nicht Gen\u00fcgend',6671147,4), (6671295,0,-1,'\u00a5',NULL,6671147,5), (8237107,87.5,93.75,'+','+',8237106,0), (8237108,75,80,'+~','+~',8237106,1), (8237109,62.5,67,'~','~',8237106,2), (8237110,50,55,'~-','~-',8237106,3), (8237111,0,38,'-','-',8237106,4), (8237115,89,93.75,'1','Sehr Gut',8237114,0), (8237116,76,81.25,'2','Gut',8237114,1), (8237117,61,68.75,'3','Befriedigend',8237114,2), (8237118,50.1,56.25,'4','Gen\u00fcgend',8237114,3), (8237119,0,43.75,'5','Nicht Gen\u00fcgend',8237114,4), (9203490,89,93.75,'1','Sehr Gut',9203489,0), (9203491,76,81.25,'2','Gut',9203489,1), (9203492,61,68.75,'3','Befriedigend',9203489,2), (9203493,50.1,56.25,'4','Gen\u00fcgend',9203489,3), (9203494,0,43.75,'5','Nicht Gen\u00fcgend',9203489,4), (22534113,89,93.75,'1','Sehr Gut',22534112,0), (22534114,76,81.25,'2','Gut',22534112,1), (22534115,61,68.75,'3','Befriedigend',22534112,2), (22534116,50.1,56.25,'4','Gen\u00fcgend',22534112,3), (22534117,0,43.75,'5','Nicht Gen\u00fcgend',22534112,4);");
        this.nativeSql.execNative("SET FOREIGN_KEY_CHECKS=0;");
    }

    public void delQuestions(List<Integer> ids) {
        System.out.print("Fragen l\u00f6schen ");
        System.out.print(".");
        this.nativeSql.execNativeWithIds("delete f  FROM MoodleFile f join moodleText t on f.idText = t.id join question q on t.idQuestion = q.id where q.id in :ids", ids);
        System.out.print(".");
        this.nativeSql.execNativeWithIds("delete t  FROM moodleText t join question q on t.idQuestion = q.id where q.id in :ids", ids);
        System.out.print(".");
        this.nativeSql.execNativeWithIds("delete a  FROM answer a join subquestion sq on a.idAnswer = sq.id join question q on sq.PARENT_ID = q.id where q.id in :ids", ids);
        System.out.print(".");
        this.nativeSql.execNativeWithIds("delete sq FROM subquestion sq join question q on sq.PARENT_ID = q.id where q.id in :ids", ids);
        System.out.print(".");
        this.nativeSql.execNativeWithIds("delete ds FROM datasetDefinition ds join question q on ds.idParent = q.id where q.id in :ids", ids);
        System.out.print(".");
        this.nativeSql.execNativeWithIds("delete c FROM questioncomment c where c.question_id  in :ids", ids);
        System.out.print(".");
        this.nativeSql.execNativeWithIds("delete q  FROM question q where q.id in :ids", ids);
        System.out.println(".");
    }

    static /* synthetic */ boolean access$002(DeleteService x0, boolean x1) {
        x0.delThreadRunning = x1;
        return x0.delThreadRunning;
    }
}

