/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.beurteilung;

import at.letto.data.dto.beuteilungsschema.BeurteilungsartDTO;
import at.letto.data.dto.beuteilungsschema.BeurteilungsconfigDTO;
import at.letto.data.entity.BeurteilungsconfigEntity;
import at.letto.data.mapper.BeurteilungsConfigMapper;
import at.letto.data.mapper.CycleAvoidingMappingContext;
import at.letto.data.repository.BeurteilungsconfigEntityRepository;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BeurteilungConfigService {
    @Autowired
    private AllRepositories allRepositories;

    public BeurteilungsconfigDTO findSchemaForBeurteilungsart(String beurteilungsart) {
        List schema = this.allRepositories.beurteilungsconfigEntityRepository.findSchemaByBeurteilungsartName(beurteilungsart);
        if (schema.size() == 0) {
            return null;
        }
        return this.toDto((BeurteilungsconfigEntity)schema.get(0));
    }

    @Transactional
    public BeurteilungsconfigDTO loadSchema(int id) {
        return this.allRepositories.beurteilungsconfigEntityRepository.findById((Object)id).map(schema -> BeurteilungsConfigMapper.service.mapDto(schema, new CycleAvoidingMappingContext())).get();
    }

    @Transactional
    public BeurteilungsconfigDTO loadDefaultSchema() {
        return this.allRepositories.beurteilungsconfigEntityRepository.findGlobal().map(schema -> this.toDto(schema)).get();
    }

    @Transactional
    public BeurteilungsconfigDTO loadUserDefault(int idUser) {
        BeurteilungsconfigEntity schema = this.allRepositories.beurteilungsconfigEntityRepository.findDefaultByUserId(idUser).orElse(this.allRepositories.beurteilungsconfigEntityRepository.findGlobal().orElse(null));
        if (schema == null) {
            return null;
        }
        return this.toDto(schema);
    }

    @Transactional
    public BeurteilungsconfigDTO loadSchemaByLehrerKlasse(int idLk) {
        BeurteilungsconfigEntityRepository repo = this.allRepositories.beurteilungsconfigEntityRepository;
        BeurteilungsconfigEntity schema = repo.findByLk(idLk).orElse(repo.findByLkGlobal(idLk).orElse(repo.findDefaultUser(idLk).orElse(repo.findGlobal().orElse(null))));
        if (schema == null) {
            return null;
        }
        return this.toDto(schema);
    }

    private BeurteilungsconfigDTO toDto(BeurteilungsconfigEntity schema) {
        if (schema == null) {
            return null;
        }
        BeurteilungsconfigDTO s = BeurteilungsConfigMapper.service.mapDto(schema, new CycleAvoidingMappingContext());
        s.getBeurteilungsarten().forEach(ba -> ba.getBewertungen().removeIf(Objects::isNull));
        s.setBeurteilungsartHash(s.getBeurteilungsarten().stream().collect(Collectors.toMap(BeurteilungsartDTO::getName, b -> b, (b1, b2) -> b1)));
        return s;
    }

    @Transactional
    public BeurteilungsartDTO loadGlobalBeurteilungsart(String name) {
        return this.allRepositories.beurteilungsartEntityRepository.loadGlobalBeurteilungsart(name).map(b -> BeurteilungsConfigMapper.service.mapDto(b, new CycleAvoidingMappingContext())).get();
    }

    @Transactional
    public BeurteilungsartDTO loadBeurteilungsartByBezeichner(String name) {
        return this.allRepositories.beurteilungsartEntityRepository.findBeurteilungsartByBezeichnung(name).map(b -> BeurteilungsConfigMapper.service.mapDto(b, new CycleAvoidingMappingContext())).get();
    }

    public String save(BeurteilungsconfigDTO schema) {
        BeurteilungsconfigEntity entity = BeurteilungsConfigMapper.service.map(schema, new CycleAvoidingMappingContext());
        this.allRepositories.beurteilungsconfigEntityRepository.save((Object)entity);
        return "";
    }
}

