/*
 * Decompiled with CFR 0.152.
 */
package at.letto.data.service.category;

import at.letto.data.dto.PairIntInt;
import at.letto.data.dto.category.CategoryDTO;
import at.letto.data.dto.category.CategorySortDTO;
import at.letto.data.entity.CategoryEntity;
import at.letto.data.repository.repositoryGroups.AllRepositories;
import at.letto.export.dto.category.ExportCategoryV1;
import at.letto.tools.Cmd;
import at.letto.tools.Listen;
import at.letto.tools.enums.Level;
import at.letto.tools.rest.MsgException;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoryServiceDatabase {
    @Inject
    EntityManager em;
    @Autowired
    private AllRepositories allRepositories;

    public CategoryDTO findCategory(int id) {
        return this.allRepositories.categoryEntityRepository.findCatById(id);
    }

    public CategorySortDTO findCategoryByPath(String path) {
        String[] x = path.split("/");
        CategorySortDTO root = (CategorySortDTO)this.allRepositories.categoryEntityRepository.findRoot().stream().findFirst().get();
        if (root == null) {
            return null;
        }
        List main = this.allRepositories.categoryEntityRepository.findChildCategories(root.getId());
        Optional<CategorySortDTO> categ = null;
        for (String c : x) {
            if (Cmd.isEmpty((String)c)) continue;
            categ = main.stream().filter(cat -> c.equals(cat.getName())).findFirst();
            if (!categ.isPresent()) {
                return null;
            }
            main = this.allRepositories.categoryEntityRepository.findChildCategories(categ.get().getId());
        }
        return (CategorySortDTO)categ.get();
    }

    public List<CategoryDTO> findAllCategories() {
        return this.allRepositories.categoryEntityRepository.findAllCategories();
    }

    @Transactional
    public CategoryDTO insertCategory(int idParent, String name, int pos) {
        List childIDs = this.allRepositories.categoryEntityRepository.findChildCategories(idParent).stream().map(c -> c.getId()).collect(Collectors.toList());
        CategoryEntity c2 = new CategoryEntity();
        CategoryEntity par = new CategoryEntity();
        par.setId(Integer.valueOf(idParent));
        c2.setParent(par);
        c2.setName(name);
        c2 = (CategoryEntity)this.allRepositories.categoryEntityRepository.save((Object)c2);
        if (pos < 0 || pos >= childIDs.size()) {
            childIDs.add(c2.getId());
        } else {
            childIDs.add(pos, c2.getId());
        }
        this.setCategoriesOrder(childIDs);
        return this.findCategory(c2.getId().intValue());
    }

    @Transactional
    public CategoryDTO insertCategory(int idParent, int pos, ExportCategoryV1 imp) {
        List childIDs = this.allRepositories.categoryEntityRepository.findChildCategories(idParent).stream().map(c -> c.getId()).collect(Collectors.toList());
        CategoryEntity c2 = new CategoryEntity();
        CategoryEntity par = new CategoryEntity();
        par.setId(Integer.valueOf(idParent));
        c2.setParent(par);
        c2.setName(imp.getName());
        c2.setCategoryLink(imp.getCategoryLink());
        c2.setEinheitenKorrText(imp.getEinheitenKorrText());
        c2.setGlobalCategory(Boolean.valueOf(imp.isGlobalCategory()));
        c2.setPrivateCategory(Boolean.valueOf(imp.isPrivateCategory()));
        c2.setIdKompetenz(imp.getIdKompetenz());
        c2.setLevel(Level.getVal((String)imp.getLevel()));
        c2 = (CategoryEntity)this.allRepositories.categoryEntityRepository.save((Object)c2);
        if (pos < 0 || pos >= childIDs.size()) {
            childIDs.add(c2.getId());
        } else {
            childIDs.add(pos, c2.getId());
        }
        this.setCategoriesOrder(childIDs);
        return this.findCategory(c2.getId().intValue());
    }

    @Transactional
    public String moveCateg(int idCat, int idZiel, List<Integer> ids) {
        this.updateParent(idCat, idZiel);
        this.setCategoriesOrder(ids);
        return "";
    }

    public String renameCateg(int id, String name) {
        this.allRepositories.categoryEntityRepository.updateCategoryName(id, name);
        return "";
    }

    public String updateCategoryEinheit(int id, String ehKorrText, boolean eh) {
        this.allRepositories.categoryEntityRepository.updateCategoryEinheit(id, ehKorrText, eh);
        return "";
    }

    public String deleteCateg(int id, boolean force) {
        if (!force) {
            List qList = this.allRepositories.questionEntityRepository.loadQuestionList(id);
            if (qList.size() > 0) {
                throw new MsgException("categoryNotEmpty");
            }
            if (this.allRepositories.categoryEntityRepository.findChildCategories(id).size() > 0) {
                throw new MsgException("categoryNotEmpty");
            }
        }
        this.allRepositories.categoryEntityRepository.deleteById((Object)id);
        return "";
    }

    public String setCategoriesOrder(List<Integer> ids) {
        if (ids.size() == 0) {
            return "";
        }
        Vector<PairIntInt> list = new Vector<PairIntInt>();
        for (int i = 0; i < ids.size(); ++i) {
            list.add(new PairIntInt(ids.get(i).intValue(), i));
        }
        String upd = Listen.sqlUpdateSort(list, PairIntInt::getVal2);
        String sql = "INSERT into category (id, categories_ORDER) VALUES " + upd + " ON DUPLICATE KEY UPDATE categories_ORDER = VALUES(categories_ORDER);";
        this.em.createNativeQuery(sql).executeUpdate();
        return "";
    }

    @Transactional
    public String sortCategories(int idParent) {
        List childs = this.allRepositories.categoryEntityRepository.findChildCategories(idParent);
        childs.sort(Comparator.comparing(CategorySortDTO::getName));
        String upd = Listen.sqlUpdateSort((List)childs, CategorySortDTO::getOrderCol);
        String sql = "INSERT into category (id, categories_ORDER) VALUES " + upd + " ON DUPLICATE KEY UPDATE categories_ORDER = VALUES(categories_ORDER);";
        this.em.createNativeQuery(sql).executeUpdate();
        return "";
    }

    public String updateParent(int idCat, int idParent) {
        this.allRepositories.categoryEntityRepository.updateParent(idCat, idParent);
        return "";
    }
}

